/*
 * Copyright (c) 2009 The University of Reading
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Reading, nor the names of the
 *    authors or contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package uk.ac.rdg.resc.ncwms.coords;

import org.geotoolkit.referencing.crs.DefaultGeographicCRS;

/**
 * Immutable implementation of {@link LonLatPosition}.
 * @author Jon
 */
public final class LonLatPositionImpl extends HorizontalPositionImpl implements LonLatPosition {

    /**
     * Returns the longitude, in the range [-180:180] degrees.
     * @return the longitude, in the range [-180:180] degrees.
     */
    @Override public double getLongitude() { return this.getX(); }

    /**
     * Returns the geodetic latitude in degrees.
     * @return the geodetic latitude in degrees.
     */
    @Override public double getLatitude() { return this.getY(); }

    /**
     * Creates a new LonLatPositionImpl with the given coordinates.
     * @param longitude The longitude.  Will be converted internally to a
     * longitude in the range [-180:180], so all getter methods will return
     * values in this range.
     * @param latitude The geodetic latitude
     */
    public LonLatPositionImpl(double longitude, double latitude) {
        super(DefaultGeographicCRS.WGS84, Longitude.constrain180(longitude), latitude);
    }

}
