/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.DataType;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class BufrTableDViewer
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted ddsTable;
    private BeanTableSorted variantTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane compareTA;
    private TextHistoryPane infoTA2;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private TableD currTable;
    private boolean skipNames = false;
    private boolean skipUnits = false;
    private HashMap<Short, List<String>> usedDds = null;
    private HashMap<Short, List<DdsBean>> allVariants = null;

    public BufrTableDViewer(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.ddsTable = new BeanTableSorted(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        this.ddsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DdsBean csb = (DdsBean)BufrTableDViewer.this.ddsTable.getSelectedBean();
                BufrTableDViewer.this.showVariants(csb);
            }
        });
        this.variantTable = new BeanTableSorted(DdsBean.class, (PreferencesExt)prefs.node("VariantBean"), false);
        this.variantTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DdsBean csb = (DdsBean)BufrTableDViewer.this.variantTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.ddsTable.getJTable(), "Options");
        varPopup.addAction("Show uses", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list;
                Formatter out = new Formatter();
                DdsBean csb = (DdsBean)BufrTableDViewer.this.ddsTable.getSelectedBean();
                if (BufrTableDViewer.this.usedDds != null && (list = (List)BufrTableDViewer.this.usedDds.get(csb.dds.getId())) != null) {
                    for (String use : list) {
                        out.format(" %s%n", use);
                    }
                }
                BufrTableDViewer.this.compareTA.setText(out.toString());
                BufrTableDViewer.this.compareTA.gotoTop();
                BufrTableDViewer.this.infoWindow.setVisible(true);
            }
        });
        varPopup = new PopupMenu(this.variantTable.getJTable(), "Options");
        varPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                DdsBean ddsBean = (DdsBean)BufrTableDViewer.this.variantTable.getSelectedBean();
                if (ddsBean != null) {
                    ddsBean.dds.show(out, false);
                }
                BufrTableDViewer.this.compareTA.setText(out.toString());
                BufrTableDViewer.this.compareTA.gotoTop();
                BufrTableDViewer.this.infoWindow.setVisible(true);
            }
        });
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Compare to standard table", false);
        compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Formatter out = new Formatter();
                    TableD wmoTable = BufrTables.getWmoTableD(null);
                    BufrTableDViewer.this.compare(BufrTableDViewer.this.currTable, wmoTable, out);
                    BufrTableDViewer.this.compareTA.setText(out.toString());
                    BufrTableDViewer.this.compareTA.gotoTop();
                    BufrTableDViewer.this.infoWindow.setVisible(true);
                }
                catch (Throwable ioe) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                    ioe.printStackTrace(new PrintStream(bos));
                    BufrTableDViewer.this.compareTA.setText(bos.toString());
                    BufrTableDViewer.this.compareTA.gotoTop();
                    BufrTableDViewer.this.infoWindow.setVisible(true);
                }
            }
        });
        buttPanel.add(compareButton);
        AbstractAction usedAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BufrTableDViewer.this.showUsed();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(usedAction, "dd", "showUsed", true, 67, -1);
        BAMutil.addActionToContainer(buttPanel, usedAction);
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.ddsTable, this.variantTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.ddsTable.saveState(false);
        this.variantTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setBufrTableD(String filename, String mode) throws IOException {
        TableD tableD = BufrTables.readTableD((String)filename, (String)mode, (boolean)true);
        int pos = filename.lastIndexOf("/");
        String src = pos > 0 ? filename.substring(pos + 1) : filename;
        ArrayList listDesc = new ArrayList(tableD.getDescriptors());
        Collections.sort(listDesc);
        ArrayList<DdsBean> dds = new ArrayList<DdsBean>(listDesc.size());
        for (TableD.Descriptor d : listDesc) {
            dds.add(new DdsBean(src, d));
        }
        this.ddsTable.setBeans(dds);
        this.currTable = tableD;
    }

    private void compare(TableD t1, TableD t2, Formatter out) {
        out.format("Compare Table D%n %s %n %s %n", t1.getName(), t2.getName());
        boolean err = false;
        ArrayList listDesc = new ArrayList(t1.getDescriptors());
        Collections.sort(listDesc);
        for (TableD.Descriptor d1 : listDesc) {
            TableD.Descriptor d2 = t2.getDescriptor(d1.getId());
            if (d2 == null) {
                err = true;
                out.format(" **No key %s in second table %n", d1.getFxy());
                continue;
            }
            List seq1 = d1.getSequence();
            List seq2 = d2.getSequence();
            if (seq1.size() != seq2.size()) {
                err = true;
                out.format(" **key %s size %d != %d %n  ", d1.getFxy(), seq1.size(), seq2.size());
                for (Short f1 : seq1) {
                    out.format(" %s,", this.fxy(f1));
                }
                out.format("%n  ", new Object[0]);
                for (Short f2 : seq2) {
                    out.format(" %s,", this.fxy(f2));
                }
                out.format("%n", new Object[0]);
                continue;
            }
            for (int i = 0; i < seq1.size(); ++i) {
                short fxy2;
                short fxy1 = (Short)seq1.get(i);
                if (fxy1 == (fxy2 = ((Short)seq2.get(i)).shortValue())) continue;
                err = true;
                out.format(" **MISMATCH key %s feature %s != %s %n", d1.getFxy(), this.fxy(fxy1), this.fxy(fxy2));
                for (Short f1 : seq1) {
                    out.format(" %s,", this.fxy(f1));
                }
                out.format("%n", new Object[0]);
                for (Short f2 : seq2) {
                    out.format(" %s,", this.fxy(f2));
                }
                out.format("%n", new Object[0]);
            }
        }
        if (!err) {
            out.format("All OK%n", new Object[0]);
        }
        for (TableD.Descriptor d2 : t2.getDescriptors()) {
            TableD.Descriptor d1 = t1.getDescriptor(d2.getId());
            if (d1 != null) continue;
            out.format(" **No key %s in first table %n", d2.getFxy());
        }
    }

    String fxy(short id) {
        return Descriptor.makeString((short)id);
    }

    private void showUsed() throws IOException {
        this.usedDds = new HashMap(3000);
        this.scanFileForDds("C:/data/formats/bufr/uniqueBrasil.bufr");
    }

    public void scanFileForDds(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        MessageScanner scan = new MessageScanner(raf);
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            TableLookup lookup = m.getTableLookup();
            List raw = m.dds.getDataDescriptors();
            String src = m.getHeader().trim() + "(" + Integer.toHexString(m.hashCode()) + ")";
            this.setDataDescriptors(src, lookup, raw);
        }
    }

    private void setDataDescriptors(String src, TableLookup lookup, List<Short> seq) {
        for (Short key : seq) {
            List subseq;
            int f = (key & 0xC000) >> 14;
            if (f != 3) continue;
            List<String> list = this.usedDds.get(key);
            if (list == null) {
                list = new ArrayList<String>();
                this.usedDds.put(key, list);
            }
            if (!list.contains(src)) {
                list.add(src);
            }
            if ((subseq = lookup.getDescriptorsTableD(key.shortValue())) == null) continue;
            this.setDataDescriptors(src, lookup, subseq);
        }
    }

    private void loadVariants() {
        this.allVariants = new HashMap();
        try {
            this.loadVariant("wmo-v14", BufrTables.getWmoTableD(null));
            this.loadVariant("ours-v13", BufrTables.readTableD((String)"C:/dev/tds4.1/thredds/bufrTables/src/main/sources/archive/B4M-000-013-D", (String)"mel-bufr", (boolean)false));
            this.loadVariant("ncep-v13", BufrTables.readTableD((String)"C:/dev/tds4.1/thredds/bufrTables/src/main/sources/ncep/bufrtab.TableD_STD_0_13", (String)"ncep", (boolean)false));
            this.loadVariant("ncep-v14", BufrTables.readTableD((String)"C:/dev/tds4.1/thredds/bufrTables/src/main/sources/ncep/bufrtab.TableD_STD_0_14", (String)"ncep", (boolean)false));
            this.loadVariant("ecmwf-v13", BufrTables.readTableD((String)"C:/dev/tds4.1/thredds/bufrTables/src/main/sources/ecmwf/D0000000000098013001.TXT", (String)"ecmwf", (boolean)false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadVariant(String src, TableD table) {
        ArrayList listDesc = new ArrayList(table.getDescriptors());
        for (TableD.Descriptor d : listDesc) {
            List<DdsBean> list = this.allVariants.get(d.getId());
            if (list == null) {
                list = new ArrayList<DdsBean>(10);
                this.allVariants.put(d.getId(), list);
            }
            list.add(new DdsBean(src, d));
        }
    }

    private void showVariants(DdsBean bean) {
        if (this.allVariants == null) {
            this.loadVariants();
        }
        List<DdsBean> all = this.allVariants.get(bean.dds.getId());
        ArrayList<DdsBean> dds = new ArrayList<DdsBean>(10);
        dds.add(bean);
        if (all != null) {
            dds.addAll(all);
        }
        this.variantTable.setBeans(dds);
    }

    public class DdsBean {
        TableD.Descriptor dds;
        String source;
        String udunits;

        public DdsBean() {
        }

        public DdsBean(String source, TableD.Descriptor dds) {
            this.source = source;
            this.dds = dds;
        }

        public String getFxy() {
            return this.dds.getFxy();
        }

        public int getId() {
            return DataType.unsignedShortToInt(this.dds.getId());
        }

        public String getSource() {
            return this.source;
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getSequence() {
            Formatter out = new Formatter();
            Iterator i$ = this.dds.getSequence().iterator();
            while (i$.hasNext()) {
                short s = (Short)i$.next();
                out.format(" %s,", Descriptor.makeString((short)s));
            }
            return out.toString();
        }

        public int getUsed() {
            if (BufrTableDViewer.this.usedDds == null) {
                return 0;
            }
            List list = (List)BufrTableDViewer.this.usedDds.get(this.dds.getId());
            if (list == null) {
                return 0;
            }
            return list.size();
        }

        public boolean isLocal() {
            return this.dds.isLocal();
        }
    }
}

