/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import ucar.nc2.ui.widget.FileManager;

public class CompareDialog
extends JDialog {
    private FileManager fileChooser;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JButton fileBrowser;
    private JLabel label1;
    private JRadioButton all;
    private JRadioButton varOnly;
    private JPanel buttonBar;
    private JCheckBox readData;
    private JCheckBox showDetails;
    private JCheckBox showCompare;
    private JComboBox datasetCombo;
    private JButton cancelButton;
    private JButton okButton;

    public CompareDialog(Frame owner, FileManager fileChooser) {
        super(owner);
        this.fileChooser = fileChooser;
        this.initComponents();
    }

    private void okButtonActionPerformed(ActionEvent e) {
        HowMuch howMuch = this.all.isSelected() ? HowMuch.All : HowMuch.varOnly;
        Data data = new Data((String)this.datasetCombo.getSelectedItem(), howMuch, this.showCompare.isSelected(), this.showDetails.isSelected(), this.readData.isSelected());
        this.firePropertyChange("OK", null, data);
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void fileBrowserActionPerformed(ActionEvent e) {
        String filename = this.fileChooser.chooseFilename();
        if (filename == null) {
            return;
        }
        this.datasetCombo.insertItemAt(filename, 0);
    }

    private void datasetComboActionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("comboBoxChanged")) {
            return;
        }
        this.datasetCombo.insertItemAt(this.datasetCombo.getSelectedItem(), 0);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.fileBrowser = new JButton();
        this.label1 = new JLabel();
        this.all = new JRadioButton();
        this.varOnly = new JRadioButton();
        this.buttonBar = new JPanel();
        this.readData = new JCheckBox();
        this.showDetails = new JCheckBox();
        this.showCompare = new JCheckBox();
        this.datasetCombo = new JComboBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setTitle("Compare current dataset with another dataset");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.fileBrowser.setIcon(UIManager.getIcon("FileView.directoryIcon"));
        this.fileBrowser.setToolTipText("open Local dataset");
        this.fileBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDialog.this.fileBrowserActionPerformed(e);
            }
        });
        this.label1.setText("dataset:");
        this.label1.setFont(new Font("Dialog", 1, 12));
        this.all.setText("All");
        this.all.setSelected(true);
        this.varOnly.setText("selected Variable");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.readData.setText("compare Data");
        this.showDetails.setText("show Details");
        this.showCompare.setText("show Compare");
        this.showCompare.setSelected(true);
        this.datasetCombo.setEditable(true);
        this.datasetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDialog.this.datasetComboActionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDialog.this.okButtonActionPerformed(e);
            }
        });
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addContainerGap().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.label1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.datasetCombo, -2, 676, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileBrowser)).addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.showCompare).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showDetails).addGap(18, 18, 18).addComponent(this.readData)).addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.all).addGap(18, 18, 18).addComponent(this.varOnly)))).addComponent(this.buttonBar, GroupLayout.Alignment.TRAILING, -2, 779, -2)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, contentPanelLayout.createSequentialGroup().addContainerGap(600, Short.MAX_VALUE).addComponent(this.okButton, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton, -2, 80, -2).addGap(32, 32, 32)));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addContainerGap().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1).addComponent(this.datasetCombo, -2, -1, -2)).addComponent(this.fileBrowser)).addGap(20, 20, 20).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.all).addComponent(this.varOnly)).addGap(18, 18, 18).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showCompare).addComponent(this.showDetails).addComponent(this.readData)).addGap(22, 22, 22).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addComponent(this.buttonBar, -2, -1, -2).addContainerGap()));
        this.dialogPane.add((Component)this.contentPanel, "North");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.all);
        buttonGroup1.add(this.varOnly);
    }

    public class Data {
        public HowMuch howMuch;
        public String name;
        public boolean showCompare;
        public boolean showDetails;
        public boolean readData;

        private Data(String name, HowMuch howMuch, boolean showCompare, boolean showDetails, boolean readData) {
            this.name = name;
            this.howMuch = howMuch;
            this.showCompare = showCompare;
            this.showDetails = showDetails;
            this.readData = readData;
        }

        public String toString() {
            return "Data{howMuch=" + (Object)((Object)this.howMuch) + ", name='" + this.name + '\'' + ", showCompare=" + this.showCompare + ", showDetails=" + this.showDetails + ", readData=" + this.readData + '}';
        }
    }

    public static enum HowMuch {
        All,
        varOnly;

    }
}

