/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public class BtreeStats
extends DatabaseStats {
    private static final long serialVersionUID = 298825033L;
    private StatGroup dbImplStats = new StatGroup("DbImpl Btree", "Btree statistics");
    private StatGroup treeStats = new StatGroup("Tree Btree", "Btree statistics");

    public void setDbImplStats(StatGroup stats) {
        this.dbImplStats = stats;
    }

    public void setTreeStats(StatGroup tStats) {
        this.treeStats = tStats;
    }

    public long getBottomInternalNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_BIN_COUNT);
    }

    public long getDuplicateBottomInternalNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_DBIN_COUNT);
    }

    public long getDeletedLeafNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_DELETED_LN_COUNT);
    }

    public long getDupCountLeafNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_DUPCOUNT_LN_COUNT);
    }

    public long getInternalNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_IN_COUNT);
    }

    public long getDuplicateInternalNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_DIN_COUNT);
    }

    public long getLeafNodeCount() {
        return this.dbImplStats.getLong(BTreeStatDefinition.BTREE_LN_COUNT);
    }

    public int getMainTreeMaxDepth() {
        return this.dbImplStats.getInt(BTreeStatDefinition.BTREE_MAINTREE_MAXDEPTH);
    }

    public int getDuplicateTreeMaxDepth() {
        return this.dbImplStats.getInt(BTreeStatDefinition.BTREE_DUPTREE_MAXDEPTH);
    }

    public long[] getINsByLevel() {
        return this.dbImplStats.getLongArray(BTreeStatDefinition.BTREE_INS_BYLEVEL);
    }

    public long[] getBINsByLevel() {
        return this.dbImplStats.getLongArray(BTreeStatDefinition.BTREE_BINS_BYLEVEL);
    }

    public long[] getDINsByLevel() {
        return this.dbImplStats.getLongArray(BTreeStatDefinition.BTREE_DINS_BYLEVEL);
    }

    public long[] getDBINsByLevel() {
        return this.dbImplStats.getLongArray(BTreeStatDefinition.BTREE_DBINS_BYLEVEL);
    }

    public long getRelatches() {
        return this.treeStats.getLong(BTreeStatDefinition.BTREE_RELATCHES_REQUIRED);
    }

    public int getRootSplits() {
        return this.treeStats.getInt(BTreeStatDefinition.BTREE_ROOT_SPLITS);
    }

    public String toString() {
        return this.dbImplStats.toString() + "\n" + this.treeStats.toString();
    }

    public String toStringVerbose() {
        return this.dbImplStats.toStringVerbose() + "\n" + this.treeStats.toStringVerbose();
    }
}

