/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.BaseEntry;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NodeLogEntry;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INLogEntry
extends BaseEntry
implements LogEntry,
NodeLogEntry,
INContainingEntry {
    private IN in;
    private DatabaseId dbId;
    private long obsoleteLsn;
    private long nodeId;

    public INLogEntry(Class<? extends IN> INClass) {
        super(INClass);
    }

    public INLogEntry(IN in) {
        this.setLogType(in.getLogType());
        this.in = in;
        this.dbId = in.getDatabase().getId();
        this.nodeId = in.getNodeId();
        this.obsoleteLsn = in.getLastFullVersion();
    }

    @Override
    public void readEntry(LogEntryHeader header, ByteBuffer entryBuffer, boolean readFullItem) throws DatabaseException {
        boolean version6OrLater;
        int logVersion = header.getVersion();
        boolean bl = version6OrLater = logVersion >= 6;
        if (version6OrLater) {
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, logVersion);
            this.obsoleteLsn = LogUtils.readLong(entryBuffer, false);
        }
        if (readFullItem) {
            this.in = (IN)LogUtils.newInstance(this.logClass);
            this.in.readFromLog(entryBuffer, logVersion);
            this.nodeId = this.in.getNodeId();
        } else {
            int position = entryBuffer.position() + header.getItemSize();
            if (logVersion == 1) {
                position -= 4;
            } else if (logVersion >= 2) {
                position = version6OrLater ? (position -= LogUtils.getPackedLongLogSize(this.obsoleteLsn)) : (position -= 8);
            }
            position = !version6OrLater ? (position -= 4) : (position -= LogUtils.getPackedIntLogSize(this.dbId.getId()));
            this.nodeId = LogUtils.readLong(entryBuffer, !version6OrLater);
            entryBuffer.position(position);
            this.in = null;
        }
        if (!version6OrLater) {
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, logVersion);
        }
        if (logVersion < 1) {
            this.obsoleteLsn = -1L;
        } else if (logVersion == 1) {
            long fileNum = LogUtils.readUnsignedInt(entryBuffer);
            this.obsoleteLsn = fileNum == 0xFFFFFFFFL ? -1L : DbLsn.makeLsn(fileNum, 0);
        } else if (!version6OrLater) {
            this.obsoleteLsn = LogUtils.readLong(entryBuffer, true);
        }
    }

    public long getObsoleteLsn() {
        return this.obsoleteLsn;
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        this.in.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
    }

    @Override
    public Object getMainItem() {
        return this.in;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public int getSize() {
        return this.in.getLogSize() + this.dbId.getLogSize() + LogUtils.getPackedLongLogSize(this.obsoleteLsn);
    }

    @Override
    public void writeEntry(LogEntryHeader header, ByteBuffer destBuffer) {
        this.dbId.writeToLog(destBuffer);
        LogUtils.writePackedLong(destBuffer, this.obsoleteLsn);
        this.in.writeToLog(destBuffer);
    }

    @Override
    public IN getIN(EnvironmentImpl env) {
        return this.in;
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public DatabaseId getDbId() {
        return this.dbId;
    }

    @Override
    public long getLsnOfIN(long lastReadLsn) {
        return lastReadLsn;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        return false;
    }
}

