/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.entry.BaseEntry;
import com.sleepycat.je.log.entry.LogEntry;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleItemEntry
extends BaseEntry
implements LogEntry {
    private Loggable item;

    public SingleItemEntry(Class<?> logClass) {
        super(logClass);
    }

    public SingleItemEntry(LogEntryType entryType, Loggable item) {
        this.setLogType(entryType);
        this.item = item;
    }

    @Override
    public void readEntry(LogEntryHeader header, ByteBuffer entryBuffer, boolean readFullItem) throws DatabaseException {
        this.item = (Loggable)LogUtils.newInstance(this.logClass);
        this.item.readFromLog(entryBuffer, header.getVersion());
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        this.item.dumpLog(sb, verbose);
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
    }

    @Override
    public Object getMainItem() {
        return this.item;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public long getTransactionId() {
        return this.item.getTransactionId();
    }

    @Override
    public int getSize() {
        return this.item.getLogSize();
    }

    @Override
    public void writeEntry(LogEntryHeader header, ByteBuffer destBuffer) {
        this.item.writeToLog(destBuffer);
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        return this.item.logicalEquals((Loggable)other.getMainItem());
    }
}

