/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNTracker;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.stream.ReplicaSyncupReader;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicaFeederSyncup {
    private final Logger logger;
    private final NamedChannel namedChannel;
    private final Protocol protocol;
    private final RepNode repNode;
    private final VLSNIndex vlsnIndex;
    private final Replay replay;
    private final RepImpl repImpl;
    private VLSN matchpointVLSN = VLSN.NULL_VLSN;
    private long matchpointLsn = DbLsn.makeLsn(0L, 0);
    private Long matchedVLSNTime = 0L;
    private boolean passedCheckpointEnd = false;
    private static TestHook<Object> syncupEndHook;

    public ReplicaFeederSyncup(RepNode repNode, Replay replay, NamedChannel namedChannel, Protocol protocol) {
        this.replay = replay;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.repNode = repNode;
        this.vlsnIndex = repNode.getVLSNIndex();
        this.namedChannel = namedChannel;
        this.protocol = protocol;
        this.repImpl = repNode.getRepImpl();
    }

    public long getMatchedVLSNTime() {
        return this.matchedVLSNTime;
    }

    public VLSN getMatchedVLSN() {
        return this.matchpointVLSN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LocalCBVLSNTracker cbvlsnTracker) throws IOException, DatabaseException, InterruptedException, InsufficientLogException {
        long startTime = System.currentTimeMillis();
        String feederName = this.namedChannel.getNameIdPair().getName();
        LoggerUtils.info(this.logger, this.repImpl, "Replica-feeder " + feederName + " syncup started. Replica range: " + this.repNode.getVLSNIndex().getRange());
        this.repNode.syncupStarted();
        try {
            VLSNRange range = this.vlsnIndex.getRange();
            this.findMatchpoint(range);
            this.verifyRollback(range);
            this.replay.rollback(this.matchpointVLSN, this.matchpointLsn);
            VLSN startVLSN = this.matchpointVLSN.getNext();
            this.vlsnIndex.truncateFromTail(startVLSN, this.matchpointLsn);
            Protocol protocol = this.protocol;
            protocol.getClass();
            this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.StartStream(startVLSN), this.namedChannel);
            LoggerUtils.info(this.logger, this.repImpl, "Replica-feeder " + feederName + " start stream at VLSN: " + startVLSN);
            cbvlsnTracker.registerMatchpoint(startVLSN);
            if (syncupEndHook != null) {
                syncupEndHook.doHook();
            }
            Object var8_6 = null;
            this.repNode.syncupEnded();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.repNode.syncupEnded();
            LoggerUtils.info(this.logger, this.repImpl, String.format("Replica-feeder " + feederName + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
            throw throwable;
        }
        LoggerUtils.info(this.logger, this.repImpl, String.format("Replica-feeder " + feederName + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
    }

    private void verifyRollback(VLSNRange range) throws RollbackException, InsufficientLogException, IOException {
        VLSN lastTxnEnd = range.getLastTxnEnd();
        VLSN lastSync = range.getLastSync();
        if (lastTxnEnd.equals(VLSN.NULL_VLSN)) {
            if (range.getLastSync().equals(VLSN.NULL_VLSN) && !this.matchpointVLSN.equals(VLSN.NULL_VLSN)) {
                throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Shouldn't be possible to find a matchpoint of " + this.matchpointVLSN + " when the sync VLSN is " + " null" + range);
            }
            return;
        }
        if (lastSync.equals(VLSN.NULL_VLSN)) {
            throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Shouldn't be possible to have a non-null sync VLSN when the  lastTxnVLSN is null" + range);
        }
        if (this.matchpointVLSN.equals(VLSN.NULL_VLSN)) {
            throw this.setupLogRefresh(this.matchpointVLSN);
        }
        if (lastTxnEnd.compareTo(this.matchpointVLSN) <= 0) {
            return;
        }
        if (this.passedCheckpointEnd) {
            throw this.setupLogRefresh(this.matchpointVLSN);
        }
        throw this.setupHardRecovery(range);
    }

    private void findMatchpoint(VLSNRange range) throws IOException, InterruptedException, InsufficientLogException {
        ReplicaSyncupReader backwardsReader;
        OutputWireRecord replicaRecord;
        VLSN candidateMatchpoint = range.getLastSync();
        if (candidateMatchpoint.equals(VLSN.NULL_VLSN)) {
            this.getFeederRecord(range, VLSN.FIRST_VLSN, false);
            return;
        }
        InputWireRecord feederRecord = this.getFeederRecord(range, candidateMatchpoint, true);
        candidateMatchpoint = feederRecord.getVLSN();
        if (this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.repImpl, "Matchpoint: " + candidateMatchpoint);
        }
        if (!(replicaRecord = (backwardsReader = this.setupBackwardsReader(candidateMatchpoint)).scanBackwards(candidateMatchpoint)).match(feederRecord)) {
            do {
                if ((replicaRecord = backwardsReader.findPrevSyncEntry()) == null) {
                    throw this.setupLogRefresh(candidateMatchpoint);
                }
                candidateMatchpoint = replicaRecord.getVLSN();
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                LoggerUtils.finest(this.logger, this.repImpl, "Next matchpoint: " + candidateMatchpoint);
            } while (!replicaRecord.match(feederRecord = this.getFeederRecord(range, candidateMatchpoint, false)));
        }
        this.matchedVLSNTime = replicaRecord.getTimeStamp();
        this.matchpointVLSN = candidateMatchpoint;
        this.matchpointLsn = backwardsReader.getLastLsn();
        this.passedCheckpointEnd = backwardsReader.getPassedCheckpointEnd();
    }

    private ReplicaSyncupReader setupBackwardsReader(VLSN candidateMatchpoint) throws IOException {
        RepImpl envImpl = this.repNode.getRepImpl();
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        return new ReplicaSyncupReader((EnvironmentImpl)envImpl, this.repNode.getVLSNIndex(), envImpl.getFileManager().getLastUsedLsn(), readBufferSize, this.repNode.getNameIdPair(), candidateMatchpoint, DbLsn.makeLsn(this.repNode.getCleanerBarrierFile(), 0));
    }

    private InsufficientLogException setupLogRefresh(VLSN failedMatchpoint) throws IOException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.RestoreRequest(failedMatchpoint), this.namedChannel);
        Protocol.RestoreResponse response = (Protocol.RestoreResponse)this.protocol.read(this.namedChannel);
        return new InsufficientLogException(this.repNode, response.getCBVLSN(), new HashSet<ReplicationNode>(Arrays.asList(response.getLogProviders())));
    }

    public RollbackException setupHardRecovery(VLSNRange range) throws IOException {
        RollbackException r = new RollbackException(this.repImpl, range.getLastTxnEnd(), this.matchpointVLSN, this.matchpointLsn);
        this.repImpl.getFileManager().truncateLog(DbLsn.getFileNumber(this.matchpointLsn), DbLsn.getFileOffset(this.matchpointLsn));
        return r;
    }

    private InputWireRecord getFeederRecord(VLSNRange range, VLSN requestVLSN, boolean acceptAlternative) throws IOException, InsufficientLogException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.EntryRequest(requestVLSN), this.namedChannel);
        BinaryProtocol.Message message = this.protocol.read(this.namedChannel);
        if (message instanceof Protocol.Entry) {
            Protocol.Entry entry = (Protocol.Entry)message;
            return entry.getWireRecord();
        }
        if (message instanceof Protocol.EntryNotFound) {
            throw this.setupLogRefresh(requestVLSN);
        }
        if (acceptAlternative && message instanceof Protocol.AlternateMatchpoint) {
            Protocol.AlternateMatchpoint alt = (Protocol.AlternateMatchpoint)message;
            InputWireRecord feederRecord = alt.getAlternateWireRecord();
            VLSN altMatchpoint = feederRecord.getVLSN();
            if (range.getFirst().compareTo(altMatchpoint) > 0) {
                throw this.setupLogRefresh(altMatchpoint);
            }
            return feederRecord;
        }
        throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Sent EntryRequest, got unexpected response of " + message);
    }

    public static TestHook<Object> getSyncupEndHook() {
        return syncupEndHook;
    }

    public static void setSyncupEndHook(TestHook<Object> syncupEndHook) {
        ReplicaFeederSyncup.syncupEndHook = syncupEndHook;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TestHook<T> {
        public void doHook() throws InterruptedException;
    }
}

