/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.scheduling.quartz.JobMethodInvocationFailedException;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class MethodInvokingJobDetailFactoryBean
extends ArgumentConvertingMethodInvoker
implements FactoryBean,
BeanNameAware,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean {
    private String name;
    private String group = "DEFAULT";
    private boolean concurrent = true;
    private String targetBeanName;
    private String[] jobListenerNames;
    private String beanName;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private BeanFactory beanFactory;
    private JobDetail jobDetail;

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public void setJobListenerNames(String[] names) {
        this.jobListenerNames = names;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected Class resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, this.beanClassLoader);
    }

    public void afterPropertiesSet() throws ClassNotFoundException, NoSuchMethodException {
        String name;
        this.prepare();
        String string = name = this.name != null ? this.name : this.beanName;
        Class clazz = this.concurrent ? MethodInvokingJob.class : StatefulMethodInvokingJob.class;
        Class jobClass = clazz;
        this.jobDetail = new JobDetail(name, this.group, jobClass);
        this.jobDetail.getJobDataMap().put((Object)"methodInvoker", this);
        this.jobDetail.setVolatility(true);
        this.jobDetail.setDurability(true);
        if (this.jobListenerNames != null) {
            for (int i = 0; i < this.jobListenerNames.length; ++i) {
                this.jobDetail.addJobListener(this.jobListenerNames[i]);
            }
        }
        this.postProcessJobDetail(this.jobDetail);
    }

    protected void postProcessJobDetail(JobDetail jobDetail) {
    }

    public Class getTargetClass() {
        Class targetClass = super.getTargetClass();
        if (targetClass == null && this.targetBeanName != null) {
            Assert.state(this.beanFactory != null, "BeanFactory must be set when using 'targetBeanName'");
            targetClass = this.beanFactory.getType(this.targetBeanName);
        }
        return targetClass;
    }

    public Object getTargetObject() {
        Object targetObject = super.getTargetObject();
        if (targetObject == null && this.targetBeanName != null) {
            Assert.state(this.beanFactory != null, "BeanFactory must be set when using 'targetBeanName'");
            targetObject = this.beanFactory.getBean(this.targetBeanName);
        }
        return targetObject;
    }

    public Object getObject() {
        return this.jobDetail;
    }

    public Class getObjectType() {
        return JobDetail.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public static class StatefulMethodInvokingJob
    extends MethodInvokingJob
    implements StatefulJob {
    }

    public static class MethodInvokingJob
    extends QuartzJobBean {
        protected static final Log logger = LogFactory.getLog(class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob == null ? (class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob = MethodInvokingJobDetailFactoryBean.class$("org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean$MethodInvokingJob")) : class$org$springframework$scheduling$quartz$MethodInvokingJobDetailFactoryBean$MethodInvokingJob);
        private MethodInvoker methodInvoker;

        public void setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
        }

        protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
            try {
                this.methodInvoker.invoke();
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof JobExecutionException) {
                    throw (JobExecutionException)ex.getTargetException();
                }
                throw new JobMethodInvocationFailedException(this.methodInvoker, ex.getTargetException());
            }
            catch (Exception ex) {
                throw new JobMethodInvocationFailedException(this.methodInvoker, (Throwable)ex);
            }
        }
    }
}

