/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import thredds.logs.AccessLogParser;
import thredds.logs.LogCategorizer;
import thredds.logs.LogReader;
import thredds.ui.monitor.Chart;
import thredds.ui.monitor.LogLocalManager;
import thredds.ui.monitor.MultipleAxisChart;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.TimeUnit;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class AccessLogTable
extends JPanel {
    private PreferencesExt prefs;
    private Cache dnsCache;
    private BeanTableSorted logTable;
    private BeanTableSorted userTable;
    private BeanTableSorted datarootTable;
    private BeanTableSorted serviceTable;
    private JPanel timeSeriesPanel;
    private ArrayList<LogReader.Log> completeLogs;
    private ArrayList<LogReader.Log> restrictLogs;
    private boolean calcUser = true;
    private boolean calcRoot = true;
    private boolean calcService = true;
    private JTabbedPane tabbedPanel;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private JTextArea startDateField;
    private JTextArea endDateField;
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private LogLocalManager manager;
    private List<LogLocalManager.FileDateRange> accessLogFiles = null;
    private boolean showDNStime = false;
    private ExecutorService executor = null;

    public AccessLogTable(JTextArea startDateField, JTextArea endDateField, PreferencesExt prefs, Cache dnsCache) {
        this.startDateField = startDateField;
        this.endDateField = endDateField;
        this.prefs = prefs;
        this.dnsCache = dnsCache;
        this.logTable = new BeanTableSorted(LogReader.Log.class, (PreferencesExt)prefs.node("Logs"), false);
        this.logTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogReader.Log log = (LogReader.Log)AccessLogTable.this.logTable.getSelectedBean();
                if (log == null) {
                    return;
                }
                AccessLogTable.this.infoTA.setText(log.toString());
                AccessLogTable.this.infoWindow.showIfNotIconified();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.logTable.getJTable(), "Options");
        varPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogReader.Log log = (LogReader.Log)AccessLogTable.this.logTable.getSelectedBean();
                if (log == null) {
                    return;
                }
                Formatter f = new Formatter();
                log.toString(f);
                AccessLogTable.this.infoTA.setText(f.toString());
                AccessLogTable.this.infoWindow.showIfNotIconified();
            }
        });
        varPopup.addAction("DNS Lookup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogReader.Log log = (LogReader.Log)AccessLogTable.this.logTable.getSelectedBean();
                if (log == null) {
                    return;
                }
                try {
                    AccessLogTable.this.infoTA.setText(log.getIp() + " = " + AccessLogTable.this.reverseDNS(log.getIp()));
                }
                catch (Exception ee) {
                    AccessLogTable.this.infoTA.setTextFromStackTrace(ee);
                }
                AccessLogTable.this.infoWindow.showIfNotIconified();
            }
        });
        varPopup.addAction("Resend URL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogReader.Log log = (LogReader.Log)AccessLogTable.this.logTable.getSelectedBean();
                if (log == null) {
                    return;
                }
                String urlString = log.getPath();
                AccessLogTable.this.firePropertyChange("UrlDump", null, "http://" + AccessLogTable.this.manager.getServer() + urlString);
            }
        });
        varPopup.addAction("Remove selected logs", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List all = AccessLogTable.this.logTable.getBeans();
                ArrayList selected = AccessLogTable.this.logTable.getSelectedBeans();
                all.removeAll(selected);
                AccessLogTable.this.logTable.setBeans(all);
            }
        });
        this.userTable = new BeanTableSorted(User.class, (PreferencesExt)prefs.node("LogUser"), false);
        this.userTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                User accum = (User)AccessLogTable.this.userTable.getSelectedBean();
                if (accum == null) {
                    return;
                }
                accum.run();
            }
        });
        PopupMenu varPopupU = new PopupMenu(this.userTable.getJTable(), "Options");
        varPopupU.addAction("User requests", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Accum accum = (Accum)AccessLogTable.this.userTable.getSelectedBean();
                if (accum == null) {
                    return;
                }
                AccessLogTable.this.logTable.setBeans(accum.logs);
                AccessLogTable.this.tabbedPanel.setSelectedIndex(0);
            }
        });
        this.datarootTable = new BeanTableSorted(Dataroot.class, (PreferencesExt)prefs.node("DataRoot"), false);
        this.datarootTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Dataroot accum = (Dataroot)AccessLogTable.this.datarootTable.getSelectedBean();
                if (accum == null) {
                    return;
                }
            }
        });
        PopupMenu varPopupR = new PopupMenu(this.datarootTable.getJTable(), "Options");
        varPopupR.addAction("User requests", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Accum accum = (Accum)AccessLogTable.this.datarootTable.getSelectedBean();
                if (accum == null) {
                    return;
                }
                AccessLogTable.this.logTable.setBeans(accum.logs);
                AccessLogTable.this.tabbedPanel.setSelectedIndex(0);
            }
        });
        this.serviceTable = new BeanTableSorted(Service.class, (PreferencesExt)prefs.node("Service"), false);
        this.serviceTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Service accum = (Service)AccessLogTable.this.serviceTable.getSelectedBean();
                if (accum == null) {
                    return;
                }
            }
        });
        PopupMenu varPopupS = new PopupMenu(this.serviceTable.getJTable(), "Options");
        varPopupS.addAction("User requests", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Accum accum = (Accum)AccessLogTable.this.serviceTable.getSelectedBean();
                if (accum == null) {
                    return;
                }
                AccessLogTable.this.logTable.setBeans(accum.logs);
                AccessLogTable.this.tabbedPanel.setSelectedIndex(0);
            }
        });
        this.timeSeriesPanel = new JPanel();
        this.timeSeriesPanel.setLayout(new BorderLayout());
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 100)));
        this.tabbedPanel = new JTabbedPane(1);
        this.tabbedPanel.addTab("LogTable", this.logTable);
        this.tabbedPanel.addTab("User", this.userTable);
        this.tabbedPanel.addTab("DataRoot", this.datarootTable);
        this.tabbedPanel.addTab("Service", this.serviceTable);
        this.tabbedPanel.addTab("TimeSeries", this.timeSeriesPanel);
        this.tabbedPanel.setSelectedIndex(0);
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ArrayList useBeans = (ArrayList)AccessLogTable.this.logTable.getBeans();
                int idx = AccessLogTable.this.tabbedPanel.getSelectedIndex();
                String title = AccessLogTable.this.tabbedPanel.getTitleAt(idx);
                if (title.equals("User")) {
                    AccessLogTable.this.initUserLogs(useBeans);
                }
                if (title.equals("DataRoot")) {
                    AccessLogTable.this.initDatarootLogs(useBeans);
                }
                if (title.equals("Service")) {
                    AccessLogTable.this.initServiceLogs(useBeans);
                }
                if (title.equals("TimeSeries")) {
                    AccessLogTable.this.showTimeSeriesAll(useBeans);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPanel, "Center");
    }

    public void exit() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.logTable.saveState(false);
        this.userTable.saveState(false);
        this.datarootTable.saveState(false);
        this.serviceTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
    }

    public void setLocalManager(LogLocalManager manager) {
        this.manager = manager;
        Date startDate = manager.getStartDate();
        Date endDate = manager.getEndDate();
        if (startDate != null) {
            this.startDateField.setText(this.df.format(startDate));
        } else {
            this.startDateField.setText(this.df.format(new Date()));
        }
        if (endDate != null) {
            this.endDateField.setText(this.df.format(endDate));
        } else {
            this.endDateField.setText(this.df.format(new Date()));
        }
        LogCategorizer.setRoots(manager.getRoots());
    }

    void showLogs(LogReader.LogFilter filter) {
        Date start = null;
        Date end = null;
        try {
            start = this.df.parse(this.startDateField.getText());
            end = this.df.parse(this.endDateField.getText());
            this.accessLogFiles = this.manager.getLocalFiles(start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.accessLogFiles = this.manager.getLocalFiles(null, null);
        }
        LogReader reader = new LogReader(new AccessLogParser());
        this.completeLogs = new ArrayList(30000);
        if (start != null && end != null) {
            filter = new LogReader.DateFilter(start.getTime(), end.getTime(), filter);
        }
        try {
            long startElapsed = System.nanoTime();
            LogReader.Stats stats = new LogReader.Stats();
            for (LogLocalManager.FileDateRange fdr : this.accessLogFiles) {
                reader.scanLogFile(fdr.f, new MyClosure(this.completeLogs), filter, stats);
            }
            long elapsedTime = System.nanoTime() - startElapsed;
            System.out.printf(" setLogFile total= %d passed=%d%n", stats.total, stats.passed);
            System.out.printf(" elapsed=%f msecs %n", (double)elapsedTime / 1000000.0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        this.resetLogs();
    }

    void showInfo(Formatter f) {
        List restrict;
        f.format(" Current time =   %s%n%n", new Date().toString());
        int n = 0;
        if (this.completeLogs != null) {
            n = this.completeLogs.size();
            f.format("Complete logs n=%d%n", n);
            f.format("  first log date= %s%n", this.completeLogs.get(0).getDate());
            f.format("   last log date= %s%n", this.completeLogs.get(n - 1).getDate());
        }
        if ((restrict = this.logTable.getBeans()) != null && restrict.size() != n) {
            f.format("%nRestricted logs n=%d%n", restrict.size());
        }
        if (this.accessLogFiles != null) {
            f.format("%nFiles used%n", new Object[0]);
        }
        for (LogLocalManager.FileDateRange fdr : this.accessLogFiles) {
            f.format(" %s [%s,%s]%n", fdr.f.getName(), fdr.start, fdr.end);
        }
    }

    void resetLogs() {
        this.logTable.setBeans(this.completeLogs);
        this.tabbedPanel.setSelectedIndex(0);
        this.userTable.setBeans(new ArrayList());
        this.datarootTable.setBeans(new ArrayList());
        this.calcUser = true;
        this.calcRoot = true;
        this.calcService = true;
        this.restrictLogs = this.completeLogs;
    }

    void restrictLogs(String restrict) {
        this.restrictLogs = new ArrayList(1000);
        for (LogReader.Log log : this.completeLogs) {
            String ip = log.getIp();
            if (ip.startsWith(restrict)) continue;
            this.restrictLogs.add(log);
        }
        this.logTable.setBeans(this.restrictLogs);
        this.tabbedPanel.setSelectedIndex(0);
        this.userTable.setBeans(new ArrayList());
        this.datarootTable.setBeans(new ArrayList());
        this.calcUser = true;
        this.calcRoot = true;
        this.calcService = true;
    }

    void initUserLogs(ArrayList<LogReader.Log> logs) {
        if (!this.calcUser) {
            return;
        }
        if (logs == null) {
            return;
        }
        HashMap<String, User> map = new HashMap<String, User>();
        for (LogReader.Log log : logs) {
            User accum = (User)map.get(log.getIp());
            if (accum == null) {
                accum = new User(log.getIp());
                map.put(log.getIp(), accum);
            }
            accum.add(log);
        }
        this.userTable.setBeans(new ArrayList(map.values()));
        this.calcUser = false;
    }

    void showDNS() {
        if (null == this.executor) {
            this.executor = Executors.newFixedThreadPool(3);
        }
        ArrayList accums = (ArrayList)this.userTable.getBeans();
        for (User a : accums) {
            this.executor.execute(a);
        }
    }

    String reverseDNS(String ip) throws UnknownHostException {
        Element cacheElem = this.dnsCache.get((Serializable)((Object)ip));
        if (cacheElem == null) {
            InetAddress addr = InetAddress.getByName(ip);
            cacheElem = new Element((Serializable)((Object)ip), (Serializable)((Object)addr.getHostName()));
            this.dnsCache.put(cacheElem);
        }
        return (String)((Object)cacheElem.getValue());
    }

    void initDatarootLogs(ArrayList<LogReader.Log> logs) {
        if (!this.calcRoot) {
            return;
        }
        if (logs == null) {
            return;
        }
        HashMap<String, Dataroot> map = new HashMap<String, Dataroot>();
        for (LogReader.Log log : logs) {
            String path = log.getPath();
            if (path == null) continue;
            String dataRoot = LogCategorizer.getDataroot(path, log.getStatus());
            Dataroot accum = (Dataroot)map.get(dataRoot);
            if (accum == null) {
                accum = new Dataroot(dataRoot);
                map.put(dataRoot, accum);
            }
            accum.add(log);
        }
        this.datarootTable.setBeans(new ArrayList(map.values()));
        this.calcRoot = false;
    }

    void initServiceLogs(ArrayList<LogReader.Log> logs) {
        if (!this.calcService) {
            return;
        }
        if (logs == null) {
            return;
        }
        HashMap<String, Service> map = new HashMap<String, Service>();
        for (LogReader.Log log : logs) {
            String path = log.getPath();
            if (path == null) {
                System.out.printf("FAIL %s%n", log);
                continue;
            }
            String service = LogCategorizer.getService(path);
            Service accum = (Service)map.get(service);
            if (accum == null) {
                accum = new Service(service);
                map.put(service, accum);
            }
            accum.add(log);
        }
        this.serviceTable.setBeans(new ArrayList(map.values()));
        this.calcService = false;
    }

    private void showTimeSeries(List<LogReader.Log> logs) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
        SimpleDateFormat dfo = new SimpleDateFormat("yyyy/MMM/dd HH:mm:ss");
        TimeSeries bytesSentData = new TimeSeries((Comparable)((Object)"Bytes Sent"), Minute.class);
        TimeSeries timeTookData = new TimeSeries((Comparable)((Object)"Average Latency"), Minute.class);
        TimeSeries nreqData = new TimeSeries((Comparable)((Object)"Number of Requests"), Minute.class);
        long period = 300000L;
        long current = 0L;
        long bytes = 0L;
        long timeTook = 0L;
        long count = 0L;
        try {
            for (LogReader.Log log : logs) {
                Date d = df.parse(log.getDate());
                long msecs = d.getTime();
                if (msecs - current > period) {
                    if (current > 0L) {
                        this.addPoint(bytesSentData, timeTookData, nreqData, new Date(current), bytes, count, timeTook);
                    }
                    bytes = 0L;
                    count = 0L;
                    timeTook = 0L;
                    current = msecs;
                }
                bytes += log.getBytes();
                timeTook += log.getMsecs();
                ++count;
            }
            this.addPoint(bytesSentData, timeTookData, nreqData, new Date(current), bytes, count, timeTook);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Chart c1 = new Chart("Bytes Sent", "5 min average", "Mbytes/sec", bytesSentData);
        Chart c2 = new Chart("Average Latency", "5 min average", "Millisecs", timeTookData);
        Chart c3 = new Chart("Number of Requests/sec", "5 min average", "", nreqData);
        this.timeSeriesPanel.removeAll();
        this.timeSeriesPanel.add(c1);
        this.timeSeriesPanel.add(c2);
        this.timeSeriesPanel.add(c3);
    }

    private void showTimeSeriesAll(List<LogReader.Log> logs) {
        TimeSeries bytesSentData = new TimeSeries((Comparable)((Object)"Bytes Sent"), Minute.class);
        TimeSeries timeTookData = new TimeSeries((Comparable)((Object)"Average Latency"), Minute.class);
        TimeSeries nreqData = new TimeSeries((Comparable)((Object)"Number of Requests"), Minute.class);
        String intervalS = "5 minute";
        long period = 300000L;
        try {
            TimeUnit tu = new TimeUnit(intervalS);
            period = (long)(1000.0 * tu.getValueInSeconds());
        }
        catch (Exception e) {
            System.out.printf("Illegal Time interval=%s %n", intervalS);
        }
        long current = 0L;
        long bytes = 0L;
        long timeTook = 0L;
        long total_count = 0L;
        long count = 0L;
        for (LogReader.Log log : logs) {
            long msecs = log.date;
            if (msecs - current > period) {
                if (current > 0L) {
                    total_count += count;
                    this.addPoint(bytesSentData, timeTookData, nreqData, new Date(current), bytes, count, timeTook);
                }
                bytes = 0L;
                count = 0L;
                timeTook = 0L;
                current = msecs;
            }
            bytes += log.getBytes();
            timeTook += log.getMsecs();
            ++count;
        }
        this.addPoint(bytesSentData, timeTookData, nreqData, new Date(current), bytes, count, timeTook);
        System.out.printf("showTimeSeriesAll: total_count = %d logs = %d%n", total_count += count, logs.size());
        MultipleAxisChart mc = new MultipleAxisChart("Access Logs", intervalS + " average", "Mbytes Sent", bytesSentData);
        mc.addSeries("Number of Requests", nreqData);
        mc.addSeries("Average Latency (secs)", timeTookData);
        mc.finish(new Dimension(1000, 1000));
        this.timeSeriesPanel.removeAll();
        this.timeSeriesPanel.add(mc);
    }

    void addPoint(TimeSeries bytesSentData, TimeSeries timeTookData, TimeSeries nreqData, Date date, long bytes, long count, long timeTook) {
        bytesSentData.add((RegularTimePeriod)new Minute(date), (double)bytes / 1000.0 / 1000.0);
        double latency = (double)timeTook / (double)count / 1000.0;
        timeTookData.add((RegularTimePeriod)new Minute(date), latency);
        nreqData.add((RegularTimePeriod)new Minute(date), count);
    }

    private static void test(String ip) {
        StringBuffer sbuff = new StringBuffer();
        String[] p = ip.split("\\.");
        for (int i = p.length - 1; i >= 0; --i) {
            sbuff.append(p[i]);
            if (i == 0) continue;
            sbuff.append('.');
        }
        String ipr = sbuff.toString();
        System.out.printf("%s == %s%n", ip, ipr);
    }

    public static void main(String[] args) {
        AccessLogTable.test("1.2.3.4");
        AccessLogTable.test("..1.2");
        AccessLogTable.test("..1.2..");
    }

    public class Service
    extends Accum {
        public Service() {
        }

        Service(String name) {
            super(name);
        }
    }

    public class Dataroot
    extends Accum {
        public Dataroot() {
        }

        Dataroot(String name) {
            super(name);
        }
    }

    public class User
    extends Accum
    implements Runnable {
        String ip;
        String namer;

        public String getIp() {
            return this.ip;
        }

        public String getNameReverse() {
            if (this.name != null && this.namer == null) {
                StringBuffer sbuff = new StringBuffer();
                String[] p = this.name.split("\\.");
                for (int i = p.length - 1; i >= 0; --i) {
                    sbuff.append(p[i]);
                    if (i == 0) continue;
                    sbuff.append('.');
                }
                this.namer = sbuff.toString();
            }
            return this.namer;
        }

        public User() {
        }

        User(String ip) {
            this.ip = ip;
        }

        @Override
        public void run() {
            if (this.name != null) {
                return;
            }
            try {
                long startElapsed = System.nanoTime();
                this.name = AccessLogTable.this.reverseDNS(this.ip);
                long elapsedTime = System.nanoTime() - startElapsed;
                if (AccessLogTable.this.showDNStime) {
                    System.out.printf(" reverseDNS took=%f msecs %n", (double)elapsedTime / 1000000.0);
                }
            }
            catch (Throwable e) {
                this.name = e.getMessage();
            }
        }
    }

    public class Accum {
        ArrayList<LogReader.Log> logs = new ArrayList(100);
        String name;
        long msecs;
        long bytes;
        int count;

        public String getName() {
            return this.name;
        }

        public long getMsecs() {
            return this.msecs;
        }

        public long getMsecsPerRequest() {
            return this.msecs / (long)this.count;
        }

        public long getKbytes() {
            return this.bytes / 1000L;
        }

        public int getCount() {
            return this.count;
        }

        public Accum() {
        }

        Accum(String name) {
            this.name = name;
        }

        void add(LogReader.Log log) {
            this.logs.add(log);
            ++this.count;
            this.bytes += log.getBytes();
            this.msecs += log.getMsecs();
        }
    }

    class MyClosure
    implements LogReader.Closure {
        ArrayList<LogReader.Log> logs;

        MyClosure(ArrayList<LogReader.Log> logs) {
            this.logs = logs;
        }

        @Override
        public void process(LogReader.Log log) {
            this.logs.add(log);
        }
    }
}

