/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NotSupportedException;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2IndicatorSection {
    private long gribLength;
    private int length;
    private int discipline;
    private final int edition;
    private long startPos = -1L;
    private long endPos = -1L;

    public Grib2IndicatorSection(RandomAccessFile raf) throws IOException {
        int[] data = new int[3];
        for (int i = 0; i < 3; ++i) {
            data[i] = raf.read();
        }
        this.edition = raf.read();
        if (this.edition == 1) {
            this.gribLength = GribNumbers.uint3(data[0], data[1], data[2]);
            raf.seek(raf.getFilePointer() + this.gribLength - 4L);
            this.length = 8;
        } else if (this.edition == 2) {
            this.discipline = data[2];
            this.gribLength = GribNumbers.int8(raf);
            this.length = 16;
        } else {
            throw new NotSupportedException("GRIB edition " + this.edition + " is not yet supported");
        }
    }

    public final long getGribLength() {
        return this.gribLength;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getDiscipline() {
        return this.discipline;
    }

    public final String getDisciplineName() {
        switch (this.discipline) {
            case 0: {
                return "Meteorological products";
            }
            case 1: {
                return "Hydrological products";
            }
            case 2: {
                return "Land surface products";
            }
            case 3: {
                return "Space products";
            }
            case 10: {
                return "Oceanographic products";
            }
        }
        return "Unknown";
    }

    public final int getGribEdition() {
        return this.edition;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public void setPos(long startPos, long endPos) {
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public long getEndPos() {
        return this.endPos;
    }
}

