/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.dialog.BufrBCompare;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class BufrTableBViewer
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted ddsTable;
    private BeanTableSorted variantTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane compareTA;
    private TextHistoryPane infoTA2;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private TableB currTable;
    private TableB refTable;
    private StructureTable dataTable;
    private IndependentWindow dataWindow;
    private FileManager fileChooser;
    private DateFormatter df = new DateFormatter();
    private char[] remove = new char[]{'(', ')', ' ', '\"', ',', '*', '-'};
    private String[] replace = new String[]{"", "", "", "", "", "", ""};
    private BufrBCompare dialog = null;
    private HashMap<Short, List<Message>> usedDds = null;
    private HashMap<String, TableB> standardTables = null;
    private HashMap<Short, List<DdsBean>> allVariants = null;
    private boolean variantsLoaded = false;

    public BufrTableBViewer(final PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.ddsTable = new BeanTableSorted(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        this.ddsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DdsBean csb = (DdsBean)BufrTableBViewer.this.ddsTable.getSelectedBean();
                BufrTableBViewer.this.showVariants(csb);
            }
        });
        this.variantTable = new BeanTableSorted(DdsBean.class, (PreferencesExt)prefs.node("VariantBean"), false);
        this.variantTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DdsBean csb = (DdsBean)BufrTableBViewer.this.variantTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.ddsTable.getJTable(), "Options");
        varPopup.addAction("Show uses", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list;
                Formatter out = new Formatter();
                DdsBean csb = (DdsBean)BufrTableBViewer.this.ddsTable.getSelectedBean();
                if (BufrTableBViewer.this.usedDds != null && (list = (List)BufrTableBViewer.this.usedDds.get(csb.getId())) != null) {
                    for (Message use : list) {
                        use.dumpHeaderShort(out);
                    }
                }
                BufrTableBViewer.this.compareTA.setText(out.toString());
                BufrTableBViewer.this.compareTA.gotoTop();
                BufrTableBViewer.this.infoWindow.setVisible(true);
            }
        });
        AbstractButton standardButton = BAMutil.makeButtcon("Select", "Show standard table", false);
        standardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BufrTableBViewer.this.setBufrTableB(BufrTables.getWmoTableB(14));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        buttPanel.add(standardButton);
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Compare to standard table", false);
        compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufrTableBViewer.this.compareToStandard();
            }
        });
        buttPanel.add(compareButton);
        AbstractAction refAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufrTableBViewer.this.refTable = BufrTableBViewer.this.currTable;
                BufrTableBViewer.this.loadVariant(BufrTableBViewer.this.refTable.getName(), BufrTableBViewer.this.refTable);
            }
        };
        BAMutil.setActionProperties(refAction, "Dataset", "useAsRef", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, refAction);
        AbstractAction usedAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String filename;
                    if (BufrTableBViewer.this.fileChooser == null) {
                        BufrTableBViewer.this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
                    }
                    if ((filename = BufrTableBViewer.this.fileChooser.chooseFilename()) == null) {
                        return;
                    }
                    BufrTableBViewer.this.showUsed(filename);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(usedAction, "dd", "showUsed", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, usedAction);
        AbstractAction diffAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String filename;
                    String defloc = "C:/dev/tds/thredds/bufrTables/src/main/resources/resources/bufrTables/local";
                    if (BufrTableBViewer.this.fileChooser == null) {
                        BufrTableBViewer.this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
                    }
                    if ((filename = BufrTableBViewer.this.fileChooser.chooseFilenameToSave(defloc + ".csv")) == null) {
                        return;
                    }
                    File file = new File(filename);
                    FileOutputStream fos = new FileOutputStream(file);
                    Formatter out = new Formatter(fos);
                    BufrTableBViewer.this.writeDiff(BufrTables.getWmoTableB(14), BufrTableBViewer.this.currTable, out);
                    fos.close();
                    JOptionPane.showMessageDialog(BufrTableBViewer.this, filename + " successfully written");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrTableBViewer.this, "ERROR: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(diffAction, "dd", "write diff", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, diffAction);
        AbstractAction localAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String filename;
                    String defloc = "C:/dev/tds/thredds/bufrTables/src/main/resources/resources/bufrTables/local";
                    if (BufrTableBViewer.this.fileChooser == null) {
                        BufrTableBViewer.this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
                    }
                    if ((filename = BufrTableBViewer.this.fileChooser.chooseFilenameToSave(defloc + ".csv")) == null) {
                        return;
                    }
                    File file = new File(filename);
                    FileOutputStream fos = new FileOutputStream(file);
                    Formatter out = new Formatter(fos);
                    BufrTableBViewer.this.writeLocal(BufrTableBViewer.this.currTable, out);
                    fos.close();
                    JOptionPane.showMessageDialog(BufrTableBViewer.this, filename + " successfully written");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(BufrTableBViewer.this, "ERROR: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(localAction, "dd", "write local", false, 67, -1);
        BAMutil.addActionToContainer(buttPanel, localAction);
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.ddsTable, this.variantTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.ddsTable.saveState(false);
        this.variantTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public void setBufrTableB(String filename, String mode) throws IOException {
        TableB tableB = BufrTables.readTableB(filename, mode, true);
        this.setBufrTableB(tableB);
    }

    private void setBufrTableB(TableB tb) throws IOException {
        String location = tb.getLocation();
        int pos = location.lastIndexOf("/");
        String src = pos > 0 ? location.substring(pos + 1) : location;
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(tb.getDescriptors());
        Collections.sort(listDesc);
        ArrayList<DdsBean> dds = new ArrayList<DdsBean>(listDesc.size());
        for (TableB.Descriptor d : listDesc) {
            dds.add(new DdsBean(src, d));
        }
        this.ddsTable.setBeans(dds);
        this.currTable = tb;
    }

    private String checkDiff(TableB.Descriptor want) {
        if (this.refTable == null) {
            return "n/a";
        }
        for (TableB.Descriptor d1 : this.refTable.getDescriptors()) {
            if (d1.getId() != want.getId()) continue;
            if (d1.getScale() != want.getScale()) {
                return "diff";
            }
            if (d1.getRefVal() != want.getRefVal()) {
                return "diff";
            }
            if (d1.getDataWidth() != want.getDataWidth()) {
                return "diff";
            }
            return "";
        }
        return want.isLocal() ? "local" : "new";
    }

    private void writeDiff(TableB wmo, TableB t, Formatter out) {
        out.format("#%n# BUFR diff written from %s against %s %n#%n", t.getName(), wmo.getName());
        out.format("Class,FXY,enElementName,BUFR_Unit,BUFR_Scale,BUFR_ReferenceValue,BUFR_DataWidth_Bits%n", new Object[0]);
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(t.getDescriptors());
        Collections.sort(listDesc);
        for (TableB.Descriptor d1 : listDesc) {
            TableB.Descriptor d2 = wmo.getDescriptor(d1.getId());
            if (d2 != null && d1.getScale() == d2.getScale() && d1.getRefVal() == d2.getRefVal() && d1.getDataWidth() == d2.getDataWidth()) continue;
            short fxy = d1.getId();
            int f = (fxy & 0xC000) >> 14;
            int x = (fxy & 0x3F00) >> 8;
            int y = fxy & 0xFF;
            out.format("%d,%2d%03d,\"%s\",%s,%d,%d,%d%n", x, x, y, d1.getName(), d1.getUnits(), d1.getScale(), d1.getRefVal(), d1.getDataWidth());
        }
        out.flush();
    }

    private void writeLocal(TableB t, Formatter out) {
        out.format("#%n# BUFR local only from %s %n#%n", t.getName());
        out.format("Class,FXY,enElementName,BUFR_Unit,BUFR_Scale,BUFR_ReferenceValue,BUFR_DataWidth_Bits%n", new Object[0]);
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(t.getDescriptors());
        Collections.sort(listDesc);
        for (TableB.Descriptor d1 : listDesc) {
            if (!d1.isLocal()) continue;
            short fxy = d1.getId();
            int f = (fxy & 0xC000) >> 14;
            int x = (fxy & 0x3F00) >> 8;
            int y = fxy & 0xFF;
            out.format("%d,%d%03d,\"%s\",%s,%d,%d,%d%n", x, x, y, d1.getName(), d1.getUnits(), d1.getScale(), d1.getRefVal(), d1.getDataWidth());
        }
        out.flush();
    }

    private boolean equiv(String org1, String org2) {
        String s1 = StringUtil.replace(org1, this.remove, this.replace).toLowerCase();
        String s2 = StringUtil.replace(org2, this.remove, this.replace).toLowerCase();
        return s1.equals(s2);
    }

    private boolean equivUnits(String unitS1, String unitS2) {
        String lower2;
        String lower1 = unitS1.toLowerCase();
        if (lower1.equals(lower2 = unitS2.toLowerCase())) {
            return true;
        }
        if (lower1.startsWith("code") && lower2.startsWith("code")) {
            return true;
        }
        if (lower1.startsWith("flag") && lower2.startsWith("flag")) {
            return true;
        }
        if (unitS1.startsWith("CCITT") && unitS2.startsWith("CCITT")) {
            return true;
        }
        try {
            return SimpleUnit.isCompatibleWithExceptions(unitS1, unitS2);
        }
        catch (Exception e) {
            return this.equiv(unitS1, unitS2);
        }
    }

    public void compareToStandard() {
        if (this.currTable == null) {
            return;
        }
        if (this.dialog == null) {
            this.dialog = new BufrBCompare(null);
            this.dialog.pack();
            this.dialog.addPropertyChangeListener("OK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BufrTableBViewer.this.compareToStandard((BufrBCompare.Data)evt.getNewValue());
                }
            });
        }
        this.dialog.setVisible(true);
    }

    private void compareToStandard(BufrBCompare.Data data) {
        try {
            Formatter out = new Formatter();
            TableB ref = this.getStandardTable(data.name);
            if (ref == null) {
                this.compareTA.setText("Cant find standard table = " + data.name);
                this.compareTA.gotoTop();
                this.infoWindow.setVisible(true);
                return;
            }
            this.compare(this.currTable, ref, !data.compareNames, !data.compareUnits, out);
            this.compareTA.setText(out.toString());
            this.compareTA.gotoTop();
            this.infoWindow.setVisible(true);
        }
        catch (Throwable ioe) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            ioe.printStackTrace(new PrintStream(bos));
            this.compareTA.setText(bos.toString());
            this.compareTA.gotoTop();
            this.infoWindow.setVisible(true);
        }
    }

    private void compare(TableB t1, TableB t2, boolean skipNames, boolean skipUnits, Formatter out) {
        out.format("Compare Table B%n %s%n %s %n", t1.getName(), t2.getName());
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(t1.getDescriptors());
        Collections.sort(listDesc);
        for (TableB.Descriptor d1 : listDesc) {
            TableB.Descriptor d2 = t2.getDescriptor(d1.getId());
            if (d2 == null) {
                out.format("**No key %s in second table; local=%s%n", d1.getFxy(), d1.isLocal());
                continue;
            }
            if (!skipNames && !this.equiv(d1.getName(), d2.getName())) {
                out.format(" %s name%n   %s%n   %s%n", d1.getFxy(), d1.getName(), d2.getName());
            }
            if (!skipUnits && !this.equivUnits(d1.getUnits(), d2.getUnits())) {
                out.format(" %s units%n   %s%n   %s%n", d1.getFxy(), d1.getUnits(), d2.getUnits());
            }
            if (d1.getScale() != d2.getScale()) {
                out.format(" %s scale %d != %d %n", d1.getFxy(), d1.getScale(), d2.getScale());
            }
            if (d1.getRefVal() != d2.getRefVal()) {
                out.format(" %s refVal %d != %d %n", d1.getFxy(), d1.getRefVal(), d2.getRefVal());
            }
            if (d1.getDataWidth() == d2.getDataWidth()) continue;
            out.format(" %s bitWidth %d != %d %n", d1.getFxy(), d1.getDataWidth(), d2.getDataWidth());
        }
        out.format("%n Missing in first table %n", new Object[0]);
        for (TableB.Descriptor d2 : t2.getDescriptors()) {
            TableB.Descriptor d1 = t1.getDescriptor(d2.getId());
            if (d1 != null) continue;
            out.format("   %s%n", d2.getFxy());
        }
    }

    private void showUsed() throws IOException {
        this.usedDds = new HashMap(3000);
        this.scanFileForDds("Q:/cdmUnitTest/iosp/bufr/uniqueExamples.bufr");
        this.scanFileForDds("Q:/cdmUnitTest/iosp/bufr/uniqueIDD.bufr");
        this.scanFileForDds("Q:/cdmUnitTest/iosp/bufr/uniqueBrasil.bufr");
        this.scanFileForDds("Q:/cdmUnitTest/iosp/bufr/uniqueFnmoc.bufr");
    }

    private void showUsed(String filename) throws IOException {
        this.usedDds = new HashMap(3000);
        this.scanFileForDds(filename);
    }

    public void scanFileForDds(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        MessageScanner scan = new MessageScanner(raf);
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            this.setDataDescriptors(m, m.getRootDataDescriptor());
        }
    }

    private void setDataDescriptors(Message src, DataDescriptor dds) {
        for (DataDescriptor key : dds.getSubKeys()) {
            List<Message> list = this.usedDds.get(key.getFxy());
            if (list == null) {
                list = new ArrayList<Message>();
                this.usedDds.put(key.getFxy(), list);
            }
            if (!list.contains(src)) {
                list.add(src);
            }
            if (key.getSubKeys() == null) continue;
            this.setDataDescriptors(src, key);
        }
    }

    private void initStandardTables() throws IOException {
        this.standardTables = new HashMap();
        this.standardTables.put("WMO-v14", BufrTables.getWmoTableB(14));
        this.standardTables.put("ours-v13", BufrTables.getWmoTableB(13));
        this.standardTables.put("ncep-v13", BufrTables.readTableB("resource:/resources/bufrTables/reference/bufrtab.TableB_STD_0_13", "ncep", false));
        this.standardTables.put("ncep-v14", BufrTables.readTableB("resource:/resources/bufrTables/reference/bufrtab.TableB_STD_0_14", "ncep", false));
        this.standardTables.put("ukmet-v13", BufrTables.readTableB("resource:/resources/bufrTables/reference/BUFR_B_080731.xml", "ukmet", false));
    }

    private TableB getStandardTable(String name) throws IOException {
        if (this.standardTables == null) {
            this.initStandardTables();
        }
        return this.standardTables.get(name);
    }

    private void loadVariants() throws IOException {
        if (this.allVariants == null) {
            this.allVariants = new HashMap();
        }
        if (this.standardTables == null) {
            this.initStandardTables();
        }
        for (String key : this.standardTables.keySet()) {
            this.loadVariant(key, this.standardTables.get(key));
        }
        this.variantsLoaded = true;
    }

    private void loadVariant(String src, TableB tableB) {
        if (this.allVariants == null) {
            this.allVariants = new HashMap();
        }
        ArrayList<TableB.Descriptor> listDesc = new ArrayList<TableB.Descriptor>(tableB.getDescriptors());
        for (TableB.Descriptor d : listDesc) {
            List<DdsBean> list = this.allVariants.get(d.getId());
            if (list == null) {
                list = new ArrayList<DdsBean>(10);
                this.allVariants.put(d.getId(), list);
            }
            list.add(new DdsBean(src, d));
        }
    }

    private void showVariants(DdsBean bean) {
        if (!this.variantsLoaded) {
            try {
                this.loadVariants();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        List<DdsBean> all = this.allVariants.get(bean.getId());
        ArrayList<DdsBean> ddsBean = new ArrayList<DdsBean>(10);
        ddsBean.add(bean);
        if (all != null) {
            ddsBean.addAll(all);
        }
        this.variantTable.setBeans(ddsBean);
    }

    public class DdsBean {
        TableB.Descriptor dds;
        String source;
        String udunits;
        boolean checkDiff;
        String isDiff;

        public DdsBean() {
        }

        public DdsBean(String source, TableB.Descriptor dds) {
            this.source = source;
            this.dds = dds;
        }

        public String getFxy() {
            return this.dds.getFxy();
        }

        public short getId() {
            return this.dds.getId();
        }

        public String getSource() {
            return this.source;
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getUnits() {
            return this.dds.getUnits();
        }

        public String getUdunits() {
            if (this.udunits == null) {
                try {
                    SimpleUnit su = SimpleUnit.factoryWithExceptions(this.dds.getUnits());
                    this.udunits = su.isUnknownUnit() ? "" : su.toString();
                }
                catch (Exception ioe) {
                    this.udunits = " unit convert failed ";
                }
            }
            return this.udunits;
        }

        public int getWidth() {
            return this.dds.getDataWidth();
        }

        public int getScale() {
            return this.dds.getScale();
        }

        public int getReference() {
            return this.dds.getRefVal();
        }

        public boolean isNumeric() {
            return this.dds.isNumeric();
        }

        public boolean isLocal() {
            return this.dds.isLocal();
        }

        public String getDiff() {
            if (!this.checkDiff && BufrTableBViewer.this.refTable != null) {
                this.isDiff = BufrTableBViewer.this.checkDiff(this.dds);
                this.checkDiff = true;
            }
            return this.isDiff;
        }

        public int getUsed() {
            if (BufrTableBViewer.this.usedDds == null) {
                return 0;
            }
            List list = (List)BufrTableBViewer.this.usedDds.get(this.dds.getId());
            if (list == null) {
                return 0;
            }
            return list.size();
        }
    }
}

