/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSAttribute;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSVariable;
import ucar.nc2.dods.DodsV;

public class DODSGrid
extends DODSVariable {
    private static Logger logger = LoggerFactory.getLogger(DODSGrid.class);

    DODSGrid(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String dodsShortName, DodsV dodsV) throws IOException {
        super(dodsfile, parentGroup, parentStructure, DODSNetcdfFile.makeNetcdfName(dodsShortName), dodsV);
        this.dodsShortName = dodsShortName;
        DodsV array = dodsV.children.get(0);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Formatter sbuff = new Formatter();
        for (int i = 1; i < dodsV.children.size(); ++i) {
            DodsV map = dodsV.children.get(i);
            String name = DODSNetcdfFile.makeNetcdfName(map.bt.getEncodedName());
            Dimension dim = parentGroup.findDimension(name);
            if (dim == null) {
                logger.warn("DODSGrid cant find dimension = <" + name + ">");
                continue;
            }
            dims.add(dim);
            sbuff.format("%s ", name);
        }
        this.setDimensions(dims);
        this.setDataType(DODSNetcdfFile.convertToNCType(array.bt));
        if (DODSNetcdfFile.isUnsigned(array.bt)) {
            this.addAttribute(new Attribute("_Unsigned", "true"));
        }
        DODSAttribute att = new DODSAttribute("_CoordinateAxes", sbuff.toString());
        this.addAttribute(att);
    }

    @Override
    protected Variable copy() {
        return new DODSGrid(this);
    }

    private DODSGrid(DODSGrid from) {
        super(from);
    }
}

