/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.ConstructNC;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.iosp.bufr.tables.WmoXmlReader;
import ucar.unidata.io.RandomAccessFile;

public class EmbeddedTable {
    private static final boolean showB = false;
    private static final boolean showD = false;
    private final RandomAccessFile raf;
    private final BufrIdentificationSection ids;
    private List<Message> messages = new ArrayList<Message>();
    private boolean tableRead = false;
    private TableB b;
    private TableD d;
    private Structure seq2;
    private Structure seq3;
    private Structure seq4;
    private TableLookup lookup;

    EmbeddedTable(BufrIdentificationSection ids, RandomAccessFile raf) {
        this.raf = raf;
        this.ids = ids;
        this.b = new TableB("embed", raf.getLocation());
        this.d = new TableD("embed", raf.getLocation());
    }

    public void addTable(Message m) {
        this.messages.add(m);
    }

    private void read2() throws IOException {
        Message proto = null;
        int countObs = 0;
        for (Message m : this.messages) {
            if (proto == null) {
                proto = m;
            }
            int n = m.getNumberDatasets();
            countObs += n;
        }
        ConstructNC construct = new ConstructNC(proto, countObs, new FakeNetcdfFile());
        this.seq2 = (Structure)construct.recordStructure.findVariable("seq2");
        this.seq3 = (Structure)construct.recordStructure.findVariable("seq3");
        this.seq4 = (Structure)this.seq3.findVariable("seq4");
        for (Message m : this.messages) {
            ArrayStructure data;
            Object reader;
            if (!m.dds.isCompressed()) {
                reader = new MessageUncompressedDataReader();
                data = ((MessageUncompressedDataReader)reader).readEntireMessage(construct.recordStructure, proto, m, this.raf, null);
            } else {
                reader = new MessageCompressedDataReader();
                data = ((MessageCompressedDataReader)reader).readEntireMessage(construct.recordStructure, proto, m, this.raf, null);
            }
            while (data.hasNext()) {
                StructureData sdata = (StructureData)data.next();
                this.add(sdata);
            }
        }
    }

    private void add(StructureData data) throws IOException {
        for (StructureMembers.Member m : data.getMembers()) {
            StructureDataIterator iter;
            ArraySequence seq;
            if (m.getDataType() != DataType.SEQUENCE) continue;
            if (m.getName().equals("seq2")) {
                seq = data.getArraySequence(m);
                iter = seq.getStructureDataIterator();
                while (iter.hasNext()) {
                    this.addTableEntryB(iter.next());
                }
                continue;
            }
            if (!m.getName().equals("seq3")) continue;
            seq = data.getArraySequence(m);
            iter = seq.getStructureDataIterator();
            while (iter.hasNext()) {
                this.addTableEntryD(iter.next());
            }
        }
    }

    private void addTableEntryB(StructureData sdata) throws IOException {
        String name = "";
        String units = null;
        String f = null;
        String x = null;
        String y = null;
        String signScale = null;
        String scaleS = null;
        String signRef = null;
        String refS = null;
        String widthS = null;
        List<StructureMembers.Member> members = sdata.getMembers();
        List<Variable> vars = this.seq2.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = vars.get(i);
            StructureMembers.Member m = members.get(i);
            String data = sdata.getScalarString(m);
            Attribute att = v.findAttribute("BUFR:TableB_descriptor");
            if (att.getStringValue().equals("0-0-10")) {
                f = sdata.getScalarString(m);
                continue;
            }
            if (att.getStringValue().equals("0-0-11")) {
                x = sdata.getScalarString(m);
                continue;
            }
            if (att.getStringValue().equals("0-0-12")) {
                y = sdata.getScalarString(m);
                continue;
            }
            if (att.getStringValue().equals("0-0-13")) {
                name = sdata.getScalarString(m);
                continue;
            }
            if (att.getStringValue().equals("0-0-14")) {
                name = name + sdata.getScalarString(m);
                continue;
            }
            if (att.getStringValue().equals("0-0-15")) {
                units = sdata.getScalarString(m);
                continue;
            }
            if (att.getStringValue().equals("0-0-16")) {
                signScale = sdata.getScalarString(m).trim();
                continue;
            }
            if (att.getStringValue().equals("0-0-17")) {
                scaleS = sdata.getScalarString(m);
                continue;
            }
            if (att.getStringValue().equals("0-0-18")) {
                signRef = sdata.getScalarString(m).trim();
                continue;
            }
            if (att.getStringValue().equals("0-0-19")) {
                refS = sdata.getScalarString(m);
                continue;
            }
            if (!att.getStringValue().equals("0-0-20")) continue;
            widthS = sdata.getScalarString(m);
        }
        String desc = null;
        int pos = (name = name.trim()).indexOf(32);
        if (pos > 0) {
            desc = WmoXmlReader.cleanName(name.substring(pos + 1));
            name = name.substring(0, pos);
        }
        units = WmoXmlReader.cleanUnit(units.trim());
        int scale = Integer.parseInt(scaleS.trim());
        int refVal = Integer.parseInt(refS.trim());
        int width = Integer.parseInt(widthS.trim());
        short x1 = Short.parseShort(x.trim());
        short y1 = Short.parseShort(y.trim());
        if ("-".equals(signScale)) {
            scale = -1 * scale;
        }
        if ("-".equals(signRef)) {
            refVal = -1 * refVal;
        }
        this.b.addDescriptor(x1, y1, scale, refVal, width, name, units, desc);
    }

    private void addTableEntryD(StructureData sdata) throws IOException {
        String f = null;
        String x = null;
        String y = null;
        String name = null;
        List<Short> dds = null;
        List<StructureMembers.Member> members = sdata.getMembers();
        List<Variable> vars = this.seq3.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = vars.get(i);
            StructureMembers.Member m = members.get(i);
            if (m.getName().equals("seq4")) {
                dds = this.getDescriptors(sdata.getArraySequence(m));
                continue;
            }
            Attribute att = v.findAttribute("BUFR:TableB_descriptor");
            if (att == null) continue;
            if (att.getStringValue().equals("0-0-10")) {
                f = sdata.getScalarString(m);
                continue;
            }
            if (att.getStringValue().equals("0-0-11")) {
                x = sdata.getScalarString(m);
                continue;
            }
            if (!att.getStringValue().equals("0-0-12")) continue;
            y = sdata.getScalarString(m);
        }
        short f1 = Short.parseShort(f.trim());
        short x1 = Short.parseShort(x.trim());
        short y1 = Short.parseShort(y.trim());
        this.d.addDescriptor(x1, y1, name, dds);
    }

    private List<Short> getDescriptors(ArraySequence seqdata) throws IOException {
        ArrayList<Short> list = new ArrayList<Short>();
        String fxyS = null;
        List<Variable> vars = this.seq4.getVariables();
        StructureDataIterator iter = seqdata.getStructureDataIterator();
        while (iter.hasNext()) {
            StructureData sdata = iter.next();
            List<StructureMembers.Member> members = sdata.getMembers();
            for (int i = 0; i < vars.size(); ++i) {
                Variable v = vars.get(i);
                StructureMembers.Member m = members.get(i);
                String data = sdata.getScalarString(m);
                Attribute att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null || !att.getStringValue().equals("0-0-30")) continue;
                fxyS = sdata.getScalarString(m);
            }
            short id = Descriptor.getFxy2(fxyS);
            list.add(id);
        }
        return list;
    }

    TableLookup getTableLookup() throws IOException {
        if (!this.tableRead) {
            this.read2();
            this.tableRead = true;
            this.lookup = new TableLookup(this.ids, this.b, this.d);
        }
        return this.lookup;
    }

    private static class FakeNetcdfFile
    extends NetcdfFile {
        private FakeNetcdfFile() {
        }
    }
}

