/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.TimeUnitConverter;
import ucar.unidata.util.StringUtil2;

public class FeatureCollectionConfig {
    public static final String AUX_GRIB_CONFIG = "gribConfig";
    private static boolean regularizeDefault = false;
    private static Logger log = LoggerFactory.getLogger(FeatureCollectionConfig.class);
    public String name;
    public String spec;
    public String dateFormatMark;
    public String olderThan;
    public String timePartition;
    public UpdateConfig tdmConfig;
    public UpdateConfig updateConfig = new UpdateConfig();
    public ProtoConfig protoConfig = new ProtoConfig();
    public FmrcConfig fmrcConfig = new FmrcConfig();
    public PointConfig pointConfig = new PointConfig();
    public GribConfig gribConfig = new GribConfig();
    public Element innerNcml = null;
    public boolean useIndexOnly = false;
    private static Set<FmrcDatasetType> defaultFmrcDatasetTypes = Collections.unmodifiableSet(EnumSet.of(FmrcDatasetType.TwoD, FmrcDatasetType.Best, FmrcDatasetType.Files, FmrcDatasetType.Runs));
    private static Set<PointDatasetType> defaultPointDatasetTypes = Collections.unmodifiableSet(EnumSet.of(PointDatasetType.cdmrFeature, PointDatasetType.Files));
    private static Set<GribDatasetType> defaultGribDatasetTypes = Collections.unmodifiableSet(EnumSet.of(GribDatasetType.Collection, GribDatasetType.Files));

    public static void setRegularizeDefault(boolean t) {
        regularizeDefault = t;
    }

    public static boolean getRegularizeDefault() {
        return regularizeDefault;
    }

    public FeatureCollectionConfig() {
    }

    public FeatureCollectionConfig(String name, String spec, String dateFormatMark, String olderThan, String recheckAfter, String timePartition, String useIndexOnlyS, Element innerNcml) {
        this.name = name;
        this.spec = spec;
        this.dateFormatMark = dateFormatMark;
        this.olderThan = olderThan;
        if (recheckAfter != null) {
            this.updateConfig.recheckAfter = recheckAfter;
        }
        this.timePartition = timePartition;
        this.useIndexOnly = useIndexOnlyS != null && useIndexOnlyS.equalsIgnoreCase("true");
        this.innerNcml = innerNcml;
    }

    public boolean isTrigggerOk() {
        if (this.updateConfig.triggerOk) {
            return true;
        }
        return this.tdmConfig != null && this.tdmConfig.triggerOk;
    }

    public String toString() {
        return "FeatureCollectionConfig{name='" + this.name + '\'' + ", spec='" + this.spec + '\'' + ", dateFormatMark='" + this.dateFormatMark + '\'' + ", olderThan='" + this.olderThan + '\'' + ", timePartition=" + this.timePartition + ", updateConfig=" + this.updateConfig + ", tdmConfig=" + this.tdmConfig + ", protoConfig=" + this.protoConfig + ", fmrcConfig=" + this.fmrcConfig + ", pointConfig=" + this.pointConfig + ", hasInnerNcml=" + (this.innerNcml != null) + '}';
    }

    static /* synthetic */ boolean access$100() {
        return regularizeDefault;
    }

    static /* synthetic */ Set access$200() {
        return defaultFmrcDatasetTypes;
    }

    static /* synthetic */ Set access$300() {
        return defaultPointDatasetTypes;
    }

    static /* synthetic */ Set access$400() {
        return defaultGribDatasetTypes;
    }

    private static class TimeUnitConverterHash
    implements TimeUnitConverter {
        Map<Integer, Integer> map = new HashMap<Integer, Integer>(5);

        private TimeUnitConverterHash() {
        }

        @Override
        public int convertTimeUnit(int timeUnit) {
            if (this.map == null) {
                return timeUnit;
            }
            Integer convert = this.map.get(timeUnit);
            return convert == null ? timeUnit : convert;
        }
    }

    public static class GribIntvFilter {
        List<GribIntvFilterParam> filter;
        boolean isZeroExcluded;

        public boolean isZeroExcluded() {
            return this.isZeroExcluded;
        }

        public boolean hasFilter() {
            return this.filter != null;
        }

        public boolean filterOut(int id, int hasLength, int prob) {
            if (this.filter == null) {
                return false;
            }
            for (GribIntvFilterParam param : this.filter) {
                boolean isMine;
                boolean needProb = param.prob != Integer.MIN_VALUE;
                boolean hasProb = prob != Integer.MIN_VALUE;
                boolean bl = isMine = !needProb || hasProb && param.prob == prob;
                if (param.id != id || !isMine) continue;
                return param.intvLength != hasLength;
            }
            return false;
        }

        void addVariable(int intvLength, String idS, String probS) {
            if (idS == null) {
                log.warn("Error on intvFilter: must have an id attribute");
                return;
            }
            String[] s = idS.split("-");
            if (s.length != 3 && s.length != 4) {
                log.warn("Error on intvFilter: id attribute must be of format 'discipline-category-number' (GRIB2) or 'center-subcenter-version-param' (GRIB1)");
                return;
            }
            try {
                int prob;
                int id;
                if (s.length == 3) {
                    int discipline = Integer.parseInt(s[0]);
                    int category = Integer.parseInt(s[1]);
                    int number = Integer.parseInt(s[2]);
                    id = (discipline << 16) + (category << 8) + number;
                } else {
                    int center = Integer.parseInt(s[0]);
                    int subcenter = Integer.parseInt(s[1]);
                    int version = Integer.parseInt(s[2]);
                    int param = Integer.parseInt(s[3]);
                    id = (center << 8) + (subcenter << 16) + (version << 24) + param;
                }
                int n = prob = probS == null ? Integer.MIN_VALUE : Integer.parseInt(probS);
                if (this.filter == null) {
                    this.filter = new ArrayList<GribIntvFilterParam>(10);
                }
                this.filter.add(new GribIntvFilterParam(id, intvLength, prob));
            }
            catch (NumberFormatException e) {
                log.info("Error on intvFilter element - attribute must be an integer");
            }
        }
    }

    static class GribIntvFilterParam {
        int id;
        int intvLength;
        int prob = Integer.MIN_VALUE;

        GribIntvFilterParam(int id, int intvLength, int prob) {
            this.id = id;
            this.intvLength = intvLength;
            this.prob = prob;
        }
    }

    public static class GribConfig {
        public Set<GribDatasetType> datasets = FeatureCollectionConfig.access$400();
        public Map<Integer, Integer> gdsHash;
        public Map<Integer, String> gdsNamer;
        public String groupNamer;
        public String lookupTablePath;
        public String paramTablePath;
        public Element paramTable;
        public Boolean intvMerge = null;
        public Boolean useGenType = null;
        public GribIntvFilter intvFilter;
        private TimeUnitConverterHash tuc;
        private boolean explicitDatasets = false;

        public TimeUnitConverter getTimeUnitConverter() {
            return this.tuc;
        }

        public void configFromXml(Element configElem, Namespace ns) {
            String datasetTypes = configElem.getAttributeValue("datasetTypes");
            if (null != datasetTypes) {
                this.addDatasetType(datasetTypes);
            }
            List gdsElems = configElem.getChildren("gdsHash", ns);
            for (Element gds : gdsElems) {
                this.addGdsHash(gds.getAttributeValue("from"), gds.getAttributeValue("to"));
            }
            List tuElems = configElem.getChildren("timeUnitConvert", ns);
            for (Element tu : tuElems) {
                this.addTimeUnitConvert(tu.getAttributeValue("from"), tu.getAttributeValue("to"));
            }
            gdsElems = configElem.getChildren("gdsName", ns);
            for (Element gds : gdsElems) {
                this.addGdsName(gds.getAttributeValue("hash"), gds.getAttributeValue("groupName"));
            }
            if (configElem.getChild("parameterMap", ns) != null) {
                this.paramTable = configElem.getChild("parameterMap", ns);
            }
            if (configElem.getChild("gribParameterTable", ns) != null) {
                this.paramTablePath = configElem.getChildText("gribParameterTable", ns);
            }
            if (configElem.getChild("gribParameterTableLookup", ns) != null) {
                this.lookupTablePath = configElem.getChildText("gribParameterTableLookup", ns);
            }
            if (configElem.getChild("groupNamer", ns) != null) {
                this.groupNamer = configElem.getChildText("groupNamer", ns);
            }
            List intvElems = configElem.getChildren("intvFilter", ns);
            for (Element intvElem : intvElems) {
                String intvLengthS;
                String excludeZero;
                if (this.intvFilter == null) {
                    this.intvFilter = new GribIntvFilter();
                }
                if ((excludeZero = intvElem.getAttributeValue("excludeZero")) != null) {
                    this.intvFilter.isZeroExcluded = true;
                }
                if ((intvLengthS = intvElem.getAttributeValue("intvLength")) == null) continue;
                int intvLength = Integer.parseInt(intvLengthS);
                List varElems = intvElem.getChildren("variable", ns);
                for (Element varElem : varElems) {
                    this.intvFilter.addVariable(intvLength, varElem.getAttributeValue("id"), varElem.getAttributeValue("prob"));
                }
            }
            if (configElem.getChild("intvMerge", ns) != null) {
                this.intvMerge = true;
            }
            if (configElem.getChild("useGenType", ns) != null) {
                this.useGenType = true;
            }
        }

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicitDatasets) {
                this.datasets = EnumSet.noneOf(GribDatasetType.class);
            }
            this.explicitDatasets = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    GribDatasetType fdt = GribDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize GribDatasetType {}", (Object)type);
                }
            }
        }

        public void addGdsHash(String fromS, String toS) {
            if (fromS == null || toS == null) {
                return;
            }
            if (this.gdsHash == null) {
                this.gdsHash = new HashMap<Integer, Integer>(10);
            }
            try {
                int from = Integer.parseInt(fromS);
                int to = Integer.parseInt(toS);
                this.gdsHash.put(from, to);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)fromS, (Object)toS);
            }
        }

        public void addTimeUnitConvert(String fromS, String toS) {
            if (fromS == null || toS == null) {
                return;
            }
            if (this.tuc == null) {
                this.tuc = new TimeUnitConverterHash();
            }
            try {
                int from = Integer.parseInt(fromS);
                int to = Integer.parseInt(toS);
                this.tuc.map.put(from, to);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)fromS, (Object)toS);
            }
        }

        public void addGdsName(String hashS, String name) {
            if (hashS == null || name == null) {
                return;
            }
            if (this.gdsNamer == null) {
                this.gdsNamer = new HashMap<Integer, String>(5);
            }
            try {
                int hash = Integer.parseInt(hashS);
                this.gdsNamer.put(hash, name);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)hashS, (Object)name);
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("GribConfig: datasetTypes=%s", this.datasets);
            return f.toString();
        }
    }

    public static class PointConfig {
        public Set<PointDatasetType> datasets = FeatureCollectionConfig.access$300();
        protected boolean explicit = false;

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(PointDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    PointDatasetType fdt = PointDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize PointDatasetType " + type);
                }
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("PointConfig: datasetTypes=%s", this.datasets);
            return f.toString();
        }
    }

    public static class BestDataset {
        public String name;
        public double greaterThan;

        public BestDataset(String name, double greaterThan) {
            this.name = name;
            this.greaterThan = greaterThan;
        }
    }

    public static class FmrcConfig {
        public boolean regularize = FeatureCollectionConfig.access$100();
        public Set<FmrcDatasetType> datasets = FeatureCollectionConfig.access$200();
        private boolean explicit = false;
        private List<BestDataset> bestDatasets = null;

        public FmrcConfig() {
        }

        public FmrcConfig(String regularize) {
            this.regularize = regularize != null && regularize.equalsIgnoreCase("true");
        }

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(FmrcDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    FmrcDatasetType fdt = FmrcDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize FmrcDatasetType " + type);
                }
            }
        }

        public void addBestDataset(String name, double greaterEqual) {
            if (this.bestDatasets == null) {
                this.bestDatasets = new ArrayList<BestDataset>(2);
            }
            this.bestDatasets.add(new BestDataset(name, greaterEqual));
        }

        public List<BestDataset> getBestDatasets() {
            return this.bestDatasets;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("FmrcConfig: regularize=%s datasetTypes=%s", this.regularize, this.datasets);
            if (this.bestDatasets != null) {
                for (BestDataset bd : this.bestDatasets) {
                    f.format("best = (%s, %f) ", bd.name, bd.greaterThan);
                }
            }
            return f.toString();
        }
    }

    public static class ProtoConfig {
        public ProtoChoice choice = ProtoChoice.Penultimate;
        public String param = null;
        public String change = null;
        public Element outerNcml = null;
        public boolean cacheAll = true;

        public ProtoConfig() {
        }

        public ProtoConfig(String choice, String change, String param, Element ncml) {
            if (choice != null) {
                try {
                    this.choice = ProtoChoice.valueOf(choice);
                }
                catch (Exception e) {
                    log.warn("Dont recognize ProtoChoice " + choice);
                }
            }
            this.change = change;
            this.param = param;
            this.outerNcml = ncml;
        }

        public String toString() {
            return "ProtoConfig{choice=" + (Object)((Object)this.choice) + ", change='" + this.change + '\'' + ", param='" + this.param + '\'' + ", outerNcml='" + this.outerNcml + '\'' + ", cacheAll=" + this.cacheAll + '}';
        }
    }

    public static class UpdateConfig {
        public String recheckAfter;
        public String rescan;
        public boolean triggerOk;
        public boolean startup;
        public String deleteAfter = null;

        public UpdateConfig() {
        }

        public UpdateConfig(String startupS, String recheckAfter, String rescan, String triggerS, String deleteAfter) {
            this.rescan = rescan;
            if (recheckAfter != null) {
                this.recheckAfter = recheckAfter;
            }
            this.deleteAfter = deleteAfter;
            if (startupS != null && startupS.equalsIgnoreCase("true")) {
                this.startup = true;
            }
            if (triggerS != null) {
                this.triggerOk = triggerS.equalsIgnoreCase("allow");
            }
        }

        public boolean isStatic() {
            return this.recheckAfter == null && this.rescan == null && this.deleteAfter == null && !this.triggerOk && !this.startup;
        }

        public String toString() {
            return "UpdateConfig{startup=" + this.startup + ", recheckAfter='" + this.recheckAfter + '\'' + ", rescan='" + this.rescan + '\'' + ", triggerOk=" + this.triggerOk + ", deleteAfter=" + this.deleteAfter + '}';
        }
    }

    public static enum GribDatasetType {
        Collection,
        Files;

    }

    public static enum PointDatasetType {
        cdmrFeature,
        Files;

    }

    public static enum FmrcDatasetType {
        TwoD,
        Best,
        Files,
        Runs,
        ConstantForecasts,
        ConstantOffsets;

    }

    public static enum ProtoChoice {
        First,
        Random,
        Latest,
        Penultimate,
        Run;

    }
}

