/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArraySequence;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.N3iosp;

public class WriteT41_ncRect {
    private static boolean debug = true;
    private static long maxSize = 1000000L;

    WriteT41_ncRect(NetcdfFile bufr, String fileOutName, boolean fill) throws IOException, InvalidRangeException {
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew(fileOutName, fill);
        if (debug) {
            System.out.println("FileWriter write " + bufr.getLocation() + " to " + fileOutName);
        }
        List<Attribute> glist = bufr.getGlobalAttributes();
        for (Attribute att : glist) {
            String useName = N3iosp.makeValidNetcdfObjectName(att.getName());
            Attribute useAtt = att.isArray() ? ncfile.addGlobalAttribute(useName, att.getValues()) : (att.isString() ? ncfile.addGlobalAttribute(useName, att.getStringValue()) : ncfile.addGlobalAttribute(useName, att.getNumericValue()));
            if (!debug) continue;
            System.out.println("add gatt= " + useAtt);
        }
        Dimension recordDim = null;
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (Dimension oldD : bufr.getDimensions()) {
            String useName;
            boolean isRecord = (useName = N3iosp.makeValidNetcdfObjectName(oldD.getName())).equals("record");
            Dimension newD = ncfile.addDimension(useName, isRecord ? 0 : oldD.getLength(), oldD.isShared(), isRecord, oldD.isVariableLength());
            dimHash.put(newD.getName(), newD);
            if (isRecord) {
                recordDim = newD;
            }
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        Structure recordStruct = (Structure)bufr.findVariable("obs");
        for (Variable oldVar : recordStruct.getVariables()) {
            if (oldVar.getDataType() == DataType.SEQUENCE) continue;
            String varName = N3iosp.makeValidNetcdfObjectName(oldVar.getShortName());
            DataType newType = oldVar.getDataType();
            ArrayList<Dimension> newDims = new ArrayList<Dimension>();
            newDims.add(recordDim);
            for (Dimension dim : oldVar.getDimensions()) {
                newDims.add(ncfile.addDimension(oldVar.getShortName() + "_strlen", dim.getLength()));
            }
            Variable newVar = ncfile.addVariable(varName, newType, newDims);
            if (debug) {
                System.out.println("add var= " + newVar);
            }
            List<Attribute> attList = oldVar.getAttributes();
            for (Attribute att : attList) {
                String useName = N3iosp.makeValidNetcdfObjectName(att.getName());
                if (att.isArray()) {
                    ncfile.addVariableAttribute(varName, useName, att.getValues());
                    continue;
                }
                if (att.isString()) {
                    ncfile.addVariableAttribute(varName, useName, att.getStringValue());
                    continue;
                }
                ncfile.addVariableAttribute(varName, useName, att.getNumericValue());
            }
        }
        int max_seq = this.countSeq(recordStruct);
        Dimension seqD = ncfile.addDimension("level", max_seq);
        for (Variable v : recordStruct.getVariables()) {
            if (v.getDataType() != DataType.SEQUENCE) continue;
            Structure seq = (Structure)v;
            for (Variable seqVar : seq.getVariables()) {
                String varName = N3iosp.makeValidNetcdfObjectName(seqVar.getShortName());
                DataType newType = seqVar.getDataType();
                ArrayList<Dimension> newDims = new ArrayList<Dimension>();
                newDims.add(recordDim);
                newDims.add(seqD);
                for (Dimension dim : seqVar.getDimensions()) {
                    newDims.add(ncfile.addDimension(seqVar.getShortName() + "_strlen", dim.getLength()));
                }
                Variable newVar = ncfile.addVariable(varName, newType, newDims);
                if (debug) {
                    System.out.println("add var= " + newVar);
                }
                List<Attribute> attList = seqVar.getAttributes();
                for (Attribute att : attList) {
                    String useName = N3iosp.makeValidNetcdfObjectName(att.getName());
                    if (att.isArray()) {
                        ncfile.addVariableAttribute(varName, useName, att.getValues());
                        continue;
                    }
                    if (att.isString()) {
                        ncfile.addVariableAttribute(varName, useName, att.getStringValue());
                        continue;
                    }
                    ncfile.addVariableAttribute(varName, useName, att.getNumericValue());
                }
            }
        }
        ncfile.create();
        if (debug) {
            System.out.println("File Out= " + ncfile.toString());
        }
        double total = this.copyVarData(bufr, ncfile, recordStruct);
        ncfile.flush();
        if (debug) {
            System.out.println("FileWriter done total bytes = " + total);
        }
        ncfile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countSeq(Structure recordStruct) throws IOException {
        int total = 0;
        int count = 0;
        int max = 0;
        StructureDataIterator iter = recordStruct.getStructureIterator();
        try {
            while (iter.hasNext()) {
                StructureData sdata = iter.next();
                ArraySequence seq1 = sdata.getArraySequence("seq1");
                int n = seq1.getStructureDataCount();
                total += n;
                ++count;
                max = Math.max(max, n);
            }
        }
        finally {
            iter.finish();
        }
        double avg = total / count;
        int wasted = count * max - total;
        double wp = (double)wasted / (double)(count * max);
        System.out.println(" Max = " + max + " avg = " + avg + " wasted = " + wasted + " %= " + wp);
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double copyVarData(NetcdfFile bufr, NetcdfFileWriteable ncfile, Structure recordStruct) throws IOException, InvalidRangeException {
        int nrecs = (int)recordStruct.getSize();
        int sdataSize = recordStruct.getElementSize();
        double total = 0.0;
        double totalRecordBytes = 0.0;
        for (int count = 0; count < nrecs; ++count) {
            StructureData recordData = recordStruct.readStructure(count);
            for (StructureMembers.Member m : recordData.getMembers()) {
                if (m.getDataType() == DataType.SEQUENCE) {
                    int countLevel = 0;
                    ArraySequence seq1 = recordData.getArraySequence(m);
                    StructureDataIterator iter = seq1.getStructureDataIterator();
                    try {
                        while (iter.hasNext()) {
                            StructureData seqData = iter.next();
                            for (StructureMembers.Member seqm : seqData.getMembers()) {
                                Array data = seqData.getArray(seqm);
                                int[] shape = data.getShape();
                                int[] newShape = new int[data.getRank() + 2];
                                newShape[0] = 1;
                                newShape[1] = 1;
                                for (int i = 0; i < data.getRank(); ++i) {
                                    newShape[i + 1] = shape[i];
                                }
                                int[] origin = new int[data.getRank() + 2];
                                origin[0] = count;
                                origin[1] = countLevel;
                                if (debug && count == 0 && countLevel == 0) {
                                    System.out.println("write to = " + seqm.getName());
                                }
                                ncfile.write(seqm.getName(), origin, data.reshape(newShape));
                            }
                            ++countLevel;
                        }
                        continue;
                    }
                    finally {
                        iter.finish();
                        continue;
                    }
                }
                Array data = recordData.getArray(m);
                int[] shape = data.getShape();
                int[] newShape = new int[data.getRank() + 1];
                newShape[0] = 1;
                for (int i = 0; i < data.getRank(); ++i) {
                    newShape[i + 1] = shape[i];
                }
                int[] origin = new int[data.getRank() + 1];
                origin[0] = count;
                if (debug && count == 0) {
                    System.out.println("write to = " + m.getName());
                }
                ncfile.write(m.getName(), origin, data.reshape(newShape));
            }
            totalRecordBytes += (double)sdataSize;
        }
        total += totalRecordBytes;
        totalRecordBytes /= 1000000.0;
        if (debug) {
            System.out.println("write record var; total = " + totalRecordBytes + " Mbytes # recs=" + nrecs);
        }
        return total;
    }

    private void copyAll(NetcdfFileWriteable ncfile, Variable oldVar) throws IOException {
        String newName = N3iosp.makeValidNetcdfObjectName(oldVar.getShortName());
        Array data = oldVar.read();
        try {
            if (oldVar.getDataType() == DataType.STRING) {
                data = this.convertToChar(ncfile.findVariable(newName), data);
            }
            if (data.getSize() > 0L) {
                ncfile.write(newName, data);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage() + " for Variable " + oldVar.getFullName());
        }
    }

    private void copySome(NetcdfFileWriteable ncfile, Variable oldVar, int nelems) throws IOException {
        String newName = N3iosp.makeValidNetcdfObjectName(oldVar.getShortName());
        int[] shape = oldVar.getShape();
        int[] origin = new int[oldVar.getRank()];
        int size = shape[0];
        for (int i = 0; i < size; i += nelems) {
            origin[0] = i;
            int left = size - i;
            shape[0] = Math.min(nelems, left);
            try {
                Array data = oldVar.read(origin, shape);
                if (oldVar.getDataType() == DataType.STRING) {
                    data = this.convertToChar(ncfile.findVariable(newName), data);
                }
                if (data.getSize() <= 0L) continue;
                ncfile.write(newName, origin, data);
                if (!debug) continue;
                System.out.println("write " + data.getSize() + " bytes");
                continue;
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    private Array convertToChar(Variable newVar, Array oldData) {
        ArrayChar newData = (ArrayChar)Array.factory(DataType.CHAR, newVar.getShape());
        Index ima = newData.getIndex();
        IndexIterator ii = oldData.getIndexIterator();
        while (ii.hasNext()) {
            String s = (String)ii.getObjectNext();
            int[] c = ii.getCurrentCounter();
            for (int i = 0; i < c.length; ++i) {
                ima.setDim(i, c[i]);
            }
            newData.setString(ima, s);
        }
        return newData;
    }
}

