/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib1.Grib1Record;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib1.GribPDSLevel;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTableLookup;

public class Grib1GridTableLookup
implements GridTableLookup {
    private static Logger logger = LoggerFactory.getLogger(Grib1GridTableLookup.class);
    private final Grib1Pds firstPDSV;

    public Grib1GridTableLookup(Grib1Record firstRecord) {
        this.firstPDSV = firstRecord.getPDS().getPdsVars();
    }

    @Override
    public final String getGridName(GridDefRecord gds) {
        return Grib1Tables.getGridName(gds.getParamInt("grid_type"));
    }

    @Override
    public final String getShapeName(GridDefRecord gds) {
        return Grib1Tables.getShapeName(gds.getParamInt("grid_shape_code"));
    }

    @Override
    public final String getDisciplineName(GridRecord gr) {
        return "Meteorological Products";
    }

    @Override
    public final String getCategoryName(GridRecord gr) {
        return "Meteorological Parameters";
    }

    @Override
    public final GridParameter getParameter(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.getParameter();
    }

    @Override
    public final String getSource() {
        return Grib1Tables.getTimeRangeIndicatorName(this.firstPDSV.getTimeRangeIndicator());
    }

    public final String getGenProcessName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib1Tables.getTypeGenProcessName(this.firstPDSV.getCenter(), ggr.getPds().getGenProcessId());
    }

    @Override
    public final String getLevelName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return GribPDSLevel.getNameShort(ggr.getLevelType1());
    }

    @Override
    public final String getLevelDescription(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return GribPDSLevel.getLevelDescription(ggr.getLevelType1());
    }

    @Override
    public final String getLevelUnit(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return GribPDSLevel.getUnits(ggr.getLevelType1());
    }

    @Override
    public final Date getFirstBaseTime() {
        return this.firstPDSV.getReferenceDate();
    }

    @Override
    public final String getTimeRangeUnitName(int tunit) {
        return Grib1Tables.getTimeUnit(this.firstPDSV.getTimeUnit(), false);
    }

    public final String getFirstCenterName() {
        return Grib1Tables.getCenter_idName(this.firstPDSV.getCenter()) + " (" + Integer.toString(this.firstPDSV.getCenter()) + ")";
    }

    public final int getFirstCenterId() {
        return this.firstPDSV.getCenter();
    }

    public final int getFirstSubcenterId() {
        return this.firstPDSV.getSubCenter();
    }

    public final int getFirstTableVersion() {
        return this.firstPDSV.getParameterTableVersion();
    }

    public final String getFirstSubcenterName() {
        String subcenter = Grib1Tables.getSubCenter_idName(this.firstPDSV.getCenter(), this.firstPDSV.getSubCenter());
        if (subcenter == null) {
            return null;
        }
        return subcenter + " (" + Integer.toString(this.firstPDSV.getSubCenter()) + ")";
    }

    @Override
    public String getInstitution() {
        String subcenter = this.getFirstSubcenterName();
        if (subcenter == null) {
            return "Center " + this.getFirstCenterName();
        }
        return "Center " + this.getFirstCenterName() + " Subcenter " + subcenter;
    }

    public final String getFirstProductStatusName() {
        return null;
    }

    @Override
    public final String getComment() {
        return null;
    }

    public final String getFirstProductTypeName() {
        return Grib1Tables.getTimeRangeIndicatorName(this.firstPDSV.getTimeRangeIndicator());
    }

    public final String getFirstSignificanceOfRTName() {
        return "Start of forecast";
    }

    @Override
    public final boolean isLatLon(GridDefRecord gds) {
        int grid_type = gds.getParamInt("grid_type");
        return grid_type == 0 || grid_type == 4 || grid_type == 14 || grid_type == 24 || grid_type == 34;
    }

    @Override
    public final int getProjectionType(GridDefRecord gds) {
        switch (gds.getParamInt("grid_type")) {
            case 1: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 10: {
                return 10;
            }
        }
        return -1;
    }

    @Override
    public final boolean isVerticalCoordinate(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        int levelType = ggr.getLevelType1();
        if (levelType == 20) {
            return true;
        }
        if (levelType == 100) {
            return true;
        }
        if (levelType == 101) {
            return true;
        }
        if (levelType >= 103 && levelType <= 128) {
            return true;
        }
        if (levelType == 141) {
            return true;
        }
        return levelType == 160;
    }

    @Override
    public final boolean isPositiveUp(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        int levelType = ggr.getLevelType1();
        if (levelType == 103) {
            return true;
        }
        if (levelType == 104) {
            return true;
        }
        if (levelType == 105) {
            return true;
        }
        if (levelType == 106) {
            return true;
        }
        if (levelType == 111) {
            return true;
        }
        if (levelType == 112) {
            return true;
        }
        return levelType == 125;
    }

    @Override
    public final float getFirstMissingValue() {
        return -9999.0f;
    }

    @Override
    public final boolean isLayer(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        int levelType = ggr.getLevelType1();
        if (levelType == 101) {
            return true;
        }
        if (levelType == 104) {
            return true;
        }
        if (levelType == 106) {
            return true;
        }
        if (levelType == 108) {
            return true;
        }
        if (levelType == 110) {
            return true;
        }
        if (levelType == 112) {
            return true;
        }
        if (levelType == 114) {
            return true;
        }
        if (levelType == 116) {
            return true;
        }
        if (levelType == 120) {
            return true;
        }
        if (levelType == 121) {
            return true;
        }
        if (levelType == 128) {
            return true;
        }
        return levelType == 141;
    }

    @Override
    public final String getTitle() {
        String productType;
        String grid;
        StringBuilder title = new StringBuilder(Grib1Tables.getCenter_idName(this.firstPDSV.getCenter()));
        String model = Grib1Tables.getModelName(this.firstPDSV.getCenter(), this.firstPDSV.getGenProcessId());
        if (model != null) {
            title.append(" ");
            title.append(model);
        }
        if (this.firstPDSV.getCenter() != 7 && (grid = Grib1Tables.getGridDefinition(this.firstPDSV.getGenProcessId())) != null) {
            title.append(" ");
            title.append(grid);
        }
        if ((productType = Grib1Tables.getTimeRangeIndicatorName(this.firstPDSV.getTimeRangeIndicator())) != null) {
            title.append(" ");
            title.append(productType);
        }
        return title.toString();
    }

    public final String getModel() {
        return Grib1Tables.getModelName(this.firstPDSV.getCenter(), this.firstPDSV.getGenProcessId());
    }

    @Override
    public final String getGridType() {
        return "GRIB-1";
    }
}

