/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;

public class VerticalPerspectiveView
extends ProjectionImpl {
    private double lat0;
    private double lon0;
    private final double false_east;
    private final double false_north;
    private double R;
    private double H;
    private double P;
    private double lon0Degrees;
    private double cosLat0;
    private double sinLat0;
    private double maxR;
    private double maxR2;

    @Override
    public ProjectionImpl constructCopy() {
        VerticalPerspectiveView result = new VerticalPerspectiveView(this.getOriginLat(), this.getOriginLon(), this.R, this.getHeight(), this.false_east, this.false_north);
        result.setDefaultMapArea(this.defaultMapArea);
        return result;
    }

    public VerticalPerspectiveView() {
        this(0.0, 0.0, EARTH_RADIUS, 35800.0);
    }

    public VerticalPerspectiveView(double lat0, double lon0, double earthRadius, double distance) {
        this(lat0, lon0, earthRadius, distance, 0.0, 0.0);
    }

    public VerticalPerspectiveView(double lat0, double lon0, double earthRadius, double distance, double false_easting, double false_northing) {
        super("VerticalPerspectiveView", false);
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.R = earthRadius;
        this.H = distance;
        this.false_east = false_easting;
        this.false_north = false_northing;
        this.precalculate();
        this.addParameter("grid_mapping_name", "vertical_perspective");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("earth_radius", earthRadius * 1000.0);
        this.addParameter("perspective_point_height", distance * 1000.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    private void precalculate() {
        this.sinLat0 = Math.sin(this.lat0);
        this.cosLat0 = Math.cos(this.lat0);
        this.lon0Degrees = Math.toDegrees(this.lon0);
        this.P = 1.0 + this.H / this.R;
        this.maxR = 0.99 * this.R * Math.sqrt((this.P - 1.0) / (this.P + 1.0));
        this.maxR2 = this.maxR * this.maxR;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerticalPerspectiveView that = (VerticalPerspectiveView)o;
        if (Double.compare(that.H, this.H) != 0) {
            return false;
        }
        if (Double.compare(that.R, this.R) != 0) {
            return false;
        }
        if (Double.compare(that.false_east, this.false_east) != 0) {
            return false;
        }
        if (Double.compare(that.false_north, this.false_north) != 0) {
            return false;
        }
        if (Double.compare(that.lat0, this.lat0) != 0) {
            return false;
        }
        if (Double.compare(that.lon0, this.lon0) != 0) {
            return false;
        }
        if (this.defaultMapArea == null != (that.defaultMapArea == null)) {
            return false;
        }
        return this.defaultMapArea == null || that.defaultMapArea.equals(this.defaultMapArea);
    }

    public int hashCode() {
        long temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.false_east != 0.0 ? Double.doubleToLongBits(this.false_east) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.false_north != 0.0 ? Double.doubleToLongBits(this.false_north) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.R != 0.0 ? Double.doubleToLongBits(this.R) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.H != 0.0 ? Double.doubleToLongBits(this.H) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getHeight() {
        return this.H;
    }

    public double getOriginLon() {
        return Math.toDegrees(this.lon0);
    }

    public double getOriginLat() {
        return Math.toDegrees(this.lat0);
    }

    public void setOriginLon(double lon) {
        this.lon0 = Math.toRadians(lon);
        this.precalculate();
    }

    public void setHeight(double height) {
        this.H = height;
        this.precalculate();
    }

    public void setOriginLat(double lat) {
        this.lat0 = Math.toRadians(lat);
        this.precalculate();
    }

    @Override
    public String getProjectionTypeLabel() {
        return "VerticalPerspectiveView";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "VerticalPerspectiveView{lat0=" + this.lat0 + ", lon0=" + this.lon0 + ", false_east=" + this.false_east + ", false_north=" + this.false_north + ", R=" + this.R + ", H=" + this.H + ", P=" + this.P + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
        double cosc = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
        double ksp = (this.P - 1.0) / (this.P - cosc);
        if (cosc < 1.0 / this.P) {
            toX = Double.POSITIVE_INFINITY;
            toY = Double.POSITIVE_INFINITY;
        } else {
            toX = this.false_east + this.R * ksp * Math.cos(fromLat) * Math.sin(lonDiff);
            toY = this.false_north + this.R * ksp * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff));
        }
        result.setLocation(toX, toY);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double toLat;
        double fromX = world.getX();
        double fromY = world.getY();
        double rho = Math.sqrt((fromX -= this.false_east) * fromX + (fromY -= this.false_north) * fromY);
        double r = rho / this.R;
        double con = this.P - 1.0;
        double com = this.P + 1.0;
        double c = Math.asin((this.P - Math.sqrt(1.0 - r * r * com / con)) / (con / r + r / con));
        double toLon = this.lon0;
        double temp = 0.0;
        if (Math.abs(rho) > 1.0E-6) {
            toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
            if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
            } else if (this.lat0 == 0.7853981633974483) {
                toLon = this.lon0 + Math.atan(fromX / -fromY);
                temp = -fromY;
            } else {
                toLon = this.lon0 + Math.atan(fromX / fromY);
                temp = fromY;
            }
        } else {
            toLat = this.lat0;
        }
        toLat = Math.toDegrees(toLat);
        toLon = Math.toDegrees(toLon);
        if (temp < 0.0) {
            toLon += 180.0;
        }
        toLon = LatLonPointImpl.lonNormal(toLon);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toY;
            double toX;
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
            double cosc = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
            double ksp = (this.P - 1.0) / (this.P - cosc);
            if (cosc < 1.0 / this.P) {
                toX = Double.POSITIVE_INFINITY;
                toY = Double.POSITIVE_INFINITY;
            } else {
                toX = this.false_east + this.R * ksp * Math.cos(fromLat) * Math.sin(lonDiff);
                toY = this.false_north + this.R * ksp * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff));
            }
            resultXA[i] = (float)toX;
            resultYA[i] = (float)toY;
        }
        return to;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toLat;
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double rho = Math.sqrt((fromX -= this.false_east) * fromX + (fromY -= this.false_north) * fromY);
            double r = rho / this.R;
            double con = this.P - 1.0;
            double com = this.P + 1.0;
            double c = Math.asin((this.P - Math.sqrt(1.0 - r * r * com / con)) / (con / r + r / con));
            double toLon = this.lon0;
            double temp = 0.0;
            if (Math.abs(rho) > 1.0E-6) {
                toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
                if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                    temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                    toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
                } else if (this.lat0 == 0.7853981633974483) {
                    toLon = this.lon0 + Math.atan(fromX / -fromY);
                    temp = -fromY;
                } else {
                    toLon = this.lon0 + Math.atan(fromX / fromY);
                    temp = fromY;
                }
            } else {
                toLat = this.lat0;
            }
            toLat = Math.toDegrees(toLat);
            toLon = Math.toDegrees(toLon);
            if (temp < 0.0) {
                toLon += 180.0;
            }
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toY;
            double toX;
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
            double cosc = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
            double ksp = (this.P - 1.0) / (this.P - cosc);
            if (cosc < 1.0 / this.P) {
                toX = Double.POSITIVE_INFINITY;
                toY = Double.POSITIVE_INFINITY;
            } else {
                toX = this.false_east + this.R * ksp * Math.cos(fromLat) * Math.sin(lonDiff);
                toY = this.false_north + this.R * ksp * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff));
            }
            resultXA[i] = toX;
            resultYA[i] = toY;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toLat;
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double rho = Math.sqrt((fromX -= this.false_east) * fromX + (fromY -= this.false_north) * fromY);
            double r = rho / this.R;
            double con = this.P - 1.0;
            double com = this.P + 1.0;
            double c = Math.asin((this.P - Math.sqrt(1.0 - r * r * com / con)) / (con / r + r / con));
            double toLon = this.lon0;
            double temp = 0.0;
            if (Math.abs(rho) > 1.0E-6) {
                toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
                if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                    temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                    toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
                } else if (this.lat0 == 0.7853981633974483) {
                    toLon = this.lon0 + Math.atan(fromX / -fromY);
                    temp = -fromY;
                } else {
                    toLon = this.lon0 + Math.atan(fromX / fromY);
                    temp = fromY;
                }
            } else {
                toLat = this.lat0;
            }
            toLat = Math.toDegrees(toLat);
            toLon = Math.toDegrees(toLon);
            if (temp < 0.0) {
                toLon += 180.0;
            }
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProjectionRect latLonToProjBB(LatLonRect rect) {
        ProjectionPoint llpt = this.latLonToProj(rect.getLowerLeftPoint(), new ProjectionPointImpl());
        ProjectionPoint urpt = this.latLonToProj(rect.getUpperRightPoint(), new ProjectionPointImpl());
        ProjectionPoint lrpt = this.latLonToProj(rect.getLowerRightPoint(), new ProjectionPointImpl());
        ProjectionPoint ulpt = this.latLonToProj(rect.getUpperLeftPoint(), new ProjectionPointImpl());
        ArrayList<ProjectionPoint> goodPts = new ArrayList<ProjectionPoint>(4);
        int countBad = 0;
        if (!this.addGoodPts(goodPts, llpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, urpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, lrpt)) {
            ++countBad;
        }
        if (!this.addGoodPts(goodPts, ulpt)) {
            ++countBad;
        }
        if (countBad == 2) {
            if (!ProjectionPointImpl.isInfinite(llpt) && !ProjectionPointImpl.isInfinite(lrpt)) {
                this.addGoodPts(goodPts, new ProjectionPointImpl(0.0, this.maxR));
                return this.makeRect(goodPts);
            } else if (!ProjectionPointImpl.isInfinite(ulpt) && !ProjectionPointImpl.isInfinite(llpt)) {
                this.addGoodPts(goodPts, new ProjectionPointImpl(this.maxR, 0.0));
                return this.makeRect(goodPts);
            } else if (!ProjectionPointImpl.isInfinite(ulpt) && !ProjectionPointImpl.isInfinite(urpt)) {
                this.addGoodPts(goodPts, new ProjectionPointImpl(0.0, -this.maxR));
                return this.makeRect(goodPts);
            } else {
                if (ProjectionPointImpl.isInfinite(urpt) || ProjectionPointImpl.isInfinite(lrpt)) throw new IllegalStateException();
                this.addGoodPts(goodPts, new ProjectionPointImpl(-this.maxR, 0.0));
            }
            return this.makeRect(goodPts);
        } else {
            if (countBad != 3) return this.makeRect(goodPts);
            if (!ProjectionPointImpl.isInfinite(llpt)) {
                double xcoord = llpt.getX();
                this.addGoodPts(goodPts, new ProjectionPointImpl(xcoord, this.getLimitCoord(xcoord)));
                double ycoord = llpt.getY();
                this.addGoodPts(goodPts, new ProjectionPointImpl(this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else if (!ProjectionPointImpl.isInfinite(urpt)) {
                double xcoord = urpt.getX();
                this.addGoodPts(goodPts, new ProjectionPointImpl(xcoord, -this.getLimitCoord(xcoord)));
                double ycoord = urpt.getY();
                this.addGoodPts(goodPts, new ProjectionPointImpl(-this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else if (!ProjectionPointImpl.isInfinite(ulpt)) {
                double xcoord = ulpt.getX();
                this.addGoodPts(goodPts, new ProjectionPointImpl(xcoord, -this.getLimitCoord(xcoord)));
                double ycoord = ulpt.getY();
                this.addGoodPts(goodPts, new ProjectionPointImpl(this.getLimitCoord(ycoord), ycoord));
                return this.makeRect(goodPts);
            } else {
                if (ProjectionPointImpl.isInfinite(lrpt)) throw new IllegalStateException();
                double xcoord = lrpt.getX();
                this.addGoodPts(goodPts, new ProjectionPointImpl(xcoord, this.getLimitCoord(xcoord)));
                double ycoord = lrpt.getY();
                this.addGoodPts(goodPts, new ProjectionPointImpl(-this.getLimitCoord(ycoord), ycoord));
            }
        }
        return this.makeRect(goodPts);
    }

    private boolean addGoodPts(List<ProjectionPoint> goodPts, ProjectionPoint pt) {
        if (!ProjectionPointImpl.isInfinite(pt)) {
            goodPts.add(pt);
            return true;
        }
        return false;
    }

    private double getLimitCoord(double coord) {
        return Math.sqrt(this.maxR2 - coord * coord);
    }

    private ProjectionRect makeRect(List<ProjectionPoint> goodPts) {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        for (ProjectionPoint pp : goodPts) {
            minx = Math.min(minx, pp.getX());
            maxx = Math.max(maxx, pp.getX());
            miny = Math.min(miny, pp.getY());
            maxy = Math.max(maxy, pp.getY());
        }
        return new ProjectionRect(minx, miny, maxx, maxy);
    }

    private static void test(double lat, double lon) {
        double radius = 6371.0;
        VerticalPerspectiveView a = new VerticalPerspectiveView(0.0, 0.0, radius, 5.62 * radius);
        ProjectionPointImpl p = a.latLonToProj(lat, lon);
        System.out.println("-----\nproj point = " + p);
        System.out.println("x/r = " + p.getX() / radius);
        System.out.println("y/r = " + p.getY() / radius);
        LatLonPoint ll = a.projToLatLon(p);
        System.out.println(" lat = " + ll.getLatitude() + " should be= " + lat);
        System.out.println(" lon = " + ll.getLongitude() + " should be= " + lon);
    }

    public static void main2(String[] args) {
        VerticalPerspectiveView.test(40.0, 0.0);
        VerticalPerspectiveView.test(40.0, 40.0);
        VerticalPerspectiveView.test(0.0, 40.0);
    }

    public static void main(String[] args) {
        double radius = 6371.0;
        double height = 35747.0;
        VerticalPerspectiveView a = new VerticalPerspectiveView(0.0, 0.0, radius, height);
        double limit = 0.99 * Math.sqrt((a.P - 1.0) / (a.P + 1.0));
        System.out.println(" limit = " + limit);
        System.out.println(" limit*90 = " + limit * 90.0);
        LatLonRect rect = new LatLonRect(new LatLonPointImpl(-45.0, -45.0), -45.0, -45.0);
        ProjectionRect r = a.latLonToProjBB(rect);
        System.out.println(" ProjectionRect result = " + r);
    }
}

