/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.proj4.MapMath;

public class EquidistantAzimuthalProjection
extends ProjectionImpl {
    public static final int NORTH_POLE = 1;
    public static final int SOUTH_POLE = 2;
    public static final int EQUATOR = 3;
    public static final int OBLIQUE = 4;
    private static final double TOL = 1.0E-8;
    private double lat0;
    private double lon0;
    private double projectionLatitude;
    private double projectionLongitude;
    private double falseEasting;
    private double falseNorthing;
    private Earth earth;
    private double e;
    private double es;
    private double one_es;
    private double totalScale;
    private int mode;
    private double[] en;
    private double N1;
    private double Mp;
    private double He;
    private double G;
    private double sinphi0;
    private double cosphi0;

    public EquidistantAzimuthalProjection() {
        this(90.0, 0.0, 0.0, 0.0, new Earth());
    }

    public EquidistantAzimuthalProjection(double lat0, double lon0, double falseEasting, double falseNorthing, Earth earth) {
        super("EquidistantAzimuthalProjection", false);
        this.lat0 = lat0;
        this.lon0 = lon0;
        this.projectionLatitude = Math.toRadians(lat0);
        this.projectionLongitude = Math.toRadians(lon0);
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.earth = earth;
        this.e = earth.getEccentricity();
        this.es = earth.getEccentricitySquared();
        this.one_es = 1.0 - this.es;
        this.totalScale = earth.getMajor() * 0.001;
        this.addParameter("grid_mapping_name", "azimuthal_equidistant");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_central_meridian", lon0);
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            this.addParameter("false_easting", falseEasting);
            this.addParameter("false_northing", falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", earth.getMajor());
        this.addParameter("inverse_flattening", 1.0 / earth.getFlattening());
        this.initialize();
    }

    @Override
    public ProjectionImpl constructCopy() {
        EquidistantAzimuthalProjection result = new EquidistantAzimuthalProjection(this.lat0, this.lon0, this.falseEasting, this.falseNorthing, this.earth);
        result.setDefaultMapArea(this.defaultMapArea);
        return result;
    }

    private void initialize() {
        if (Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10) {
            this.mode = this.projectionLatitude < 0.0 ? 2 : 1;
            this.sinphi0 = this.projectionLatitude < 0.0 ? -1.0 : 1.0;
            this.cosphi0 = 0.0;
        } else if (Math.abs(this.projectionLatitude) < 1.0E-10) {
            this.mode = 3;
            this.sinphi0 = 0.0;
            this.cosphi0 = 1.0;
        } else {
            this.mode = 4;
            this.sinphi0 = Math.sin(this.projectionLatitude);
            this.cosphi0 = Math.cos(this.projectionLatitude);
        }
        if (!this.earth.isSpherical()) {
            this.en = MapMath.enfn(this.es);
            switch (this.mode) {
                case 1: {
                    this.Mp = MapMath.mlfn(1.5707963267948966, 1.0, 0.0, this.en);
                    break;
                }
                case 2: {
                    this.Mp = MapMath.mlfn(-1.5707963267948966, -1.0, 0.0, this.en);
                    break;
                }
                case 3: 
                case 4: {
                    this.N1 = 1.0 / Math.sqrt(1.0 - this.es * this.sinphi0 * this.sinphi0);
                    this.He = this.e / Math.sqrt(this.one_es);
                    this.G = this.sinphi0 * this.He;
                    this.He *= this.cosphi0;
                }
            }
        }
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl xy) {
        double lam = Math.toRadians(latlon.getLongitude() - this.lon0);
        double phi = Math.toRadians(latlon.getLatitude());
        if (this.earth.isSpherical()) {
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double coslam = Math.cos(lam);
            switch (this.mode) {
                case 3: 
                case 4: {
                    xy.y = this.mode == 3 ? cosphi * coslam : this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam;
                    if (Math.abs(Math.abs(xy.y) - 1.0) < 1.0E-8) {
                        if (xy.y < 0.0) {
                            throw new IllegalStateException();
                        }
                        xy.y = 0.0;
                        xy.x = 0.0;
                        break;
                    }
                    xy.y = Math.acos(xy.y);
                    xy.y /= Math.sin(xy.y);
                    xy.x = xy.y * cosphi * Math.sin(lam);
                    xy.y = xy.y * (this.mode == 3 ? sinphi : this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam);
                    break;
                }
                case 1: {
                    phi = -phi;
                    coslam = -coslam;
                }
                case 2: {
                    if (Math.abs(phi - 1.5707963267948966) < 1.0E-10) {
                        throw new IllegalStateException();
                    }
                    xy.y = 1.5707963267948966 + phi;
                    xy.x = xy.y * Math.sin(lam);
                    xy.y *= coslam;
                }
            }
        } else {
            double coslam = Math.cos(lam);
            double cosphi = Math.cos(phi);
            double sinphi = Math.sin(phi);
            switch (this.mode) {
                case 1: {
                    coslam = -coslam;
                }
                case 2: {
                    double rho = Math.abs(this.Mp - MapMath.mlfn(phi, sinphi, cosphi, this.en));
                    xy.x = rho * Math.sin(lam);
                    xy.y = rho * coslam;
                    break;
                }
                case 3: 
                case 4: {
                    if (Math.abs(lam) < 1.0E-10 && Math.abs(phi - this.projectionLatitude) < 1.0E-10) {
                        xy.y = 0.0;
                        xy.x = 0.0;
                        break;
                    }
                    double t = Math.atan2(this.one_es * sinphi + this.es * this.N1 * this.sinphi0 * Math.sqrt(1.0 - this.es * sinphi * sinphi), cosphi);
                    double ct = Math.cos(t);
                    double st = Math.sin(t);
                    double Az = Math.atan2(Math.sin(lam) * ct, this.cosphi0 * st - this.sinphi0 * coslam * ct);
                    double cA = Math.cos(Az);
                    double sA = Math.sin(Az);
                    double s = MapMath.asin(Math.abs(sA) < 1.0E-8 ? (this.cosphi0 * st - this.sinphi0 * coslam * ct) / cA : Math.sin(lam) * ct / sA);
                    double H = this.He * cA;
                    double H2 = H * H;
                    double c = this.N1 * s * (1.0 + s * s * (-H2 * (1.0 - H2) / 6.0 + s * (this.G * H * (1.0 - 2.0 * H2 * H2) / 8.0 + s * ((H2 * (4.0 - 7.0 * H2) - 3.0 * this.G * this.G * (1.0 - 7.0 * H2)) / 120.0 - s * this.G * H / 48.0))));
                    xy.x = c * sA;
                    xy.y = c * cA;
                }
            }
        }
        xy.setLocation(this.totalScale * xy.x + this.falseEasting, this.totalScale * xy.y + this.falseNorthing);
        return xy;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl lp) {
        double x = (ppt.getX() - this.falseEasting) / this.totalScale;
        double y = (ppt.getY() - this.falseNorthing) / this.totalScale;
        if (this.earth.isSpherical()) {
            double d;
            double c_rh = MapMath.distance(x, y);
            if (d > Math.PI) {
                if (c_rh - 1.0E-10 > Math.PI) {
                    throw new IllegalStateException();
                }
                c_rh = Math.PI;
            } else if (c_rh < 1.0E-10) {
                lp.setLatitude(this.lat0);
                lp.setLongitude(0.0);
                return lp;
            }
            if (this.mode == 4 || this.mode == 3) {
                double sinc = Math.sin(c_rh);
                double cosc = Math.cos(c_rh);
                if (this.mode == 3) {
                    lp.setLatitude(Math.toDegrees(MapMath.asin(y * sinc / c_rh)));
                    x *= sinc;
                    y = cosc * c_rh;
                } else {
                    lp.setLatitude(Math.toDegrees(MapMath.asin(cosc * this.sinphi0 + y * sinc * this.cosphi0 / c_rh)));
                    y = (cosc - this.sinphi0 * MapMath.sind(lp.getLatitude())) * c_rh;
                    x *= sinc * this.cosphi0;
                }
                lp.setLongitude(Math.toDegrees(y == 0.0 ? 0.0 : Math.atan2(x, y)));
            } else if (this.mode == 1) {
                lp.setLatitude(Math.toDegrees(1.5707963267948966 - c_rh));
                lp.setLongitude(Math.toDegrees(Math.atan2(x, -y)));
            } else {
                lp.setLatitude(Math.toDegrees(c_rh - 1.5707963267948966));
                lp.setLongitude(Math.toDegrees(Math.atan2(x, y)));
            }
        } else {
            double d;
            double c = MapMath.distance(x, y);
            if (d < 1.0E-10) {
                lp.setLatitude(this.lat0);
                lp.setLongitude(0.0);
                return lp;
            }
            if (this.mode == 4 || this.mode == 3) {
                double d2;
                double Az = Math.atan2(x, y);
                double cosAz = Math.cos(Az);
                double t = this.cosphi0 * cosAz;
                double B = this.es * t / this.one_es;
                double A = -B * t;
                double D = c / this.N1;
                double E = D * (1.0 - D * D * (A * (1.0 + A) / 6.0 + (B *= 3.0 * (1.0 - A) * this.sinphi0) * (1.0 + 3.0 * A) * D / 24.0));
                double F = 1.0 - E * E * (A / 2.0 + B * E / 6.0);
                double psi = MapMath.asin(this.sinphi0 * Math.cos(E) + t * Math.sin(E));
                lp.setLongitude(Math.toDegrees(MapMath.asin(Math.sin(Az) * Math.sin(E) / Math.cos(psi))));
                t = Math.abs(psi);
                if (d2 < 1.0E-10) {
                    lp.setLatitude(0.0);
                } else if (Math.abs(t - 1.5707963267948966) < 0.0) {
                    lp.setLatitude(Math.toDegrees(1.5707963267948966));
                } else {
                    lp.setLatitude(Math.toDegrees(Math.atan((1.0 - this.es * F * this.sinphi0 / Math.sin(psi)) * Math.tan(psi) / this.one_es)));
                }
            } else {
                lp.setLatitude(Math.toDegrees(MapMath.inv_mlfn(this.mode == 1 ? this.Mp - c : this.Mp + c, this.es, this.en)));
                lp.setLongitude(Math.toDegrees(Math.atan2(x, this.mode == 1 ? -y : y)));
            }
        }
        lp.setLongitude(lp.getLongitude() + this.lon0);
        return lp;
    }

    @Override
    public String paramsToString() {
        return null;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EquidistantAzimuthalProjection that = (EquidistantAzimuthalProjection)o;
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.projectionLatitude, this.projectionLatitude) != 0) {
            return false;
        }
        if (Double.compare(that.projectionLongitude, this.projectionLongitude) != 0) {
            return false;
        }
        if (this.earth != null ? !this.earth.equals(that.earth) : that.earth != null) {
            return false;
        }
        if (this.defaultMapArea == null != (that.defaultMapArea == null)) {
            return false;
        }
        return this.defaultMapArea == null || that.defaultMapArea.equals(this.defaultMapArea);
    }

    public int hashCode() {
        long temp = this.projectionLatitude != 0.0 ? Double.doubleToLongBits(this.projectionLatitude) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.projectionLongitude != 0.0 ? Double.doubleToLongBits(this.projectionLongitude) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.earth != null ? this.earth.hashCode() : 0);
        return result;
    }
}

