/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream {
    private InputStream myInput;
    private int myBitCount;
    private int myBuffer;
    private File myFile;
    private static final int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final int BITS_PER_BYTE = 8;

    public BitInputStream(String filename) {
        this(new File(filename));
    }

    public BitInputStream(File file) {
        this.myFile = file;
        try {
            this.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BitInputStream(InputStream in) {
        this.myInput = in;
        this.myFile = null;
    }

    @Override
    public boolean markSupported() {
        return this.myFile != null;
    }

    @Override
    public void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("not resettable");
        }
        try {
            this.close();
            this.myInput = new BufferedInputStream(new FileInputStream(this.myFile));
        }
        catch (FileNotFoundException fnf) {
            System.err.println("error opening " + this.myFile.getName() + " " + fnf);
        }
        this.myBitCount = 0;
        this.myBuffer = 0;
    }

    @Override
    public void close() {
        try {
            if (this.myInput != null) {
                this.myInput.close();
            }
        }
        catch (IOException ioe) {
            System.err.println("error closing bit stream " + ioe);
        }
    }

    public int read(int howManyBits) throws IOException {
        int retval = 0;
        if (this.myInput == null) {
            return -1;
        }
        while (howManyBits > this.myBitCount) {
            retval |= this.myBuffer << howManyBits - this.myBitCount;
            howManyBits -= this.myBitCount;
            try {
                this.myBuffer = this.myInput.read();
                if (this.myBuffer == -1) {
                    return -1;
                }
            }
            catch (IOException ioe) {
                throw new IOException("bitreading trouble " + ioe);
            }
            this.myBitCount = 8;
        }
        if (howManyBits > 0) {
            retval |= this.myBuffer >> this.myBitCount - howManyBits;
            this.myBuffer &= bmask[this.myBitCount - howManyBits];
            this.myBitCount -= howManyBits;
        }
        return retval;
    }

    @Override
    public int read() throws IOException {
        return this.read(8);
    }
}

