/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib2.Grib2Pds;

public abstract class GribPds {
    protected byte[] input;

    public static GribPds factory(int edition, byte[] raw, long baseTime, Calendar cal) throws IOException {
        if (edition == 1) {
            return new Grib1Pds(raw, cal);
        }
        return Grib2Pds.factory(raw, baseTime, cal);
    }

    public byte[] getPDSBytes() {
        return this.input;
    }

    public final int getOctet(int index) {
        if (index > this.input.length) {
            return -9999;
        }
        return this.input[index - 1] & 0xFF;
    }

    public abstract int getParameterNumber();

    public abstract double getLevelValue1();

    public abstract double getLevelValue2();

    public abstract int getLevelType1();

    public abstract int getLevelType2();

    public abstract int getTimeUnit();

    public abstract int getForecastTime();

    public abstract Date getForecastDate();

    public abstract long getReferenceTime();

    public final Date getReferenceDate() {
        return new Date(this.getReferenceTime());
    }

    public abstract boolean isInterval();

    public abstract int getStatisticalProcessType();

    public abstract long getIntervalTimeEnd();

    public abstract int[] getForecastTimeInterval();

    public abstract int[] getForecastTimeInterval(int var1);

    public abstract int getGenProcessId();

    public abstract boolean isEnsemble();

    public abstract int getPerturbationNumber();

    public abstract int getPerturbationType();

    public abstract boolean isEnsembleDerived();

    public abstract int getNumberEnsembleForecasts();

    public abstract boolean isProbability();

    public abstract double getProbabilityLowerLimit();

    public abstract double getProbabilityUpperLimit();

    public abstract int getProbabilityType();

    public abstract boolean isPercentile();

    public abstract int getPercentileValue();
}

