/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.hdf5.BTree2;
import ucar.nc2.iosp.hdf5.DataBTree;
import ucar.nc2.iosp.hdf5.FractalHeap;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.Misc;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Format;

public class H5header {
    private static Logger log = LoggerFactory.getLogger(H5header.class);
    public static final String HDF5_CLASS = "CLASS";
    public static final String HDF5_DIMENSION_LIST = "DIMENSION_LIST";
    public static final String HDF5_DIMENSION_SCALE = "DIMENSION_SCALE";
    public static final String HDF5_DIMENSION_LABELS = "DIMENSION_LABELS";
    private static boolean debugEnum = false;
    private static boolean debugVlen = false;
    private static boolean debug1 = false;
    private static boolean debugDetail = false;
    private static boolean debugPos = false;
    private static boolean debugHeap = false;
    private static boolean debugV = false;
    private static boolean debugGroupBtree = false;
    private static boolean debugDataBtree = false;
    private static boolean debugDataChunk = false;
    private static boolean debugBtree2 = false;
    private static boolean debugContinueMessage = false;
    private static boolean debugTracker = false;
    private static boolean debugSoftLink = false;
    private static boolean debugSymbolTable = false;
    private static boolean warnings = false;
    private static boolean debugReference = false;
    private static boolean debugRegionReference = false;
    private static boolean debugCreationOrder = false;
    private static boolean debugFractalHeap = false;
    private static boolean debugDimensionScales = false;
    private static final byte[] head = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};
    private static final String hdf5magic = new String(head);
    private static final long maxHeaderPos = 500000L;
    private static boolean transformReference = true;
    RandomAccessFile raf;
    NetcdfFile ncfile;
    private H5iosp h5iosp;
    private long baseAddress;
    byte sizeOffsets;
    byte sizeLengths;
    boolean isOffsetLong;
    boolean isLengthLong;
    boolean isNetcdf4;
    Map<Integer, DataObjectFacade> dimIds = null;
    private H5Group rootGroup;
    private Map<String, DataObjectFacade> symlinkMap = new HashMap<String, DataObjectFacade>(200);
    private Map<Long, DataObject> addressMap = new HashMap<Long, DataObject>(200);
    private Map<Long, GlobalHeap> heapMap = new HashMap<Long, GlobalHeap>();
    private SimpleDateFormat hdfDateParser;
    private PrintStream debugOut = System.out;
    private MemTracker memTracker;
    private static final String[] filterName = new String[]{"", "deflate", "shuffle", "fletcher32", "szip", "nbit", "scaleoffset"};

    public static void setDebugFlags(DebugFlags debugFlag) {
        debug1 = debugFlag.isSet("H5header/header");
        debugBtree2 = debugFlag.isSet("H5header/btree2");
        debugContinueMessage = debugFlag.isSet("H5header/continueMessage");
        debugDetail = debugFlag.isSet("H5header/headerDetails");
        debugDataBtree = debugFlag.isSet("H5header/dataBtree");
        debugDataChunk = debugFlag.isSet("H5header/dataChunk");
        debugGroupBtree = debugFlag.isSet("H5header/groupBtree");
        debugFractalHeap = debugFlag.isSet("H5header/fractalHeap");
        debugHeap = debugFlag.isSet("H5header/Heap");
        debugPos = debugFlag.isSet("H5header/filePos");
        debugReference = debugFlag.isSet("H5header/reference");
        debugSoftLink = debugFlag.isSet("H5header/softLink");
        debugSymbolTable = debugFlag.isSet("H5header/symbolTable");
        debugTracker = debugFlag.isSet("H5header/memTracker");
        debugV = debugFlag.isSet("H5header/Variable");
    }

    public static boolean isValidFile(RandomAccessFile raf) throws IOException {
        long filePos = 0L;
        long size = raf.length();
        byte[] b = new byte[8];
        while (filePos < size && filePos < 500000L) {
            raf.seek(filePos);
            raf.read(b);
            String magic = new String(b);
            if (magic.equals(hdf5magic)) {
                return true;
            }
            filePos = filePos == 0L ? 512L : 2L * filePos;
        }
        return false;
    }

    H5header(RandomAccessFile myRaf, NetcdfFile ncfile, H5iosp h5iosp) {
        this.ncfile = ncfile;
        this.raf = myRaf;
        this.h5iosp = h5iosp;
    }

    public byte getSizeOffsets() {
        return this.sizeOffsets;
    }

    public void read(PrintStream debugPS) throws IOException {
        if (debugPS != null) {
            this.debugOut = debugPS;
        }
        long actualSize = this.raf.length();
        this.memTracker = new MemTracker(actualSize);
        boolean ok = false;
        long filePos = 0L;
        byte[] b = new byte[8];
        while (filePos < actualSize) {
            this.raf.seek(filePos);
            this.raf.read(b);
            String magic = new String(b);
            if (magic.equals(hdf5magic)) {
                ok = true;
                break;
            }
            filePos = filePos == 0L ? 512L : 2L * filePos;
        }
        if (!ok) {
            throw new IOException("Not a netCDF4/HDF5 file ");
        }
        if (debug1) {
            this.debugOut.println("H5header 0pened file to read:'" + this.raf.getLocation() + "' size= " + actualSize);
        }
        this.raf.order(1);
        long superblockStart = this.raf.getFilePointer() - 8L;
        this.memTracker.add("header", 0L, superblockStart);
        byte versionSB = this.raf.readByte();
        if (versionSB < 2) {
            this.readSuperBlock1(superblockStart, versionSB);
        } else if (versionSB == 2) {
            this.readSuperBlock2(superblockStart);
        } else {
            throw new IOException("Unknown superblock version= " + versionSB);
        }
        this.replaceSymbolicLinks(this.rootGroup);
        this.makeNetcdfGroup(this.ncfile.getRootGroup(), this.rootGroup);
        if (debugTracker) {
            this.memTracker.report();
        }
    }

    private void readSuperBlock1(long superblockStart, byte versionSB) throws IOException {
        byte versionFSS = this.raf.readByte();
        byte versionGroup = this.raf.readByte();
        this.raf.readByte();
        byte versionSHMF = this.raf.readByte();
        if (debugDetail) {
            this.debugOut.println(" versionSB= " + versionSB + " versionFSS= " + versionFSS + " versionGroup= " + versionGroup + " versionSHMF= " + versionSHMF);
        }
        this.sizeOffsets = this.raf.readByte();
        this.isOffsetLong = this.sizeOffsets == 8;
        this.sizeLengths = this.raf.readByte();
        boolean bl = this.isLengthLong = this.sizeLengths == 8;
        if (debugDetail) {
            this.debugOut.println(" sizeOffsets= " + this.sizeOffsets + " sizeLengths= " + this.sizeLengths);
        }
        if (debugDetail) {
            this.debugOut.println(" isLengthLong= " + this.isLengthLong + " isOffsetLong= " + this.isOffsetLong);
        }
        this.raf.read();
        short btreeLeafNodeSize = this.raf.readShort();
        short btreeInternalNodeSize = this.raf.readShort();
        if (debugDetail) {
            this.debugOut.println(" btreeLeafNodeSize= " + btreeLeafNodeSize + " btreeInternalNodeSize= " + btreeInternalNodeSize);
        }
        int fileFlags = this.raf.readInt();
        if (debugDetail) {
            this.debugOut.println(" fileFlags= 0x" + Integer.toHexString(fileFlags));
        }
        if (versionSB == 1) {
            short storageInternalNodeSize = this.raf.readShort();
            this.raf.skipBytes(2);
        }
        this.baseAddress = this.readOffset();
        long heapAddress = this.readOffset();
        long eofAddress = this.readOffset();
        long driverBlockAddress = this.readOffset();
        if (this.baseAddress != superblockStart) {
            this.baseAddress = superblockStart;
            eofAddress += superblockStart;
            if (debugDetail) {
                this.debugOut.println(" baseAddress set to superblockStart");
            }
        }
        if (debugDetail) {
            this.debugOut.println(" baseAddress= 0x" + Long.toHexString(this.baseAddress));
            this.debugOut.println(" global free space heap Address= 0x" + Long.toHexString(heapAddress));
            this.debugOut.println(" eof Address=" + eofAddress);
            this.debugOut.println(" raf length= " + this.raf.length());
            this.debugOut.println(" driver BlockAddress= 0x" + Long.toHexString(driverBlockAddress));
            this.debugOut.println();
        }
        this.memTracker.add("superblock", superblockStart, this.raf.getFilePointer());
        long fileSize = this.raf.length();
        if (fileSize < eofAddress) {
            throw new IOException("File is truncated should be= " + eofAddress + " actual = " + fileSize + "%nlocation= " + this.raf.getLocation());
        }
        SymbolTableEntry rootEntry = new SymbolTableEntry(this.raf.getFilePointer());
        long rootObjectAddress = rootEntry.getObjectAddress();
        DataObjectFacade f = new DataObjectFacade(null, "", rootObjectAddress);
        this.rootGroup = new H5Group(f);
    }

    private void readSuperBlock2(long superblockStart) throws IOException {
        long fileSize;
        this.sizeOffsets = this.raf.readByte();
        this.isOffsetLong = this.sizeOffsets == 8;
        this.sizeLengths = this.raf.readByte();
        boolean bl = this.isLengthLong = this.sizeLengths == 8;
        if (debugDetail) {
            this.debugOut.println(" sizeOffsets= " + this.sizeOffsets + " sizeLengths= " + this.sizeLengths);
        }
        if (debugDetail) {
            this.debugOut.println(" isLengthLong= " + this.isLengthLong + " isOffsetLong= " + this.isOffsetLong);
        }
        byte fileFlags = this.raf.readByte();
        if (debugDetail) {
            this.debugOut.println(" fileFlags= 0x" + Integer.toHexString(fileFlags));
        }
        this.baseAddress = this.readOffset();
        long extensionAddress = this.readOffset();
        long eofAddress = this.readOffset();
        long rootObjectAddress = this.readOffset();
        int checksum = this.raf.readInt();
        if (debugDetail) {
            this.debugOut.println(" baseAddress= 0x" + Long.toHexString(this.baseAddress));
            this.debugOut.println(" extensionAddress= 0x" + Long.toHexString(extensionAddress));
            this.debugOut.println(" eof Address=" + eofAddress);
            this.debugOut.println(" rootObjectAddress= 0x" + Long.toHexString(rootObjectAddress));
            this.debugOut.println();
        }
        this.memTracker.add("superblock", superblockStart, this.raf.getFilePointer());
        if (this.baseAddress != superblockStart) {
            this.baseAddress = superblockStart;
            eofAddress += superblockStart;
            if (debugDetail) {
                this.debugOut.println(" baseAddress set to superblockStart");
            }
        }
        if ((fileSize = this.raf.length()) < eofAddress) {
            throw new IOException("File is truncated should be= " + eofAddress + " actual = " + fileSize);
        }
        DataObjectFacade f = new DataObjectFacade(null, "", rootObjectAddress);
        this.rootGroup = new H5Group(f);
    }

    private void replaceSymbolicLinks(H5Group group) {
        if (group == null) {
            return;
        }
        List<DataObjectFacade> objList = group.nestedObjects;
        int count = 0;
        while (count < objList.size()) {
            DataObjectFacade dof = objList.get(count);
            if (dof.group != null) {
                this.replaceSymbolicLinks(dof.group);
            } else if (dof.linkName != null) {
                DataObjectFacade link = this.symlinkMap.get(dof.linkName);
                if (link == null) {
                    log.error(" WARNING Didnt find symbolic link=" + dof.linkName + " from " + dof.name);
                    objList.remove(count);
                    continue;
                }
                if (link.group != null && group.isChildOf(link.group)) {
                    log.error(" ERROR Symbolic Link loop found =" + dof.linkName);
                    objList.remove(count);
                    continue;
                }
                if (dof.parent == link.parent) {
                    objList.remove(dof);
                    --count;
                } else {
                    objList.set(count, link);
                }
                if (debugSoftLink) {
                    this.debugOut.println("  Found symbolic link=" + dof.linkName);
                }
            }
            ++count;
        }
    }

    private void makeNetcdfGroup(Group ncGroup, H5Group h5group) throws IOException {
        if (h5group == null) {
            return;
        }
        for (DataObjectFacade facade : h5group.nestedObjects) {
            if (!facade.isVariable) continue;
            this.findDimensionScales(ncGroup, h5group, facade);
        }
        if (this.dimIds != null) {
            for (DataObjectFacade dimscale : this.dimIds.values()) {
                if (dimscale.dobj.mds.ndims <= 1) continue;
                StringBuilder sbuff = new StringBuilder();
                Attribute att = dimscale.netcdf4CoordinatesAtt;
                for (int i = 0; i < att.getLength(); ++i) {
                    int id = att.getNumericValue(i).intValue();
                    DataObjectFacade ds2 = this.dimIds.get(id);
                    String name = ds2.getName();
                    int pos = name.lastIndexOf(47);
                    String dimName = pos >= 0 ? name.substring(pos + 1) : name;
                    sbuff.append(dimName);
                    sbuff.append(" ");
                }
                dimscale.dimList = sbuff.toString();
            }
        }
        for (DataObjectFacade facade : h5group.nestedObjects) {
            if (!facade.isVariable || facade.netcdf4CoordinatesAtt == null || !facade.dimList.equals("%REDO%")) continue;
            Formatter f = new Formatter();
            for (int i = 0; i < facade.netcdf4CoordinatesAtt.getLength(); ++i) {
                int dimIndex = facade.netcdf4CoordinatesAtt.getNumericValue(i).intValue();
                f.format("%s ", h5group.dimList.get(dimIndex).getShortName());
            }
            facade.dimList = f.toString();
        }
        for (DataObjectFacade facade : h5group.nestedObjects) {
            if (!facade.isVariable) continue;
            this.findDimensionLists(ncGroup, h5group, facade);
        }
        this.createDimensions(ncGroup, h5group);
        for (DataObjectFacade facadeNested : h5group.nestedObjects) {
            if (facadeNested.isGroup) {
                Group nestedGroup = new Group(this.ncfile, ncGroup, facadeNested.name);
                ncGroup.addGroup(nestedGroup);
                if (debug1) {
                    this.debugOut.println("--made Group " + nestedGroup.getFullName() + " add to " + ncGroup.getFullName());
                }
                H5Group h5groupNested = new H5Group(facadeNested);
                this.makeNetcdfGroup(nestedGroup, h5groupNested);
                continue;
            }
            if (facadeNested.isVariable) {
                Variable v;
                if (debugReference && facadeNested.dobj.mdt.type == 7) {
                    this.debugOut.println(facadeNested);
                }
                if ((v = this.makeVariable(ncGroup, facadeNested)) == null || v.getDataType() == null) continue;
                v.setParentGroup(ncGroup);
                ncGroup.addVariable(v);
                if (v.getDataType().isEnum()) {
                    EnumTypedef enumTypedef = v.getEnumTypedef();
                    if (enumTypedef == null) {
                        log.error("EnumTypedef is missing for variable: " + v.getFullName());
                        throw new IllegalStateException("EnumTypedef is missing for variable: " + v.getFullName());
                    }
                    String ename = enumTypedef.getShortName();
                    if (ename == null || ename.length() == 0) {
                        enumTypedef = ncGroup.findEnumeration(facadeNested.name);
                        if (enumTypedef == null) {
                            enumTypedef = new EnumTypedef(facadeNested.name, facadeNested.dobj.mdt.map);
                            ncGroup.addEnumeration(enumTypedef);
                        }
                        v.setEnumTypedef(enumTypedef);
                    }
                }
                Vinfo vinfo = (Vinfo)v.getSPobject();
                if (!debugV) continue;
                this.debugOut.println("  made Variable " + v.getFullName() + "  vinfo= " + vinfo + "\n" + v);
                continue;
            }
            if (facadeNested.isTypedef) {
                EnumTypedef enumTypedef;
                if (debugReference && facadeNested.dobj.mdt.type == 7) {
                    this.debugOut.println(facadeNested);
                }
                if (facadeNested.dobj.mdt.map != null && (enumTypedef = ncGroup.findEnumeration(facadeNested.name)) == null) {
                    enumTypedef = new EnumTypedef(facadeNested.name, facadeNested.dobj.mdt.map);
                    ncGroup.addEnumeration(enumTypedef);
                }
                if (!debugV) continue;
                this.debugOut.println("  made enumeration " + facadeNested.name);
                continue;
            }
            if (facadeNested.isDimensionNotVariable || !warnings) continue;
            this.debugOut.println("WARN:  DataObject ndo " + facadeNested + " not a Group or a Variable");
        }
        List<MessageAttribute> fatts = this.filterAttributes(h5group.facade.dobj.attributes);
        for (MessageAttribute matt : fatts) {
            try {
                this.makeAttributes(null, matt, ncGroup.getAttributes());
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.processSystemAttributes(h5group.facade.dobj.messages, ncGroup.getAttributes());
    }

    private void findDimensionScales(Group g, H5Group h5group, DataObjectFacade facade) throws IOException {
        Iterator<MessageAttribute> iter = facade.dobj.attributes.iterator();
        while (iter.hasNext()) {
            Attribute att;
            String val;
            MessageAttribute matt = iter.next();
            if (!matt.name.equals(HDF5_CLASS) || !(val = (att = this.makeAttribute(matt)).getStringValue()).equals(HDF5_DIMENSION_SCALE)) continue;
            this.findNetcdf4DimidAttribute(facade);
            if (facade.dobj.mds.ndims == 1) {
                facade.dimList = this.addDimension(g, h5group, facade.name, facade.dobj.mds.dimLength[0], facade.dobj.mds.maxLength[0] == -1);
                if (!this.h5iosp.includeOriginalAttributes) {
                    iter.remove();
                }
                if (!debugDimensionScales) continue;
                System.out.printf("Found dimScale %s for group '%s' matt=%s %n", facade.dimList, g.getFullName(), matt);
                continue;
            }
            int dimIndex = this.findCoordinateDimensionIndex(facade, h5group);
            this.addDimension(g, h5group, facade.name, facade.dobj.mds.dimLength[dimIndex], facade.dobj.mds.maxLength[dimIndex] == -1);
            if (!this.h5iosp.includeOriginalAttributes) {
                iter.remove();
            }
            if (!debugDimensionScales) continue;
            System.out.printf("Found multidim dimScale %s for group '%s' matt=%s %n", facade.dimList, g.getFullName(), matt);
        }
    }

    private void findNetcdf4DimidAttribute(DataObjectFacade facade) throws IOException {
        for (MessageAttribute matt : facade.dobj.attributes) {
            if (!matt.name.equals("_Netcdf4Dimid")) continue;
            if (this.dimIds == null) {
                this.dimIds = new HashMap<Integer, DataObjectFacade>();
            }
            Attribute att_dimid = this.makeAttribute(matt);
            Integer dimid = (Integer)att_dimid.getNumericValue();
            this.dimIds.put(dimid, facade);
            return;
        }
        if (this.dimIds != null) {
            log.warn("Missing _Netcdf4Dimid attribute on " + facade.getName());
        }
    }

    private int findCoordinateDimensionIndex(DataObjectFacade facade, H5Group h5group) throws IOException {
        Attribute att_coord = null;
        Attribute att_dimid = null;
        for (MessageAttribute matt : facade.dobj.attributes) {
            if (matt.name.equals("_Netcdf4Coordinates")) {
                att_coord = this.makeAttribute(matt);
            }
            if (!matt.name.equals("_Netcdf4Dimid")) continue;
            att_dimid = this.makeAttribute(matt);
        }
        if (att_coord != null && att_dimid != null) {
            facade.netcdf4CoordinatesAtt = att_coord;
            Integer want = (Integer)att_dimid.getNumericValue();
            for (int i = 0; i < att_coord.getLength(); ++i) {
                Integer got = (Integer)att_dimid.getNumericValue(i);
                if (!want.equals(got)) continue;
                return i;
            }
            log.warn("Multidimension dimension scale attributes _Netcdf4Coordinates and _Netcdf4Dimid dont match. Assume Dimension is index 0 (!)");
            return 0;
        }
        if (att_coord != null) {
            facade.netcdf4CoordinatesAtt = att_coord;
            int n = h5group.dimList.size();
            facade.dimList = "%REDO%";
            for (int i = 0; i < att_coord.getLength(); ++i) {
                if (att_coord.getNumericValue(i).intValue() != n) continue;
                return i;
            }
            log.warn("Multidimension dimension scale attribute _Netcdf4Dimid missing. Dimension ordering is not found. Assume index 0 (!)");
            return 0;
        }
        log.warn("Multidimension dimension scale doesnt have _Netcdf4Coordinates attribute. Assume Dimension is index 0 (!)");
        return 0;
    }

    private void findDimensionLists(Group g, H5Group h5group, DataObjectFacade facade) throws IOException {
        Iterator<MessageAttribute> iter = facade.dobj.attributes.iterator();
        while (iter.hasNext()) {
            Attribute att;
            MessageAttribute matt = iter.next();
            if (matt.name.equals(HDF5_DIMENSION_LIST)) {
                att = this.makeAttribute(matt);
                if (att == null) {
                    log.error("DIMENSION_LIST: failed to read");
                    continue;
                }
                if (att.getLength() != facade.dobj.mds.dimLength.length) {
                    log.error("DIMENSION_LIST: must have same number of dimension scales as dimensions = " + att);
                    continue;
                }
                StringBuilder sbuff = new StringBuilder();
                for (int i = 0; i < att.getLength(); ++i) {
                    String name = att.getStringValue(i);
                    String dimName = this.extendDimension(g, h5group, name, facade.dobj.mds.dimLength[i]);
                    sbuff.append(dimName).append(" ");
                }
                facade.dimList = sbuff.toString();
                if (debugDimensionScales) {
                    System.out.printf("Found dimList '%s' for group '%s' matt=%s %n", facade.dimList, g.getFullName(), matt);
                }
                if (this.h5iosp.includeOriginalAttributes) continue;
                iter.remove();
                continue;
            }
            if (matt.name.equals("NAME")) {
                att = this.makeAttribute(matt);
                String val = att.getStringValue();
                if (val.startsWith("This is a netCDF dimension but not a netCDF variable")) {
                    facade.isVariable = false;
                    facade.isDimensionNotVariable = true;
                    this.isNetcdf4 = true;
                }
                if (!this.h5iosp.includeOriginalAttributes) {
                    iter.remove();
                }
                if (!debugDimensionScales) continue;
                System.out.printf("Found %s %n", val);
                continue;
            }
            if (!matt.name.equals("REFERENCE_LIST") || this.h5iosp.includeOriginalAttributes) continue;
            iter.remove();
        }
    }

    private String addDimension(Group g, H5Group h5group, String name, int length, boolean isUnlimited) {
        int pos = name.lastIndexOf(47);
        String dimName = pos >= 0 ? name.substring(pos + 1) : name;
        Dimension d = h5group.dimMap.get(dimName);
        if (d == null) {
            d = new Dimension(dimName, length, true, isUnlimited, false);
            d.setGroup(g);
            h5group.dimMap.put(dimName, d);
            h5group.dimList.add(d);
            if (debugDimensionScales) {
                this.debugOut.println("addDimension name=" + name + " dim= " + d + " to group " + g);
            }
        } else if (d.getLength() != length) {
            throw new IllegalStateException("addDimension: DimScale has different length than dimension it references dimScale=" + dimName);
        }
        return d.getShortName();
    }

    private String extendDimension(Group g, H5Group h5group, String name, int length) {
        int pos = name.lastIndexOf(47);
        String dimName = pos >= 0 ? name.substring(pos + 1) : name;
        Dimension d = h5group.dimMap.get(dimName);
        if (d == null) {
            d = g.findDimension(dimName);
        }
        if (d != null) {
            if (d.isUnlimited() && length > d.getLength()) {
                d.setLength(length);
            }
            if (!d.isUnlimited() && length != d.getLength()) {
                throw new IllegalStateException("extendDimension: DimScale has different length than dimension it references dimScale=" + dimName);
            }
            return d.getShortName();
        }
        return dimName;
    }

    private void createDimensions(Group g, H5Group h5group) throws IOException {
        for (Dimension d : h5group.dimList) {
            g.addDimension(d);
        }
    }

    private List<MessageAttribute> filterAttributes(List<MessageAttribute> attList) {
        ArrayList<MessageAttribute> result = new ArrayList<MessageAttribute>(attList.size());
        for (MessageAttribute matt : attList) {
            if (matt.name.equals("_Netcdf4Coordinates") || matt.name.equals("_Netcdf4Dimid") || matt.name.equals("_nc3_strict")) {
                this.isNetcdf4 = true;
                continue;
            }
            result.add(matt);
        }
        return result;
    }

    private void makeAttributes(Structure s, MessageAttribute matt, List<Attribute> attList) throws IOException, InvalidRangeException {
        MessageDatatype mdt = matt.mdt;
        if (mdt.type == 6) {
            Vinfo vinfo = new Vinfo(matt.mdt, matt.mds, matt.dataPos);
            ArrayStructure attData = (ArrayStructure)this.readAttributeData(matt, vinfo, DataType.STRUCTURE);
            if (null == s) {
                for (StructureMembers.Member sm : attData.getStructureMembers().getMembers()) {
                    Array memberData = attData.extractMemberArray(sm);
                    attList.add(new Attribute(matt.name + "." + sm.getName(), memberData));
                }
            } else {
                StructureMembers smember = attData.getStructureMembers();
                for (Variable v : s.getVariables()) {
                    StructureMembers.Member sm = smember.findMember(v.getShortName());
                    if (null == sm) continue;
                    Array memberData = attData.extractMemberArray(sm);
                    v.addAttribute(new Attribute(matt.name, memberData));
                }
                for (StructureMembers.Member sm : attData.getStructureMembers().getMembers()) {
                    if (s.findVariable(sm.getName()) != null) continue;
                    Array memberData = attData.extractMemberArray(sm);
                    attList.add(new Attribute(matt.name + "." + sm.getName(), memberData));
                }
            }
        } else {
            attList.add(this.makeAttribute(matt));
        }
        this.raf.order(1);
    }

    private Attribute makeAttribute(MessageAttribute matt) throws IOException {
        Attribute result;
        Vinfo vinfo = new Vinfo(matt.mdt, matt.mds, matt.dataPos);
        DataType dtype = vinfo.getNCDataType();
        if (matt.mds.type == 2) {
            if (dtype == DataType.CHAR) {
                return new Attribute(matt.name, "");
            }
            return new Attribute(matt.name, dtype);
        }
        Array attData = null;
        try {
            attData = this.readAttributeData(matt, vinfo, dtype);
            attData.setUnsigned(matt.mdt.unsigned);
        }
        catch (InvalidRangeException e) {
            log.error("failed to read Attribute " + matt.name, e);
            return null;
        }
        if (attData.getElementType() == Array.class) {
            ArrayList<Object> dataList = new ArrayList<Object>();
            while (attData.hasNext()) {
                Array nested = (Array)attData.next();
                while (nested.hasNext()) {
                    dataList.add(nested.next());
                }
            }
            result = new Attribute(matt.name, dataList);
        } else {
            result = new Attribute(matt.name, attData);
        }
        this.raf.order(1);
        return result;
    }

    private Array readAttributeData(MessageAttribute matt, Vinfo vinfo, DataType dataType) throws IOException, InvalidRangeException {
        boolean debugStructure = false;
        int[] shape = matt.mds.dimLength;
        if (dataType == DataType.STRUCTURE) {
            boolean hasStrings = false;
            StructureMembers sm = new StructureMembers(matt.name);
            for (StructureMember h5sm : matt.mdt.members) {
                DataType dt = null;
                int[] dim = null;
                switch (h5sm.mdt.type) {
                    case 9: {
                        dt = DataType.STRING;
                        dim = new int[]{1};
                        break;
                    }
                    case 10: {
                        dt = this.getNCtype(h5sm.mdt.base.type, h5sm.mdt.base.byteSize);
                        dim = h5sm.mdt.dim;
                        break;
                    }
                    default: {
                        dt = this.getNCtype(h5sm.mdt.type, h5sm.mdt.byteSize);
                        dim = new int[]{1};
                    }
                }
                StructureMembers.Member m = sm.addMember(h5sm.name, null, null, dt, dim);
                if (h5sm.mdt.endian >= 0) {
                    m.setDataObject(h5sm.mdt.endian == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                }
                m.setDataParam(h5sm.offset);
                if (dt != DataType.STRING) continue;
                hasStrings = true;
            }
            int recsize = matt.mdt.byteSize;
            LayoutRegular layout = new LayoutRegular(matt.dataPos, recsize, shape, new Section(shape));
            sm.setStructureSize(recsize);
            ArrayStructureBB asbb = new ArrayStructureBB(sm, shape);
            byte[] byteArray = asbb.getByteBuffer().array();
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                if (debugStructure) {
                    System.out.println(" readStructure " + matt.name + " chunk= " + chunk + " index.getElemSize= " + layout.getElemSize());
                }
                this.raf.seek(chunk.getSrcPos());
                this.raf.read(byteArray, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            if (hasStrings) {
                int destPos = 0;
                int i = 0;
                while ((long)i < layout.getTotalNelems()) {
                    this.h5iosp.convertHeap(asbb, destPos, sm);
                    destPos += layout.getElemSize();
                    ++i;
                }
            }
            return asbb;
        }
        if (vinfo.typeInfo.hdfType == 9 && vinfo.typeInfo.isVString) {
            LayoutRegular layout = new LayoutRegular(matt.dataPos, matt.mdt.byteSize, shape, new Section(shape));
            ArrayObject.D1 data = new ArrayObject.D1(String.class, (int)layout.getTotalNelems());
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    long address = chunk.getSrcPos() + (long)(layout.getElemSize() * i);
                    String sval = this.readHeapString(address);
                    data.set(count++, sval);
                }
            }
            return data;
        }
        if (vinfo.typeInfo.hdfType == 9) {
            LayoutRegular layout;
            int endian = vinfo.typeInfo.endian;
            DataType readType = dataType;
            if (vinfo.typeInfo.base.hdfType == 7) {
                readType = DataType.LONG;
                endian = 1;
            }
            boolean scalar = (layout = new LayoutRegular(matt.dataPos, matt.mdt.byteSize, shape, new Section(shape))).getTotalNelems() == 1L;
            Array[] data = new Array[(int)layout.getTotalNelems()];
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    long address = chunk.getSrcPos() + (long)(layout.getElemSize() * i);
                    Array vlenArray = this.getHeapDataArray(address, readType, endian);
                    data[count++] = vinfo.typeInfo.base.hdfType == 7 ? this.h5iosp.convertReference(vlenArray) : vlenArray;
                }
            }
            return scalar ? data[0] : Array.factory(Array.class, shape, (Object)data);
        }
        DataType readDtype = dataType;
        int elemSize = dataType.getSize();
        int endian = vinfo.typeInfo.endian;
        if (vinfo.typeInfo.hdfType == 2) {
            readDtype = vinfo.mdt.timeType;
            elemSize = readDtype.getSize();
        } else if (vinfo.typeInfo.hdfType == 3) {
            if (vinfo.mdt.byteSize > 1) {
                int[] newShape = new int[shape.length + 1];
                System.arraycopy(shape, 0, newShape, 0, shape.length);
                newShape[shape.length] = vinfo.mdt.byteSize;
                shape = newShape;
            }
        } else if (vinfo.typeInfo.hdfType == 5) {
            elemSize = vinfo.mdt.byteSize;
        } else if (vinfo.typeInfo.hdfType == 8) {
            TypeInfo baseInfo = vinfo.typeInfo.base;
            readDtype = baseInfo.dataType;
            elemSize = readDtype.getSize();
            endian = baseInfo.endian;
        }
        LayoutRegular layout = new LayoutRegular(matt.dataPos, elemSize, shape, new Section(shape));
        Object data = this.h5iosp.readDataPrimitive(layout, dataType, shape, null, endian, false);
        Array dataArray = null;
        if (dataType == DataType.CHAR) {
            if (vinfo.mdt.byteSize > 1) {
                byte[] bdata = (byte[])data;
                int strlen = vinfo.mdt.byteSize;
                int n = bdata.length / strlen;
                ArrayObject.D1 sarray = new ArrayObject.D1(String.class, n);
                for (int i = 0; i < n; ++i) {
                    String sval = this.convertString(bdata, i * strlen, strlen);
                    sarray.set(i, sval);
                }
                dataArray = sarray;
            } else {
                String sval = this.convertString((byte[])data);
                ArrayObject.D1 sarray = new ArrayObject.D1(String.class, 1);
                sarray.set(0, sval);
                dataArray = sarray;
            }
        } else {
            Array array = dataArray = data instanceof Array ? (Array)data : Array.factory(readDtype, shape, data);
        }
        if (vinfo.typeInfo.hdfType == 8 && matt.mdt.map != null) {
            dataArray = this.convertEnums(matt.mdt.map, dataType, dataArray);
        }
        return dataArray;
    }

    private String convertString(byte[] b) throws UnsupportedEncodingException {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, CDM.utf8Charset);
    }

    private String convertString(byte[] b, int start, int len) throws UnsupportedEncodingException {
        int count;
        for (count = start; count < start + len && b[count] != 0; ++count) {
        }
        return new String(b, start, count - start, CDM.utf8Charset);
    }

    protected Array convertEnums(Map<Integer, String> map, DataType dataType, Array values) {
        Array result = Array.factory(DataType.STRING, values.getShape());
        IndexIterator ii = result.getIndexIterator();
        values.resetLocalIterator();
        while (values.hasNext()) {
            int ival = dataType == DataType.ENUM1 ? DataType.unsignedByteToShort(values.nextByte()) : (dataType == DataType.ENUM2 ? DataType.unsignedShortToInt(values.nextShort()) : values.nextInt());
            String sval = map.get(ival);
            if (sval == null) {
                sval = "Unknown enum value=" + ival;
            }
            ii.setObjectNext(sval);
        }
        return result;
    }

    private Variable makeVariable(Group ncGroup, DataObjectFacade facade) throws IOException {
        String desc;
        Variable v;
        String vname;
        Vinfo vinfo = new Vinfo(facade);
        if (vinfo.getNCDataType() == null) {
            this.debugOut.println("SKIPPING DataType= " + vinfo.typeInfo.hdfType + " for variable " + facade.name);
            return null;
        }
        if (facade.dobj.mfp != null) {
            for (Filter f : facade.dobj.mfp.filters) {
                if (f.id != 4) continue;
                this.debugOut.println("SKIPPING variable with SZIP Filter= " + facade.dobj.mfp + " for variable " + facade.name);
                return null;
            }
        }
        Attribute fillAttribute = null;
        for (HeaderMessage mess : facade.dobj.messages) {
            Object defFillValue;
            Object fillValue;
            Named fvm;
            if (mess.mtype == MessageType.FillValue) {
                fvm = (MessageFillValue)mess.messData;
                if (fvm.hasFillValue) {
                    vinfo.fillValue = fvm.value;
                }
            } else if (mess.mtype == MessageType.FillValueOld) {
                fvm = (MessageFillValueOld)mess.messData;
                if (((MessageFillValueOld)fvm).size > 0) {
                    vinfo.fillValue = ((MessageFillValueOld)fvm).value;
                }
            }
            if ((fillValue = vinfo.getFillValueNonDefault()) == null || fillValue.equals(defFillValue = vinfo.getFillValueDefault(vinfo.typeInfo.dataType))) continue;
            fillAttribute = new Attribute("_FillValue", (Number)fillValue);
        }
        long dataAddress = facade.dobj.msl.dataAddress;
        if (dataAddress == -1L) {
            vinfo.useFillValue = true;
            if (vinfo.fillValue == null) {
                vinfo.fillValue = new byte[vinfo.typeInfo.dataType.getSize()];
            }
        }
        Structure s = null;
        if (facade.dobj.mdt.type == 6) {
            vname = facade.name;
            s = new Structure(this.ncfile, ncGroup, null, vname);
            v = s;
            if (!this.makeVariableShapeAndType(v, facade.dobj.mdt, facade.dobj.mds, vinfo, facade.dimList)) {
                return null;
            }
            this.addMembersToStructure(ncGroup, s, vinfo, facade.dobj.mdt);
            v.setElementSize(facade.dobj.mdt.byteSize);
        } else {
            vname = facade.name;
            if (vname.startsWith("_nc4_non_coord_")) {
                vname = vname.substring("_nc4_non_coord_".length());
            }
            if (!this.makeVariableShapeAndType(v = new Variable(this.ncfile, ncGroup, null, vname), facade.dobj.mdt, facade.dobj.mds, vinfo, facade.dimList)) {
                return null;
            }
        }
        if (v.getDataType() == DataType.STRING) {
            v.setElementSize(16);
        }
        v.setSPobject(vinfo);
        List<MessageAttribute> fatts = this.filterAttributes(facade.dobj.attributes);
        for (MessageAttribute matt : fatts) {
            try {
                this.makeAttributes(s, matt, v.getAttributes());
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.processSystemAttributes(facade.dobj.messages, v.getAttributes());
        if (fillAttribute != null && v.findAttribute("_FillValue") == null) {
            v.addAttribute(fillAttribute);
        }
        if (vinfo.typeInfo.unsigned) {
            v.addAttribute(new Attribute("_Unsigned", "true"));
        }
        if (facade.dobj.mdt.type == 5 && (desc = facade.dobj.mdt.opaque_desc) != null && desc.length() > 0) {
            v.addAttribute(new Attribute("_opaqueDesc", desc));
        }
        if (vinfo.isChunked) {
            vinfo.btree = new DataBTree(this, dataAddress, v.getShape(), vinfo.storageSize);
            if (vinfo.isChunked) {
                ArrayList<Integer> chunksize = new ArrayList<Integer>();
                for (int i = 0; i < vinfo.storageSize.length - 1; ++i) {
                    chunksize.add(vinfo.storageSize[i]);
                }
                v.addAttribute(new Attribute("_ChunkSize", chunksize));
            }
        }
        if (transformReference && facade.dobj.mdt.type == 7 && facade.dobj.mdt.referenceType == 0) {
            Array newData = this.findReferenceObjectNames(v.read());
            v.setDataType(DataType.STRING);
            v.setCachedData(newData, true);
            v.addAttribute(new Attribute("_HDF5ReferenceType", "values are names of referenced Variables"));
        }
        if (transformReference && facade.dobj.mdt.type == 7 && facade.dobj.mdt.referenceType == 1) {
            log.warn("transform region Reference: facade=" + facade.name + " variable name=" + v.getFullName());
            int nelems = (int)v.getSize();
            int heapIdSize = 12;
            v.setDataType(DataType.LONG);
            Array newData = Array.factory(DataType.LONG, v.getShape());
            v.setCachedData(newData, true);
            v.addAttribute(new Attribute("_HDF5ReferenceType", "values are regions of referenced Variables"));
        }
        vinfo.setOwner(v);
        if (vinfo.typeInfo.hdfType == 7 && warnings) {
            this.debugOut.println("WARN:  Variable " + facade.name + " is a Reference type");
        }
        if (vinfo.mfp != null && vinfo.mfp.filters[0].id != 1 && warnings) {
            this.debugOut.println("WARN:  Variable " + facade.name + " has a Filter = " + vinfo.mfp);
        }
        if (debug1) {
            this.debugOut.println("makeVariable " + v.getFullName() + "; vinfo= " + vinfo);
        }
        return v;
    }

    private Array findReferenceObjectNames(Array data) throws IOException {
        IndexIterator ii = data.getIndexIterator();
        Array newData = Array.factory(DataType.STRING, data.getShape());
        IndexIterator ii2 = newData.getIndexIterator();
        while (ii.hasNext()) {
            long objId = ii.getLongNext();
            DataObject dobj = this.getDataObject(objId, null);
            if (dobj == null) {
                log.error("readReferenceObjectNames cant find obj= " + objId);
                continue;
            }
            if (debugReference) {
                System.out.println(" Referenced object= " + dobj.who);
            }
            ii2.setObjectNext(dobj.who);
        }
        return newData;
    }

    private void addMembersToStructure(Group g, Structure s, Vinfo parentVinfo, MessageDatatype mdt) throws IOException {
        for (StructureMember m : mdt.members) {
            Variable v = this.makeVariableMember(g, s, m.name, m.offset, m.mdt);
            if (v == null) continue;
            s.addMemberVariable(v);
            if (!debug1) continue;
            this.debugOut.println("  made Member Variable " + v.getFullName() + "\n" + v);
        }
    }

    private Variable makeVariableMember(Group g, Structure s, String name, long dataPos, MessageDatatype mdt) throws IOException {
        Variable v;
        Vinfo vinfo = new Vinfo(mdt, null, dataPos);
        if (vinfo.getNCDataType() == null) {
            this.debugOut.println("SKIPPING DataType= " + vinfo.typeInfo.hdfType + " for variable " + name);
            return null;
        }
        if (mdt.type == 6) {
            v = new Structure(this.ncfile, g, s, name);
            this.makeVariableShapeAndType(v, mdt, null, vinfo, null);
            this.addMembersToStructure(g, (Structure)v, vinfo, mdt);
            v.setElementSize(mdt.byteSize);
        } else {
            v = new Variable(this.ncfile, g, s, name);
            this.makeVariableShapeAndType(v, mdt, null, vinfo, null);
        }
        if (v.getDataType() == DataType.STRING) {
            v.setElementSize(16);
        }
        v.setSPobject(vinfo);
        vinfo.setOwner(v);
        if (vinfo.typeInfo.unsigned) {
            v.addAttribute(new Attribute("_Unsigned", "true"));
        }
        return v;
    }

    private void processSystemAttributes(List<HeaderMessage> messages, List<Attribute> attributes) {
        for (HeaderMessage mess : messages) {
            if (mess.mtype != MessageType.Comment) continue;
            MessageComment m = (MessageComment)mess.messData;
            attributes.add(new Attribute("_comment", m.comment));
        }
    }

    private SimpleDateFormat getHdfDateFormatter() {
        if (this.hdfDateParser == null) {
            this.hdfDateParser = new SimpleDateFormat("yyyyMMddHHmmss");
            this.hdfDateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return this.hdfDateParser;
    }

    private boolean makeVariableShapeAndType(Variable v, MessageDatatype mdt, MessageDataspace msd, Vinfo vinfo, String dims) {
        int[] dim;
        int[] nArray = dim = msd != null ? msd.dimLength : new int[]{};
        if (dim == null) {
            dim = new int[]{};
        }
        if (mdt.type == 10) {
            int i;
            int len = dim.length + mdt.dim.length;
            int[] combinedDim = new int[len];
            for (i = 0; i < dim.length; ++i) {
                combinedDim[i] = dim[i];
            }
            for (i = 0; i < mdt.dim.length; ++i) {
                combinedDim[dim.length + i] = mdt.dim[i];
            }
            dim = combinedDim;
        }
        try {
            if (dims != null) {
                if (mdt.type == 9 && !mdt.isVString) {
                    v.setDimensions(dims + " *");
                } else {
                    v.setDimensions(dims);
                }
            } else if (mdt.type == 3) {
                if (mdt.byteSize == 1) {
                    v.setDimensionsAnonymous(dim);
                } else {
                    int[] shape = new int[dim.length + 1];
                    System.arraycopy(dim, 0, shape, 0, dim.length);
                    shape[dim.length] = mdt.byteSize;
                    v.setDimensionsAnonymous(shape);
                }
            } else if (mdt.type == 9 && !mdt.isVString) {
                if (dim.length == 1 && dim[0] == 1) {
                    int[] shape = new int[]{-1};
                    v.setDimensionsAnonymous(shape);
                } else {
                    int[] shape = new int[dim.length + 1];
                    System.arraycopy(dim, 0, shape, 0, dim.length);
                    shape[dim.length] = -1;
                    v.setDimensionsAnonymous(shape);
                }
            } else {
                v.setDimensionsAnonymous(dim);
            }
        }
        catch (InvalidRangeException ee) {
            log.error(ee.getMessage());
            this.debugOut.println("ERROR: makeVariableShapeAndType " + ee.getMessage());
            return false;
        }
        DataType dt = vinfo.getNCDataType();
        if (dt == null) {
            return false;
        }
        v.setDataType(dt);
        if (dt.isEnum()) {
            Group ncGroup = v.getParentGroup();
            EnumTypedef enumTypedef = ncGroup.findEnumeration(mdt.enumTypeName);
            if (enumTypedef == null) {
                enumTypedef = new EnumTypedef(mdt.enumTypeName, mdt.map);
            }
            v.setEnumTypedef(enumTypedef);
        }
        return true;
    }

    private DataType getNCtype(int hdfType, int size) {
        if (hdfType == 0 || hdfType == 4) {
            if (size == 1) {
                return DataType.BYTE;
            }
            if (size == 2) {
                return DataType.SHORT;
            }
            if (size == 4) {
                return DataType.INT;
            }
            if (size == 8) {
                return DataType.LONG;
            }
            if (warnings) {
                this.debugOut.println("WARNING HDF5 file " + this.ncfile.getLocation() + " not handling hdf integer type (" + hdfType + ") with size= " + size);
                log.warn("HDF5 file " + this.ncfile.getLocation() + " not handling hdf integer type (" + hdfType + ") with size= " + size);
                return null;
            }
        } else if (hdfType == 1) {
            if (size == 4) {
                return DataType.FLOAT;
            }
            if (size == 8) {
                return DataType.DOUBLE;
            }
            if (warnings) {
                this.debugOut.println("WARNING HDF5 file " + this.ncfile.getLocation() + " not handling hdf float type with size= " + size);
                log.warn("HDF5 file " + this.ncfile.getLocation() + " not handling hdf float type with size= " + size);
                return null;
            }
        } else {
            if (hdfType == 3) {
                return DataType.CHAR;
            }
            if (hdfType == 6) {
                return DataType.STRUCTURE;
            }
            if (hdfType == 7) {
                return DataType.LONG;
            }
            if (warnings) {
                this.debugOut.println("WARNING not handling hdf type = " + hdfType + " size= " + size);
                log.warn("HDF5 file " + this.ncfile.getLocation() + " not handling hdf type = " + hdfType + " size= " + size);
            }
        }
        return null;
    }

    private DataObject getDataObject(long address, String name) throws IOException {
        DataObject dobj = this.addressMap.get(address);
        if (dobj != null) {
            if (dobj.who == null && name != null) {
                dobj.who = name;
            }
            return dobj;
        }
        dobj = new DataObject(address, name);
        this.addressMap.put(address, dobj);
        return dobj;
    }

    private DataObject getSharedDataObject(MessageType mtype) throws IOException {
        DataObject dobj;
        byte sharedVersion = this.raf.readByte();
        byte sharedType = this.raf.readByte();
        if (sharedVersion == 1) {
            this.raf.skipBytes(6);
        }
        if (sharedVersion == 3 && sharedType == 1) {
            long heapId = this.raf.readLong();
            if (debug1) {
                this.debugOut.println("     Shared Message " + sharedVersion + " type=" + sharedType + " heapId = " + heapId);
            }
            if (debugPos) {
                this.debugOut.println("  --> Shared Message reposition to =" + this.raf.getFilePointer());
            }
            throw new UnsupportedOperationException("****SHARED MESSAGE type = " + mtype + " heapId = " + heapId);
        }
        long address = this.readOffset();
        if (debug1) {
            this.debugOut.println("     Shared Message " + sharedVersion + " type=" + sharedType + " address = " + address);
        }
        if (null == (dobj = this.getDataObject(address, null))) {
            throw new IllegalStateException("cant find data object at" + address);
        }
        if (mtype == MessageType.Datatype) {
            return dobj;
        }
        throw new UnsupportedOperationException("****SHARED MESSAGE type = " + mtype);
    }

    private void readGroupNew(H5Group group, MessageGroupNew groupNewMessage, DataObject dobj) throws IOException {
        if (debug1) {
            this.debugOut.println("\n--> GroupNew read <" + group.displayName + ">");
        }
        if (groupNewMessage.fractalHeapAddress >= 0L) {
            long btreeAddress;
            FractalHeap fractalHeap = new FractalHeap(this, group.displayName, groupNewMessage.fractalHeapAddress);
            long l = btreeAddress = groupNewMessage.v2BtreeAddressCreationOrder >= 0L ? groupNewMessage.v2BtreeAddressCreationOrder : groupNewMessage.v2BtreeAddress;
            if (btreeAddress < 0L) {
                throw new IllegalStateException("no valid btree for GroupNew with Fractal Heap");
            }
            BTree2 btree = new BTree2(this, group.displayName, btreeAddress);
            block4: for (BTree2.Entry2 e : btree.entryList) {
                byte[] heapId = null;
                switch (btree.btreeType) {
                    case 5: {
                        heapId = ((BTree2.Record5)e.record).heapId;
                        break;
                    }
                    case 6: {
                        heapId = ((BTree2.Record6)e.record).heapId;
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                long pos = fractalHeap.getHeapId(heapId).getPos();
                if (pos < 0L) continue;
                this.raf.seek(pos);
                MessageLink linkMessage = new MessageLink();
                linkMessage.read();
                if (debugBtree2) {
                    System.out.println("    linkMessage=" + linkMessage);
                }
                group.nestedObjects.add(new DataObjectFacade(group, linkMessage.linkName, linkMessage.linkAddress));
            }
        } else {
            for (HeaderMessage mess : dobj.messages) {
                if (mess.mtype != MessageType.Link) continue;
                MessageLink linkMessage = (MessageLink)mess.messData;
                if (linkMessage.linkType != 0) continue;
                group.nestedObjects.add(new DataObjectFacade(group, linkMessage.linkName, linkMessage.linkAddress));
            }
        }
        if (debug1) {
            this.debugOut.println("<-- end GroupNew read <" + group.displayName + ">");
        }
    }

    private void readGroupOld(H5Group group, long btreeAddress, long nameHeapAddress) throws IOException {
        if (debug1) {
            this.debugOut.println("\n--> GroupOld read <" + group.displayName + ">");
        }
        LocalHeap nameHeap = new LocalHeap(group, nameHeapAddress);
        GroupBTree btree = new GroupBTree(group.displayName, btreeAddress);
        for (SymbolTableEntry s : btree.getSymbolTableEntries()) {
            String sname = nameHeap.getString((int)s.getNameOffset());
            if (debugSoftLink) {
                this.debugOut.println("\n   Symbol name=" + sname);
            }
            if (s.cacheType == 2) {
                String linkName = nameHeap.getString(s.linkOffset);
                if (debugSoftLink) {
                    this.debugOut.println("   Symbolic link name=" + linkName + " symbolName=" + sname);
                }
                group.nestedObjects.add(new DataObjectFacade(group, sname, linkName));
                continue;
            }
            group.nestedObjects.add(new DataObjectFacade(group, sname, s.getObjectAddress()));
        }
        if (debug1) {
            this.debugOut.println("<-- end GroupOld read <" + group.displayName + ">");
        }
    }

    Array getHeapDataArray(long globalHeapIdAddress, DataType dataType, int endian) throws IOException, InvalidRangeException {
        HeapIdentifier heapId = new HeapIdentifier(globalHeapIdAddress);
        if (debugHeap) {
            this.debugOut.println(" heapId= " + heapId);
        }
        return this.getHeapDataArray(heapId, dataType, endian);
    }

    Array getHeapDataArray(HeapIdentifier heapId, DataType dataType, int endian) throws IOException, InvalidRangeException {
        GlobalHeap.HeapObject ho = heapId.getHeapObject();
        if (ho == null) {
            throw new InvalidRangeException("Illegal Heap address = " + ho);
        }
        if (debugHeap) {
            this.debugOut.println(" HeapObject= " + ho);
        }
        if (endian >= 0) {
            this.raf.order(endian);
        }
        if (DataType.FLOAT == dataType) {
            float[] pa = new float[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readFloat(pa, 0, pa.length);
            return Array.factory(dataType.getPrimitiveClassType(), new int[]{pa.length}, (Object)pa);
        }
        if (DataType.DOUBLE == dataType) {
            double[] pa = new double[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readDouble(pa, 0, pa.length);
            return Array.factory(dataType.getPrimitiveClassType(), new int[]{pa.length}, (Object)pa);
        }
        if (DataType.BYTE == dataType) {
            byte[] pa = new byte[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.read(pa, 0, pa.length);
            return Array.factory(dataType.getPrimitiveClassType(), new int[]{pa.length}, (Object)pa);
        }
        if (DataType.SHORT == dataType) {
            short[] pa = new short[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readShort(pa, 0, pa.length);
            return Array.factory(dataType.getPrimitiveClassType(), new int[]{pa.length}, (Object)pa);
        }
        if (DataType.INT == dataType) {
            int[] pa = new int[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readInt(pa, 0, pa.length);
            return Array.factory(dataType.getPrimitiveClassType(), new int[]{pa.length}, (Object)pa);
        }
        if (DataType.LONG == dataType) {
            long[] pa = new long[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readLong(pa, 0, pa.length);
            return Array.factory(dataType.getPrimitiveClassType(), new int[]{pa.length}, (Object)pa);
        }
        throw new UnsupportedOperationException("getHeapDataAsArray dataType=" + (Object)((Object)dataType));
    }

    String readHeapString(long heapIdAddress) throws IOException {
        HeapIdentifier heapId = new HeapIdentifier(heapIdAddress);
        GlobalHeap.HeapObject ho = heapId.getHeapObject();
        this.raf.seek(ho.dataPos);
        return this.readStringFixedLength((int)ho.dataSize);
    }

    String readHeapString(ByteBuffer bb, int pos) throws IOException {
        HeapIdentifier heapId = new HeapIdentifier(bb, pos);
        GlobalHeap.HeapObject ho = heapId.getHeapObject();
        this.raf.seek(ho.dataPos);
        return this.readStringFixedLength((int)ho.dataSize);
    }

    Array readHeapVlen(ByteBuffer bb, int pos, DataType dataType, int endian) throws IOException, InvalidRangeException {
        HeapIdentifier heapId = new HeapIdentifier(bb, pos);
        return this.getHeapDataArray(heapId, dataType, endian);
    }

    public List<DataObject> getDataObjects() {
        ArrayList<DataObject> result = new ArrayList<DataObject>(this.addressMap.values());
        Collections.sort(result, new Comparator<DataObject>(){

            @Override
            public int compare(DataObject o1, DataObject o2) {
                return o1.address < o2.address ? -1 : (o1.address == o2.address ? 0 : 1);
            }
        });
        return result;
    }

    String getDataObjectName(long objId) throws IOException {
        DataObject dobj = this.getDataObject(objId, null);
        if (dobj == null) {
            log.error("H5iosp.readVlenData cant find dataObject id= " + objId);
            return null;
        }
        if (debugVlen) {
            System.out.println(" Referenced object= " + dobj.who);
        }
        return dobj.who;
    }

    int makeIntFromBytes(byte[] bb, int start, int n) {
        int result = 0;
        for (int i = start + n - 1; i >= start; --i) {
            result <<= 8;
            int b = bb[i];
            result += b < 0 ? b + 256 : b;
        }
        return result;
    }

    private String readString(RandomAccessFile raf) throws IOException {
        long filePos = raf.getFilePointer();
        int count = 0;
        while (raf.readByte() != 0) {
            ++count;
        }
        raf.seek(filePos);
        byte[] s = new byte[count];
        raf.read(s);
        raf.readByte();
        return new String(s, CDM.utf8Charset);
    }

    private String readString8(RandomAccessFile raf) throws IOException {
        long filePos = raf.getFilePointer();
        int count = 0;
        while (raf.readByte() != 0) {
            ++count;
        }
        raf.seek(filePos);
        byte[] s = new byte[count];
        raf.read(s);
        ++count;
        count += this.padding(count, 8);
        raf.seek(filePos + (long)count);
        return new String(s, CDM.utf8Charset);
    }

    private String readStringFixedLength(int size) throws IOException {
        byte[] s = new byte[size];
        this.raf.read(s);
        return new String(s, CDM.utf8Charset);
    }

    long readLength() throws IOException {
        return this.isLengthLong ? this.raf.readLong() : (long)this.raf.readInt();
    }

    long readOffset() throws IOException {
        return this.isOffsetLong ? this.raf.readLong() : (long)this.raf.readInt();
    }

    long readAddress() throws IOException {
        return this.getFileOffset(this.readOffset());
    }

    int getNumBytesFromMax(long maxNumber) {
        int size = 0;
        while (maxNumber != 0L) {
            ++size;
            maxNumber >>>= 8;
        }
        return size;
    }

    private long readVariableSizeMax(int maxNumber) throws IOException {
        int size = this.getNumBytesFromMax(maxNumber);
        return this.readVariableSizeUnsigned(size);
    }

    private long readVariableSizeFactor(int sizeFactor) throws IOException {
        int size = (int)Math.pow(2.0, sizeFactor);
        return this.readVariableSizeUnsigned(size);
    }

    long readVariableSizeUnsigned(int size) throws IOException {
        long vv;
        if (size == 1) {
            vv = DataType.unsignedByteToShort(this.raf.readByte());
        } else if (size == 2) {
            if (debugPos) {
                this.debugOut.println("position=" + this.raf.getFilePointer());
            }
            short s = this.raf.readShort();
            vv = DataType.unsignedShortToInt(s);
        } else {
            vv = size == 4 ? DataType.unsignedIntToLong(this.raf.readInt()) : (size == 8 ? this.raf.readLong() : this.readVariableSizeN(size));
        }
        return vv;
    }

    private int readVariableSize(int size) throws IOException {
        if (size == 1) {
            return this.raf.readByte();
        }
        if (size == 2) {
            return this.raf.readShort();
        }
        if (size == 4) {
            return this.raf.readInt();
        }
        throw new IllegalArgumentException("Dont support int size == " + size);
    }

    private long readVariableSizeN(int nbytes) throws IOException {
        int[] ch = new int[nbytes];
        for (int i = 0; i < nbytes; ++i) {
            ch[i] = this.raf.read();
        }
        long result = ch[nbytes - 1];
        for (int i = nbytes - 2; i >= 0; --i) {
            result <<= 8;
            result += (long)ch[i];
        }
        return result;
    }

    long getFileOffset(long address) throws IOException {
        return this.baseAddress + address;
    }

    private int makeUnsignedIntFromBytes(byte upper, byte lower) {
        return DataType.unsignedByteToShort(upper) * 256 + DataType.unsignedByteToShort(lower);
    }

    private int padding(int nbytes, int multipleOf) {
        int pad = nbytes % multipleOf;
        if (pad != 0) {
            pad = multipleOf - pad;
        }
        return pad;
    }

    void dump(String head, long filePos, int nbytes, boolean count) throws IOException {
        long savePos = this.raf.getFilePointer();
        if (filePos >= 0L) {
            this.raf.seek(filePos);
        }
        byte[] mess = new byte[nbytes];
        this.raf.read(mess);
        H5header.printBytes(head, mess, nbytes, false, this.debugOut);
        this.raf.seek(savePos);
    }

    static void printBytes(String head, byte[] buff, int n, boolean count, PrintStream ps) {
        ps.print(head + " == ");
        for (int i = 0; i < n; ++i) {
            int ub;
            int b = buff[i];
            int n2 = ub = b < 0 ? b + 256 : b;
            if (count) {
                ps.print(i + ":");
            }
            ps.print(ub);
            if (!count) {
                ps.print("(");
                ps.print(b);
                ps.print(")");
            }
            ps.print(" ");
        }
        ps.println();
    }

    static void printBytes(String head, byte[] buff, int offset, int n, PrintStream ps) {
        ps.print(head + " == ");
        for (int i = 0; i < n; ++i) {
            int b = buff[offset + i];
            int ub = b < 0 ? b + 256 : b;
            ps.print(ub);
            ps.print(" ");
        }
        ps.println();
    }

    public void close() {
        if (debugTracker) {
            this.memTracker.report();
        }
    }

    private class MemTracker {
        private List<Mem> memList = new ArrayList<Mem>();
        private StringBuilder sbuff = new StringBuilder();
        private long fileSize;

        MemTracker(long fileSize) {
            this.fileSize = fileSize;
        }

        void add(String name, long start, long end) {
            this.memList.add(new Mem(name, start, end));
        }

        void addByLen(String name, long start, long size) {
            this.memList.add(new Mem(name, start, start + size));
        }

        void report() {
            H5header.this.debugOut.println("Memory used file size= " + this.fileSize);
            H5header.this.debugOut.println("  start    end   size   name");
            Collections.sort(this.memList);
            Mem prev = null;
            for (Mem m : this.memList) {
                if (prev != null && m.start > prev.end) {
                    this.doOne('+', prev.end, m.start, m.start - prev.end, "HOLE");
                }
                char c = prev != null && prev.end != m.start ? (char)'*' : ' ';
                this.doOne(c, m.start, m.end, m.end - m.start, m.name);
                prev = m;
            }
            H5header.this.debugOut.println();
        }

        private void doOne(char c, long start, long end, long size, String name) {
            this.sbuff.setLength(0);
            this.sbuff.append(c);
            this.sbuff.append(Format.l(start, 6));
            this.sbuff.append(" ");
            this.sbuff.append(Format.l(end, 6));
            this.sbuff.append(" ");
            this.sbuff.append(Format.l(size, 6));
            this.sbuff.append(" ");
            this.sbuff.append(name);
            H5header.this.debugOut.println(this.sbuff.toString());
        }

        class Mem
        implements Comparable {
            public String name;
            public long start;
            public long end;

            Mem(String name, long start, long end) {
                this.name = name;
                this.start = start;
                this.end = end;
            }

            public int compareTo(Object o1) {
                Mem m = (Mem)o1;
                return (int)(this.start - m.start);
            }
        }
    }

    private class LocalHeap {
        H5Group group;
        int size;
        long freelistOffset;
        long dataAddress;
        byte[] heap;
        byte version;

        LocalHeap(H5Group group, long address) throws IOException {
            this.group = group;
            H5header.this.raf.order(1);
            H5header.this.raf.seek(H5header.this.getFileOffset(address));
            if (debugDetail) {
                H5header.this.debugOut.println("-- readLocalHeap position=" + H5header.this.raf.getFilePointer());
            }
            byte[] heapname = new byte[4];
            H5header.this.raf.read(heapname);
            String magic = new String(heapname);
            if (!magic.equals("HEAP")) {
                throw new IllegalStateException(magic + " should equal HEAP");
            }
            this.version = H5header.this.raf.readByte();
            H5header.this.raf.skipBytes(3);
            this.size = (int)H5header.this.readLength();
            this.freelistOffset = H5header.this.readLength();
            this.dataAddress = H5header.this.readOffset();
            if (debugDetail) {
                H5header.this.debugOut.println(" version=" + this.version + " size=" + this.size + " freelistOffset=" + this.freelistOffset + " heap starts at dataAddress=" + this.dataAddress);
            }
            if (debugPos) {
                H5header.this.debugOut.println("    *now at position=" + H5header.this.raf.getFilePointer());
            }
            H5header.this.raf.seek(H5header.this.getFileOffset(this.dataAddress));
            this.heap = new byte[this.size];
            H5header.this.raf.read(this.heap);
            if (debugDetail) {
                H5header.this.debugOut.println("-- endLocalHeap position=" + H5header.this.raf.getFilePointer());
            }
            int hsize = 8 + 2 * H5header.this.sizeLengths + H5header.this.sizeOffsets;
            if (debugTracker) {
                H5header.this.memTracker.addByLen("Group LocalHeap (" + group.displayName + ")", address, hsize);
            }
            if (debugTracker) {
                H5header.this.memTracker.addByLen("Group LocalHeapData (" + group.displayName + ")", this.dataAddress, this.size);
            }
        }

        public String getString(int offset) {
            int count = 0;
            while (this.heap[offset + count] != 0) {
                ++count;
            }
            return new String(this.heap, offset, count, CDM.utf8Charset);
        }
    }

    private class GlobalHeap {
        byte version;
        int sizeBytes;
        List<HeapObject> hos = new ArrayList<HeapObject>();
        HeapObject freeSpace = null;

        GlobalHeap(long address) throws IOException {
            H5header.this.raf.order(1);
            H5header.this.raf.seek(H5header.this.getFileOffset(address));
            byte[] heapname = new byte[4];
            H5header.this.raf.read(heapname);
            String magic = new String(heapname);
            if (!magic.equals("GCOL")) {
                throw new IllegalStateException(magic + " should equal GCOL");
            }
            this.version = H5header.this.raf.readByte();
            H5header.this.raf.skipBytes(3);
            this.sizeBytes = H5header.this.raf.readInt();
            if (debugDetail) {
                H5header.this.debugOut.println("-- readGlobalHeap address=" + address + " version= " + this.version + " size = " + this.sizeBytes);
            }
            H5header.this.raf.skipBytes(4);
            int count = 0;
            int countBytes = 0;
            do {
                long startPos = H5header.this.raf.getFilePointer();
                HeapObject o = new HeapObject();
                o.id = H5header.this.raf.readShort();
                o.refCount = H5header.this.raf.readShort();
                H5header.this.raf.skipBytes(4);
                o.dataSize = H5header.this.readLength();
                o.dataPos = H5header.this.raf.getFilePointer();
                int dsize = (int)o.dataSize + H5header.this.padding((int)o.dataSize, 8);
                if (o.id == 0 || o.dataSize < 0L || (countBytes += dsize + 16) < 0) break;
                if (debugDetail) {
                    H5header.this.debugOut.println("   HeapObject  position=" + startPos + " id=" + o.id + " refCount= " + o.refCount + " dataSize = " + o.dataSize + " dataPos = " + o.dataPos + " count= " + count + " countBytes= " + countBytes);
                }
                H5header.this.raf.skipBytes(dsize);
                this.hos.add(o);
                ++count;
            } while (countBytes + 16 < this.sizeBytes);
            if (debugDetail) {
                H5header.this.debugOut.println("-- endGlobalHeap position=" + H5header.this.raf.getFilePointer());
            }
            if (debugTracker) {
                H5header.this.memTracker.addByLen("GlobalHeap", address, this.sizeBytes);
            }
        }

        class HeapObject {
            short id;
            short refCount;
            long dataSize;
            long dataPos;

            HeapObject() {
            }

            public String toString() {
                return "id=" + this.id + ", refCount=" + this.refCount + ", dataSize=" + this.dataSize + ", dataPos=" + this.dataPos;
            }
        }
    }

    private class RegionReference {
        private long heapAddress;
        private int index;

        RegionReference(long filePos) throws IOException {
            H5header.this.raf.order(1);
            H5header.this.raf.seek(filePos);
            this.heapAddress = H5header.this.readOffset();
            this.index = H5header.this.raf.readInt();
            GlobalHeap gheap = (GlobalHeap)H5header.this.heapMap.get(this.heapAddress);
            if (null == gheap) {
                gheap = new GlobalHeap(this.heapAddress);
                H5header.this.heapMap.put(this.heapAddress, gheap);
            }
            for (GlobalHeap.HeapObject ho : gheap.hos) {
                if (ho.id != this.index) continue;
                GlobalHeap.HeapObject want = ho;
                if (debugRegionReference) {
                    System.out.println(" found ho=" + ho);
                }
                H5header.this.raf.seek(ho.dataPos);
                long objId = H5header.this.raf.readLong();
                DataObject ndo = H5header.this.getDataObject(objId, null);
                if (debugRegionReference) {
                    System.out.println(" objId=" + objId + " DataObject= " + ndo);
                }
                if (null == ndo) {
                    throw new IllegalStateException("cant find data object at" + objId);
                }
                return;
            }
            throw new IllegalStateException("cant find HeapObject");
        }
    }

    class HeapIdentifier {
        private int nelems;
        private long heapAddress;
        private int index;

        HeapIdentifier(long address) throws IOException {
            H5header.this.raf.order(1);
            H5header.this.raf.seek(address);
            this.nelems = H5header.this.raf.readInt();
            this.heapAddress = H5header.this.readOffset();
            this.index = H5header.this.raf.readInt();
            if (debugDetail) {
                H5header.this.debugOut.println("   read HeapIdentifier address=" + address + this);
            }
            if (debugHeap) {
                H5header.this.dump("heapIdentifier", H5header.this.getFileOffset(address), 16, true);
            }
        }

        HeapIdentifier(ByteBuffer bb, int pos) throws IOException {
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.position(pos);
            this.nelems = bb.getInt();
            this.heapAddress = H5header.this.isOffsetLong ? bb.getLong() : (long)bb.getInt();
            this.index = bb.getInt();
            if (debugDetail) {
                H5header.this.debugOut.println("   read HeapIdentifier from ByteBuffer=" + this);
            }
        }

        public String toString() {
            return " nelems=" + this.nelems + " heapAddress=" + this.heapAddress + " index=" + this.index;
        }

        public boolean isEmpty() {
            return this.heapAddress == 0L;
        }

        GlobalHeap.HeapObject getHeapObject() throws IOException {
            if (this.isEmpty()) {
                return null;
            }
            GlobalHeap gheap = (GlobalHeap)H5header.this.heapMap.get(this.heapAddress);
            if (null == gheap) {
                gheap = new GlobalHeap(this.heapAddress);
                H5header.this.heapMap.put(this.heapAddress, gheap);
            }
            for (GlobalHeap.HeapObject ho : gheap.hos) {
                if (ho.id != this.index) continue;
                return ho;
            }
            throw new IllegalStateException("cant find HeapObject");
        }
    }

    private class SymbolTableEntry {
        long nameOffset;
        long objectHeaderAddress;
        long btreeAddress;
        long nameHeapAddress;
        int cacheType;
        int linkOffset;
        long posData;
        boolean isSymbolicLink = false;

        SymbolTableEntry(long filePos) throws IOException {
            H5header.this.raf.seek(filePos);
            if (debugSymbolTable) {
                H5header.this.debugOut.println("--> readSymbolTableEntry position=" + H5header.this.raf.getFilePointer());
            }
            this.nameOffset = H5header.this.readOffset();
            this.objectHeaderAddress = H5header.this.readOffset();
            this.cacheType = H5header.this.raf.readInt();
            H5header.this.raf.skipBytes(4);
            if (debugSymbolTable) {
                H5header.this.debugOut.print(" nameOffset=" + this.nameOffset);
                H5header.this.debugOut.print(" objectHeaderAddress=" + this.objectHeaderAddress);
                H5header.this.debugOut.println(" cacheType=" + this.cacheType);
            }
            this.posData = H5header.this.raf.getFilePointer();
            if (debugSymbolTable) {
                H5header.this.dump("Group Entry scratch pad", this.posData, 16, false);
            }
            if (this.cacheType == 1) {
                this.btreeAddress = H5header.this.readOffset();
                this.nameHeapAddress = H5header.this.readOffset();
                if (debugSymbolTable) {
                    H5header.this.debugOut.println("btreeAddress=" + this.btreeAddress + " nameHeadAddress=" + this.nameHeapAddress);
                }
            }
            if (this.cacheType == 2) {
                this.linkOffset = H5header.this.raf.readInt();
                if (debugSymbolTable) {
                    H5header.this.debugOut.println("WARNING Symbolic Link linkOffset=" + this.linkOffset);
                }
                this.isSymbolicLink = true;
            }
            if (debugSymbolTable) {
                H5header.this.debugOut.println("<-- end readSymbolTableEntry position=" + H5header.this.raf.getFilePointer());
            }
            H5header.this.memTracker.add("SymbolTableEntry", filePos, this.posData + 16L);
        }

        public int getSize() {
            return H5header.this.isOffsetLong ? 40 : 32;
        }

        public long getObjectAddress() {
            return this.objectHeaderAddress;
        }

        public long getNameOffset() {
            return this.nameOffset;
        }

        public String toString() {
            return "SymbolTableEntry{nameOffset=" + this.nameOffset + ", objectHeaderAddress=" + this.objectHeaderAddress + ", btreeAddress=" + this.btreeAddress + ", nameHeapAddress=" + this.nameHeapAddress + ", cacheType=" + this.cacheType + ", linkOffset=" + this.linkOffset + ", posData=" + this.posData + ", isSymbolicLink=" + this.isSymbolicLink + '}';
        }
    }

    private class GroupBTree {
        protected String owner;
        protected int wantType = 0;
        private List<SymbolTableEntry> sentries = new ArrayList<SymbolTableEntry>();

        GroupBTree(String owner) {
            this.owner = owner;
        }

        GroupBTree(String owner, long address) throws IOException {
            this.owner = owner;
            ArrayList<Entry> entryList = new ArrayList<Entry>();
            this.readAllEntries(address, entryList);
            for (Entry e : entryList) {
                GroupNode node = new GroupNode(e.address);
                this.sentries.addAll(node.getSymbols());
            }
        }

        List<SymbolTableEntry> getSymbolTableEntries() {
            return this.sentries;
        }

        protected void readAllEntries(long address, List<Entry> entryList) throws IOException {
            H5header.this.raf.seek(H5header.this.getFileOffset(address));
            if (debugGroupBtree) {
                H5header.this.debugOut.println("\n--> GroupBTree read tree at position=" + H5header.this.raf.getFilePointer());
            }
            byte[] name = new byte[4];
            H5header.this.raf.read(name);
            String magic = new String(name);
            if (!magic.equals("TREE")) {
                throw new IllegalStateException("BtreeGroup doesnt start with TREE");
            }
            byte type = H5header.this.raf.readByte();
            byte level = H5header.this.raf.readByte();
            int nentries = H5header.this.raf.readShort();
            if (debugGroupBtree) {
                H5header.this.debugOut.println("    type=" + type + " level=" + level + " nentries=" + nentries);
            }
            if (type != this.wantType) {
                throw new IllegalStateException("BtreeGroup must be type " + this.wantType);
            }
            long size = 8 + 2 * H5header.this.sizeOffsets + nentries * (H5header.this.sizeOffsets + H5header.this.sizeLengths);
            if (debugTracker) {
                H5header.this.memTracker.addByLen("Group BTree (" + this.owner + ")", address, size);
            }
            long leftAddress = H5header.this.readOffset();
            long rightAddress = H5header.this.readOffset();
            if (debugGroupBtree) {
                H5header.this.debugOut.println("    leftAddress=" + leftAddress + " " + Long.toHexString(leftAddress) + " rightAddress=" + rightAddress + " " + Long.toHexString(rightAddress));
            }
            ArrayList<Entry> myEntries = new ArrayList<Entry>();
            for (int i = 0; i < nentries; ++i) {
                myEntries.add(new Entry());
            }
            if (level == 0) {
                entryList.addAll(myEntries);
            } else {
                for (Entry entry : myEntries) {
                    if (debugDataBtree) {
                        H5header.this.debugOut.println("  nonzero node entry at =" + entry.address);
                    }
                    this.readAllEntries(entry.address, entryList);
                }
            }
        }

        class GroupNode {
            long address;
            byte version;
            short nentries;
            List<SymbolTableEntry> symbols = new ArrayList<SymbolTableEntry>();

            GroupNode(long address) throws IOException {
                this.address = address;
                H5header.this.raf.seek(H5header.this.getFileOffset(address));
                if (debugDetail) {
                    H5header.this.debugOut.println("--Group Node position=" + H5header.this.raf.getFilePointer());
                }
                byte[] sig = new byte[4];
                H5header.this.raf.read(sig);
                String magic = new String(sig);
                if (!magic.equals("SNOD")) {
                    throw new IllegalStateException(magic + " should equal SNOD");
                }
                this.version = H5header.this.raf.readByte();
                H5header.this.raf.readByte();
                this.nentries = H5header.this.raf.readShort();
                if (debugDetail) {
                    H5header.this.debugOut.println("   version=" + this.version + " nentries=" + this.nentries);
                }
                long posEntry = H5header.this.raf.getFilePointer();
                for (int i = 0; i < this.nentries; ++i) {
                    SymbolTableEntry entry = new SymbolTableEntry(posEntry);
                    posEntry += (long)entry.getSize();
                    if (entry.objectHeaderAddress != 0L) {
                        if (debug1) {
                            H5header.this.debugOut.printf("   add %s%n", entry);
                        }
                        this.symbols.add(entry);
                        continue;
                    }
                    if (!debug1) continue;
                    H5header.this.debugOut.printf("   BAD objectHeaderAddress==0 !! %s%n", entry);
                }
                if (debugDetail) {
                    H5header.this.debugOut.println("-- Group Node end position=" + H5header.this.raf.getFilePointer());
                }
                long size = 8 + this.nentries * 40;
                if (debugTracker) {
                    H5header.this.memTracker.addByLen("Group BtreeNode (" + GroupBTree.this.owner + ")", address, size);
                }
            }

            List<SymbolTableEntry> getSymbols() {
                return this.symbols;
            }
        }

        class Entry {
            long key;
            long address;

            Entry() throws IOException {
                this.key = H5header.this.readLength();
                this.address = H5header.this.readOffset();
                if (debugGroupBtree) {
                    H5header.this.debugOut.println("     GroupEntry key=" + this.key + " address=" + this.address);
                }
            }
        }
    }

    private class MessageObjectReferenceCount
    implements Named {
        int refCount;

        private MessageObjectReferenceCount() {
        }

        void read() throws IOException {
            byte version = H5header.this.raf.readByte();
            this.refCount = H5header.this.raf.readInt();
            if (debug1) {
                H5header.this.debugOut.println("   ObjectReferenceCount=" + this.refCount);
            }
        }

        @Override
        public String getName() {
            return Integer.toString(this.refCount);
        }
    }

    private class MessageContinue
    implements Named {
        long offset;
        long length;

        private MessageContinue() {
        }

        void read() throws IOException {
            this.offset = H5header.this.readOffset();
            this.length = H5header.this.readLength();
            if (debug1) {
                H5header.this.debugOut.println("   Continue offset=" + this.offset + " length=" + this.length);
            }
        }

        @Override
        public String getName() {
            return "";
        }
    }

    private class MessageLastModifiedOld
    implements Named {
        String datemod;

        private MessageLastModifiedOld() {
        }

        void read() throws IOException {
            byte[] s = new byte[14];
            H5header.this.raf.read(s);
            this.datemod = new String(s);
            if (debug1) {
                H5header.this.debugOut.println("   MessageLastModifiedOld=" + this.datemod);
            }
        }

        public String toString() {
            return this.datemod;
        }

        @Override
        public String getName() {
            return this.toString();
        }
    }

    private class MessageLastModified
    implements Named {
        byte version;
        int secs;

        private MessageLastModified() {
        }

        void read() throws IOException {
            this.version = H5header.this.raf.readByte();
            H5header.this.raf.skipBytes(3);
            this.secs = H5header.this.raf.readInt();
        }

        public String toString() {
            return new Date(this.secs * 1000).toString();
        }

        @Override
        public String getName() {
            return this.toString();
        }
    }

    private class MessageComment
    implements Named {
        String comment;

        private MessageComment() {
        }

        void read() throws IOException {
            this.comment = H5header.this.readString(H5header.this.raf);
        }

        public String toString() {
            return this.comment;
        }

        @Override
        public String getName() {
            return this.comment;
        }
    }

    private class MessageAttributeInfo
    implements Named {
        byte version;
        byte flags;
        short maxCreationIndex = (short)-1;
        long fractalHeapAddress = -2L;
        long v2BtreeAddress = -2L;
        long v2BtreeAddressCreationOrder = -2L;

        private MessageAttributeInfo() {
        }

        @Override
        public String getName() {
            long btreeAddress = this.v2BtreeAddressCreationOrder > 0L ? this.v2BtreeAddressCreationOrder : this.v2BtreeAddress;
            return Long.toString(btreeAddress);
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("   MessageAttributeInfo ", new Object[0]);
            if ((this.flags & 1) != 0) {
                f.format(" maxCreationIndex=" + this.maxCreationIndex, new Object[0]);
            }
            f.format(" fractalHeapAddress=%d v2BtreeAddress=%d", this.fractalHeapAddress, this.v2BtreeAddress);
            if ((this.flags & 2) != 0) {
                f.format(" v2BtreeAddressCreationOrder=%d", this.v2BtreeAddressCreationOrder);
            }
            this.showFractalHeap(f);
            return f.toString();
        }

        void showFractalHeap(Formatter f) {
            long btreeAddress;
            long l = btreeAddress = this.v2BtreeAddressCreationOrder > 0L ? this.v2BtreeAddressCreationOrder : this.v2BtreeAddress;
            if (this.fractalHeapAddress > 0L && btreeAddress > 0L) {
                try {
                    FractalHeap fractalHeap = new FractalHeap(H5header.this, "", this.fractalHeapAddress);
                    fractalHeap.showDetails(f);
                    f.format(" Btree:%n", new Object[0]);
                    f.format("  type n m  offset size pos       attName%n", new Object[0]);
                    BTree2 btree = new BTree2(H5header.this, "", btreeAddress);
                    block6: for (BTree2.Entry2 e : btree.entryList) {
                        byte[] heapId = null;
                        switch (btree.btreeType) {
                            case 8: {
                                heapId = ((BTree2.Record8)e.record).heapId;
                                break;
                            }
                            case 9: {
                                heapId = ((BTree2.Record9)e.record).heapId;
                                break;
                            }
                            default: {
                                f.format(" unknown btreetype %d\n", btree.btreeType);
                                continue block6;
                            }
                        }
                        FractalHeap.DHeapId dh = fractalHeap.getHeapId(heapId);
                        f.format("   %2d %2d %2d %6d %4d %8d", dh.type, dh.n, dh.m, dh.offset, dh.size, dh.getPos());
                        if (dh.getPos() > 0L) {
                            H5header.this.raf.seek(dh.getPos());
                            MessageAttribute attMessage = new MessageAttribute();
                            attMessage.read();
                            f.format(" %-30s", this.trunc(attMessage.getName(), 30));
                        }
                        f.format(" heapId=:", new Object[0]);
                        Misc.showBytes(heapId, f);
                        f.format("%n", new Object[0]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        String trunc(String s, int max) {
            if (s == null) {
                return null;
            }
            if (s.length() < max) {
                return s;
            }
            return s.substring(0, max);
        }

        void read() throws IOException {
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageAttributeInfo start pos= " + H5header.this.raf.getFilePointer());
            }
            byte version = H5header.this.raf.readByte();
            byte flags = H5header.this.raf.readByte();
            if ((flags & 1) != 0) {
                this.maxCreationIndex = H5header.this.raf.readShort();
            }
            this.fractalHeapAddress = H5header.this.readOffset();
            this.v2BtreeAddress = H5header.this.readOffset();
            if ((flags & 2) != 0) {
                this.v2BtreeAddressCreationOrder = H5header.this.readOffset();
            }
            if (debug1) {
                H5header.this.debugOut.println("   MessageAttributeInfo version= " + version + " flags = " + flags + this);
            }
        }
    }

    public class MessageAttribute
    implements Named {
        byte version;
        String name;
        MessageDatatype mdt;
        MessageDataspace mds;
        long dataPos;

        public MessageAttribute() {
            this.mdt = new MessageDatatype();
            this.mds = new MessageDataspace();
        }

        public byte getVersion() {
            return this.version;
        }

        public MessageDatatype getMdt() {
            return this.mdt;
        }

        public MessageDataspace getMds() {
            return this.mds;
        }

        public long getDataPosAbsolute() {
            return this.dataPos;
        }

        public Attribute getNcAttribute() throws IOException {
            return H5header.this.makeAttribute(this);
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   Name= ").append(this.name);
            sbuff.append(" dataPos = ").append(this.dataPos);
            if (this.mdt != null) {
                sbuff.append("\n mdt=");
                sbuff.append(this.mdt.toString());
            }
            if (this.mds != null) {
                sbuff.append("\n mds=");
                sbuff.append(this.mds.toString());
            }
            return sbuff.toString();
        }

        @Override
        public String getName() {
            return this.name;
        }

        boolean read() throws IOException {
            boolean isShared;
            short spaceSize;
            short typeSize;
            short nameSize;
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageAttribute start pos= " + H5header.this.raf.getFilePointer());
            }
            byte flags = 0;
            byte encoding = 0;
            this.version = H5header.this.raf.readByte();
            if (this.version == 1) {
                H5header.this.raf.read();
                nameSize = H5header.this.raf.readShort();
                typeSize = H5header.this.raf.readShort();
                spaceSize = H5header.this.raf.readShort();
            } else if (this.version == 2 || this.version == 3) {
                flags = H5header.this.raf.readByte();
                nameSize = H5header.this.raf.readShort();
                typeSize = H5header.this.raf.readShort();
                spaceSize = H5header.this.raf.readShort();
                if (this.version == 3) {
                    encoding = H5header.this.raf.readByte();
                }
            } else {
                log.error("bad version " + this.version + " at filePos " + H5header.this.raf.getFilePointer());
                return false;
            }
            long filePos = H5header.this.raf.getFilePointer();
            this.name = H5header.this.readString(H5header.this.raf);
            if (this.version == 1) {
                nameSize = (short)(nameSize + H5header.this.padding(nameSize, 8));
            }
            H5header.this.raf.seek(filePos + (long)nameSize);
            if (debug1) {
                H5header.this.debugOut.println("   MessageAttribute version= " + this.version + " flags = " + Integer.toBinaryString(flags) + " nameSize = " + nameSize + " typeSize=" + typeSize + " spaceSize= " + spaceSize + " name= " + this.name);
            }
            filePos = H5header.this.raf.getFilePointer();
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageAttribute before mdt pos= " + filePos);
            }
            boolean bl = isShared = (flags & 1) != 0;
            if (isShared) {
                this.mdt = ((H5header)H5header.this).getSharedDataObject((MessageType)MessageType.Datatype).mdt;
                if (debug1) {
                    H5header.this.debugOut.println("    MessageDatatype: " + this.mdt);
                }
            } else {
                this.mdt.read(this.name);
                if (this.version == 1) {
                    typeSize = (short)(typeSize + H5header.this.padding(typeSize, 8));
                }
            }
            H5header.this.raf.seek(filePos + (long)typeSize);
            filePos = H5header.this.raf.getFilePointer();
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageAttribute before mds = " + filePos);
            }
            this.mds.read();
            if (this.version == 1) {
                spaceSize = (short)(spaceSize + H5header.this.padding(spaceSize, 8));
            }
            H5header.this.raf.seek(filePos + (long)spaceSize);
            this.dataPos = H5header.this.raf.getFilePointer();
            if (debug1) {
                H5header.this.debugOut.println("   *MessageAttribute dataPos= " + this.dataPos);
            }
            return true;
        }
    }

    class Filter {
        short id;
        short flags;
        String name;
        short nValues;
        int[] data;

        Filter(byte version) throws IOException {
            this.id = H5header.this.raf.readShort();
            short nameSize = version > 1 && this.id < 256 ? (short)0 : H5header.this.raf.readShort();
            this.flags = H5header.this.raf.readShort();
            this.nValues = H5header.this.raf.readShort();
            this.name = version == 1 ? (nameSize > 0 ? H5header.this.readString8(H5header.this.raf) : this.getFilterName(this.id)) : (nameSize > 0 ? H5header.this.readStringFixedLength(nameSize) : this.getFilterName(this.id));
            this.data = new int[this.nValues];
            for (int i = 0; i < this.nValues; ++i) {
                this.data[i] = H5header.this.raf.readInt();
            }
            if (this.nValues % 2 == 1) {
                H5header.this.raf.skipBytes(4);
            }
            if (debug1) {
                H5header.this.debugOut.println(this);
            }
        }

        String getFilterName(int id) {
            return id < filterName.length ? filterName[id] : "StandardFilter " + id;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   Filter id= ").append(this.id).append(" flags = ").append(this.flags).append(" nValues=").append(this.nValues).append(" name= ").append(this.name).append(" data = ");
            for (int i = 0; i < this.nValues; ++i) {
                sbuff.append(this.data[i]).append(" ");
            }
            return sbuff.toString();
        }
    }

    class MessageFilter
    implements Named {
        Filter[] filters;

        MessageFilter() {
        }

        void read() throws IOException {
            byte version = H5header.this.raf.readByte();
            int nfilters = H5header.this.raf.readByte();
            if (version == 1) {
                H5header.this.raf.skipBytes(6);
            }
            this.filters = new Filter[nfilters];
            for (int i = 0; i < nfilters; ++i) {
                this.filters[i] = new Filter(version);
            }
            if (debug1) {
                H5header.this.debugOut.println("   MessageFilter version=" + version + this);
            }
        }

        public Filter[] getFilters() {
            return this.filters;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   MessageFilter filters=\n");
            for (Filter f : this.filters) {
                sbuff.append(" ").append(f).append("\n");
            }
            return sbuff.toString();
        }

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            for (Filter f : this.filters) {
                sbuff.append(f.name).append(", ");
            }
            return sbuff.toString();
        }
    }

    class MessageLayout
    implements Named {
        byte type;
        long dataAddress = -1L;
        long contiguousSize;
        int[] chunkSize;
        int dataSize;

        MessageLayout() {
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append(" type= ").append(this.type).append(" (");
            switch (this.type) {
                case 0: {
                    sbuff.append("compact");
                    break;
                }
                case 1: {
                    sbuff.append("contiguous");
                    break;
                }
                case 2: {
                    sbuff.append("chunked");
                    break;
                }
                default: {
                    sbuff.append("unknown type= ").append(this.type);
                }
            }
            sbuff.append(")");
            if (this.chunkSize != null) {
                sbuff.append(" storageSize = (");
                for (int i = 0; i < this.chunkSize.length; ++i) {
                    if (i > 0) {
                        sbuff.append(",");
                    }
                    sbuff.append(this.chunkSize[i]);
                }
                sbuff.append(")");
            }
            sbuff.append(" dataSize=").append(this.dataSize);
            sbuff.append(" dataAddress=").append(this.dataAddress);
            return sbuff.toString();
        }

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            switch (this.type) {
                case 0: {
                    sbuff.append("compact");
                    break;
                }
                case 1: {
                    sbuff.append("contiguous");
                    break;
                }
                case 2: {
                    sbuff.append("chunked");
                    break;
                }
                default: {
                    sbuff.append("unknown type= ").append(this.type);
                }
            }
            if (this.chunkSize != null) {
                sbuff.append(" chunk = (");
                for (int i = 0; i < this.chunkSize.length; ++i) {
                    if (i > 0) {
                        sbuff.append(",");
                    }
                    sbuff.append(this.chunkSize[i]);
                }
                sbuff.append(")");
            }
            return sbuff.toString();
        }

        void read() throws IOException {
            byte version = H5header.this.raf.readByte();
            if (version < 3) {
                boolean isCompact;
                int ndims = H5header.this.raf.readByte();
                this.type = H5header.this.raf.readByte();
                H5header.this.raf.skipBytes(5);
                boolean bl = isCompact = this.type == 0;
                if (!isCompact) {
                    this.dataAddress = H5header.this.readOffset();
                }
                this.chunkSize = new int[ndims];
                for (int i = 0; i < ndims; ++i) {
                    this.chunkSize[i] = H5header.this.raf.readInt();
                }
                if (isCompact) {
                    this.dataSize = H5header.this.raf.readInt();
                    this.dataAddress = H5header.this.raf.getFilePointer();
                }
            } else {
                this.type = H5header.this.raf.readByte();
                if (this.type == 0) {
                    this.dataSize = H5header.this.raf.readShort();
                    this.dataAddress = H5header.this.raf.getFilePointer();
                } else if (this.type == 1) {
                    this.dataAddress = H5header.this.readOffset();
                    this.contiguousSize = H5header.this.readLength();
                } else if (this.type == 2) {
                    int ndims = H5header.this.raf.readByte();
                    this.dataAddress = H5header.this.readOffset();
                    this.chunkSize = new int[ndims];
                    for (int i = 0; i < ndims; ++i) {
                        this.chunkSize[i] = H5header.this.raf.readInt();
                    }
                }
            }
            if (debug1) {
                H5header.this.debugOut.println("   StorageLayout version= " + version + this);
            }
        }
    }

    private class MessageFillValue
    implements Named {
        byte version;
        byte spaceAllocateTime;
        byte fillWriteTime;
        int size;
        byte[] value;
        boolean hasFillValue = false;
        byte flags;

        private MessageFillValue() {
        }

        void read() throws IOException {
            this.version = H5header.this.raf.readByte();
            if (this.version < 3) {
                this.spaceAllocateTime = H5header.this.raf.readByte();
                this.fillWriteTime = H5header.this.raf.readByte();
                this.hasFillValue = H5header.this.raf.readByte() != 0;
            } else {
                this.flags = H5header.this.raf.readByte();
                this.spaceAllocateTime = (byte)(this.flags & 3);
                this.fillWriteTime = (byte)(this.flags >> 2 & 3);
                boolean bl = this.hasFillValue = (this.flags & 0x20) != 0;
            }
            if (this.hasFillValue) {
                this.size = H5header.this.raf.readInt();
                if (this.size > 0) {
                    this.value = new byte[this.size];
                    H5header.this.raf.read(this.value);
                    this.hasFillValue = true;
                } else {
                    this.hasFillValue = false;
                }
            }
            if (debug1) {
                H5header.this.debugOut.println(this);
            }
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   FillValue version= ").append(this.version).append(" spaceAllocateTime = ").append(this.spaceAllocateTime).append(" fillWriteTime=").append(this.fillWriteTime).append(" hasFillValue= ").append(this.hasFillValue);
            sbuff.append("\n size = ").append(this.size).append(" value=");
            for (int i = 0; i < this.size; ++i) {
                sbuff.append(" ").append(this.value[i]);
            }
            return sbuff.toString();
        }

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                sbuff.append(" ").append(this.value[i]);
            }
            return sbuff.toString();
        }
    }

    private class MessageFillValueOld
    implements Named {
        byte[] value;
        int size;

        private MessageFillValueOld() {
        }

        void read() throws IOException {
            this.size = H5header.this.raf.readInt();
            this.value = new byte[this.size];
            H5header.this.raf.read(this.value);
            if (debug1) {
                H5header.this.debugOut.println(this);
            }
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   FillValueOld size= ").append(this.size).append(" value=");
            for (int i = 0; i < this.size; ++i) {
                sbuff.append(" ").append(this.value[i]);
            }
            return sbuff.toString();
        }

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                sbuff.append(" ").append(this.value[i]);
            }
            return sbuff.toString();
        }
    }

    private class StructureMember {
        String name;
        int offset;
        byte dims;
        MessageDatatype mdt;

        StructureMember(int version, int byteSize) throws IOException {
            if (debugPos) {
                H5header.this.debugOut.println("   *StructureMember now at position=" + H5header.this.raf.getFilePointer());
            }
            this.name = H5header.this.readString(H5header.this.raf);
            if (version < 3) {
                H5header.this.raf.skipBytes(H5header.this.padding(this.name.length() + 1, 8));
                this.offset = H5header.this.raf.readInt();
            } else {
                this.offset = (int)H5header.this.readVariableSizeMax(byteSize);
            }
            if (debug1) {
                H5header.this.debugOut.println("   Member name=" + this.name + " offset= " + this.offset);
            }
            if (version == 1) {
                this.dims = H5header.this.raf.readByte();
                H5header.this.raf.skipBytes(3);
                H5header.this.raf.skipBytes(24);
            }
            this.mdt = new MessageDatatype();
            this.mdt.read(this.name);
            if (debugDetail) {
                H5header.this.debugOut.println("   ***End Member name=" + this.name);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StructureMember");
            sb.append("{name='").append(this.name).append('\'');
            sb.append(", offset=").append(this.offset);
            sb.append(", dims=").append(this.dims);
            sb.append(", mdt=").append(this.mdt);
            sb.append('}');
            return sb.toString();
        }
    }

    public class MessageDatatype
    implements Named {
        int type;
        int version;
        byte[] flags = new byte[3];
        int byteSize;
        int endian;
        boolean isOK = true;
        boolean unsigned;
        DataType timeType;
        String opaque_desc;
        List<StructureMember> members;
        int referenceType;
        Map<Integer, String> map;
        String enumTypeName;
        MessageDatatype base;
        boolean isVString;
        int[] dim;

        public String toString() {
            Formatter f = new Formatter();
            f.format(" datatype= %d", this.type);
            f.format(" byteSize= %d", this.byteSize);
            DataType dtype = H5header.this.getNCtype(this.type, this.byteSize);
            f.format(" NCtype= %s", new Object[]{dtype});
            f.format(" flags= ", new Object[0]);
            for (int i = 0; i < 3; ++i) {
                f.format(" %d", this.flags[i]);
            }
            f.format(" endian= %s", this.endian == 0 ? "BIG" : "LITTLE");
            if (this.type == 2) {
                f.format(" timeType= %s", new Object[]{this.timeType});
            } else if (this.type == 6) {
                f.format("%n  members%n", new Object[0]);
                for (StructureMember mm : this.members) {
                    f.format("   %s%n", mm);
                }
            } else if (this.type == 7) {
                f.format(" referenceType= %s", this.referenceType);
            } else if (this.type == 9) {
                f.format(" isVString= %s", this.isVString);
            }
            if (this.type == 9 || this.type == 10) {
                f.format(" parent base= {%s}", this.base);
            }
            return f.toString();
        }

        @Override
        public String getName() {
            DataType dtype = H5header.this.getNCtype(this.type, this.byteSize);
            if (dtype != null) {
                return dtype.toString() + " size= " + this.byteSize;
            }
            return "type=" + Integer.toString(this.type) + " size= " + this.byteSize;
        }

        public String getType() {
            DataType dtype = H5header.this.getNCtype(this.type, this.byteSize);
            if (dtype != null) {
                return dtype.toString();
            }
            return "type=" + Integer.toString(this.type) + " size= " + this.byteSize;
        }

        void read(String objectName) throws IOException {
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageDatatype start pos= " + H5header.this.raf.getFilePointer());
            }
            byte tandv = H5header.this.raf.readByte();
            this.type = tandv & 0xF;
            this.version = (tandv & 0xF0) >> 4;
            H5header.this.raf.read(this.flags);
            this.byteSize = H5header.this.raf.readInt();
            int n = this.endian = (this.flags[0] & 1) == 0 ? 1 : 0;
            if (debug1) {
                H5header.this.debugOut.println("   Datatype type=" + this.type + " version= " + this.version + " flags = " + this.flags[0] + " " + this.flags[1] + " " + this.flags[2] + " byteSize=" + this.byteSize + " byteOrder=" + (this.endian == 0 ? "BIG" : "LITTLE"));
            }
            if (this.type == 0) {
                this.unsigned = (this.flags[0] & 8) == 0;
                short bitOffset = H5header.this.raf.readShort();
                short bitPrecision = H5header.this.raf.readShort();
                if (debug1) {
                    H5header.this.debugOut.println("   type 0 (fixed point): bitOffset= " + bitOffset + " bitPrecision= " + bitPrecision + " unsigned= " + this.unsigned);
                }
                this.isOK = bitOffset == 0 && bitPrecision % 8 == 0;
            } else if (this.type == 1) {
                short bitOffset = H5header.this.raf.readShort();
                short bitPrecision = H5header.this.raf.readShort();
                byte expLocation = H5header.this.raf.readByte();
                byte expSize = H5header.this.raf.readByte();
                byte manLocation = H5header.this.raf.readByte();
                byte manSize = H5header.this.raf.readByte();
                int expBias = H5header.this.raf.readInt();
                if (debug1) {
                    H5header.this.debugOut.println("   type 1 (floating point): bitOffset= " + bitOffset + " bitPrecision= " + bitPrecision + " expLocation= " + expLocation + " expSize= " + expSize + " manLocation= " + manLocation + " manSize= " + manSize + " expBias= " + expBias);
                }
            } else if (this.type == 2) {
                short bitPrecision = H5header.this.raf.readShort();
                if (bitPrecision == 16) {
                    this.timeType = DataType.SHORT;
                } else if (bitPrecision == 32) {
                    this.timeType = DataType.INT;
                } else if (bitPrecision == 64) {
                    this.timeType = DataType.LONG;
                }
                if (debug1) {
                    H5header.this.debugOut.println("   type 2 (time): bitPrecision= " + bitPrecision + " timeType = " + (Object)((Object)this.timeType));
                }
            } else if (this.type == 3) {
                int ptype = this.flags[0] & 0xF;
                if (debug1) {
                    H5header.this.debugOut.println("   type 3 (String): pad type= " + ptype);
                }
            } else if (this.type == 4) {
                short bitOffset = H5header.this.raf.readShort();
                short bitPrecision = H5header.this.raf.readShort();
                if (debug1) {
                    H5header.this.debugOut.println("   type 4 (bit field): bitOffset= " + bitOffset + " bitPrecision= " + bitPrecision);
                }
            } else if (this.type == 5) {
                byte len = this.flags[0];
                String string = this.opaque_desc = len > 0 ? H5header.this.readString(H5header.this.raf).trim() : null;
                if (debug1) {
                    H5header.this.debugOut.println("   type 5 (opaque): len= " + len + " desc= " + this.opaque_desc);
                }
            } else if (this.type == 6) {
                int nmembers = H5header.this.makeUnsignedIntFromBytes(this.flags[1], this.flags[0]);
                if (debug1) {
                    H5header.this.debugOut.println("   --type 6(compound): nmembers=" + nmembers);
                }
                this.members = new ArrayList<StructureMember>();
                for (int i = 0; i < nmembers; ++i) {
                    this.members.add(new StructureMember(this.version, this.byteSize));
                }
                if (debugDetail) {
                    H5header.this.debugOut.println("   --done with compound type");
                }
            } else if (this.type == 7) {
                this.referenceType = this.flags[0] & 0xF;
                if (debug1 || debugReference) {
                    H5header.this.debugOut.println("   --type 7(reference): type= " + this.referenceType);
                }
            } else if (this.type == 8) {
                int i;
                int nmembers = H5header.this.makeUnsignedIntFromBytes(this.flags[1], this.flags[0]);
                boolean saveDebugDetail = debugDetail;
                if (debug1 || debugEnum) {
                    H5header.this.debugOut.println("   --type 8(enums): nmembers=" + nmembers);
                    debugDetail = true;
                }
                this.base = new MessageDatatype();
                this.base.read(objectName);
                debugDetail = saveDebugDetail;
                String[] enumName = new String[nmembers];
                for (int i2 = 0; i2 < nmembers; ++i2) {
                    enumName[i2] = this.version < 3 ? H5header.this.readString8(H5header.this.raf) : H5header.this.readString(H5header.this.raf);
                }
                if (this.base.endian >= 0) {
                    H5header.this.raf.order(this.base.endian);
                }
                int[] enumValue = new int[nmembers];
                for (i = 0; i < nmembers; ++i) {
                    enumValue[i] = (int)H5header.this.readVariableSizeUnsigned(this.base.byteSize);
                }
                H5header.this.raf.order(1);
                this.enumTypeName = objectName;
                this.map = new TreeMap<Integer, String>();
                for (i = 0; i < nmembers; ++i) {
                    this.map.put(enumValue[i], enumName[i]);
                }
                if (debugEnum) {
                    for (i = 0; i < nmembers; ++i) {
                        H5header.this.debugOut.println("   " + enumValue[i] + "=" + enumName[i]);
                    }
                }
            } else if (this.type == 9) {
                boolean bl = this.isVString = (this.flags[0] & 0xF) == 1;
                if (debug1) {
                    H5header.this.debugOut.println("   type 9(variable length): type= " + (this.isVString ? "string" : "sequence of type:"));
                }
                this.base = new MessageDatatype();
                this.base.read(objectName);
            } else if (this.type == 10) {
                if (debug1) {
                    H5header.this.debugOut.print("   type 10(array) lengths= ");
                }
                int ndims = H5header.this.raf.readByte();
                if (this.version < 3) {
                    H5header.this.raf.skipBytes(3);
                }
                this.dim = new int[ndims];
                for (int i = 0; i < ndims; ++i) {
                    this.dim[i] = H5header.this.raf.readInt();
                    if (!debug1) continue;
                    H5header.this.debugOut.print(" " + this.dim[i]);
                }
                if (this.version < 3) {
                    int[] pdim = new int[ndims];
                    for (int i = 0; i < ndims; ++i) {
                        pdim[i] = H5header.this.raf.readInt();
                    }
                }
                if (debug1) {
                    H5header.this.debugOut.println();
                }
                this.base = new MessageDatatype();
                this.base.read(objectName);
            } else if (warnings) {
                H5header.this.debugOut.println(" WARNING not dealing with type= " + this.type);
            }
        }

        int getBaseType() {
            return this.base != null ? this.base.getBaseType() : this.type;
        }

        int getBaseSize() {
            return this.base != null ? this.base.getBaseSize() : this.byteSize;
        }

        byte[] getFlags() {
            return this.base != null ? this.base.getFlags() : this.flags;
        }
    }

    private class MessageLink
    implements Named {
        byte version;
        byte flags;
        byte encoding;
        byte linkType;
        long creationOrder;
        String linkName;
        String link;
        long linkAddress;

        private MessageLink() {
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   MessageLink ");
            sbuff.append(" name=").append(this.linkName).append(" type=").append(this.linkType);
            if (this.linkType == 0) {
                sbuff.append(" linkAddress=" + this.linkAddress);
            } else {
                sbuff.append(" link=").append(this.link);
            }
            if ((this.flags & 4) != 0) {
                sbuff.append(" creationOrder=" + this.creationOrder);
            }
            if ((this.flags & 0x10) != 0) {
                sbuff.append(" encoding=" + this.encoding);
            }
            return sbuff.toString();
        }

        void read() throws IOException {
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageLink start pos= " + H5header.this.raf.getFilePointer());
            }
            this.version = H5header.this.raf.readByte();
            this.flags = H5header.this.raf.readByte();
            if ((this.flags & 8) != 0) {
                this.linkType = H5header.this.raf.readByte();
            }
            if ((this.flags & 4) != 0) {
                this.creationOrder = H5header.this.raf.readLong();
            }
            if ((this.flags & 0x10) != 0) {
                this.encoding = H5header.this.raf.readByte();
            }
            int linkNameLength = (int)H5header.this.readVariableSizeFactor(this.flags & 3);
            this.linkName = H5header.this.readStringFixedLength(linkNameLength);
            if (this.linkType == 0) {
                this.linkAddress = H5header.this.readOffset();
            } else if (this.linkType == 1) {
                short len = H5header.this.raf.readShort();
                this.link = H5header.this.readStringFixedLength(len);
            } else if (this.linkType == 64) {
                short len = H5header.this.raf.readShort();
                this.link = H5header.this.readStringFixedLength(len);
            }
            if (debug1) {
                H5header.this.debugOut.println("   MessageLink version= " + this.version + " flags = " + Integer.toBinaryString(this.flags) + this);
            }
        }

        @Override
        public String getName() {
            return this.linkName;
        }
    }

    private class MessageGroupInfo
    implements Named {
        byte flags;
        short maxCompactValue = (short)-1;
        short minDenseValue = (short)-1;
        short estNumEntries = (short)-1;
        short estLengthEntryName = (short)-1;

        private MessageGroupInfo() {
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("   MessageGroupInfo ");
            if ((this.flags & 1) != 0) {
                sbuff.append(" maxCompactValue=").append(this.maxCompactValue).append(" minDenseValue=").append(this.minDenseValue);
            }
            if ((this.flags & 2) != 0) {
                sbuff.append(" estNumEntries=").append(this.estNumEntries).append(" estLengthEntryName=").append(this.estLengthEntryName);
            }
            return sbuff.toString();
        }

        void read() throws IOException {
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageGroupInfo start pos= " + H5header.this.raf.getFilePointer());
            }
            byte version = H5header.this.raf.readByte();
            this.flags = H5header.this.raf.readByte();
            if ((this.flags & 1) != 0) {
                this.maxCompactValue = H5header.this.raf.readShort();
                this.minDenseValue = H5header.this.raf.readShort();
            }
            if ((this.flags & 2) != 0) {
                this.estNumEntries = H5header.this.raf.readShort();
                this.estLengthEntryName = H5header.this.raf.readShort();
            }
            if (debug1) {
                H5header.this.debugOut.println("   MessageGroupInfo version= " + version + " flags = " + this.flags + this);
            }
        }

        @Override
        public String getName() {
            return "";
        }
    }

    private class MessageGroupNew
    implements Named {
        byte version;
        byte flags;
        long maxCreationIndex = -2L;
        long fractalHeapAddress;
        long v2BtreeAddress;
        long v2BtreeAddressCreationOrder = -2L;

        private MessageGroupNew() {
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("   GroupNew fractalHeapAddress=%d v2BtreeAddress=%d ", this.fractalHeapAddress, this.v2BtreeAddress);
            if (this.v2BtreeAddressCreationOrder > -2L) {
                f.format(" v2BtreeAddressCreationOrder=%d ", this.v2BtreeAddressCreationOrder);
            }
            if (this.maxCreationIndex > -2L) {
                f.format(" maxCreationIndex=%d", this.maxCreationIndex);
            }
            f.format(" %n%n", new Object[0]);
            if (this.fractalHeapAddress > 0L) {
                try {
                    f.format("\n\n", new Object[0]);
                    FractalHeap fractalHeap = new FractalHeap(H5header.this, "", this.fractalHeapAddress);
                    fractalHeap.showDetails(f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return f.toString();
        }

        void read() throws IOException {
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageGroupNew start pos= " + H5header.this.raf.getFilePointer());
            }
            byte version = H5header.this.raf.readByte();
            byte flags = H5header.this.raf.readByte();
            if ((flags & 1) != 0) {
                this.maxCreationIndex = H5header.this.raf.readLong();
            }
            this.fractalHeapAddress = H5header.this.readOffset();
            this.v2BtreeAddress = H5header.this.readOffset();
            if ((flags & 2) != 0) {
                this.v2BtreeAddressCreationOrder = H5header.this.readOffset();
            }
            if (debug1) {
                H5header.this.debugOut.println("   MessageGroupNew version= " + version + " flags = " + flags + this);
            }
        }

        @Override
        public String getName() {
            return Long.toString(this.fractalHeapAddress);
        }
    }

    private class MessageGroup
    implements Named {
        long btreeAddress;
        long nameHeapAddress;

        private MessageGroup() {
        }

        void read() throws IOException {
            this.btreeAddress = H5header.this.readOffset();
            this.nameHeapAddress = H5header.this.readOffset();
            if (debug1) {
                H5header.this.debugOut.println("   Group btreeAddress=" + this.btreeAddress + " nameHeapAddress=" + this.nameHeapAddress);
            }
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append(" btreeAddress=").append(this.btreeAddress);
            sbuff.append(" nameHeapAddress=").append(this.nameHeapAddress);
            return sbuff.toString();
        }

        @Override
        public String getName() {
            return Long.toString(this.btreeAddress);
        }
    }

    public class MessageDataspace
    implements Named {
        byte ndims;
        byte flags;
        byte type;
        int[] dimLength;
        int[] maxLength;

        @Override
        public String getName() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("(");
            for (int size : this.dimLength) {
                sbuff.append(size).append(",");
            }
            sbuff.append(")");
            return sbuff.toString();
        }

        public String toString() {
            Formatter sbuff = new Formatter();
            sbuff.format(" ndims=%d flags=%x type=%d ", this.ndims, this.flags, this.type);
            sbuff.format(" length=(", new Object[0]);
            for (int size : this.dimLength) {
                sbuff.format("%d,", size);
            }
            sbuff.format(") max=(", new Object[0]);
            for (int aMaxLength : this.maxLength) {
                sbuff.format("%d,", aMaxLength);
            }
            sbuff.format(")", new Object[0]);
            return sbuff.toString();
        }

        void read() throws IOException {
            int i;
            byte version;
            if (debugPos) {
                H5header.this.debugOut.println("   *MessageSimpleDataspace start pos= " + H5header.this.raf.getFilePointer());
            }
            if ((version = H5header.this.raf.readByte()) == 1) {
                this.ndims = H5header.this.raf.readByte();
                this.flags = H5header.this.raf.readByte();
                this.type = (byte)(this.ndims != 0 ? 1 : 0);
                H5header.this.raf.skipBytes(5);
            } else if (version == 2) {
                this.ndims = H5header.this.raf.readByte();
                this.flags = H5header.this.raf.readByte();
                this.type = H5header.this.raf.readByte();
            } else {
                throw new IllegalStateException("MessageDataspace: unknown version= " + version);
            }
            if (debug1) {
                H5header.this.debugOut.println("   SimpleDataspace version= " + version + " flags=" + Integer.toBinaryString(this.flags) + " ndims=" + this.ndims + " type=" + this.type);
            }
            this.dimLength = new int[this.ndims];
            for (int i2 = 0; i2 < this.ndims; ++i2) {
                this.dimLength[i2] = (int)H5header.this.readLength();
            }
            boolean hasMax = (this.flags & 1) != 0;
            this.maxLength = new int[this.ndims];
            if (hasMax) {
                for (i = 0; i < this.ndims; ++i) {
                    this.maxLength[i] = (int)H5header.this.readLength();
                }
            } else {
                System.arraycopy(this.dimLength, 0, this.maxLength, 0, this.ndims);
            }
            if (debug1) {
                for (i = 0; i < this.ndims; ++i) {
                    H5header.this.debugOut.println("    dim length = " + this.dimLength[i] + " max = " + this.maxLength[i]);
                }
            }
        }
    }

    static interface Named {
        public String getName();
    }

    public class HeaderMessage
    implements Comparable {
        long start;
        byte headerMessageFlags;
        int size;
        short type;
        short header_length;
        Named messData;
        MessageType mtype;
        short creationOrder = (short)-1;

        public MessageType getMtype() {
            return this.mtype;
        }

        public String getName() {
            return this.messData.getName();
        }

        public int getSize() {
            return this.size;
        }

        public short getType() {
            return this.type;
        }

        public byte getFlags() {
            return this.headerMessageFlags;
        }

        public long getStart() {
            return this.start;
        }

        int read(long filePos, int version, boolean creationOrderPresent, String objectName) throws IOException {
            this.start = filePos;
            H5header.this.raf.seek(filePos);
            if (debugPos) {
                H5header.this.debugOut.println("  --> Message Header starts at =" + H5header.this.raf.getFilePointer());
            }
            if (version == 1) {
                this.type = H5header.this.raf.readShort();
                this.size = DataType.unsignedShortToInt(H5header.this.raf.readShort());
                this.headerMessageFlags = H5header.this.raf.readByte();
                H5header.this.raf.skipBytes(3);
                this.header_length = (short)8;
            } else {
                this.type = H5header.this.raf.readByte();
                this.size = DataType.unsignedShortToInt(H5header.this.raf.readShort());
                this.headerMessageFlags = H5header.this.raf.readByte();
                this.header_length = (short)4;
                if (creationOrderPresent) {
                    this.creationOrder = H5header.this.raf.readShort();
                    this.header_length = (short)(this.header_length + 2);
                }
            }
            this.mtype = MessageType.getType(this.type);
            if (debug1) {
                H5header.this.debugOut.println("  -->" + this.mtype + " messageSize=" + this.size + " flags = " + Integer.toBinaryString(this.headerMessageFlags));
                if (creationOrderPresent && debugCreationOrder) {
                    H5header.this.debugOut.println("     creationOrder = " + this.creationOrder);
                }
            }
            if (debugPos) {
                H5header.this.debugOut.println("  --> Message Data starts at=" + H5header.this.raf.getFilePointer());
            }
            if ((this.headerMessageFlags & 2) != 0) {
                this.messData = ((H5header)H5header.this).getSharedDataObject((MessageType)this.mtype).mdt;
                return this.header_length + this.size;
            }
            if (this.mtype != MessageType.NIL) {
                if (this.mtype == MessageType.SimpleDataspace) {
                    MessageDataspace data = new MessageDataspace();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.GroupNew) {
                    MessageGroupNew data = new MessageGroupNew();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Datatype) {
                    MessageDatatype data = new MessageDatatype();
                    data.read(objectName);
                    this.messData = data;
                } else if (this.mtype == MessageType.FillValueOld) {
                    MessageFillValueOld data = new MessageFillValueOld();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.FillValue) {
                    MessageFillValue data = new MessageFillValue();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Link) {
                    MessageLink data = new MessageLink();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Layout) {
                    MessageLayout data = new MessageLayout();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.GroupInfo) {
                    MessageGroupInfo data = new MessageGroupInfo();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.FilterPipeline) {
                    MessageFilter data = new MessageFilter();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Attribute) {
                    MessageAttribute data = new MessageAttribute();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Comment) {
                    MessageComment data = new MessageComment();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.LastModifiedOld) {
                    MessageLastModifiedOld data = new MessageLastModifiedOld();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.ObjectHeaderContinuation) {
                    MessageContinue data = new MessageContinue();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.Group) {
                    MessageGroup data = new MessageGroup();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.LastModified) {
                    MessageLastModified data = new MessageLastModified();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.AttributeInfo) {
                    MessageAttributeInfo data = new MessageAttributeInfo();
                    data.read();
                    this.messData = data;
                } else if (this.mtype == MessageType.ObjectReferenceCount) {
                    MessageObjectReferenceCount data = new MessageObjectReferenceCount();
                    data.read();
                    this.messData = data;
                } else {
                    H5header.this.debugOut.println("****UNPROCESSED MESSAGE type = " + this.mtype + " raw = " + this.type);
                    throw new UnsupportedOperationException("****UNPROCESSED MESSAGE type = " + this.mtype + " raw = " + this.type);
                }
            }
            return this.header_length + this.size;
        }

        public int compareTo(Object o) {
            return this.type - ((HeaderMessage)o).type;
        }

        public String toString() {
            return "message type = " + this.mtype + "; " + this.messData;
        }

        public void showFractalHeap(Formatter f) {
            if (this.mtype != MessageType.AttributeInfo) {
                f.format("No fractal heap", new Object[0]);
                return;
            }
            MessageAttributeInfo info = (MessageAttributeInfo)this.messData;
            info.showFractalHeap(f);
        }

        public void showCompression(Formatter f) {
            if (this.mtype != MessageType.AttributeInfo) {
                f.format("No fractal heap", new Object[0]);
                return;
            }
            MessageAttributeInfo info = (MessageAttributeInfo)this.messData;
            info.showFractalHeap(f);
        }
    }

    public static class MessageType {
        private static int MAX_MESSAGE = 23;
        private static Map<String, MessageType> hash = new HashMap<String, MessageType>(10);
        private static MessageType[] mess = new MessageType[MAX_MESSAGE];
        public static final MessageType NIL = new MessageType("NIL", 0);
        public static final MessageType SimpleDataspace = new MessageType("SimpleDataspace", 1);
        public static final MessageType GroupNew = new MessageType("GroupNew", 2);
        public static final MessageType Datatype = new MessageType("Datatype", 3);
        public static final MessageType FillValueOld = new MessageType("FillValueOld", 4);
        public static final MessageType FillValue = new MessageType("FillValue", 5);
        public static final MessageType Link = new MessageType("Link", 6);
        public static final MessageType ExternalDataFiles = new MessageType("ExternalDataFiles", 7);
        public static final MessageType Layout = new MessageType("Layout", 8);
        public static final MessageType GroupInfo = new MessageType("GroupInfo", 10);
        public static final MessageType FilterPipeline = new MessageType("FilterPipeline", 11);
        public static final MessageType Attribute = new MessageType("Attribute", 12);
        public static final MessageType Comment = new MessageType("Comment", 13);
        public static final MessageType LastModifiedOld = new MessageType("LastModifiedOld", 14);
        public static final MessageType SharedObject = new MessageType("SharedObject", 15);
        public static final MessageType ObjectHeaderContinuation = new MessageType("ObjectHeaderContinuation", 16);
        public static final MessageType Group = new MessageType("Group", 17);
        public static final MessageType LastModified = new MessageType("LastModified", 18);
        public static final MessageType AttributeInfo = new MessageType("AttributeInfo", 21);
        public static final MessageType ObjectReferenceCount = new MessageType("ObjectReferenceCount", 22);
        private String name;
        private int num;

        private MessageType(String name, int num) {
            this.name = name;
            this.num = num;
            hash.put(name, this);
            MessageType.mess[num] = this;
        }

        public static MessageType getType(String name) {
            if (name == null) {
                return null;
            }
            return hash.get(name);
        }

        public static MessageType getType(int num) {
            if (num < 0 || num >= MAX_MESSAGE) {
                return null;
            }
            return mess[num];
        }

        public String toString() {
            return this.name + "(" + this.num + ")";
        }

        public int getNum() {
            return this.num;
        }
    }

    public class DataObject
    implements Named {
        long address;
        String who;
        List<HeaderMessage> messages = new ArrayList<HeaderMessage>();
        List<MessageAttribute> attributes = new ArrayList<MessageAttribute>();
        MessageGroup groupMessage = null;
        MessageGroupNew groupNewMessage = null;
        MessageDatatype mdt = null;
        MessageDataspace mds = null;
        MessageLayout msl = null;
        MessageFilter mfp = null;
        byte version;

        public long getAddress() {
            return this.address;
        }

        @Override
        public String getName() {
            return this.who;
        }

        public List<HeaderMessage> getMessages() {
            ArrayList<HeaderMessage> result = new ArrayList<HeaderMessage>(100);
            for (HeaderMessage m : this.messages) {
                if (m.messData instanceof MessageAttribute) continue;
                result.add(m);
            }
            return result;
        }

        public List<MessageAttribute> getAttributes() {
            return this.attributes;
        }

        public void show(Formatter f) throws IOException {
            if (this.mdt != null) {
                f.format("%s ", this.mdt.getType());
            }
            f.format("%s", this.getName());
            if (this.mds != null) {
                f.format("(", new Object[0]);
                for (int len : this.mds.dimLength) {
                    f.format("%d,", len);
                }
                f.format(");%n", new Object[0]);
            }
            for (MessageAttribute mess : this.getAttributes()) {
                Attribute att = mess.getNcAttribute();
                f.format("  :%s%n", att);
            }
            f.format("%n", new Object[0]);
        }

        private DataObject(long address, String who) throws IOException {
            this.address = address;
            this.who = who;
            if (debug1) {
                H5header.this.debugOut.println("\n--> DataObject.read parsing <" + who + "> object ID/address=" + address);
            }
            if (debugPos) {
                H5header.this.debugOut.println("      DataObject.read now at position=" + H5header.this.raf.getFilePointer() + " for <" + who + "> reposition to " + H5header.this.getFileOffset(address));
            }
            H5header.this.raf.seek(H5header.this.getFileOffset(address));
            this.version = H5header.this.raf.readByte();
            if (this.version == 1) {
                H5header.this.raf.readByte();
                short nmess = H5header.this.raf.readShort();
                if (debugDetail) {
                    H5header.this.debugOut.println(" version=" + this.version + " nmess=" + nmess);
                }
                int referenceCount = H5header.this.raf.readInt();
                int headerSize = H5header.this.raf.readInt();
                if (debugDetail) {
                    H5header.this.debugOut.println(" referenceCount=" + referenceCount + " headerSize=" + headerSize);
                }
                H5header.this.raf.skipBytes(4);
                long posMess = H5header.this.raf.getFilePointer();
                int count = this.readMessagesVersion1(posMess, nmess, Integer.MAX_VALUE, this.who);
                if (debugContinueMessage) {
                    H5header.this.debugOut.println(" nmessages read = " + count);
                }
                if (debugPos) {
                    H5header.this.debugOut.println("<--done reading messages for <" + who + ">; position=" + H5header.this.raf.getFilePointer());
                }
                if (debugTracker) {
                    H5header.this.memTracker.addByLen("Object " + who, H5header.this.getFileOffset(address), headerSize + 16);
                }
            } else {
                byte[] name = new byte[3];
                H5header.this.raf.read(name);
                String magic = new String(name);
                if (!magic.equals("HDR")) {
                    throw new IllegalStateException("DataObject doesnt start with OHDR");
                }
                this.version = H5header.this.raf.readByte();
                byte flags = H5header.this.raf.readByte();
                if (debugDetail) {
                    H5header.this.debugOut.println(" version=" + this.version + " flags=" + Integer.toBinaryString(flags));
                }
                if ((flags >> 5 & 1) == 1) {
                    int accessTime = H5header.this.raf.readInt();
                    int modTime = H5header.this.raf.readInt();
                    int changeTime = H5header.this.raf.readInt();
                    int birthTime = H5header.this.raf.readInt();
                }
                if ((flags >> 4 & 1) == 1) {
                    short maxCompactAttributes = H5header.this.raf.readShort();
                    short minDenseAttributes = H5header.this.raf.readShort();
                }
                long sizeOfChunk = H5header.this.readVariableSizeFactor(flags & 3);
                if (debugDetail) {
                    H5header.this.debugOut.println(" sizeOfChunk=" + sizeOfChunk);
                }
                long posMess = H5header.this.raf.getFilePointer();
                int count = this.readMessagesVersion2(posMess, sizeOfChunk, (flags & 4) != 0, this.who);
                if (debugContinueMessage) {
                    H5header.this.debugOut.println(" nmessages read = " + count);
                }
                if (debugPos) {
                    H5header.this.debugOut.println("<--done reading messages for <" + who + ">; position=" + H5header.this.raf.getFilePointer());
                }
            }
            for (HeaderMessage mess : this.messages) {
                if (debugTracker) {
                    H5header.this.memTracker.addByLen("Message (" + who + ") " + mess.mtype, mess.start, mess.size + 8);
                }
                if (mess.mtype == MessageType.Group) {
                    this.groupMessage = (MessageGroup)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.GroupNew) {
                    this.groupNewMessage = (MessageGroupNew)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.SimpleDataspace) {
                    this.mds = (MessageDataspace)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.Datatype) {
                    this.mdt = (MessageDatatype)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.Layout) {
                    this.msl = (MessageLayout)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.Group) {
                    this.groupMessage = (MessageGroup)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.FilterPipeline) {
                    this.mfp = (MessageFilter)mess.messData;
                    continue;
                }
                if (mess.mtype == MessageType.Attribute) {
                    this.attributes.add((MessageAttribute)mess.messData);
                    continue;
                }
                if (mess.mtype != MessageType.AttributeInfo) continue;
                this.processAttributeInfoMessage((MessageAttributeInfo)mess.messData, this.attributes);
            }
            if (debug1) {
                H5header.this.debugOut.println("<-- end DataObject " + who);
            }
        }

        private void processAttributeInfoMessage(MessageAttributeInfo attInfo, List<MessageAttribute> list) throws IOException {
            long btreeAddress;
            long l = btreeAddress = attInfo.v2BtreeAddressCreationOrder > 0L ? attInfo.v2BtreeAddressCreationOrder : attInfo.v2BtreeAddress;
            if (btreeAddress < 0L || attInfo.fractalHeapAddress < 0L) {
                return;
            }
            BTree2 btree = new BTree2(H5header.this, this.who, btreeAddress);
            FractalHeap fractalHeap = new FractalHeap(H5header.this, this.who, attInfo.fractalHeapAddress);
            block4: for (BTree2.Entry2 e : btree.entryList) {
                long pos;
                byte[] heapId = null;
                switch (btree.btreeType) {
                    case 8: {
                        heapId = ((BTree2.Record8)e.record).heapId;
                        break;
                    }
                    case 9: {
                        heapId = ((BTree2.Record9)e.record).heapId;
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                if ((pos = fractalHeap.getHeapId(heapId).getPos()) <= 0L) continue;
                H5header.this.raf.seek(pos);
                MessageAttribute attMessage = new MessageAttribute();
                if (attMessage.read()) {
                    list.add(attMessage);
                }
                if (!debugBtree2) continue;
                System.out.println("    attMessage=" + attMessage);
            }
        }

        private int readMessagesVersion1(long pos, int maxMess, int maxBytes, String objectName) throws IOException {
            if (debugContinueMessage) {
                H5header.this.debugOut.println(" readMessages start at =" + pos + " maxMess= " + maxMess + " maxBytes= " + maxBytes);
            }
            int count = 0;
            int bytesRead = 0;
            while (count < maxMess && bytesRead < maxBytes) {
                HeaderMessage mess = new HeaderMessage();
                int n = mess.read(pos, 1, false, objectName);
                pos += (long)n;
                bytesRead += n;
                ++count;
                if (debugContinueMessage) {
                    H5header.this.debugOut.println("   count=" + count + " bytesRead=" + bytesRead);
                }
                if (mess.mtype == MessageType.ObjectHeaderContinuation) {
                    MessageContinue c = (MessageContinue)mess.messData;
                    if (debugContinueMessage) {
                        H5header.this.debugOut.println(" ---ObjectHeaderContinuation--- ");
                    }
                    count += this.readMessagesVersion1(H5header.this.getFileOffset(c.offset), maxMess - count, (int)c.length, objectName);
                    if (!debugContinueMessage) continue;
                    H5header.this.debugOut.println(" ---ObjectHeaderContinuation return --- ");
                    continue;
                }
                if (mess.mtype == MessageType.NIL) continue;
                this.messages.add(mess);
            }
            return count;
        }

        private int readMessagesVersion2(long filePos, long maxBytes, boolean creationOrderPresent, String objectName) throws IOException {
            if (debugContinueMessage) {
                H5header.this.debugOut.println(" readMessages2 starts at =" + filePos + " maxBytes= " + maxBytes);
            }
            maxBytes -= 3L;
            int count = 0;
            int bytesRead = 0;
            while ((long)bytesRead < maxBytes) {
                HeaderMessage mess = new HeaderMessage();
                int n = mess.read(filePos, 2, creationOrderPresent, objectName);
                filePos += (long)n;
                bytesRead += n;
                ++count;
                if (debugContinueMessage) {
                    H5header.this.debugOut.println("   mess size=" + n + " bytesRead=" + bytesRead + " maxBytes=" + maxBytes);
                }
                if (mess.mtype == MessageType.ObjectHeaderContinuation) {
                    MessageContinue c = (MessageContinue)mess.messData;
                    long continuationBlockFilePos = H5header.this.getFileOffset(c.offset);
                    if (debugContinueMessage) {
                        H5header.this.debugOut.println(" ---ObjectHeaderContinuation filePos= " + continuationBlockFilePos);
                    }
                    H5header.this.raf.seek(continuationBlockFilePos);
                    String sig = H5header.this.readStringFixedLength(4);
                    if (!sig.equals("OCHK")) {
                        throw new IllegalStateException(" ObjectHeaderContinuation Missing signature");
                    }
                    count += this.readMessagesVersion2(continuationBlockFilePos + 4L, (int)c.length - 8, creationOrderPresent, objectName);
                    if (debugContinueMessage) {
                        H5header.this.debugOut.println(" ---ObjectHeaderContinuation return --- ");
                    }
                    if (!debugContinueMessage) continue;
                    H5header.this.debugOut.println("   continuationMessages =" + count + " bytesRead=" + bytesRead + " maxBytes=" + maxBytes);
                    continue;
                }
                if (mess.mtype == MessageType.NIL) continue;
                this.messages.add(mess);
            }
            return count;
        }
    }

    private class H5Group {
        H5Group parent;
        String name;
        String displayName;
        DataObjectFacade facade;
        List<DataObjectFacade> nestedObjects = new ArrayList<DataObjectFacade>();
        Map<String, Dimension> dimMap = new HashMap<String, Dimension>();
        List<Dimension> dimList = new ArrayList<Dimension>();

        private H5Group(DataObjectFacade facade) throws IOException {
            this.facade = facade;
            this.parent = facade.parent;
            this.name = facade.name;
            String string = this.displayName = this.name.length() == 0 ? "root" : this.name;
            if (facade.dobj.groupMessage != null) {
                H5header.this.readGroupOld(this, facade.dobj.groupMessage.btreeAddress, facade.dobj.groupMessage.nameHeapAddress);
            } else if (facade.dobj.groupNewMessage != null) {
                H5header.this.readGroupNew(this, facade.dobj.groupNewMessage, facade.dobj);
            } else {
                throw new IllegalStateException("H5Group needs group messages " + facade.getName());
            }
            facade.group = this;
        }

        String getName() {
            return this.parent == null ? this.name : this.parent.getName() + "/" + this.name;
        }

        boolean isChildOf(H5Group that) {
            if (this.parent == null) {
                return false;
            }
            if (this.parent == that) {
                return true;
            }
            return this.parent.isChildOf(that);
        }
    }

    private class DataObjectFacade {
        H5Group parent;
        String name;
        String displayName;
        DataObject dobj;
        boolean isGroup;
        boolean isVariable;
        boolean isTypedef;
        boolean isDimensionNotVariable;
        H5Group group;
        String dimList;
        String linkName = null;
        Attribute netcdf4CoordinatesAtt;

        DataObjectFacade(H5Group parent, String name, String linkName) {
            this.parent = parent;
            this.name = name;
            this.linkName = linkName;
        }

        DataObjectFacade(H5Group parent, String name, long address) throws IOException {
            this.parent = parent;
            this.name = name;
            this.displayName = name.length() == 0 ? "root" : name;
            this.dobj = H5header.this.getDataObject(address, this.displayName);
            H5header.this.symlinkMap.put(this.getName(), this);
            if (this.dobj.groupMessage != null || this.dobj.groupNewMessage != null) {
                this.isGroup = true;
            } else if (this.dobj.mdt != null && this.dobj.msl != null) {
                this.isVariable = true;
            } else if (this.dobj.mdt != null) {
                this.isTypedef = true;
            } else if (warnings) {
                H5header.this.debugOut.println("WARNING Unknown DataObjectFacade = " + this);
                return;
            }
        }

        String getName() {
            return this.parent == null ? this.name : this.parent.getName() + "/" + this.name;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append(this.getName());
            if (this.dobj == null) {
                sbuff.append(" dobj is NULL! ");
            } else {
                sbuff.append(" id= ").append(this.dobj.address);
                sbuff.append(" messages= ");
                for (HeaderMessage message : this.dobj.messages) {
                    sbuff.append("\n  ").append(message);
                }
            }
            return sbuff.toString();
        }
    }

    public class TypeInfo {
        int hdfType;
        int byteSize;
        DataType dataType;
        int endian = -1;
        boolean unsigned;
        boolean isVString;
        int vpad;
        TypeInfo base;

        TypeInfo(int hdfType, int byteSize) {
            this.hdfType = hdfType;
            this.byteSize = byteSize;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("hdfType=").append(this.hdfType).append(" byteSize=").append(this.byteSize).append(" dataType=").append((Object)this.dataType);
            buff.append(" unsigned=").append(this.unsigned).append(" isVString=").append(this.isVString).append(" vpad=").append(this.vpad).append(" endian=").append(this.endian);
            if (this.base != null) {
                buff.append("\n   base=").append(this.base);
            }
            return buff.toString();
        }
    }

    public class Vinfo {
        Variable owner;
        DataObjectFacade facade;
        long dataPos;
        TypeInfo typeInfo;
        int[] storageSize;
        boolean isChunked = false;
        DataBTree btree = null;
        MessageDatatype mdt;
        MessageDataspace mds;
        MessageFilter mfp;
        boolean useFillValue = false;
        byte[] fillValue;

        public String getCompression() {
            if (this.mfp == null) {
                return null;
            }
            Formatter f = new Formatter();
            for (Filter filt : this.mfp.filters) {
                f.format("%s ", filt.name);
            }
            return f.toString();
        }

        public int[] getChunking() {
            return this.storageSize;
        }

        public boolean isChunked() {
            return this.isChunked;
        }

        public boolean useFillValue() {
            return this.useFillValue;
        }

        public long[] countStorageSize(Formatter f) throws IOException {
            long[] result = new long[2];
            if (this.btree == null) {
                if (f != null) {
                    f.format("btree is null%n", new Object[0]);
                }
                return result;
            }
            if (this.useFillValue) {
                if (f != null) {
                    f.format("useFillValue - no data is stored%n", new Object[0]);
                }
                return result;
            }
            int count = 0;
            long total = 0L;
            DataBTree.DataChunkIterator iter = this.btree.getDataChunkIteratorFilter(null);
            while (iter.hasNext()) {
                DataBTree.DataChunk dc = iter.next();
                if (f != null) {
                    f.format(" %s%n", dc);
                }
                total += (long)dc.size;
                ++count;
            }
            result[0] = total;
            result[1] = count;
            return result;
        }

        Vinfo(DataObjectFacade facade) throws IOException {
            this.facade = facade;
            this.dataPos = H5header.this.getFileOffset(facade.dobj.msl.dataAddress);
            this.mdt = facade.dobj.mdt;
            this.mds = facade.dobj.mds;
            this.mfp = facade.dobj.mfp;
            if (!facade.dobj.mdt.isOK && warnings) {
                H5header.this.debugOut.println("WARNING HDF5 file " + H5header.this.ncfile.getLocation() + " not handling " + facade.dobj.mdt);
                return;
            }
            this.isChunked = facade.dobj.msl.type == 2;
            this.storageSize = this.isChunked ? facade.dobj.msl.chunkSize : facade.dobj.mds.dimLength;
            this.typeInfo = this.calcNCtype(facade.dobj.mdt);
        }

        Vinfo(MessageDatatype mdt, MessageDataspace mds, long dataPos) throws IOException {
            this.mdt = mdt;
            this.mds = mds;
            this.dataPos = dataPos;
            if (!mdt.isOK && warnings) {
                H5header.this.debugOut.println("WARNING HDF5 file " + H5header.this.ncfile.getLocation() + " not handling " + mdt);
                return;
            }
            this.typeInfo = this.calcNCtype(mdt);
        }

        void setOwner(Variable owner) {
            this.owner = owner;
            if (this.btree != null) {
                this.btree.setOwner(owner);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private TypeInfo calcNCtype(MessageDatatype mdt) {
            TypeInfo tinfo;
            block13: {
                byte[] flags;
                int byteSize;
                int hdfType;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    hdfType = mdt.type;
                                                    byteSize = mdt.byteSize;
                                                    flags = mdt.flags;
                                                    tinfo = new TypeInfo(hdfType, byteSize);
                                                    if (hdfType != 0) break block14;
                                                    tinfo.dataType = H5header.this.getNCtype(hdfType, byteSize);
                                                    tinfo.endian = (flags[0] & 1) == 0 ? 1 : 0;
                                                    tinfo.unsigned = (flags[0] & 8) == 0;
                                                    break block13;
                                                }
                                                if (hdfType != 1) break block15;
                                                tinfo.dataType = H5header.this.getNCtype(hdfType, byteSize);
                                                tinfo.endian = (flags[0] & 1) == 0 ? 1 : 0;
                                                break block13;
                                            }
                                            if (hdfType != 2) break block16;
                                            tinfo.dataType = DataType.STRING;
                                            tinfo.endian = (flags[0] & 1) == 0 ? 1 : 0;
                                            break block13;
                                        }
                                        if (hdfType != 3) break block17;
                                        tinfo.dataType = DataType.CHAR;
                                        tinfo.vpad = flags[0] & 0xF;
                                        break block13;
                                    }
                                    if (hdfType != 4) break block18;
                                    tinfo.dataType = H5header.this.getNCtype(hdfType, byteSize);
                                    break block13;
                                }
                                if (hdfType != 5) break block19;
                                tinfo.dataType = DataType.OPAQUE;
                                break block13;
                            }
                            if (hdfType != 6) break block20;
                            tinfo.dataType = DataType.STRUCTURE;
                            break block13;
                        }
                        if (hdfType != 7) break block21;
                        tinfo.endian = 1;
                        tinfo.dataType = DataType.LONG;
                        break block13;
                    }
                    if (hdfType != 8) break block22;
                    if (tinfo.byteSize == 1) {
                        tinfo.dataType = DataType.ENUM1;
                        break block13;
                    } else if (tinfo.byteSize == 2) {
                        tinfo.dataType = DataType.ENUM2;
                        break block13;
                    } else {
                        if (tinfo.byteSize != 4) {
                            log.warn("Illegal byte suze for enum type = " + tinfo.byteSize);
                            throw new IllegalStateException("Illegal byte suze for enum type = " + tinfo.byteSize);
                        }
                        tinfo.dataType = DataType.ENUM4;
                    }
                    break block13;
                }
                if (hdfType == 9) {
                    tinfo.isVString = mdt.isVString;
                    if (mdt.isVString) {
                        tinfo.vpad = flags[0] >> 4 & 0xF;
                        tinfo.dataType = DataType.STRING;
                    } else {
                        tinfo.dataType = H5header.this.getNCtype(mdt.getBaseType(), mdt.getBaseSize());
                        tinfo.endian = mdt.base.endian;
                    }
                } else if (hdfType == 10) {
                    int n = tinfo.endian = (mdt.getFlags()[0] & 1) == 0 ? 1 : 0;
                    tinfo.dataType = mdt.base.type == 9 && mdt.base.isVString ? DataType.STRING : H5header.this.getNCtype(mdt.getBaseType(), mdt.getBaseSize());
                } else if (warnings) {
                    H5header.this.debugOut.println("WARNING not handling hdf dataType = " + hdfType + " size= " + byteSize);
                }
            }
            if (mdt.base != null) {
                tinfo.base = this.calcNCtype(mdt.base);
            }
            return tinfo;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("dataPos=").append(this.dataPos).append(" datatype=").append(this.typeInfo);
            if (this.isChunked) {
                buff.append(" isChunked (");
                for (int size : this.storageSize) {
                    buff.append(size).append(" ");
                }
                buff.append(")");
            }
            if (this.mfp != null) {
                buff.append(" hasFilter");
            }
            buff.append("; // ").append(this.extraInfo());
            if (null != this.facade) {
                buff.append("\n").append(this.facade);
            }
            return buff.toString();
        }

        public String extraInfo() {
            StringBuilder buff = new StringBuilder();
            if (this.typeInfo.dataType != DataType.CHAR && this.typeInfo.dataType != DataType.STRING) {
                buff.append(this.typeInfo.unsigned ? " unsigned" : " signed");
            }
            if (this.typeInfo.endian >= 0) {
                buff.append(this.typeInfo.endian == 1 ? " LittleEndian" : " BigEndian");
            }
            if (this.useFillValue) {
                buff.append(" useFillValue");
            }
            return buff.toString();
        }

        DataType getNCDataType() {
            return this.typeInfo.dataType;
        }

        Object getFillValue() {
            return this.fillValue == null ? this.getFillValueDefault(this.typeInfo.dataType) : this.getFillValueNonDefault();
        }

        Object getFillValueDefault(DataType dtype) {
            if (dtype == DataType.BYTE || dtype == DataType.ENUM1) {
                return (byte)-127;
            }
            if (dtype == DataType.CHAR) {
                return (byte)0;
            }
            if (dtype == DataType.SHORT || dtype == DataType.ENUM2) {
                return (short)-32767;
            }
            if (dtype == DataType.INT || dtype == DataType.ENUM4) {
                return -2147483647;
            }
            if (dtype == DataType.LONG) {
                return -9223372036854775806L;
            }
            if (dtype == DataType.FLOAT) {
                return Float.valueOf(9.96921E36f);
            }
            if (dtype == DataType.DOUBLE) {
                return (double)9.96921E36f;
            }
            return null;
        }

        Object getFillValueNonDefault() {
            if (this.fillValue == null) {
                return null;
            }
            if (this.typeInfo.dataType == DataType.BYTE || this.typeInfo.dataType == DataType.CHAR || this.typeInfo.dataType == DataType.ENUM1) {
                return this.fillValue[0];
            }
            ByteBuffer bbuff = ByteBuffer.wrap(this.fillValue);
            if (this.typeInfo.endian >= 0) {
                bbuff.order(this.typeInfo.endian == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            }
            if (this.typeInfo.dataType == DataType.SHORT || this.typeInfo.dataType == DataType.ENUM2) {
                ShortBuffer tbuff = bbuff.asShortBuffer();
                return tbuff.get();
            }
            if (this.typeInfo.dataType == DataType.INT || this.typeInfo.dataType == DataType.ENUM4) {
                IntBuffer tbuff = bbuff.asIntBuffer();
                return tbuff.get();
            }
            if (this.typeInfo.dataType == DataType.LONG) {
                LongBuffer tbuff = bbuff.asLongBuffer();
                return tbuff.get();
            }
            if (this.typeInfo.dataType == DataType.FLOAT) {
                FloatBuffer tbuff = bbuff.asFloatBuffer();
                return Float.valueOf(tbuff.get());
            }
            if (this.typeInfo.dataType == DataType.DOUBLE) {
                DoubleBuffer tbuff = bbuff.asDoubleBuffer();
                return tbuff.get();
            }
            return null;
        }
    }
}

