/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.StringTokenizer;
import ucar.nc2.constants.CDM;

public class StringUtil2 {
    private static final char[] htmlIn = new char[]{'&', '\"', '\'', '<', '>', '\n'};
    private static final String[] htmlOut = new String[]{"&amp;", "&quot;", "&#39;", "&lt;", "&gt;", "\n<p>"};
    private static final char[] xmlInC = new char[]{'&', '<', '>'};
    private static final String[] xmlOutC = new String[]{"&amp;", "&lt;", "&gt;"};
    private static final char[] xmlIn = new char[]{'&', '\"', '\'', '<', '>', '\r', '\n'};
    private static final String[] xmlOut = new String[]{"&amp;", "&quot;", "&apos;", "&lt;", "&gt;", "&#13;", "&#10;"};

    public static String allow(String x, String allowChars, char replaceChar) {
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (Character.isLetterOrDigit(c) || 0 <= allowChars.indexOf(c)) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (Character.isLetterOrDigit(c) || 0 <= allowChars.indexOf(c)) continue;
            sb.setCharAt(pos, replaceChar);
        }
        return sb.toString();
    }

    public static String breakTextAtWords(String text, String insert, int lineSize) {
        StringBuilder buff = new StringBuilder();
        StringTokenizer stoker = new StringTokenizer(text);
        int lineCount = 0;
        while (stoker.hasMoreTokens()) {
            String tok = stoker.nextToken();
            if (tok.length() + lineCount >= lineSize) {
                buff.append(insert);
                lineCount = 0;
            }
            buff.append(tok);
            buff.append(" ");
            lineCount += tok.length() + 1;
        }
        return buff.toString();
    }

    public static String cleanup(byte[] h) {
        byte[] bb = new byte[h.length];
        int count = 0;
        for (byte b : h) {
            if (b < 32 || b >= 127) continue;
            bb[count++] = b;
        }
        return new String(bb, 0, count);
    }

    public static String cleanup(String s) {
        if (s == null) {
            return null;
        }
        return StringUtil2.cleanup(s.getBytes(CDM.utf8Charset));
    }

    public static String filter(String x, String okChars) {
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (Character.isLetterOrDigit(c) || 0 <= okChars.indexOf(c)) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x.length());
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (!Character.isLetterOrDigit(c) && 0 > okChars.indexOf(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String filter7bits(String s) {
        if (s == null) {
            return null;
        }
        char[] bo = new char[s.length()];
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c >= '\u0080' || c <= '\u001f') && c != '\n' && c != '\t') continue;
            bo[count++] = c;
        }
        return new String(bo, 0, count);
    }

    public static String makeValidCdmObjectName(String name) {
        name = name.trim();
        boolean ok = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c < ' ') {
                ok = false;
            }
            if (c == '/') {
                ok = false;
            }
            if (c == ' ') {
                ok = false;
            }
            if (!ok) break;
        }
        if (ok) {
            return name;
        }
        StringBuilder sbuff = new StringBuilder(name.length());
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c == '/' || c == ' ') {
                sbuff.append('_');
                continue;
            }
            if (c < ' ') continue;
            sbuff.append(c);
        }
        return sbuff.toString();
    }

    public static int match(String s1, String s2) {
        int i;
        for (i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    public static String padZero(int value, int numDigits) {
        return StringUtil2.padLeft(String.valueOf(value), numDigits, "0");
    }

    public static String padLeft(String s, int desiredLength) {
        return StringUtil2.padLeft(s, desiredLength, " ");
    }

    public static String padLeft(String s, int desiredLength, String padString) {
        while (s.length() < desiredLength) {
            s = padString + s;
        }
        return s;
    }

    public static String padRight(String s, int desiredLength) {
        return StringUtil2.padRight(s, desiredLength, " ");
    }

    public static String padRight(String s, int desiredLength, String padString) {
        while (s.length() < desiredLength) {
            s = s + padString;
        }
        return s;
    }

    public static String quoteHtmlContent(String x) {
        return StringUtil2.replace(x, htmlIn, htmlOut);
    }

    public static String quoteXmlContent(String x) {
        return StringUtil2.replace(x, xmlInC, xmlOutC);
    }

    public static String unquoteXmlContent(String x) {
        return StringUtil2.unreplace(x, xmlOutC, xmlInC);
    }

    public static String quoteXmlAttribute(String x) {
        return StringUtil2.replace(x, xmlIn, xmlOut);
    }

    public static String unquoteXmlAttribute(String x) {
        return StringUtil2.unreplace(x, xmlOut, xmlIn);
    }

    public static String remove(String s, String sub) {
        int pos;
        int len = sub.length();
        while (0 <= (pos = s.indexOf(sub))) {
            s = s.substring(0, pos) + s.substring(pos + len);
        }
        return s;
    }

    public static String remove(String s, int c) {
        if (0 > s.indexOf(c)) {
            return s;
        }
        StringBuilder buff = new StringBuilder(s);
        int i = 0;
        while (i < buff.length()) {
            if (buff.charAt(i) == c) {
                buff.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return buff.toString();
    }

    public static String removeFromEnd(String s, int c) {
        if (0 > s.indexOf(c)) {
            return s;
        }
        int len = s.length();
        while (s.charAt(len - 1) == c) {
            --len;
        }
        if (len == s.length()) {
            return s;
        }
        return s.substring(0, len);
    }

    public static String removeWhitespace(String inputString) {
        StringBuilder sb = new StringBuilder();
        char[] chars = inputString.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String collapseWhitespace(String s) {
        int len = s.length();
        StringBuilder b = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                b.append(c);
                continue;
            }
            b.append(' ');
            while (i + 1 < len && Character.isWhitespace(s.charAt(i + 1))) {
                ++i;
            }
        }
        return b.toString();
    }

    public static String replace(String s, char out, String in) {
        if (s.indexOf(out) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        StringUtil2.replace(sb, out, in);
        return sb.toString();
    }

    public static String replace(String x, char[] replaceChar, String[] replaceWith) {
        boolean ok = true;
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            boolean bl = ok = pos < 0;
            if (!ok) break;
        }
        if (ok) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x);
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            if (pos < 0) continue;
            StringUtil2.replace(sb, replaceChar[i], replaceWith[i]);
        }
        return sb.toString();
    }

    public static String replace(String string, String pattern, String value) {
        int idx;
        if (pattern.length() == 0) {
            return string;
        }
        if (!string.contains(pattern)) {
            return string;
        }
        StringBuilder returnValue = new StringBuilder();
        int patternLength = pattern.length();
        while ((idx = string.indexOf(pattern)) >= 0) {
            returnValue.append(string.substring(0, idx));
            if (value != null) {
                returnValue.append(value);
            }
            string = string.substring(idx + patternLength);
        }
        returnValue.append(string);
        return returnValue.toString();
    }

    public static String unreplace(String x, String[] orgReplace, char[] orgChar) {
        boolean ok = true;
        for (int i = 0; i < orgReplace.length; ++i) {
            int pos = x.indexOf(orgReplace[i]);
            boolean bl = ok = pos < 0;
            if (!ok) break;
        }
        if (ok) {
            return x;
        }
        StringBuilder result = new StringBuilder(x);
        for (int i = 0; i < orgReplace.length; ++i) {
            int pos = result.indexOf(orgReplace[i]);
            if (pos < 0) continue;
            StringUtil2.unreplace(result, orgReplace[i], orgChar[i]);
        }
        return result.toString();
    }

    public static String substitute(String original, String match, String subst) {
        int pos;
        String s = original;
        while (0 <= (pos = s.indexOf(match))) {
            StringBuilder sb = new StringBuilder(s);
            s = sb.replace(pos, pos + match.length(), subst).toString();
        }
        return s;
    }

    public static String escape(String x, String okChars) {
        String newname = "";
        for (char c : x.toCharArray()) {
            newname = c == '%' ? newname + "%%" : (!Character.isLetterOrDigit(c) && okChars.indexOf(c) < 0 ? newname + '%' + Integer.toHexString(0xFF & c) : newname + c);
        }
        return newname;
    }

    public static String unescape(String x) {
        if (x.indexOf(37) < 0) {
            return x;
        }
        char[] b = new char[2];
        StringBuilder sb = new StringBuilder(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            int value;
            char c = sb.charAt(pos);
            if (c != '%') continue;
            if (pos >= sb.length() - 2) {
                return x;
            }
            b[0] = sb.charAt(pos + 1);
            b[1] = sb.charAt(pos + 2);
            try {
                value = Integer.parseInt(new String(b), 16);
            }
            catch (NumberFormatException e) {
                continue;
            }
            c = (char)value;
            sb.setCharAt(pos, c);
            sb.delete(pos + 1, pos + 3);
        }
        return sb.toString();
    }

    public static String[] splitString(String source) {
        return source.trim().split("\\s+");
    }

    public static String substitute(String original, String[] match, String[] subst) {
        boolean ok = true;
        for (int i = 0; i < match.length; ++i) {
            if (!original.contains(match[i])) continue;
            ok = false;
            break;
        }
        if (ok) {
            return original;
        }
        StringBuilder sb = new StringBuilder(original);
        for (int i = 0; i < match.length; ++i) {
            StringUtil2.substitute(sb, match[i], subst[i]);
        }
        return sb.toString();
    }

    public static void remove(StringBuilder sb, String out) {
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            boolean ok = true;
            for (int j = 0; j < out.length(); ++j) {
                if (out.charAt(j) != c) continue;
                sb.delete(i, i + 1);
                ok = false;
                break;
            }
            if (!ok) continue;
            ++i;
        }
    }

    public static void replace(StringBuilder sb, char out, String in) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != out) continue;
            sb.replace(i, i + 1, in);
            i += in.length() - 1;
        }
    }

    public static void unreplace(StringBuilder sb, String out, char in) {
        int pos;
        while (0 <= (pos = sb.indexOf(out))) {
            sb.setCharAt(pos, in);
            sb.delete(pos + 1, pos + out.length());
        }
    }

    public static void replace(StringBuilder sb, String out, String in) {
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            for (int j = 0; j < out.length(); ++j) {
                if (out.charAt(j) != c) continue;
                sb.setCharAt(i, in.charAt(j));
            }
        }
    }

    public static void substitute(StringBuilder sbuff, String match, String subst) {
        int pos;
        int fromIndex = 0;
        int substLen = subst.length();
        int matchLen = match.length();
        while (0 <= (pos = sbuff.indexOf(match, fromIndex))) {
            sbuff.replace(pos, pos + matchLen, subst);
            fromIndex = pos + substLen;
        }
    }

    public static StringBuilder trim(StringBuilder sb) {
        char c;
        int i;
        int count = 0;
        for (i = 0; i < sb.length() && (c = sb.charAt(i)) == ' '; ++i) {
            ++count;
        }
        if (count > 0) {
            sb = sb.delete(0, count);
        }
        count = 0;
        for (i = sb.length() - 1; i >= 0 && (c = sb.charAt(i)) == ' '; --i) {
            ++count;
        }
        if (count > 0) {
            sb.setLength(sb.length() - count);
        }
        return sb;
    }

    private static void showUsage() {
        System.out.println(" StringUtil escape <string> [okChars]");
        System.out.println(" StringUtil unescape <string>");
    }

    public static String escape2(String x, String reservedChars) {
        String newname = "";
        for (char c : x.toCharArray()) {
            newname = c == '%' ? newname + "%%" : (reservedChars.indexOf(c) >= 0 ? newname + '%' + Integer.toHexString(0xFF & c) : newname + c);
        }
        return newname;
    }

    public static String ignoreescape2(String x, String reservedChars) {
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            sb.setCharAt(pos, '%');
            char value = c;
            sb.insert(++pos, Integer.toHexString(value));
            ++pos;
        }
        return sb.toString();
    }

    public static String breakText(String text, String insert, int lineSize) {
        text = StringUtil2.replace(text, "\n", " ");
        StringBuilder buff = new StringBuilder();
        while (text.length() > 0) {
            int idx;
            int len = text.length();
            if (len < lineSize) {
                buff.append(text);
                break;
            }
            for (idx = lineSize; idx < len && text.charAt(idx) != ' '; ++idx) {
            }
            if (idx == len) {
                buff.append(text);
                break;
            }
            buff.append(text.substring(0, idx));
            buff.append(insert);
            text = text.substring(idx);
        }
        return buff.toString();
    }

    public static void main3(String[] args) {
        if (args.length < 2) {
            StringUtil2.showUsage();
            return;
        }
        if (args[0].equalsIgnoreCase("escape")) {
            String ok = args.length > 2 ? args[2] : "";
            System.out.println(" escape(" + args[1] + "," + ok + ")= " + StringUtil2.escape(args[1], ok));
        } else if (args[0].equalsIgnoreCase("unescape")) {
            System.out.println(" unescape(" + args[1] + ")= " + StringUtil2.unescape(args[1]));
        } else {
            StringUtil2.showUsage();
        }
    }

    public static void main(String[] args) {
        String s = "Level of 0\u00c2\u00b0C isotherm";
        System.out.printf("filter7bits(%s) == %s%n", s, StringUtil2.filter7bits(s));
    }
}

