/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.QuasiRegular;
import ucar.grib.grib1.Grib1BinaryDataSection;
import ucar.grib.grib1.Grib1BitMapSection;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1Data {
    private static Logger log = LoggerFactory.getLogger(Grib1Data.class);
    private static boolean expandGrib1ThinGrids = true;
    private final RandomAccessFile raf;

    public Grib1Data(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final float[] getData(long gdsOffset, long dataOffset, int decimalScale, boolean bmsExists) throws IOException {
        Grib1GridDefinitionSection gds = null;
        Grib1GDSVariables gdsv = null;
        boolean isThin = false;
        try {
            if (gdsOffset != -1L) {
                this.raf.seek(gdsOffset);
                gds = new Grib1GridDefinitionSection(this.raf);
                gdsv = gds.getGdsVars();
                int PVorPL = gdsv.getPVorPL();
                int NV = gdsv.getNV();
                isThin = false;
                if (PVorPL != 255 && (NV == 0 || NV == 255)) {
                    isThin = true;
                }
            }
        }
        catch (NoValidGribException nvge) {
            log.debug("gds exception was caught");
        }
        this.raf.seek(dataOffset);
        Grib1BitMapSection bms = null;
        if (bmsExists) {
            bms = new Grib1BitMapSection(this.raf);
        }
        try {
            if (!isThin) {
                Grib1BinaryDataSection bds = new Grib1BinaryDataSection(this.raf, decimalScale, bms, gdsv.getScanMode(), gdsv.getNx(), gdsv.getNy());
                return bds.getValues();
            }
            Grib1BinaryDataSection bds = new Grib1BinaryDataSection(this.raf, decimalScale, bms, gdsv.getScanMode(), -1, gdsv.getNy());
            if (expandGrib1ThinGrids) {
                QuasiRegular qr = new QuasiRegular(bds.getValues(), gdsv.getParallels(), gdsv.getNx(), gdsv.getNy());
                return qr.getData();
            }
            return bds.getValues();
        }
        catch (NotSupportedException notSupport) {
            log.error("Grib1BinaryDataSection exception was caught");
            return null;
        }
    }

    public final float[] getData(long offset, int decimalScale, boolean bmsExists) throws IOException {
        boolean isThin = false;
        Grib1GridDefinitionSection gds = null;
        Grib1GDSVariables gdsv = null;
        try {
            this.raf.seek(offset);
            int length = GribNumbers.uint3(this.raf);
            int NV = this.raf.read();
            int P_VorL = this.raf.read();
            if (length < 50) {
                this.raf.skipBytes(length - 5);
            } else if (length < 1200 && !bmsExists) {
                if (P_VorL != 255) {
                    this.raf.skipBytes(-5);
                    gds = new Grib1GridDefinitionSection(this.raf);
                    gdsv = gds.getGdsVars();
                    isThin = gdsv.isThin();
                } else {
                    this.raf.skipBytes(length - 5);
                }
            } else if (length == NV * 4 + 32) {
                this.raf.skipBytes(length - 5);
            } else if (length < 600) {
                if (P_VorL != 255) {
                    this.raf.skipBytes(-5);
                    gds = new Grib1GridDefinitionSection(this.raf);
                    gdsv = gds.getGdsVars();
                    isThin = gdsv.isThin();
                } else {
                    this.raf.skipBytes(length - 5);
                }
            } else {
                this.raf.seek(offset);
            }
        }
        catch (NoValidGribException nvge) {
            log.error("gds exception was caught");
            this.raf.seek(offset);
        }
        Grib1BitMapSection bms = null;
        if (bmsExists) {
            bms = new Grib1BitMapSection(this.raf);
        }
        try {
            if (!isThin) {
                Grib1BinaryDataSection bds = new Grib1BinaryDataSection(this.raf, decimalScale, bms, gdsv.getScanMode(), gdsv.getNx(), gdsv.getNy());
                return bds.getValues();
            }
            Grib1BinaryDataSection bds = new Grib1BinaryDataSection(this.raf, decimalScale, bms, gdsv.getScanMode(), -1, gdsv.getNy());
            if (expandGrib1ThinGrids) {
                QuasiRegular qr = new QuasiRegular(bds.getValues(), gdsv.getParallels(), gdsv.getNx(), gdsv.getNy());
                return qr.getData();
            }
            return bds.getValues();
        }
        catch (NotSupportedException notSupport) {
            log.error("Grib1BinaryDataSection exception was caught");
            return null;
        }
    }

    public static void setExpandGrib1ThinGrids(boolean b) {
        expandGrib1ThinGrids = b;
    }
}

