/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.txn.Locker;

public abstract class SecondaryReferenceException
extends OperationFailureException {
    private static final long serialVersionUID = 1L;
    private final String secDbName;
    private final DatabaseEntry secKey;
    private final DatabaseEntry priKey;

    public SecondaryReferenceException(Locker locker, String message, String secDbName, DatabaseEntry secKey, DatabaseEntry priKey) {
        super(locker, true, message, null);
        this.secDbName = secDbName;
        this.secKey = secKey;
        this.priKey = priKey;
    }

    SecondaryReferenceException(String message, SecondaryReferenceException cause) {
        super(message, cause);
        this.secDbName = cause.secDbName;
        this.secKey = cause.secKey;
        this.priKey = cause.priKey;
    }

    public String getSecondaryDatabaseName() {
        return this.secDbName;
    }

    public DatabaseEntry getSecondaryKey() {
        return this.secKey;
    }

    public DatabaseEntry getPrimaryKey() {
        return this.priKey;
    }
}

