/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import thredds.wcs.v1_0_0_Plus.WcsCoverage;
import thredds.wcs.v1_0_0_Plus.WcsDataset;
import thredds.wcs.v1_0_0_Plus.WcsRangeField;
import thredds.wcs.v1_0_0_Plus.WcsRequest;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class DescribeCoverage
extends WcsRequest {
    private List<String> coverages;
    private Document describeCoverageDoc;

    public DescribeCoverage(WcsRequest.Operation operation, String version, WcsDataset dataset, List<String> coverages) {
        super(operation, version, dataset);
        this.coverages = coverages;
        if (this.coverages == null) {
            throw new IllegalArgumentException("Non-null coverage list required.");
        }
        if (this.coverages.size() < 1) {
            throw new IllegalArgumentException("Coverage list must contain at least one ID <" + this.coverages.size() + ">.");
        }
        String badCovIds = "";
        for (String curCov : coverages) {
            if (this.getDataset().isAvailableCoverageName(curCov)) continue;
            badCovIds = badCovIds + (badCovIds.length() > 0 ? ", " : "") + curCov;
        }
        if (badCovIds.length() > 0) {
            throw new IllegalArgumentException("Coverage ID list contains one or more unknown IDs <" + badCovIds + ">.");
        }
    }

    public Document getDescribeCoverageDoc() {
        if (this.describeCoverageDoc == null) {
            this.describeCoverageDoc = this.generateDescribeCoverageDoc();
        }
        return this.describeCoverageDoc;
    }

    public void writeDescribeCoverageDoc(PrintWriter pw) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.getDescribeCoverageDoc(), (Writer)pw);
    }

    public Document generateDescribeCoverageDoc() {
        Element coverageDescriptionsElem = new Element("CoverageDescription", wcsNS);
        coverageDescriptionsElem.addNamespaceDeclaration(gmlNS);
        coverageDescriptionsElem.addNamespaceDeclaration(xlinkNS);
        coverageDescriptionsElem.setAttribute("version", this.getVersion());
        for (String curCoverageId : this.coverages) {
            coverageDescriptionsElem.addContent((Content)this.genCoverageOfferingElem(curCoverageId));
        }
        return new Document(coverageDescriptionsElem);
    }

    public Element genCoverageOfferingElem(String covId) {
        WcsCoverage coverage = this.getDataset().getAvailableCoverage(covId);
        GridCoordSystem gridCoordSystem = coverage.getCoordinateSystem();
        Element covDescripElem = this.genCoverageOfferingBriefElem("CoverageOffering", covId, coverage.getLabel(), coverage.getDescription(), gridCoordSystem);
        covDescripElem.addContent((Content)this.genDomainSetElem(coverage));
        covDescripElem.addContent((Content)this.genRangeSetElem(coverage));
        covDescripElem.addContent((Content)this.genSupportedCRSsElem(coverage));
        covDescripElem.addContent((Content)this.genSupportedFormatsElem(coverage));
        covDescripElem.addContent((Content)this.genSupportedInterpolationsElem());
        return covDescripElem;
    }

    private Element genDomainSetElem(WcsCoverage coverage) {
        Element domainSetElem = new Element("domainSet", wcsNS);
        domainSetElem.addContent((Content)this.genSpatialDomainElem(coverage));
        if (coverage.getCoordinateSystem().hasTimeAxis()) {
            domainSetElem.addContent((Content)this.genTemporalDomainElem(coverage.getCoordinateSystem().getTimeAxis1D()));
        }
        return domainSetElem;
    }

    private Element genSpatialDomainElem(WcsCoverage coverage) {
        Element spatialDomainElem = new Element("spatialDomain", wcsNS);
        spatialDomainElem.addContent((Content)this.genEnvelopeElem(coverage.getCoordinateSystem()));
        spatialDomainElem.addContent((Content)this.genRectifiedGridElem(coverage));
        return spatialDomainElem;
    }

    private Element genRectifiedGridElem(WcsCoverage coverage) {
        Element rectifiedGridElem = new Element("RectifiedGrid", gmlNS);
        CoordinateAxis1D xaxis = (CoordinateAxis1D)coverage.getCoordinateSystem().getXHorizAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)coverage.getCoordinateSystem().getYHorizAxis();
        CoordinateAxis1D zaxis = coverage.getCoordinateSystem().getVerticalAxis();
        rectifiedGridElem.setAttribute("srsName", coverage.getNativeCrs());
        int ndim = zaxis != null ? 3 : 2;
        rectifiedGridElem.setAttribute("dimension", Integer.toString(ndim));
        int[] minValues = new int[ndim];
        int[] maxValues = new int[ndim];
        maxValues[0] = (int)(xaxis.getSize() - 1L);
        maxValues[1] = (int)(yaxis.getSize() - 1L);
        if (zaxis != null) {
            maxValues[2] = (int)(zaxis.getSize() - 1L);
        }
        Element limitsElem = new Element("limits", gmlNS);
        limitsElem.addContent((Content)new Element("GridEnvelope", gmlNS).addContent((Content)new Element("low", gmlNS).addContent(this.genIntegerListString(minValues))).addContent((Content)new Element("high", gmlNS).addContent(this.genIntegerListString(maxValues))));
        rectifiedGridElem.addContent((Content)limitsElem);
        rectifiedGridElem.addContent((Content)new Element("axisName", gmlNS).addContent("x"));
        rectifiedGridElem.addContent((Content)new Element("axisName", gmlNS).addContent("y"));
        if (zaxis != null) {
            rectifiedGridElem.addContent((Content)new Element("axisName", gmlNS).addContent("z"));
        }
        double[] origin = new double[ndim];
        origin[0] = xaxis.getStart();
        origin[1] = yaxis.getStart();
        if (zaxis != null) {
            origin[2] = zaxis.getStart();
        }
        rectifiedGridElem.addContent((Content)new Element("origin", gmlNS).addContent((Content)new Element("pos", gmlNS).addContent(this.genDoubleListString(origin))));
        double[] xoffset = new double[ndim];
        xoffset[0] = xaxis.getIncrement();
        rectifiedGridElem.addContent((Content)new Element("offsetVector", gmlNS).addContent(this.genDoubleListString(xoffset)));
        double[] yoffset = new double[ndim];
        yoffset[1] = yaxis.getIncrement();
        rectifiedGridElem.addContent((Content)new Element("offsetVector", gmlNS).addContent(this.genDoubleListString(yoffset)));
        if (zaxis != null) {
            double[] zoffset = new double[ndim];
            zoffset[2] = zaxis.getIncrement();
            rectifiedGridElem.addContent((Content)new Element("offsetVector", gmlNS).addContent(this.genDoubleListString(zoffset)));
        }
        return rectifiedGridElem;
    }

    private String genIntegerListString(int[] values) {
        StringBuilder buf = new StringBuilder();
        for (int intValue : values) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(intValue);
        }
        return buf.toString();
    }

    private String genDoubleListString(double[] values) {
        StringBuffer buf = new StringBuffer();
        for (double doubleValue : values) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(doubleValue);
        }
        return buf.toString();
    }

    private Element genEnvelopeElem(GridCoordSystem gcs) {
        Element envelopeElem = gcs.hasTimeAxis() ? new Element("EnvelopeWithTimePeriod", wcsNS) : new Element("Envelope", wcsNS);
        envelopeElem.setAttribute("srsName", "urn:ogc:def:crs:OGC:1.3:CRS84");
        LatLonRect llbb = gcs.getLatLonBoundingBox();
        LatLonPointImpl llpt = llbb.getLowerLeftPoint();
        LatLonPointImpl urpt = llbb.getUpperRightPoint();
        double lon = llpt.getLongitude() + llbb.getWidth();
        int posDim = 2;
        String firstPosition = llpt.getLongitude() + " " + llpt.getLatitude();
        String secondPosition = lon + " " + urpt.getLatitude();
        CoordinateAxis1D vertAxis = gcs.getVerticalAxis();
        if (vertAxis != null) {
            ++posDim;
            double zeroIndexValue = vertAxis.getCoordValue(0);
            double sizeIndexValue = vertAxis.getCoordValue((int)vertAxis.getSize() - 1);
            if (vertAxis.getPositive().equals("up")) {
                firstPosition = firstPosition + " " + zeroIndexValue;
                secondPosition = secondPosition + " " + sizeIndexValue;
            } else {
                firstPosition = firstPosition + " " + sizeIndexValue;
                secondPosition = secondPosition + " " + zeroIndexValue;
            }
        }
        String posDimString = Integer.toString(posDim);
        envelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(firstPosition).setAttribute(new Attribute("dimension", posDimString)));
        envelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(secondPosition).setAttribute(new Attribute("dimension", posDimString)));
        if (gcs.hasTimeAxis()) {
            envelopeElem.addContent((Content)new Element("timePosition", gmlNS).addContent(gcs.getCalendarDateRange().getStart().toString()));
            envelopeElem.addContent((Content)new Element("timePosition", gmlNS).addContent(gcs.getCalendarDateRange().getEnd().toString()));
        }
        return envelopeElem;
    }

    private Element genTemporalDomainElem(CoordinateAxis1DTime timeAxis) {
        Element temporalDomainElem = new Element("temporalDomain", wcsNS);
        List<CalendarDate> dates = timeAxis.getCalendarDates();
        for (CalendarDate curDate : dates) {
            temporalDomainElem.addContent((Content)new Element("timePosition", gmlNS).addContent(curDate.toString()));
        }
        return temporalDomainElem;
    }

    private Element genRangeSetElem(WcsCoverage coverage) {
        Element rangeSetElem = new Element("rangeSet", wcsNS);
        for (WcsRangeField curField : coverage.getRange()) {
            Element fieldElem = new Element("Field", wcsNS);
            if (curField.getDescription() != null) {
                fieldElem.addContent((Content)new Element("description").addContent(curField.getDescription()));
            }
            fieldElem.addContent((Content)new Element("name", wcsNS).addContent(curField.getName()));
            fieldElem.addContent((Content)new Element("label", wcsNS).addContent(curField.getLabel()));
            fieldElem.addContent((Content)new Element("dataType", wcsNS).addContent(curField.getDatatypeString()));
            fieldElem.addContent((Content)new Element("units", wcsNS).addContent(curField.getUnitsString()));
            Element valuesElem = new Element("AllowedValues", wcsNS);
            Element minElem = new Element("MinimumValue", wcsNS).addContent(Double.toString(curField.getValidMin()));
            Element maxElem = new Element("MaximumValue", wcsNS).addContent(Double.toString(curField.getValidMin()));
            valuesElem.addContent((Content)new Element("Range", wcsNS).addContent((Content)minElem).addContent((Content)maxElem));
            List<WcsRangeField.Axis> axes = curField.getAxes();
            for (WcsRangeField.Axis curAxis : axes) {
                if (curAxis == null) continue;
                Element axisDescElem = new Element("Axis", wcsNS);
                axisDescElem.addContent((Content)new Element("name", wcsNS).addContent(curAxis.getName()));
                axisDescElem.addContent((Content)new Element("label", wcsNS).addContent(curAxis.getLabel()));
                Element axisValuesElem = new Element("values", wcsNS);
                for (String curVal : curAxis.getValues()) {
                    axisValuesElem.addContent((Content)new Element("singleValue", wcsNS).addContent(curVal));
                }
                axisDescElem.addContent((Content)axisValuesElem);
                fieldElem.addContent((Content)axisDescElem);
            }
            if (curField.hasMissingData()) {
                fieldElem.addContent((Content)new Element("nullValues", wcsNS).addContent((Content)new Element("singleValue", wcsNS).addContent("NaN")));
            }
            rangeSetElem.addContent((Content)fieldElem);
        }
        return rangeSetElem;
    }

    private Element genSupportedCRSsElem(WcsCoverage coverage) {
        Element supportedCRSsElem = new Element("supportedCRSs", wcsNS);
        supportedCRSsElem.addContent((Content)new Element("requestCRSs", wcsNS).addContent(coverage.getDefaultRequestCrs()));
        supportedCRSsElem.addContent((Content)new Element("responseCRSs", wcsNS).addContent(coverage.getNativeCrs()));
        return supportedCRSsElem;
    }

    private Element genSupportedFormatsElem(WcsCoverage coverage) {
        Element supportedFormatsElem = new Element("supportedFormats", wcsNS);
        for (WcsRequest.Format curFormat : coverage.getSupportedCoverageFormatList()) {
            supportedFormatsElem.addContent((Content)new Element("formats", wcsNS).addContent(curFormat.toString()));
        }
        return supportedFormatsElem;
    }

    private Element genSupportedInterpolationsElem() {
        Element supportedInterpolationsElem = new Element("supportedInterpolations", wcsNS);
        supportedInterpolationsElem.addContent((Content)new Element("interpolationMethod", wcsNS).addContent("none"));
        return supportedInterpolationsElem;
    }
}

