/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.util.DebugFlags;

public class FileWriter {
    private static final Logger log = LoggerFactory.getLogger(FileWriter.class);
    private static boolean debug = false;
    private static boolean debugWrite = false;
    private final NetcdfFileWriteable ncfile;
    private final HashMap<String, Dimension> dimHash = new HashMap();
    private final List<Variable> varList = new ArrayList<Variable>();
    private final Structure recordVar = null;

    public static void setDebugFlags(DebugFlags debugFlags) {
        debug = debugFlags.isSet("ncfileWriter/debug");
        debugWrite = debugFlags.isSet("ncfileWriter/debugWrite");
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName) throws IOException {
        return FileWriter.writeToFile(fileIn, fileOutName, false, false, null);
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName, boolean fill) throws IOException {
        return FileWriter.writeToFile(fileIn, fileOutName, fill, false, null);
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName, boolean fill, boolean isLargeFile) throws IOException {
        return FileWriter.writeToFile(fileIn, fileOutName, fill, isLargeFile, null);
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName, boolean fill, boolean isLargeFile, List<FileWriterProgressListener> progressListeners) throws IOException {
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew(fileOutName, fill);
        if (debug) {
            System.out.println("FileWriter write " + fileIn.getLocation() + " to " + fileOutName);
            System.out.println("File In = " + fileIn);
        }
        ncfile.setLargeFile(isLargeFile);
        List<Attribute> glist = fileIn.getGlobalAttributes();
        for (Attribute att : glist) {
            String useName = N3iosp.makeValidNetcdfObjectName(att.getName());
            Attribute useAtt = att.isArray() ? ncfile.addGlobalAttribute(useName, att.getValues()) : (att.isString() ? ncfile.addGlobalAttribute(useName, att.getStringValue()) : ncfile.addGlobalAttribute(useName, att.getNumericValue()));
            if (!debug) continue;
            System.out.println("add gatt= " + useAtt);
        }
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (Dimension oldD : fileIn.getDimensions()) {
            String useName = N3iosp.makeValidNetcdfObjectName(oldD.getName());
            Dimension newD = ncfile.addDimension(useName, oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isShared(), oldD.isUnlimited(), oldD.isVariableLength());
            dimHash.put(newD.getName(), newD);
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        int anonCount = 0;
        List<Variable> varlist = fileIn.getVariables();
        for (Variable oldVar : varlist) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            List<Dimension> dimvList = oldVar.getDimensions();
            for (Dimension oldD : dimvList) {
                if (!oldD.isShared()) {
                    String anonName = "anon" + anonCount;
                    ++anonCount;
                    Dimension newD = ncfile.addDimension(anonName, oldD.getLength());
                    dims.add(newD);
                    continue;
                }
                String useName = N3iosp.makeValidNetcdfObjectName(oldD.getName());
                Dimension dim = (Dimension)dimHash.get(useName);
                if (dim != null) {
                    dims.add(dim);
                    continue;
                }
                throw new IllegalStateException("Unknown dimension= " + oldD.getName());
            }
            DataType newType = oldVar.getDataType();
            if (oldVar.getDataType() == DataType.STRING) {
                Array data = oldVar.read();
                IndexIterator ii = data.getIndexIterator();
                int max_len = 0;
                while (ii.hasNext()) {
                    String s = (String)ii.getObjectNext();
                    max_len = Math.max(max_len, s.length());
                }
                String useName = N3iosp.makeValidNetcdfObjectName(oldVar.getShortName() + "_strlen");
                Dimension newD = ncfile.addDimension(useName, max_len);
                dims.add(newD);
                newType = DataType.CHAR;
            }
            String varName = N3iosp.makeValidNetcdfObjectName(oldVar.getShortName());
            Variable v = ncfile.addVariable(varName, newType, dims);
            if (debug) {
                System.out.println("add var= " + v);
            }
            List<Attribute> attList = oldVar.getAttributes();
            for (Attribute att : attList) {
                String useName = N3iosp.makeValidNetcdfObjectName(att.getName());
                if (att.isArray()) {
                    ncfile.addVariableAttribute(varName, useName, att.getValues());
                    continue;
                }
                if (att.isString()) {
                    ncfile.addVariableAttribute(varName, useName, att.getStringValue());
                    continue;
                }
                ncfile.addVariableAttribute(varName, useName, att.getNumericValue());
            }
        }
        if (anonCount > 0) {
            ncfile.finish();
        }
        ncfile.create();
        if (debug) {
            System.out.println("File Out= " + ncfile.toString());
        }
        if (fileIn.hasUnlimitedDimension()) {
            fileIn.sendIospMessage("AddRecordStructure");
            ncfile.sendIospMessage("AddRecordStructure");
        }
        boolean useRecordDimension = FileWriter.hasRecordStructure(fileIn) && FileWriter.hasRecordStructure(ncfile);
        Structure recordVar = useRecordDimension ? (Structure)fileIn.findVariable("record") : null;
        double total = FileWriter.copyVarData(ncfile, varlist, recordVar, progressListeners);
        ncfile.flush();
        if (debug) {
            System.out.println("FileWriter done total bytes = " + total);
        }
        fileIn.sendIospMessage("RemoveRecordStructure");
        return ncfile;
    }

    private static boolean hasRecordStructure(NetcdfFile file) {
        Variable v = file.findVariable("record");
        return v != null && v.getDataType() == DataType.STRUCTURE;
    }

    public static double copyVarData(NetcdfFileWriteable ncfile, List<Variable> varlist, Structure recordVar, List<FileWriterProgressListener> progressListeners) throws IOException {
        boolean useRecordDimension = recordVar != null;
        double total = 0.0;
        for (Variable oldVar : varlist) {
            if (useRecordDimension && oldVar.isUnlimited() || oldVar == recordVar) continue;
            if (debug) {
                System.out.println("write var= " + oldVar.getShortName() + " size = " + oldVar.getSize() + " type=" + (Object)((Object)oldVar.getDataType()));
            }
            long size = oldVar.getSize() * (long)oldVar.getElementSize();
            total += (double)size;
            long maxSize = 50000000L;
            if (size <= maxSize) {
                FileWriter.copyAll(ncfile, oldVar);
                continue;
            }
            FileWriter.copySome(ncfile, oldVar, maxSize, progressListeners);
        }
        if (useRecordDimension) {
            int[] origin = new int[]{0};
            int[] size = new int[]{1};
            int nrecs = (int)recordVar.getSize();
            int sdataSize = recordVar.getElementSize();
            double totalRecordBytes = 0.0;
            for (int count = 0; count < nrecs; ++count) {
                block8: {
                    origin[0] = count;
                    try {
                        Array recordData = recordVar.read(origin, size);
                        ncfile.write("record", origin, recordData);
                        if (!debug || count != 0) break block8;
                        System.out.println("write record size = " + sdataSize);
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                totalRecordBytes += (double)sdataSize;
            }
            total += totalRecordBytes;
            totalRecordBytes /= 1000000.0;
            if (debug) {
                System.out.println("write record var; total = " + totalRecordBytes + " Mbytes # recs=" + nrecs);
            }
        }
        return total;
    }

    private static void copyAll(NetcdfFileWriteable ncfile, Variable oldVar) throws IOException {
        String newName = N3iosp.makeValidNetcdfObjectName(oldVar.getShortName());
        newName = NetcdfFile.escapeName(newName);
        Array data = oldVar.read();
        try {
            if (oldVar.getDataType() == DataType.STRING) {
                data = FileWriter.convertToChar(ncfile.findVariable(newName), data);
            }
            if (data.getSize() > 0L) {
                ncfile.write(newName, data);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage() + " for Variable " + oldVar.getFullName());
        }
    }

    private static void copySome(NetcdfFileWriteable ncfile, Variable oldVar, long maxChunkSize, List<FileWriterProgressListener> progressListeners) throws IOException {
        String newName = N3iosp.makeValidNetcdfObjectName(oldVar.getShortName());
        long maxChunkElems = maxChunkSize / (long)oldVar.getElementSize();
        long byteWriteTotal = 0L;
        FileWriterProgressEvent writeProgressEvent = new FileWriterProgressEvent();
        writeProgressEvent.setStatus("Variable: " + oldVar.getShortName());
        if (progressListeners != null) {
            for (FileWriterProgressListener listener : progressListeners) {
                listener.writeStatus(writeProgressEvent);
            }
        }
        ChunkingIndex index = new ChunkingIndex(oldVar.getShape());
        while ((long)index.currentElement() < index.getSize()) {
            try {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                writeProgressEvent.setWriteStatus("Reading chunk from variable: " + oldVar.getShortName());
                if (progressListeners != null) {
                    for (FileWriterProgressListener listener : progressListeners) {
                        listener.writeProgress(writeProgressEvent);
                    }
                }
                Array data = oldVar.read(chunkOrigin, chunkShape);
                if (oldVar.getDataType() == DataType.STRING) {
                    data = FileWriter.convertToChar(ncfile.findVariable(newName), data);
                }
                if (data.getSize() > 0L) {
                    writeProgressEvent.setWriteStatus("Writing chunk of variable: " + oldVar.getShortName());
                    writeProgressEvent.setBytesToWrite(data.getSize());
                    if (progressListeners != null) {
                        for (FileWriterProgressListener listener : progressListeners) {
                            listener.writeProgress(writeProgressEvent);
                        }
                    }
                    ncfile.write(newName, chunkOrigin, data);
                    if (debugWrite) {
                        System.out.println(" write " + data.getSize() + " bytes at " + new Section(chunkOrigin, chunkShape));
                    }
                    writeProgressEvent.setBytesWritten(byteWriteTotal += data.getSize());
                    writeProgressEvent.setProgressPercent(100.0 * (double)byteWriteTotal / (double)oldVar.getSize());
                    if (progressListeners != null) {
                        for (FileWriterProgressListener listener : progressListeners) {
                            listener.writeProgress(writeProgressEvent);
                        }
                    }
                }
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    private static Array convertToChar(Variable newVar, Array oldData) {
        ArrayChar newData = (ArrayChar)Array.factory(DataType.CHAR, newVar.getShape());
        Index ima = newData.getIndex();
        IndexIterator ii = oldData.getIndexIterator();
        while (ii.hasNext()) {
            String s = (String)ii.getObjectNext();
            int[] c = ii.getCurrentCounter();
            for (int i = 0; i < c.length; ++i) {
                ima.setDim(i, c[i]);
            }
            newData.setString(ima, s);
        }
        return newData;
    }

    public FileWriter(String fileOutName, boolean fill) throws IOException {
        this(fileOutName, fill, false, -1);
    }

    public FileWriter(String fileOutName, boolean fill, boolean isLargeFile, int extraHeaderBytes) throws IOException {
        this.ncfile = NetcdfFileWriteable.createNew(fileOutName, fill);
        if (isLargeFile) {
            this.ncfile.setLargeFile(isLargeFile);
        }
        if (extraHeaderBytes > 0) {
            this.ncfile.setExtraHeaderBytes(extraHeaderBytes);
        }
    }

    public NetcdfFileWriteable getNetcdf() {
        return this.ncfile;
    }

    public void writeGlobalAttribute(Attribute att) {
        String useName = N3iosp.makeValidNetcdfObjectName(att.getName());
        if (att.isArray()) {
            this.ncfile.addGlobalAttribute(useName, att.getValues());
        } else if (att.isString()) {
            this.ncfile.addGlobalAttribute(useName, att.getStringValue());
        } else {
            this.ncfile.addGlobalAttribute(useName, att.getNumericValue());
        }
    }

    public void writeAttribute(String varName, Attribute att) {
        String attName = N3iosp.makeValidNetcdfObjectName(att.getName());
        varName = N3iosp.makeValidNetcdfObjectName(varName);
        if (att.isArray()) {
            this.ncfile.addVariableAttribute(varName, attName, att.getValues());
        } else if (att.isString()) {
            this.ncfile.addVariableAttribute(varName, attName, att.getStringValue());
        } else {
            this.ncfile.addVariableAttribute(varName, attName, att.getNumericValue());
        }
    }

    public Dimension writeDimension(Dimension dim) {
        String useName = N3iosp.makeValidNetcdfObjectName(dim.getName());
        Dimension newDim = this.ncfile.addDimension(useName, dim.isUnlimited() ? 0 : dim.getLength(), dim.isShared(), dim.isUnlimited(), dim.isVariableLength());
        this.dimHash.put(useName, newDim);
        if (debug) {
            System.out.println("write dim= " + newDim);
        }
        return newDim;
    }

    public void writeVariable(Variable oldVar) {
        Dimension[] dims = new Dimension[oldVar.getRank()];
        List<Dimension> dimvList = oldVar.getDimensions();
        for (int j = 0; j < dimvList.size(); ++j) {
            Dimension oldD = dimvList.get(j);
            Dimension newD = this.dimHash.get(N3iosp.makeValidNetcdfObjectName(oldD.getName()));
            if (null == newD) {
                newD = this.writeDimension(oldD);
                this.dimHash.put(newD.getName(), newD);
            }
            dims[j] = newD;
        }
        String useName = N3iosp.makeValidNetcdfObjectName(oldVar.getShortName());
        if (oldVar.getDataType() == DataType.STRING) {
            try {
                int max_strlen = 0;
                ArrayObject data = (ArrayObject)oldVar.read();
                IndexIterator ii = data.getIndexIterator();
                while (ii.hasNext()) {
                    String s = (String)ii.next();
                    max_strlen = Math.max(max_strlen, s.length());
                }
                this.ncfile.addStringVariable(useName, Arrays.asList(dims), max_strlen);
            }
            catch (IOException ioe) {
                log.error("Error reading String variable " + oldVar, (Throwable)ioe);
                return;
            }
        } else {
            this.ncfile.addVariable(useName, oldVar.getDataType(), dims);
        }
        this.varList.add(oldVar);
        if (debug) {
            System.out.println("write var= " + oldVar);
        }
        List<Attribute> attList = oldVar.getAttributes();
        for (Attribute att : attList) {
            this.writeAttribute(useName, att);
        }
    }

    public void writeVariables(List<Variable> varList) {
        for (Variable v : varList) {
            this.writeVariable(v);
        }
    }

    public void finish() throws IOException {
        this.ncfile.create();
        double total = FileWriter.copyVarData(this.ncfile, this.varList, this.recordVar, null);
        this.ncfile.close();
        if (debug) {
            System.out.println("FileWriter finish total bytes = " + total);
        }
    }

    private static void usage() {
        System.out.println("usage: ucar.nc2.FileWriter -in <fileIn> -out <fileOut> [-delay <millisecs>]");
    }

    public static double copyVarData(NetcdfFileWriteable ncfile, List<Variable> varlist, Structure recordVar, long delay) throws IOException {
        return FileWriter.copyVarData(ncfile, varlist, recordVar, null);
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName, boolean fill, int delay) throws IOException {
        return FileWriter.writeToFile(fileIn, fileOutName, fill, false, null);
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName, boolean fill, int delay, boolean isLargeFile) throws IOException {
        return FileWriter.writeToFile(fileIn, fileOutName, fill, isLargeFile, null);
    }

    public static void main(String[] arg) throws IOException {
        if (arg.length < 4) {
            FileWriter.usage();
            System.exit(0);
        }
        String datasetIn = null;
        String datasetOut = null;
        boolean delay = false;
        for (int i = 0; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-in")) {
                datasetIn = arg[i + 1];
            }
            if (!s.equalsIgnoreCase("-out")) continue;
            datasetOut = arg[i + 1];
        }
        if (datasetIn == null || datasetOut == null) {
            FileWriter.usage();
            System.exit(0);
        }
        NetcdfFile ncfileIn = NetcdfFile.open(datasetIn, null);
        NetcdfFile ncfileOut = FileWriter.writeToFile(ncfileIn, datasetOut, false, false, null);
        ncfileIn.close();
        ncfileOut.close();
        System.out.println("NetcdfFile written = " + ncfileOut);
    }

    public static interface FileWriterProgressListener {
        public void writeProgress(FileWriterProgressEvent var1);

        public void writeStatus(FileWriterProgressEvent var1);
    }

    public static class FileWriterProgressEvent {
        private double progressPercent;
        private long bytesWritten;
        private long bytesToWrite;
        private String status;
        private String writeStatus;

        public void setProgressPercent(double progressPercent) {
            this.progressPercent = progressPercent;
        }

        public double getProgressPercent() {
            return this.progressPercent;
        }

        public void setBytesWritten(long bytesWritten) {
            this.bytesWritten = bytesWritten;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public void setBytesToWrite(long bytesToWrite) {
            this.bytesToWrite = bytesToWrite;
        }

        public long getBytesToWrite() {
            return this.bytesToWrite;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setWriteStatus(String writeStatus) {
            this.writeStatus = writeStatus;
        }

        public String getWriteStatus() {
            return this.writeStatus;
        }
    }

    public static class ChunkingIndex
    extends Index {
        public ChunkingIndex(int[] shape) {
            super(shape);
        }

        public int[] computeChunkShape(long maxChunkElems) {
            int[] chunkShape = new int[this.rank];
            for (int iDim = 0; iDim < this.rank; ++iDim) {
                int size = (int)(maxChunkElems / (long)this.stride[iDim]);
                size = size == 0 ? 1 : size;
                chunkShape[iDim] = size = Math.min(size, this.shape[iDim] - this.current[iDim]);
            }
            return chunkShape;
        }
    }
}

