/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.fmrc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.ServiceType;
import thredds.catalog.crawl.CatalogCrawler;
import ucar.nc2.dt.fmrc.FmrcDefinition;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.Misc;
import ucar.unidata.util.StringUtil2;

public class FmrcInventory {
    private static Logger log = LoggerFactory.getLogger(FmrcInventory.class);
    private static SimpleDateFormat dateFormatShort = new SimpleDateFormat("MM-dd HH.mm");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH.mm'Z'");
    private static boolean debug = false;
    private String name;
    private int tc_seqno = 0;
    private List<ForecastModelRunInventory.TimeCoord> timeCoords = new ArrayList<ForecastModelRunInventory.TimeCoord>();
    private int ec_seqno = 0;
    private List<ForecastModelRunInventory.EnsCoord> ensCoords = new ArrayList<ForecastModelRunInventory.EnsCoord>();
    private int vc_seqno = 0;
    private List<ForecastModelRunInventory.VertCoord> vertCoords = new ArrayList<ForecastModelRunInventory.VertCoord>();
    private int run_seqno = 0;
    private List<RunSeq> runSequences = new ArrayList<RunSeq>();
    private Map<String, UberGrid> uvHash = new HashMap<String, UberGrid>();
    private List<UberGrid> varList;
    private Set<Date> runTimeHash = new HashSet<Date>();
    private List<Date> runTimeList;
    private Set<Double> offsetHash = new HashSet<Double>();
    private List<Double> offsetList;
    private Set<Date> forecastTimeHash = new HashSet<Date>();
    private List<Date> forecastTimeList;
    private String fmrcDefinitionDir;
    private FmrcDefinition definition = null;
    private TimeMatrixDataset tmAll;
    private Calendar cal = new GregorianCalendar();
    private DateFormatter formatter = new DateFormatter();
    private static boolean debugTiming;

    FmrcInventory(String fmrcDefinitionDir, String name) throws IOException {
        this.fmrcDefinitionDir = fmrcDefinitionDir;
        int pos = name.indexOf(".fmrcDefinition.xml");
        this.name = pos > 0 ? name.substring(0, pos) : name;
        FmrcDefinition fmrc = new FmrcDefinition();
        if (fmrc.readDefinitionXML(this.getDefinitionPath())) {
            this.definition = fmrc;
        } else {
            log.warn("FmrcCollection has no Definition " + this.getDefinitionPath());
        }
        this.cal.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String getName() {
        return this.name;
    }

    public String getDefinitionPath() {
        if (this.fmrcDefinitionDir != null) {
            return this.fmrcDefinitionDir + this.name + ".fmrcDefinition.xml";
        }
        return "./" + this.name + ".fmrcDefinition.xml";
    }

    public List<ForecastModelRunInventory.TimeCoord> getTimeCoords() {
        return this.timeCoords;
    }

    public List<RunSeq> getRunSequences() {
        return this.runSequences;
    }

    public List<ForecastModelRunInventory.EnsCoord> getEnsCoords() {
        return this.ensCoords;
    }

    public List<ForecastModelRunInventory.VertCoord> getVertCoords() {
        return this.vertCoords;
    }

    public String getSuffixFilter() {
        return this.definition == null ? null : this.definition.getSuffixFilter();
    }

    public FmrcDefinition getDefinition() {
        return this.definition;
    }

    void addRun(ForecastModelRunInventory fmr) {
        if (debug) {
            System.out.println(" Adding ForecastModelRun " + fmr.getRunDateString());
        }
        this.runTimeHash.add(fmr.getRunDate());
        for (ForecastModelRunInventory.TimeCoord tc : fmr.getTimeCoords()) {
            ForecastModelRunInventory.TimeCoord tcUse = this.findTime(tc);
            if (tcUse == null) {
                this.timeCoords.add(tc);
                tcUse = tc;
                tc.setId(Integer.toString(this.tc_seqno));
                ++this.tc_seqno;
            }
            Run run = new Run(fmr.getRunDate(), tcUse);
            for (double offset : tcUse.getOffsetHours()) {
                Date fcDate = this.addHour(fmr.getRunDate(), offset);
                Inventory inv = new Inventory(fmr.getRunDate(), fcDate, offset);
                run.invList.add(inv);
                this.forecastTimeHash.add(fcDate);
                this.offsetHash.add(offset);
            }
            for (ForecastModelRunInventory.Grid grid : tc.getGrids()) {
                UberGrid uv = this.uvHash.get(grid.name);
                if (uv == null) {
                    if (this.definition != null && null == this.definition.findSeqForVariable(grid.name)) {
                        log.warn("FmrcCollection Definition " + this.name + " does not contain variable " + grid.name);
                        continue;
                    }
                    uv = new UberGrid(grid.name);
                    this.uvHash.put(grid.name, uv);
                }
                uv.addRun(run, grid);
            }
        }
    }

    void finish() {
        this.varList = new ArrayList<UberGrid>(this.uvHash.values());
        Collections.sort(this.varList);
        this.runTimeList = Arrays.asList(this.runTimeHash.toArray(new Date[this.runTimeHash.size()]));
        Collections.sort(this.runTimeList);
        this.forecastTimeList = Arrays.asList(this.forecastTimeHash.toArray(new Date[this.forecastTimeHash.size()]));
        Collections.sort(this.forecastTimeList);
        this.offsetList = Arrays.asList(this.offsetHash.toArray(new Double[this.offsetHash.size()]));
        Collections.sort(this.offsetList);
        for (UberGrid uv : this.varList) {
            uv.finish();
            uv.seq = this.findRunSequence(uv.runs);
            uv.seq.addVariable(uv);
        }
    }

    private UberGrid findVar(String varName) {
        for (UberGrid uv : this.varList) {
            if (!uv.name.equals(varName)) continue;
            return uv;
        }
        return null;
    }

    private RunSeq findRunSequence(List<RunExpected> runs) {
        for (RunSeq seq : this.runSequences) {
            if (!seq.equalsData(runs)) continue;
            return seq;
        }
        RunSeq seq = new RunSeq(runs);
        this.runSequences.add(seq);
        return seq;
    }

    private ForecastModelRunInventory.TimeCoord findTime(ForecastModelRunInventory.TimeCoord want) {
        for (ForecastModelRunInventory.TimeCoord tc : this.timeCoords) {
            if (!want.equalsData(tc)) continue;
            return tc;
        }
        return null;
    }

    private ForecastModelRunInventory.EnsCoord findEnsCoord(ForecastModelRunInventory.EnsCoord want) {
        for (ForecastModelRunInventory.EnsCoord ec : this.ensCoords) {
            if (!want.equalsData(ec)) continue;
            return ec;
        }
        return null;
    }

    private ForecastModelRunInventory.VertCoord findVertCoord(ForecastModelRunInventory.VertCoord want) {
        for (ForecastModelRunInventory.VertCoord vc : this.vertCoords) {
            if (!want.equalsData(vc)) continue;
            return vc;
        }
        return null;
    }

    private Date addHour(Date d, double hour) {
        this.cal.setTime(d);
        int ihour = (int)hour;
        int imin = (int)(hour - (double)ihour) * 60;
        this.cal.add(11, ihour);
        this.cal.add(12, imin);
        return this.cal.getTime();
    }

    private double getOffsetHour(Date run, Date forecast) {
        double diff = forecast.getTime() - run.getTime();
        return diff / 1000.0 / 60.0 / 60.0;
    }

    public String writeMatrixXML(String varName) {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        if (varName == null) {
            return fmt.outputString(this.makeMatrixDocument());
        }
        return fmt.outputString(this.makeMatrixDocument(varName));
    }

    public void writeMatrixXML(String varName, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        if (varName == null) {
            fmt.output(this.makeMatrixDocument(), os);
        } else {
            fmt.output(this.makeMatrixDocument(varName), os);
        }
    }

    public Document makeMatrixDocument() {
        if (this.tmAll == null) {
            this.tmAll = new TimeMatrixDataset();
        }
        Element rootElem = new Element("forecastModelRunCollectionInventory");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("dataset", this.name);
        for (Double offset : this.offsetList) {
            Element offsetElem = new Element("offsetTime");
            rootElem.addContent((Content)offsetElem);
            offsetElem.setAttribute("hours", offset.toString());
        }
        for (UberGrid uv : this.varList) {
            Element varElem = new Element("variable");
            rootElem.addContent((Content)varElem);
            varElem.setAttribute("name", uv.name);
            this.addCountPercent(uv.countInv, uv.countExpected, varElem, false);
        }
        for (int i = this.runTimeList.size() - 1; i >= 0; --i) {
            Element runElem = new Element("run");
            rootElem.addContent((Content)runElem);
            Date runTime = this.runTimeList.get(i);
            runElem.setAttribute("date", dateFormat.format(runTime));
            this.addCountPercent(this.tmAll.countTotalRunInv[i], this.tmAll.expectedTotalRun[i], runElem, true);
            for (int k = 0; k < this.offsetList.size(); ++k) {
                Element offsetElem = new Element("offset");
                runElem.addContent((Content)offsetElem);
                Double offset = this.offsetList.get(k);
                offsetElem.setAttribute("hours", offset.toString());
                this.addCountPercent(this.tmAll.countOffsetInv[i][k], this.tmAll.expectedOffset[i][k], offsetElem, false);
            }
        }
        for (int k = this.forecastTimeList.size() - 1; k >= 0; --k) {
            Element fcElem = new Element("forecastTime");
            rootElem.addContent((Content)fcElem);
            Date ftime = this.forecastTimeList.get(k);
            fcElem.setAttribute("date", dateFormat.format(ftime));
            for (int j = this.runTimeList.size() - 1; j >= 0; --j) {
                Element rtElem = new Element("runTime");
                fcElem.addContent((Content)rtElem);
                this.addCountPercent(this.tmAll.countInv[k][j], this.tmAll.expected[k][j], rtElem, false);
            }
        }
        return doc;
    }

    private void addCountPercent(int have, int want, Element elem, boolean always) {
        if ((have == want || want == 0) && have != 0) {
            elem.setAttribute("count", Integer.toString(have));
            if (always) {
                elem.setAttribute("percent", "100");
            }
        } else if (want != 0) {
            int percent = (int)(100.0 * (double)have / (double)want);
            elem.setAttribute("count", have + "/" + want);
            elem.setAttribute("percent", Integer.toString(percent));
        }
    }

    public Document makeMatrixDocument(String varName) {
        int expected;
        int missing;
        double hourOffset;
        int k;
        UberGrid uv = this.findVar(varName);
        if (uv == null) {
            throw new IllegalArgumentException("No variable named = " + varName);
        }
        Element rootElem = new Element("forecastModelRunCollectionInventory");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("dataset", this.name);
        rootElem.setAttribute("variable", uv.name);
        for (k = 0; k < this.offsetList.size(); ++k) {
            Element offsetElem = new Element("offsetTime");
            rootElem.addContent((Content)offsetElem);
            Double offset = this.offsetList.get(k);
            offsetElem.setAttribute("hour", offset.toString());
        }
        for (int i = this.runTimeList.size() - 1; i >= 0; --i) {
            Element runElem = new Element("run");
            rootElem.addContent((Content)runElem);
            Date runTime = this.runTimeList.get(i);
            runElem.setAttribute("date", dateFormat.format(runTime));
            RunExpected rune = uv.findRun(runTime);
            for (Double offset : this.offsetList) {
                Element offsetElem = new Element("offset");
                runElem.addContent((Content)offsetElem);
                hourOffset = offset;
                offsetElem.setAttribute("hour", offset.toString());
                missing = rune.countInventory(hourOffset);
                expected = rune.countExpected(hourOffset);
                this.addCountPercent(missing, expected, offsetElem, false);
            }
        }
        for (k = this.forecastTimeList.size() - 1; k >= 0; --k) {
            Element fcElem = new Element("forecastTime");
            rootElem.addContent((Content)fcElem);
            Date forecastTime = this.forecastTimeList.get(k);
            fcElem.setAttribute("date", dateFormat.format(forecastTime));
            for (int j = this.runTimeList.size() - 1; j >= 0; --j) {
                Element rtElem = new Element("runTime");
                fcElem.addContent((Content)rtElem);
                Date runTime = this.runTimeList.get(j);
                RunExpected rune = uv.findRun(runTime);
                hourOffset = this.getOffsetHour(runTime, forecastTime);
                missing = rune.countInventory(hourOffset);
                expected = rune.countExpected(hourOffset);
                this.addCountPercent(missing, expected, rtElem, false);
            }
        }
        return doc;
    }

    public String showOffsetHour(String varName, String offsetHour) {
        int j;
        double[] vcoords;
        UberGrid uv = this.findVar(varName);
        if (uv == null) {
            return "No variable named = " + varName;
        }
        double hour = Double.parseDouble(offsetHour);
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Inventory for ").append(varName).append(" for offset hour= ").append(offsetHour).append("\n");
        for (RunExpected rune : uv.runs) {
            vcoords = rune.grid.getVertCoords(hour);
            sbuff.append(" Run ");
            sbuff.append(this.formatter.toDateTimeString(rune.run.runTime));
            sbuff.append(": ");
            for (j = 0; j < vcoords.length; ++j) {
                if (j > 0) {
                    sbuff.append(",");
                }
                sbuff.append(vcoords[j]);
            }
            sbuff.append("\n");
        }
        sbuff.append("\nExpected for ").append(varName).append(" for offset hour= ").append(offsetHour).append("\n");
        for (RunExpected rune : uv.runs) {
            vcoords = rune.expectedGrid.getVertCoords(hour);
            sbuff.append(" Run ");
            sbuff.append(this.formatter.toDateTimeString(rune.run.runTime));
            sbuff.append(": ");
            for (j = 0; j < vcoords.length; ++j) {
                if (j > 0) {
                    sbuff.append(",");
                }
                sbuff.append(vcoords[j]);
            }
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    public static FmrcInventory makeFromDirectory(String fmrcDefinitionPath, String collectionName, DiskCache2 fmr_cache, String dirName, String suffix, int mode) throws Exception {
        File dir;
        File[] files;
        long startTime = System.currentTimeMillis();
        FmrcInventory fmrCollection = new FmrcInventory(fmrcDefinitionPath, collectionName);
        if (fmrCollection.getSuffixFilter() != null) {
            suffix = fmrCollection.getSuffixFilter();
        }
        if (null == (files = (dir = new File(dirName)).listFiles())) {
            return null;
        }
        for (File file : files) {
            ForecastModelRunInventory fmr;
            if (!file.getPath().endsWith(suffix) || null == (fmr = ForecastModelRunInventory.open(fmr_cache, file.getPath(), mode, true))) continue;
            fmrCollection.addRun(fmr);
        }
        fmrCollection.finish();
        if (debugTiming) {
            long took = System.currentTimeMillis() - startTime;
            System.out.println("that took = " + took + " msecs");
        }
        return fmrCollection;
    }

    public static void main2(String[] args) throws Exception {
        String dir = "nam/c20s";
        FmrcInventory fmrc = FmrcInventory.makeFromDirectory("R:/testdata/motherlode/grid/inv/new/", "NCEP-NAM-CONUS_20km-surface", null, "C:/data/grib/" + dir, "grib1", 2);
        FmrcDefinition def = fmrc.getDefinition();
        if (null != def) {
            System.out.println("current definition = " + fmrc.getDefinitionPath());
            System.out.println(def.writeDefinitionXML());
        } else {
            System.out.println("write definition to " + fmrc.getDefinitionPath());
            def = new FmrcDefinition();
            def.makeFromCollectionInventory(fmrc);
            FileOutputStream fos = new FileOutputStream(fmrc.getDefinitionPath());
            System.out.println(def.writeDefinitionXML());
            def.writeDefinitionXML(fos);
        }
        String varName = "Temperature";
        System.out.println(fmrc.writeMatrixXML(varName));
        FileOutputStream fos = new FileOutputStream("C:/data/grib/" + dir + "/fmrcMatrix.xml");
        fmrc.writeMatrixXML(varName, fos);
        System.out.println(fmrc.writeMatrixXML(null));
        FileOutputStream fos2 = new FileOutputStream("C:/data/grib/" + dir + "/fmrcMatrixAll.xml");
        fmrc.writeMatrixXML(null, fos2);
        System.out.println(fmrc.showOffsetHour(varName, "7.0"));
    }

    public static void main(String[] args) throws Exception {
        for (String cat : FmrcDefinition.fmrcDatasets) {
            if (cat.contains("/RUC")) {
                FmrcInventory.doOne(cat, 72);
                continue;
            }
            FmrcInventory.doOne(cat, 12);
        }
    }

    public static void doOne(String cat, int n) throws Exception {
        String server = "http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/";
        String writeDir = "D:/temp/modelDef/";
        new File(writeDir).mkdirs();
        String catName = server + cat + "/files/catalog.xml";
        FmrcInventory fmrCollection = FmrcInventory.makeFromCatalog(null, catName, catName, n, 2);
        String writeFile = writeDir + StringUtil2.replace(cat, "/", "-") + ".fmrcDefinition.xml";
        System.out.println("write definition to " + writeFile);
        FmrcDefinition def = new FmrcDefinition();
        def.makeFromCollectionInventory(fmrCollection);
        FileOutputStream fos = new FileOutputStream(writeFile);
        def.writeDefinitionXML(fos);
        fos.close();
    }

    public static void writeDefinitionFromCatalog(String catURL, String collectionName, int maxDatasets) throws Exception {
        FmrcInventory fmrCollection = FmrcInventory.makeFromCatalog(catURL, collectionName, maxDatasets, 1);
        System.out.println("write definition to " + fmrCollection.getDefinitionPath());
        FmrcDefinition def = new FmrcDefinition();
        def.makeFromCollectionInventory(fmrCollection);
        FileOutputStream fos = new FileOutputStream(fmrCollection.getDefinitionPath());
        def.writeDefinitionXML(fos);
    }

    public static FmrcInventory makeFromCatalog(String catURL, String collectionName, int maxDatasets, int mode) throws Exception {
        DiskCache2 cache = new DiskCache2("fmrcInventory/", true, 0, -1);
        return FmrcInventory.makeFromCatalog(cache, catURL, collectionName, maxDatasets, mode);
    }

    public static FmrcInventory makeFromCatalog(DiskCache2 cache, String catURL, String collectionName, int maxDatasets, int mode) throws Exception {
        String fmrcDefinitionPath = cache == null ? null : cache.getRootDirectory() + "/defs/";
        System.out.println("***makeFromCatalog " + catURL);
        long startTime = System.currentTimeMillis();
        FmrcInventory fmrCollection = new FmrcInventory(fmrcDefinitionPath, collectionName);
        CatalogCrawler crawler = new CatalogCrawler(1, false, (CatalogCrawler.Listener)new MyListener(fmrCollection, maxDatasets, mode, cache));
        crawler.crawl(catURL, null, System.out, null);
        fmrCollection.finish();
        if (debugTiming) {
            long took = System.currentTimeMillis() - startTime;
            System.out.println("that took = " + took + " msecs");
        }
        return fmrCollection;
    }

    public static void main4(String[] args) throws Exception {
        String dir = "nam/conus80";
        FmrcInventory fmrc = FmrcInventory.makeFromDirectory("C:/temp", "NCEP-NAM-CONUS_80km", null, "C:/data/grib/" + dir, "grib1", 2);
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormatShort.setTimeZone(TimeZone.getTimeZone("GMT"));
        debugTiming = false;
    }

    private static class MyListener
    implements CatalogCrawler.Listener {
        FmrcInventory fmrCollection;
        DiskCache2 cache;
        int maxDatasets;
        int mode;
        int count;
        boolean first = true;

        MyListener(FmrcInventory fmrCollection, int maxDatasets, int mode, DiskCache2 cache) {
            this.fmrCollection = fmrCollection;
            this.maxDatasets = maxDatasets;
            this.mode = mode;
            this.count = 0;
            this.cache = cache;
        }

        @Override
        public void getDataset(InvDataset dd, Object context) {
            if (this.count > this.maxDatasets && this.maxDatasets > 0) {
                return;
            }
            InvAccess access = dd.getAccess(ServiceType.OPENDAP);
            if (access == null) {
                System.out.println(" no opendap access");
                return;
            }
            if (this.first) {
                System.out.println(" skip " + access.getStandardUrlName());
                this.first = false;
                return;
            }
            ++this.count;
            System.out.println(" access " + access.getStandardUrlName());
            try {
                ForecastModelRunInventory fmr = ForecastModelRunInventory.open(this.cache, access.getStandardUrlName(), this.mode, false);
                if (null != fmr) {
                    this.fmrCollection.addRun(fmr);
                    fmr.releaseDataset();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }

        @Override
        public boolean getCatalogRef(InvCatalogRef dd, Object context) {
            return true;
        }
    }

    private class TimeMatrixDataset {
        private int ntimes;
        private int nruns;
        private int noffsets;
        private short[][] countInv;
        private short[][] expected;
        private short[][] countOffsetInv;
        private short[][] expectedOffset;
        private int[] countTotalRunInv;
        private int[] expectedTotalRun;

        TimeMatrixDataset() {
            this.nruns = FmrcInventory.this.runTimeList.size();
            this.ntimes = FmrcInventory.this.forecastTimeList.size();
            this.noffsets = FmrcInventory.this.offsetList.size();
            this.countInv = new short[this.ntimes][this.nruns];
            this.expected = new short[this.ntimes][this.nruns];
            this.countOffsetInv = new short[this.nruns][this.noffsets];
            this.expectedOffset = new short[this.nruns][this.noffsets];
            for (UberGrid uv : FmrcInventory.this.varList) {
                this.addInventory(uv);
            }
            this.countTotalRunInv = new int[this.nruns];
            this.expectedTotalRun = new int[this.nruns];
            for (int i = 0; i < this.nruns; ++i) {
                for (int j = 0; j < this.noffsets; ++j) {
                    int n = i;
                    this.countTotalRunInv[n] = this.countTotalRunInv[n] + this.countOffsetInv[i][j];
                    int n2 = i;
                    this.expectedTotalRun[n2] = this.expectedTotalRun[n2] + this.expectedOffset[i][j];
                }
            }
        }

        void addInventory(UberGrid uv) {
            uv.countInv = 0;
            uv.countExpected = 0;
            for (int runIndex = 0; runIndex < FmrcInventory.this.runTimeList.size(); ++runIndex) {
                Date runTime = (Date)FmrcInventory.this.runTimeList.get(runIndex);
                RunExpected rune = uv.findRun(runTime);
                if (rune == null) continue;
                int offsetIndex = 0;
                while (offsetIndex < FmrcInventory.this.offsetList.size()) {
                    double hourOffset = (Double)FmrcInventory.this.offsetList.get(offsetIndex);
                    int invCount = rune.countInventory(hourOffset);
                    int expectedCount = rune.countExpected(hourOffset);
                    Date forecastTime = FmrcInventory.this.addHour(runTime, hourOffset);
                    int forecastIndex = this.findForecastIndex(forecastTime);
                    if (forecastIndex < 0) {
                        log.debug("No Forecast for runTime=" + FmrcInventory.this.formatter.toDateTimeString(runTime) + " OffsetHour=" + hourOffset + " dataset=" + FmrcInventory.this.name);
                    } else {
                        short[] sArray = this.countInv[forecastIndex];
                        int n = runIndex;
                        sArray[n] = (short)(sArray[n] + invCount);
                        short[] sArray2 = this.expected[forecastIndex];
                        int n2 = runIndex;
                        sArray2[n2] = (short)(sArray2[n2] + expectedCount);
                    }
                    short[] sArray = this.countOffsetInv[runIndex];
                    int n = offsetIndex;
                    sArray[n] = (short)(sArray[n] + invCount);
                    short[] sArray3 = this.expectedOffset[runIndex];
                    int n3 = offsetIndex++;
                    sArray3[n3] = (short)(sArray3[n3] + expectedCount);
                    uv.countInv += invCount;
                    uv.countExpected += expectedCount;
                }
            }
        }

        int findRunIndex(Date runTime) {
            for (int i = 0; i < FmrcInventory.this.runTimeList.size(); ++i) {
                Date d = (Date)FmrcInventory.this.runTimeList.get(i);
                if (!d.equals(runTime)) continue;
                return i;
            }
            return -1;
        }

        int findForecastIndex(Date forecastTime) {
            for (int i = 0; i < FmrcInventory.this.forecastTimeList.size(); ++i) {
                Date d = (Date)FmrcInventory.this.forecastTimeList.get(i);
                if (!d.equals(forecastTime)) continue;
                return i;
            }
            return -1;
        }

        int findOffsetIndex(double offsetHour) {
            for (int i = 0; i < FmrcInventory.this.offsetList.size(); ++i) {
                if (offsetHour != (Double)FmrcInventory.this.offsetList.get(i)) continue;
                return i;
            }
            return -1;
        }
    }

    class RunExpected
    implements Comparable {
        Run run;
        ForecastModelRunInventory.Grid grid;
        ForecastModelRunInventory.TimeCoord expected;
        FmrcDefinition.Grid expectedGrid;

        RunExpected(Run run, ForecastModelRunInventory.TimeCoord expected, ForecastModelRunInventory.Grid grid, FmrcDefinition.Grid expectedGrid) {
            this.run = run;
            this.expected = expected;
            this.grid = grid;
            this.expectedGrid = expectedGrid;
        }

        public int compareTo(Object o) {
            RunExpected other = (RunExpected)o;
            return this.run.runTime.compareTo(other.run.runTime);
        }

        int countInventory(double hourOffset) {
            boolean hasExpected = this.expected != null && this.expected.findIndex(hourOffset) >= 0;
            return hasExpected ? this.grid.countInventory(hourOffset) : 0;
        }

        int countExpected(double hourOffset) {
            if (this.expected != null) {
                boolean hasExpected = this.expected.findIndex(hourOffset) >= 0;
                return hasExpected ? this.expectedGrid.countVertCoords(hourOffset) : 0;
            }
            return this.grid.countTotal();
        }
    }

    class LevelCoord
    implements Comparable {
        double mid;
        double value1;
        double value2;

        LevelCoord(double value1, double value2) {
            this.value1 = value1;
            this.value2 = value2;
            this.mid = value2 == 0.0 ? value1 : (value1 + value2) / 2.0;
        }

        public int compareTo(Object o) {
            LevelCoord other = (LevelCoord)o;
            if (this.mid < other.mid) {
                return -1;
            }
            if (this.mid > other.mid) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof LevelCoord)) {
                return false;
            }
            LevelCoord other = (LevelCoord)oo;
            return Misc.closeEnough(this.value1, other.value1) && Misc.closeEnough(this.value2, other.value2);
        }

        public int hashCode() {
            return (int)(this.value1 * 100000.0 + this.value2 * 100.0);
        }
    }

    class UberGrid
    implements Comparable {
        String name;
        List<RunExpected> runs = new ArrayList<RunExpected>();
        ForecastModelRunInventory.VertCoord vertCoordUnion = null;
        ForecastModelRunInventory.EnsCoord ensCoordUnion = null;
        int countInv;
        int countExpected;
        RunSeq seq;
        FmrcDefinition.RunSeq expectedSeq;
        FmrcDefinition.Grid expectedGrid;

        UberGrid(String name) {
            this.name = name;
            if (FmrcInventory.this.definition != null) {
                this.expectedSeq = FmrcInventory.this.definition.findSeqForVariable(name);
                this.expectedGrid = this.expectedSeq.findGrid(name);
            }
        }

        String getName() {
            return this.name;
        }

        void addRun(Run run, ForecastModelRunInventory.Grid grid) {
            ForecastModelRunInventory.TimeCoord xtc = this.expectedSeq == null ? null : this.expectedSeq.findTimeCoordByRuntime(run.runTime);
            RunExpected rune = new RunExpected(run, xtc, grid, this.expectedGrid);
            this.runs.add(rune);
            if (rune.expected != null) {
                for (double offset : rune.expected.getOffsetHours()) {
                    Date fcDate = FmrcInventory.this.addHour(run.runTime, offset);
                    FmrcInventory.this.forecastTimeHash.add(fcDate);
                    FmrcInventory.this.offsetHash.add(offset);
                }
            }
        }

        void finish() {
            Collections.sort(this.runs);
            ArrayList<ForecastModelRunInventory.EnsCoord> eextendList = new ArrayList<ForecastModelRunInventory.EnsCoord>();
            ForecastModelRunInventory.EnsCoord ec_union = null;
            for (RunExpected rune : this.runs) {
                ForecastModelRunInventory.EnsCoord ec = rune.grid.ec;
                if (ec == null) continue;
                if (ec_union == null) {
                    ec_union = new ForecastModelRunInventory.EnsCoord(ec);
                    continue;
                }
                if (ec_union.equalsData(ec)) continue;
                eextendList.add(ec);
            }
            if (ec_union != null) {
                this.normalize(ec_union, eextendList);
                this.ensCoordUnion = FmrcInventory.this.findEnsCoord(ec_union);
                if (this.ensCoordUnion == null) {
                    FmrcInventory.this.ensCoords.add(ec_union);
                    this.ensCoordUnion = ec_union;
                    ec_union.setId(Integer.toString(FmrcInventory.this.ec_seqno));
                    FmrcInventory.this.ec_seqno++;
                }
            }
            ArrayList<ForecastModelRunInventory.VertCoord> extendList = new ArrayList<ForecastModelRunInventory.VertCoord>();
            ForecastModelRunInventory.VertCoord vc_union = null;
            for (RunExpected rune : this.runs) {
                ForecastModelRunInventory.VertCoord vc = rune.grid.vc;
                if (vc == null) continue;
                if (vc_union == null) {
                    vc_union = new ForecastModelRunInventory.VertCoord(vc);
                    continue;
                }
                if (vc_union.equalsData(vc)) continue;
                extendList.add(vc);
            }
            if (vc_union != null) {
                this.normalize(vc_union, extendList);
                this.vertCoordUnion = FmrcInventory.this.findVertCoord(vc_union);
                if (this.vertCoordUnion == null) {
                    FmrcInventory.this.vertCoords.add(vc_union);
                    this.vertCoordUnion = vc_union;
                    vc_union.setId(Integer.toString(FmrcInventory.this.vc_seqno));
                    FmrcInventory.this.vc_seqno++;
                }
            }
        }

        public void normalize(ForecastModelRunInventory.EnsCoord result, List<ForecastModelRunInventory.EnsCoord> ecList) {
            ArrayList<ForecastModelRunInventory.EnsCoord> extra = new ArrayList<ForecastModelRunInventory.EnsCoord>();
            for (ForecastModelRunInventory.EnsCoord ec : ecList) {
                if (result.equalsData(ec)) continue;
                extra.add(ec);
            }
            if (extra.size() == 0) {
                return;
            }
            for (ForecastModelRunInventory.EnsCoord ec : extra) {
                if (ec.getNEnsembles() < result.getNEnsembles()) continue;
                result = ec;
            }
        }

        public void normalize(ForecastModelRunInventory.VertCoord result, List<ForecastModelRunInventory.VertCoord> vcList) {
            HashSet<LevelCoord> valueSet = new HashSet<LevelCoord>();
            this.addValues(valueSet, result.getValues1(), result.getValues2());
            for (ForecastModelRunInventory.VertCoord vc : vcList) {
                this.addValues(valueSet, vc.getValues1(), vc.getValues2());
            }
            List<LevelCoord> valueList = Arrays.asList(valueSet.toArray(new LevelCoord[valueSet.size()]));
            Collections.sort(valueList);
            double[] values1 = new double[valueList.size()];
            double[] values2 = new double[valueList.size()];
            boolean has_values2 = false;
            for (int i = 0; i < valueList.size(); ++i) {
                LevelCoord lc = valueList.get(i);
                values1[i] = lc.value1;
                values2[i] = lc.value2;
                if (lc.value2 == 0.0) continue;
                has_values2 = true;
            }
            result.setValues1(values1);
            if (has_values2) {
                result.setValues2(values2);
            }
        }

        private void addValues(Set<LevelCoord> valueSet, double[] values1, double[] values2) {
            for (int i = 0; i < values1.length; ++i) {
                double val2 = values2 == null ? 0.0 : values2[i];
                valueSet.add(new LevelCoord(values1[i], val2));
            }
        }

        public int compareTo(Object o) {
            UberGrid uv = (UberGrid)o;
            return this.name.compareTo(uv.name);
        }

        RunExpected findRun(Date runTime) {
            for (RunExpected rune : this.runs) {
                if (!runTime.equals(rune.run.runTime)) continue;
                return rune;
            }
            return null;
        }
    }

    class RunSeq {
        List<Run> runs;
        List<UberGrid> vars = new ArrayList<UberGrid>();
        String name;

        RunSeq(List<RunExpected> runs) {
            this.runs = new ArrayList<Run>();
            for (RunExpected rune : runs) {
                this.runs.add(rune.run);
            }
            this.name = "RunSeq" + FmrcInventory.this.run_seqno;
            FmrcInventory.this.run_seqno++;
        }

        boolean equalsData(List<RunExpected> oruns) {
            if (this.runs.size() != oruns.size()) {
                return false;
            }
            for (int i = 0; i < this.runs.size(); ++i) {
                Run run = this.runs.get(i);
                RunExpected orune = oruns.get(i);
                if (!run.runTime.equals(orune.run.runTime)) {
                    return false;
                }
                if (run.equalsData(orune.run)) continue;
                return false;
            }
            return true;
        }

        void addVariable(UberGrid uv) {
            this.vars.add(uv);
        }

        List<UberGrid> getVariables() {
            return this.vars;
        }
    }

    static class Run
    implements Comparable {
        ForecastModelRunInventory.TimeCoord tc;
        List<Inventory> invList;
        Date runTime;

        Run(Date runTime, ForecastModelRunInventory.TimeCoord tc) {
            this.runTime = runTime;
            this.tc = tc;
            this.invList = new ArrayList<Inventory>();
        }

        public int compareTo(Object o) {
            Run other = (Run)o;
            return this.runTime.compareTo(other.runTime);
        }

        public boolean equalsData(Run orun) {
            if (this.invList.size() != orun.invList.size()) {
                return false;
            }
            for (int i = 0; i < this.invList.size(); ++i) {
                Inventory inv = this.invList.get(i);
                Inventory oinv = orun.invList.get(i);
                if (inv.hourOffset == oinv.hourOffset) continue;
                return false;
            }
            return true;
        }

        double[] getOffsetHours() {
            if (this.tc != null) {
                return this.tc.getOffsetHours();
            }
            double[] result = new double[this.invList.size()];
            for (int i = 0; i < this.invList.size(); ++i) {
                Inventory inv = this.invList.get(i);
                result[i] = inv.hourOffset;
            }
            return result;
        }
    }

    private class Inventory {
        Date forecastTime;
        Date runTime;
        double hourOffset;

        Inventory(Date runTime, Date forecastTime, double hourOffset) {
            this.runTime = runTime;
            this.hourOffset = hourOffset;
            this.forecastTime = forecastTime;
        }
    }
}

