/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.jni.netcdf;

import com.sun.jna.MyPointer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.jni.netcdf.Nc4prototypes;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Nc4Iosp
extends AbstractIOServiceProvider
implements IOServiceProviderWriter {
    private static Logger log = LoggerFactory.getLogger(Nc4Iosp.class);
    private static Nc4prototypes nc4;
    private static final String JNA_PATH = "jna.library.path";
    private static String jnaPath;
    private static String libName;
    private static boolean warn;
    private static final boolean debug = false;
    private static final boolean debugCompoundAtt = false;
    private static final boolean debugUserTypes = false;
    private static final boolean debugWrite = false;
    private final NetcdfFileWriter.Version version;
    private NetcdfFile ncfile;
    private int ncid = -1;
    private int format;
    private boolean isClosed = false;
    private Map<Integer, UserType> userTypes = new HashMap<Integer, UserType>();
    private Map<Group, Integer> groupHash = new HashMap<Group, Integer>();

    public static boolean isClibraryPresent() {
        block2: {
            try {
                Nc4Iosp.load();
            }
            catch (Throwable t) {
                if (!warn) break block2;
                log.warn("netcdf4 c library not present jna_path='{}' libname='{}'", (Object)jnaPath, (Object)libName);
            }
        }
        return nc4 != null;
    }

    public static void setLibraryAndPath(String jna_path, String libname) {
        if (jna_path != null) {
            jnaPath = jna_path;
            System.setProperty(JNA_PATH, jnaPath);
        }
        if (libname != null) {
            libName = libname;
        }
    }

    private static Nc4prototypes load() {
        if (nc4 == null) {
            if (jnaPath == null && (jnaPath = System.getProperty(JNA_PATH)) == null) {
                jnaPath = "/usr/jna_lib/";
                System.setProperty(JNA_PATH, jnaPath);
            }
            Native.setProtected((boolean)true);
            nc4 = (Nc4prototypes)Native.loadLibrary((String)libName, Nc4prototypes.class);
        }
        return nc4;
    }

    public Nc4Iosp(NetcdfFileWriter.Version version) {
        this.version = version;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return false;
    }

    @Override
    public String getFileTypeId() {
        return this.version.isNetdf4format() ? DataFormatType.NETCDF4.toString() : DataFormatType.NETCDF.toString();
    }

    @Override
    public String getFileTypeDescription() {
        return "Netcdf/JNI: " + (Object)((Object)this.version);
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.ncid < 0) {
            return;
        }
        int ret = nc4.nc_close(this.ncid);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        this.isClosed = true;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        Nc4Iosp.load();
        this.ncfile = ncfile;
        IntByReference ncidp = new IntByReference();
        int ret = nc4.nc_open(ncfile.getLocation(), 0, ncidp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        this.ncid = ncidp.getValue();
        IntByReference formatp = new IntByReference();
        ret = nc4.nc_inq_format(this.ncid, formatp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        this.format = formatp.getValue();
        this.makeGroup(this.ncid, new Group4(ncfile.getRootGroup(), null));
        ncfile.finish();
    }

    private void makeGroup(int grpid, Group4 g4) throws IOException {
        this.groupHash.put(g4.g, grpid);
        this.makeDimensions(grpid, g4);
        this.makeUserTypes(grpid, g4.g);
        IntByReference ngattsp = new IntByReference();
        int ret = nc4.nc_inq_natts(grpid, ngattsp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        List<Attribute> gatts = this.makeAttributes(grpid, -1, ngattsp.getValue(), null);
        for (Attribute att : gatts) {
            this.ncfile.addAttribute(g4.g, att);
        }
        this.makeVariables(grpid, g4.g);
        if (this.format == 3) {
            IntByReference numgrps = new IntByReference();
            ret = nc4.nc_inq_grps(grpid, numgrps, Pointer.NULL);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            int[] grids = new int[numgrps.getValue()];
            ret = nc4.nc_inq_grps(grpid, numgrps, grids);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            for (int i = 0; i < grids.length; ++i) {
                byte[] name = new byte[257];
                ret = nc4.nc_inq_grpname(grids[i], name);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                Group child = new Group(this.ncfile, g4.g, this.makeString(name));
                g4.g.addGroup(child);
                this.makeGroup(grids[i], new Group4(child, g4));
            }
        }
    }

    private void makeDimensions(int grpid, Group4 g4) throws IOException {
        IntByReference ndimsp = new IntByReference();
        int ret = nc4.nc_inq_ndims(grpid, ndimsp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        int[] dimids = new int[ndimsp.getValue()];
        ret = nc4.nc_inq_dimids(grpid, ndimsp, dimids, 0);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        IntByReference nunlimdimsp = new IntByReference();
        int[] unlimdimids = new int[1024];
        ret = nc4.nc_inq_unlimdims(grpid, nunlimdimsp, unlimdimids);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        int ndims = ndimsp.getValue();
        for (int i = 0; i < ndims; ++i) {
            byte[] name = new byte[257];
            NativeLongByReference lenp = new NativeLongByReference();
            ret = nc4.nc_inq_dim(grpid, dimids[i], name, lenp);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            String dname = this.makeString(name);
            boolean isUnlimited = this.containsInt(nunlimdimsp.getValue(), unlimdimids, i);
            Dimension dim = new Dimension(dname, lenp.getValue().intValue(), true, isUnlimited, false);
            this.ncfile.addDimension(g4.g, dim);
        }
    }

    private boolean containsInt(int n, int[] have, int want) {
        for (int i = 0; i < n; ++i) {
            if (have[i] != want) continue;
            return true;
        }
        return false;
    }

    private void updateDimensions(Group g) throws IOException {
        int[] unlimdimids;
        IntByReference nunlimdimsp;
        int grpid = this.groupHash.get(g);
        int ret = nc4.nc_inq_unlimdims(grpid, nunlimdimsp = new IntByReference(), unlimdimids = new int[1024]);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        int ndims = nunlimdimsp.getValue();
        for (int i = 0; i < ndims; ++i) {
            byte[] name = new byte[257];
            NativeLongByReference lenp = new NativeLongByReference();
            ret = nc4.nc_inq_dim(grpid, unlimdimids[i], name, lenp);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            String dname = this.makeString(name);
            Dimension d = g.findDimension(dname);
            if (d == null) {
                throw new IllegalStateException("Cant find dimension " + dname);
            }
            if (!d.isUnlimited()) {
                throw new IllegalStateException("dimension " + dname + " should be unlimited");
            }
            int len = lenp.getValue().intValue();
            if (len == d.getLength()) continue;
            d.setLength(len);
            for (Variable var : g.getVariables()) {
                if (!this.contains(var.getDimensions(), d)) continue;
                var.resetShape();
                var.invalidateCache();
            }
        }
        for (Group child : g.getGroups()) {
            this.updateDimensions(child);
        }
    }

    private boolean contains(List<Dimension> dims, Dimension want) {
        for (Dimension have : dims) {
            if (!have.getName().equals(want.getName())) continue;
            return true;
        }
        return false;
    }

    private String makeString(byte[] b) throws IOException {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        if (count < b.length / 2) {
            byte[] bb = new byte[count];
            System.arraycopy(b, 0, bb, 0, count);
            b = bb;
        }
        return new String(b, 0, count, CDM.utf8Charset);
    }

    private String makeAttString(byte[] b) throws IOException {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, CDM.utf8Charset);
    }

    private List<Attribute> makeAttributes(int grpid, int varid, int natts, Variable v) throws IOException {
        ArrayList<Attribute> result = new ArrayList<Attribute>(natts);
        block24: for (int attnum = 0; attnum < natts; ++attnum) {
            IntByReference xtypep;
            byte[] name = new byte[257];
            int ret = nc4.nc_inq_attname(grpid, varid, attnum, name);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret) + " varid=" + varid + " attnum=" + attnum);
            }
            String attname = this.makeString(name);
            ret = nc4.nc_inq_atttype(grpid, varid, attname, xtypep = new IntByReference());
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret) + " varid=" + varid + "attnum=" + attnum);
            }
            int type = xtypep.getValue();
            NativeLongByReference lenp = new NativeLongByReference();
            ret = nc4.nc_inq_attlen(grpid, varid, attname, lenp);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            int len = lenp.getValue().intValue();
            if (len == 0) {
                Attribute att;
                switch (type) {
                    case 1: 
                    case 7: {
                        att = new Attribute(attname, DataType.BYTE);
                        break;
                    }
                    case 2: {
                        att = new Attribute(attname, "");
                        break;
                    }
                    case 6: {
                        att = new Attribute(attname, DataType.DOUBLE);
                        break;
                    }
                    case 5: {
                        att = new Attribute(attname, DataType.FLOAT);
                        break;
                    }
                    case 4: 
                    case 9: {
                        att = new Attribute(attname, DataType.INT);
                        break;
                    }
                    case 10: 
                    case 11: {
                        att = new Attribute(attname, DataType.LONG);
                        break;
                    }
                    case 3: 
                    case 8: {
                        att = new Attribute(attname, DataType.SHORT);
                        break;
                    }
                    case 12: {
                        att = new Attribute(attname, DataType.STRING);
                        break;
                    }
                    default: {
                        log.warn("Unsupported attribute data type == " + type);
                        continue block24;
                    }
                }
                result.add(att);
                continue;
            }
            Array values = null;
            switch (type) {
                case 7: {
                    byte[] valbu = new byte[len];
                    ret = nc4.nc_get_att_uchar(grpid, varid, attname, valbu);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.BYTE.getPrimitiveClassType(), new int[]{len}, (Object)valbu);
                    break;
                }
                case 1: {
                    byte[] valb = new byte[len];
                    ret = nc4.nc_get_att_schar(grpid, varid, attname, valb);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.BYTE.getPrimitiveClassType(), new int[]{len}, (Object)valb);
                    break;
                }
                case 2: {
                    byte[] text = new byte[len];
                    ret = nc4.nc_get_att_text(grpid, varid, attname, text);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    Attribute att = new Attribute(attname, this.makeAttString(text));
                    result.add(att);
                    break;
                }
                case 6: {
                    double[] vald = new double[len];
                    ret = nc4.nc_get_att_double(grpid, varid, attname, vald);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{len}, (Object)vald);
                    break;
                }
                case 5: {
                    float[] valf = new float[len];
                    ret = nc4.nc_get_att_float(grpid, varid, attname, valf);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.FLOAT.getPrimitiveClassType(), new int[]{len}, (Object)valf);
                    break;
                }
                case 9: {
                    int[] valiu = new int[len];
                    ret = nc4.nc_get_att_uint(grpid, varid, attname, valiu);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.INT.getPrimitiveClassType(), new int[]{len}, (Object)valiu);
                    break;
                }
                case 4: {
                    int[] vali = new int[len];
                    ret = nc4.nc_get_att_int(grpid, varid, attname, vali);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.INT.getPrimitiveClassType(), new int[]{len}, (Object)vali);
                    break;
                }
                case 11: {
                    long[] vallu = new long[len];
                    ret = nc4.nc_get_att_ulonglong(grpid, varid, attname, vallu);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.LONG.getPrimitiveClassType(), new int[]{len}, (Object)vallu);
                    break;
                }
                case 10: {
                    long[] vall = new long[len];
                    ret = nc4.nc_get_att_longlong(grpid, varid, attname, vall);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.LONG.getPrimitiveClassType(), new int[]{len}, (Object)vall);
                    break;
                }
                case 8: {
                    short[] valsu = new short[len];
                    ret = nc4.nc_get_att_ushort(grpid, varid, attname, valsu);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.SHORT.getPrimitiveClassType(), new int[]{len}, (Object)valsu);
                    break;
                }
                case 3: {
                    short[] vals = new short[len];
                    ret = nc4.nc_get_att_short(grpid, varid, attname, vals);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.SHORT.getPrimitiveClassType(), new int[]{len}, (Object)vals);
                    break;
                }
                case 12: {
                    String[] valss = new String[len];
                    ret = nc4.nc_get_att_string(grpid, varid, attname, valss);
                    if (ret != 0) {
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    values = Array.factory(String.class, new int[]{len}, (Object)valss);
                    break;
                }
                default: {
                    UserType userType = this.userTypes.get(type);
                    if (userType == null) {
                        log.warn("Unsupported attribute data type == " + type);
                        continue block24;
                    }
                    if (userType.typeClass == 15) {
                        result.add(this.readEnumAttValues(grpid, varid, attname, len, userType));
                        continue block24;
                    }
                    if (userType.typeClass == 14) {
                        result.add(this.readOpaqueAttValues(grpid, varid, attname, len, userType));
                        continue block24;
                    }
                    if (userType.typeClass == 13) {
                        values = this.readVlenAttValues(grpid, varid, attname, len, userType);
                        break;
                    }
                    if (userType.typeClass == 16) {
                        this.readCompoundAttValues(grpid, varid, attname, len, userType, result, v);
                        continue block24;
                    }
                    log.warn("Unsupported attribute data type == " + userType);
                    continue block24;
                }
            }
            if (values == null) continue;
            Attribute att = new Attribute(attname, values);
            result.add(att);
        }
        return result;
    }

    private Array readVlenAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        Nc4prototypes.Vlen_t[] vlen = new Nc4prototypes.Vlen_t[len];
        int ret = nc4.nc_get_att(grpid, varid, attname, vlen);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            count += vlen[i].len;
        }
        switch (userType.baseTypeid) {
            case 4: {
                Array intArray = Array.factory(DataType.INT, new int[]{count});
                IndexIterator iter = intArray.getIndexIterator();
                for (int i = 0; i < len; ++i) {
                    int[] ba = vlen[i].p.getIntArray(0L, vlen[i].len);
                    for (int j = 0; j < ba.length; ++j) {
                        iter.setIntNext(ba[j]);
                    }
                }
                return intArray;
            }
            case 5: {
                Array fArray = Array.factory(DataType.FLOAT, new int[]{count});
                IndexIterator iter = fArray.getIndexIterator();
                for (int i = 0; i < len; ++i) {
                    float[] ba = vlen[i].p.getFloatArray(0L, vlen[i].len);
                    for (int j = 0; j < ba.length; ++j) {
                        iter.setFloatNext(ba[j]);
                    }
                }
                return fArray;
            }
        }
        return null;
    }

    private Attribute readEnumAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        DataType dtype = this.convertDataType((int)userType.baseTypeid).dt;
        int elemSize = dtype.getSize();
        ByteBuffer bb = ByteBuffer.allocate(len * elemSize);
        int ret = nc4.nc_get_att(grpid, varid, attname, bb);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        Array data = this.convertByteBuffer(bb, userType.baseTypeid, new int[]{len});
        IndexIterator ii = data.getIndexIterator();
        if (len == 1) {
            String val = userType.e.lookupEnumString(ii.getIntNext());
            return new Attribute(attname, val);
        }
        ArrayObject.D1 attArray = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{len});
        for (int i = 0; i < len; ++i) {
            int val = ii.getIntNext();
            String vals = userType.e.lookupEnumString(val);
            if (vals == null) {
                throw new IOException("Illegal enum val " + val + " for attribute " + attname);
            }
            attArray.set(i, vals);
        }
        return new Attribute(attname, attArray);
    }

    private Array convertByteBuffer(ByteBuffer bb, int baseType, int[] shape) throws IOException {
        switch (baseType) {
            case 1: 
            case 7: {
                Array sArray = Array.factory(DataType.BYTE, shape, (Object)bb.array());
                return baseType == 1 ? sArray : MAMath.convertUnsigned(sArray);
            }
            case 3: 
            case 8: {
                ShortBuffer sb = bb.asShortBuffer();
                Array sArray = Array.factory(DataType.SHORT, shape, (Object)sb.array());
                return baseType == 3 ? sArray : MAMath.convertUnsigned(sArray);
            }
            case 4: 
            case 9: {
                IntBuffer ib = bb.asIntBuffer();
                Array sArray = Array.factory(DataType.INT, shape, (Object)ib.array());
                return baseType == 4 ? sArray : MAMath.convertUnsigned(sArray);
            }
        }
        return null;
    }

    private Attribute readOpaqueAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        int total = len * userType.size;
        ByteBuffer bb = ByteBuffer.allocate(total);
        int ret = nc4.nc_get_att(grpid, varid, attname, bb);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        return new Attribute(attname, Array.factory(DataType.BYTE, new int[]{total}, (Object)bb.array()));
    }

    private void readCompoundAttValues(int grpid, int varid, String attname, int len, UserType userType, List<Attribute> result, Variable v) throws IOException {
        int buffSize = len * userType.size;
        ByteBuffer bbuff = ByteBuffer.allocate(buffSize);
        int ret = nc4.nc_get_att(grpid, varid, attname, bbuff);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        this.decodeCompoundData(len, userType, bbuff);
        if (v != null && v instanceof Structure) {
            Structure s = (Structure)v;
            for (Field fld : userType.flds) {
                Variable mv = s.findVariable(fld.name);
                if (mv != null) {
                    mv.addAttribute(new Attribute(attname, fld.data));
                    continue;
                }
                result.add(new Attribute(attname + "." + fld.name, fld.data));
            }
        } else {
            for (Field fld : userType.flds) {
                result.add(new Attribute(attname + "." + fld.name, fld.data));
            }
        }
    }

    private void decodeCompoundData(int len, UserType userType, ByteBuffer bbuff) throws IOException {
        bbuff.order(ByteOrder.LITTLE_ENDIAN);
        for (Field fld : userType.flds) {
            ConvertedType ct = this.convertDataType(fld.fldtypeid);
            if (fld.fldtypeid == 2) {
                fld.data = Array.factory(DataType.STRING, new int[]{len});
                continue;
            }
            if (ct.isVen) {
                fld.data = new ArrayObject(ct.dt.getPrimitiveClassType(), new int[]{len});
                continue;
            }
            fld.data = Array.factory(ct.dt, new int[]{len});
        }
        for (int i = 0; i < len; ++i) {
            int record_start = i * userType.size;
            block12: for (Field fld : userType.flds) {
                int pos = record_start + fld.offset;
                switch (fld.fldtypeid) {
                    case 2: {
                        int blen = 1;
                        if (fld.dims != null) {
                            Section s = new Section(fld.dims);
                            blen = (int)s.computeSize();
                        }
                        byte[] dst = new byte[blen];
                        bbuff.get(dst, 0, blen);
                        String cval = this.makeAttString(dst);
                        fld.data.setObject(i, (Object)cval);
                        continue block12;
                    }
                    case 1: 
                    case 7: {
                        byte bval = bbuff.get(pos);
                        fld.data.setByte(i, bval);
                        continue block12;
                    }
                    case 3: 
                    case 8: {
                        short sval = bbuff.getShort(pos);
                        fld.data.setShort(i, sval);
                        continue block12;
                    }
                    case 4: 
                    case 9: {
                        int ival = bbuff.getInt(pos);
                        fld.data.setInt(i, ival);
                        continue block12;
                    }
                    case 10: 
                    case 11: {
                        long lval = bbuff.getLong(pos);
                        fld.data.setLong(i, lval);
                        continue block12;
                    }
                    case 5: {
                        float fval = bbuff.getFloat(pos);
                        fld.data.setFloat(i, fval);
                        continue block12;
                    }
                    case 6: {
                        double dval = bbuff.getDouble(pos);
                        fld.data.setDouble(i, dval);
                        continue block12;
                    }
                    case 12: {
                        long lval = bbuff.getLong(pos);
                        MyPointer p = new MyPointer(lval);
                        String strval = p.getString(0L, false);
                        fld.data.setObject(i, (Object)strval);
                        continue block12;
                    }
                }
                UserType subUserType = this.userTypes.get(fld.fldtypeid);
                if (subUserType == null) {
                    throw new IOException("Unknown compound user type == " + fld);
                }
                if (subUserType.typeClass != 15) {
                    if (subUserType.typeClass == 13) {
                        this.decodeVlen(fld, subUserType, pos, i, bbuff);
                        continue;
                    }
                    if (subUserType.typeClass == 14 || subUserType.typeClass == 16) {
                        // empty if block
                    }
                }
                log.warn("UNSUPPORTED compound fld.fldtypeid= " + fld.fldtypeid);
            }
        }
    }

    private Array decodeVlen(Field fld, UserType userType, int pos, int idx, ByteBuffer bbuff) throws IOException {
        int n = (int)bbuff.getLong(pos);
        long addr = bbuff.getLong(pos + 8);
        MyPointer p = new MyPointer(addr);
        switch (userType.baseTypeid) {
            case 5: {
                float[] data = p.getFloatArray(0L, n);
                fld.data.setObject(idx, (Object)Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
            }
        }
        throw new IllegalStateException();
    }

    private void makeVariables(int grpid, Group g) throws IOException {
        IntByReference nvarsp = new IntByReference();
        int ret = nc4.nc_inq_nvars(grpid, nvarsp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        int nvars = nvarsp.getValue();
        int[] varids = new int[nvars];
        ret = nc4.nc_inq_varids(grpid, nvarsp, varids);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        for (int i = 0; i < varids.length; ++i) {
            Variable v;
            IntByReference nattsp;
            int[] dimids;
            IntByReference ndimsp;
            IntByReference xtypep;
            byte[] name;
            int varno = varids[i];
            if (varno != i) {
                log.error("HEY varno=%d i=%d%n", (Object)varno, (Object)i);
            }
            if ((ret = nc4.nc_inq_var(grpid, varno, name = new byte[257], xtypep = new IntByReference(), ndimsp = new IntByReference(), dimids = new int[1024], nattsp = new IntByReference())) != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            int typeid = xtypep.getValue();
            DataType dtype = this.convertDataType((int)typeid).dt;
            String vname = this.makeString(name);
            Vinfo vinfo = new Vinfo(grpid, varno, typeid);
            String dimList = this.makeDimList(grpid, ndimsp.getValue(), dimids);
            UserType utype = this.userTypes.get(typeid);
            if (utype != null) {
                vinfo.utype = utype;
                if (utype.typeClass == 13) {
                    dimList = dimList + " *";
                }
            }
            if (dtype != DataType.STRUCTURE) {
                v = new Variable(this.ncfile, g, null, vname, dtype, dimList);
            } else if (utype != null) {
                Structure s = new Structure(this.ncfile, g, null, vname);
                s.setDimensions(dimList);
                v = s;
                if (utype.flds == null) {
                    utype.readFields();
                }
                for (Field f : utype.flds) {
                    s.addMemberVariable(f.makeMemberVariable(g, s));
                }
            } else {
                throw new IllegalStateException("Dunno what to with " + (Object)((Object)dtype));
            }
            this.ncfile.addVariable(g, v);
            v.setSPobject(vinfo);
            if (dtype.isEnum()) {
                EnumTypedef enumTypedef = g.findEnumeration(utype.name);
                v.setEnumTypedef(enumTypedef);
            }
            if (this.isUnsigned(typeid)) {
                v.addAttribute(new Attribute("_Unsigned", "true"));
            }
            List<Attribute> atts = this.makeAttributes(grpid, varno, nattsp.getValue(), v);
            for (Attribute att : atts) {
                v.addAttribute(att);
            }
        }
    }

    private String makeDimList(int grpid, int ndimsp, int[] dims) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ndimsp; ++i) {
            byte[] name = new byte[257];
            int ret = nc4.nc_inq_dimname(grpid, dims[i], name);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            String dname = this.makeString(name);
            sb.append(dname);
            sb.append(" ");
        }
        return sb.toString();
    }

    private void makeUserTypes(int grpid, Group g) throws IOException {
        IntByReference ntypesp = new IntByReference();
        int ret = nc4.nc_inq_typeids(grpid, ntypesp, Pointer.NULL);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        int ntypes = ntypesp.getValue();
        if (ntypes == 0) {
            return;
        }
        int[] xtypes = new int[ntypes];
        ret = nc4.nc_inq_typeids(grpid, ntypesp, xtypes);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        for (int typeid : xtypes) {
            NativeLongByReference sizep2;
            byte[] nameo;
            byte[] nameb = new byte[257];
            NativeLongByReference sizep = new NativeLongByReference();
            IntByReference baseType = new IntByReference();
            NativeLongByReference nfieldsp = new NativeLongByReference();
            IntByReference classp = new IntByReference();
            ret = nc4.nc_inq_user_type(grpid, typeid, nameb, sizep, baseType, nfieldsp, classp);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            String name = this.makeString(nameb);
            int utype = classp.getValue();
            UserType ut = new UserType(grpid, typeid, name, sizep.getValue().longValue(), baseType.getValue(), nfieldsp.getValue().longValue(), utype);
            this.userTypes.put(typeid, ut);
            if (utype == 15) {
                Map<Integer, String> map = this.makeEnum(grpid, typeid);
                EnumTypedef e = new EnumTypedef(name, map);
                g.addEnumeration(e);
                ut.setEnum(e);
                continue;
            }
            if (utype != 14 || (ret = nc4.nc_inq_opaque(grpid, typeid, nameo = new byte[257], sizep2 = new NativeLongByReference())) == 0) continue;
            throw new IOException(nc4.nc_strerror(ret));
        }
    }

    private Map<Integer, String> makeEnum(int grpid, int xtype) throws IOException {
        byte[] nameb = new byte[257];
        IntByReference baseType = new IntByReference();
        NativeLongByReference baseSize = new NativeLongByReference();
        NativeLongByReference numMembers = new NativeLongByReference();
        int ret = nc4.nc_inq_enum(grpid, xtype, nameb, baseType, baseSize, numMembers);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        int nmembers = numMembers.getValue().intValue();
        String name = this.makeString(nameb);
        HashMap<Integer, String> map = new HashMap<Integer, String>(2 * nmembers);
        for (int i = 0; i < nmembers; ++i) {
            byte[] mnameb = new byte[257];
            IntByReference value = new IntByReference();
            ret = nc4.nc_inq_enum_member(grpid, xtype, i, mnameb, value);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            String mname = this.makeString(mnameb);
            map.put(value.getValue(), mname);
        }
        return map;
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        int len;
        Vinfo vinfo = (Vinfo)v2.getSPobject();
        int vlen = (int)v2.getSize();
        if (vlen == (len = (int)section.computeSize())) {
            return this.readDataAll(vinfo.grpid, vinfo.varid, vinfo.typeid, v2.getShapeAsSection());
        }
        return this.readDataSection(vinfo.grpid, vinfo.varid, vinfo.typeid, section);
    }

    private Array readDataSection(int grpid, int varid, int typeid, Section section) throws IOException, InvalidRangeException {
        Array values;
        long[] origin = this.convert(section.getOrigin());
        long[] shape = this.convert(section.getShape());
        long[] stride = this.convert(section.getStride());
        boolean isUnsigned = this.isUnsigned(typeid);
        int len = (int)section.computeSize();
        switch (typeid) {
            case 1: 
            case 7: {
                int ret;
                byte[] valb = new byte[len];
                int n = ret = isUnsigned ? nc4.nc_get_vars_uchar(grpid, varid, origin, shape, stride, valb) : nc4.nc_get_vars_schar(grpid, varid, origin, shape, stride, valb);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.BYTE.getPrimitiveClassType(), section.getShape(), (Object)valb);
                break;
            }
            case 2: {
                byte[] valc = new byte[len];
                int ret = nc4.nc_get_vars_text(grpid, varid, origin, shape, stride, valc);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.CHAR.getPrimitiveClassType(), section.getShape(), (Object)IospHelper.convertByteToChar(valc));
                break;
            }
            case 6: {
                double[] vald = new double[len];
                int ret = nc4.nc_get_vars_double(grpid, varid, origin, shape, stride, vald);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), section.getShape(), (Object)vald);
                break;
            }
            case 5: {
                float[] valf = new float[len];
                int ret = nc4.nc_get_vars_float(grpid, varid, origin, shape, stride, valf);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.FLOAT.getPrimitiveClassType(), section.getShape(), (Object)valf);
                break;
            }
            case 4: {
                int ret;
                int[] vali = new int[len];
                int n = ret = isUnsigned ? nc4.nc_get_vars_uint(grpid, varid, origin, shape, stride, vali) : nc4.nc_get_vars_int(grpid, varid, origin, shape, stride, vali);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.INT.getPrimitiveClassType(), section.getShape(), (Object)vali);
                break;
            }
            case 10: {
                int ret;
                long[] vall = new long[len];
                int n = ret = isUnsigned ? nc4.nc_get_vars_ulonglong(grpid, varid, origin, shape, stride, vall) : nc4.nc_get_vars_longlong(grpid, varid, origin, shape, stride, vall);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.LONG.getPrimitiveClassType(), section.getShape(), (Object)vall);
                break;
            }
            case 3: {
                int ret;
                short[] vals = new short[len];
                int n = ret = isUnsigned ? nc4.nc_get_vars_ushort(grpid, varid, origin, shape, stride, vals) : nc4.nc_get_vars_short(grpid, varid, origin, shape, stride, vals);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.SHORT.getPrimitiveClassType(), section.getShape(), (Object)vals);
                break;
            }
            case 12: {
                String[] valss = new String[len];
                int ret = nc4.nc_get_vars_string(grpid, varid, origin, shape, stride, valss);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.STRING.getPrimitiveClassType(), section.getShape(), (Object)valss);
            }
            default: {
                UserType userType = this.userTypes.get(typeid);
                if (userType == null) {
                    throw new IOException("Unknown userType == " + typeid);
                }
                if (userType.typeClass == 15) {
                    return this.readDataSection(grpid, varid, userType.baseTypeid, section);
                }
                if (userType.typeClass == 13) {
                    return this.readVlen(grpid, varid, len, userType);
                }
                if (userType.typeClass == 14) {
                    return this.readOpaque(grpid, varid, section, userType.size);
                }
                if (userType.typeClass == 16) {
                    return this.readCompound(grpid, varid, section, userType);
                }
                throw new IOException("Unsupported userType = " + typeid + " userType= " + userType);
            }
        }
        return values;
    }

    private Array readDataAll(int grpid, int varid, int typeid, Section section) throws IOException, InvalidRangeException {
        int len = (int)section.computeSize();
        int[] shape = section.getShape();
        switch (typeid) {
            case 7: {
                byte[] valbu = new byte[len];
                int ret = nc4.nc_get_var_ubyte(grpid, varid, valbu);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.BYTE.getPrimitiveClassType(), shape, (Object)valbu);
            }
            case 1: {
                byte[] valb = new byte[len];
                int ret = nc4.nc_get_var_schar(grpid, varid, valb);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.BYTE.getPrimitiveClassType(), shape, (Object)valb);
            }
            case 2: {
                byte[] valc = new byte[len];
                int ret = nc4.nc_get_var_text(grpid, varid, valc);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                char[] cvals = IospHelper.convertByteToChar(valc);
                return Array.factory(DataType.CHAR.getPrimitiveClassType(), shape, (Object)cvals);
            }
            case 6: {
                double[] vald = new double[len];
                int ret = nc4.nc_get_var_double(grpid, varid, vald);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.DOUBLE.getPrimitiveClassType(), shape, (Object)vald);
            }
            case 5: {
                float[] valf = new float[len];
                int ret = nc4.nc_get_var_float(grpid, varid, valf);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.FLOAT.getPrimitiveClassType(), shape, (Object)valf);
            }
            case 4: {
                int[] vali = new int[len];
                int ret = nc4.nc_get_var_int(grpid, varid, vali);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.INT.getPrimitiveClassType(), shape, (Object)vali);
            }
            case 10: {
                long[] vall = new long[len];
                int ret = nc4.nc_get_var_longlong(grpid, varid, vall);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.LONG.getPrimitiveClassType(), shape, (Object)vall);
            }
            case 11: {
                long[] vallu = new long[len];
                int ret = nc4.nc_get_var_ulonglong(grpid, varid, vallu);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.LONG.getPrimitiveClassType(), shape, (Object)vallu);
            }
            case 3: {
                short[] vals = new short[len];
                int ret = nc4.nc_get_var_short(grpid, varid, vals);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.SHORT.getPrimitiveClassType(), shape, (Object)vals);
            }
            case 8: {
                short[] valsu = new short[len];
                int ret = nc4.nc_get_var_ushort(grpid, varid, valsu);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.SHORT.getPrimitiveClassType(), shape, (Object)valsu);
            }
            case 12: {
                String[] valss = new String[len];
                int ret = nc4.nc_get_var_string(grpid, varid, valss);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.STRING.getPrimitiveClassType(), shape, (Object)valss);
            }
        }
        UserType userType = this.userTypes.get(typeid);
        if (userType == null) {
            throw new IOException("Unknown userType == " + typeid);
        }
        if (userType.typeClass == 15) {
            int buffSize = len * userType.size;
            ByteBuffer bbuff = ByteBuffer.allocate(buffSize);
            bbuff.order(ByteOrder.nativeOrder());
            int ret = nc4.nc_get_var(grpid, varid, bbuff);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            switch (userType.baseTypeid) {
                case 1: 
                case 7: {
                    return Array.factory(DataType.BYTE, shape, bbuff);
                }
                case 3: 
                case 8: {
                    return Array.factory(DataType.SHORT, shape, bbuff);
                }
            }
            throw new IOException("unknown type " + userType.baseTypeid);
        }
        if (userType.typeClass == 13) {
            return this.readVlen(grpid, varid, len, userType);
        }
        if (userType.typeClass == 14) {
            return this.readOpaque(grpid, varid, section, userType.size);
        }
        if (userType.typeClass == 16) {
            return this.readCompound(grpid, varid, section, userType);
        }
        throw new IOException("Unsupported userType = " + typeid + " userType= " + userType);
    }

    private Array readCompound(int grpid, int varid, Section section, UserType userType) throws IOException {
        long[] origin = this.convert(section.getOrigin());
        long[] shape = this.convert(section.getShape());
        long[] stride = this.convert(section.getStride());
        int len = (int)section.computeSize();
        int buffSize = len * userType.size;
        ByteBuffer bbuff = ByteBuffer.allocate(buffSize);
        bbuff.order(ByteOrder.nativeOrder());
        int ret = nc4.nc_get_vars(grpid, varid, origin, shape, stride, bbuff);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        StructureMembers sm = new StructureMembers(userType.name);
        for (Field fld : userType.flds) {
            StructureMembers.Member m = sm.addMember(fld.name, null, null, fld.ctype.dt, fld.dims);
            m.setDataParam(fld.offset);
            if (!fld.ctype.isVen) continue;
            m.setShape(new int[]{-1});
        }
        sm.setStructureSize(userType.size);
        ArrayStructureBB asbb = new ArrayStructureBB(sm, section.getShape(), bbuff, 0);
        int destPos = 0;
        for (int i = 0; i < len; ++i) {
            this.convertHeap(asbb, destPos, sm);
            destPos += userType.size;
        }
        return asbb;
    }

    private void convertHeap(ArrayStructureBB asbb, int pos, StructureMembers sm) throws IOException {
        ByteBuffer bb = asbb.getByteBuffer();
        for (StructureMembers.Member m : sm.getMembers()) {
            if (m.getDataType() == DataType.STRING) {
                int size = m.getSize();
                int destPos = pos + m.getDataParam();
                String[] result = new String[size];
                for (int i = 0; i < size; ++i) {
                    long addr = bb.getLong(pos);
                    MyPointer p = new MyPointer(addr);
                    result[i] = p.getString(0L, false);
                }
                int index = asbb.addObjectToHeap(result);
                bb.putInt(destPos, index);
                continue;
            }
            if (!m.isVariableLength()) continue;
            int destPos = pos + m.getDataParam();
            Array result = this.decodeVlen(m.getDataType(), pos + m.getDataParam(), bb);
            int index = asbb.addObjectToHeap(result);
            bb.order(ByteOrder.nativeOrder());
            bb.putInt(destPos, index);
        }
    }

    private Array decodeVlen(DataType dt, int pos, ByteBuffer bbuff) throws IOException {
        int n = (int)bbuff.getLong(pos);
        long addr = bbuff.getLong(pos + 8);
        MyPointer p = new MyPointer(addr);
        switch (dt) {
            case FLOAT: {
                float[] data = p.getFloatArray(0L, n);
                return Array.factory(dt, new int[]{n}, (Object)data);
            }
        }
        throw new IllegalStateException();
    }

    Array readVlen(int grpid, int varid, int len, UserType userType) throws IOException {
        Nc4prototypes.Vlen_t[] vlen = new Nc4prototypes.Vlen_t[len];
        int ret = nc4.nc_get_var(grpid, varid, vlen);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        Object[] data = new Object[len];
        switch (userType.baseTypeid) {
            case 4: 
            case 9: {
                for (int i = 0; i < len; ++i) {
                    int slen = vlen[i].len;
                    int[] ba = vlen[i].p.getIntArray(0L, slen);
                    data[i] = Array.factory(DataType.INT, new int[]{slen}, (Object)ba);
                }
                break;
            }
            case 3: 
            case 8: {
                for (int i = 0; i < len; ++i) {
                    int slen = vlen[i].len;
                    short[] ba = vlen[i].p.getShortArray(0L, slen);
                    data[i] = Array.factory(DataType.SHORT, new int[]{slen}, (Object)ba);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < len; ++i) {
                    int slen = vlen[i].len;
                    float[] ba = vlen[i].p.getFloatArray(0L, slen);
                    data[i] = Array.factory(DataType.FLOAT, new int[]{slen}, (Object)ba);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Vlen type " + userType.baseTypeid + " = " + this.convertDataType(userType.baseTypeid));
            }
        }
        return (Array)(len == 1 ? data[0] : new ArrayObject(data[0].getClass(), new int[]{len}, data));
    }

    private Array readOpaque(int grpid, int varid, Section section, int size) throws IOException, InvalidRangeException {
        int len;
        ByteBuffer bb;
        long[] stride;
        long[] shape;
        long[] origin = this.convert(section.getOrigin());
        int ret = nc4.nc_get_vars(grpid, varid, origin, shape = this.convert(section.getShape()), stride = this.convert(section.getStride()), bb = ByteBuffer.allocate((len = (int)section.computeSize()) * size));
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        byte[] entire = bb.array();
        ArrayObject values = new ArrayObject(ByteBuffer.class, new int[]{len});
        int count = 0;
        IndexIterator ii = values.getIndexIterator();
        while (ii.hasNext()) {
            ii.setObjectNext(ByteBuffer.wrap(entire, count * size, size));
        }
        return values;
    }

    private boolean isUnsigned(int type) {
        return type == 7 || type == 8 || type == 9 || type == 11;
    }

    private boolean isVlen(int type) {
        UserType userType = this.userTypes.get(type);
        return userType == null ? false : userType.typeClass == 13;
    }

    private long[] convert(int[] from) {
        long[] to = new long[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
        return to;
    }

    private int convertDataType(DataType dt) {
        switch (dt) {
            case BYTE: {
                return 1;
            }
            case CHAR: {
                return 2;
            }
            case DOUBLE: {
                return 6;
            }
            case FLOAT: {
                return 5;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 10;
            }
            case SHORT: {
                return 3;
            }
            case STRING: {
                return 12;
            }
            case ENUM1: 
            case ENUM2: 
            case ENUM4: {
                return 15;
            }
        }
        throw new IllegalArgumentException("unimplemented type == " + (Object)((Object)dt));
    }

    private ConvertedType convertDataType(int type) {
        switch (type) {
            case 1: 
            case 7: {
                return new ConvertedType(DataType.BYTE);
            }
            case 2: {
                return new ConvertedType(DataType.CHAR);
            }
            case 3: 
            case 8: {
                return new ConvertedType(DataType.SHORT);
            }
            case 4: 
            case 9: {
                return new ConvertedType(DataType.INT);
            }
            case 10: 
            case 11: {
                return new ConvertedType(DataType.LONG);
            }
            case 5: {
                return new ConvertedType(DataType.FLOAT);
            }
            case 6: {
                return new ConvertedType(DataType.DOUBLE);
            }
            case 15: {
                return new ConvertedType(DataType.ENUM1);
            }
            case 12: {
                return new ConvertedType(DataType.STRING);
            }
        }
        UserType userType = this.userTypes.get(type);
        if (userType == null) {
            throw new IllegalArgumentException("unknown type == " + type);
        }
        switch (userType.typeClass) {
            case 15: {
                return new ConvertedType(DataType.ENUM1);
            }
            case 16: {
                return new ConvertedType(DataType.STRUCTURE);
            }
            case 14: {
                return new ConvertedType(DataType.OPAQUE);
            }
            case 13: {
                ConvertedType result = this.convertDataType(userType.baseTypeid);
                result.isVen = true;
                return result;
            }
        }
        throw new IllegalArgumentException("unknown type == " + type);
    }

    private String getDataTypeName(int type) {
        switch (type) {
            case 1: {
                return "byte";
            }
            case 7: {
                return "ubyte";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "short";
            }
            case 8: {
                return "ushort";
            }
            case 4: {
                return "int";
            }
            case 9: {
                return "uint";
            }
            case 10: {
                return "long";
            }
            case 11: {
                return "ulong";
            }
            case 5: {
                return "float";
            }
            case 6: {
                return "double";
            }
            case 15: {
                return "enum";
            }
            case 12: {
                return "string";
            }
            case 16: {
                return "struct";
            }
            case 14: {
                return "opaque";
            }
            case 13: {
                return "vlen";
            }
        }
        UserType userType = this.userTypes.get(type);
        if (userType == null) {
            return "unknown type " + type;
        }
        switch (userType.typeClass) {
            case 15: {
                return "userType-enum";
            }
            case 16: {
                return "userType-struct";
            }
            case 14: {
                return "userType-opaque";
            }
            case 13: {
                return "userType-vlen";
            }
        }
        return "unknown userType " + userType.typeClass;
    }

    @Override
    public void create(String filename, NetcdfFile ncfile, int extra, long preallocateSize, boolean largeFile) throws IOException {
        Nc4Iosp.load();
        this.ncfile = ncfile;
        ncfile.finish();
        IntByReference ncidp = new IntByReference();
        int ret = nc4.nc_create(filename, this.createMode(), ncidp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        this.ncid = ncidp.getValue();
        this.createGroup(this.ncid, new Group4(ncfile.getRootGroup(), null));
        nc4.nc_enddef(this.ncid);
    }

    private int createMode() {
        switch (this.version) {
            case netcdf4: {
                return 4096;
            }
            case netcdf4_classic: {
                return 4;
            }
            case netcdf3c: {
                return 1;
            }
            case netcdf3c64: {
                return 2;
            }
        }
        throw new IllegalStateException("version = " + (Object)((Object)this.version));
    }

    private void createGroup(int grpid, Group4 g4) throws IOException {
        this.groupHash.put(g4.g, grpid);
        g4.dimHash = new HashMap<Dimension, Integer>();
        for (Attribute att : g4.g.getAttributes()) {
            this.writeAttribute(grpid, -1, att, null);
        }
        for (Dimension dim : g4.g.getDimensions()) {
            int dimid = this.addDimension(grpid, dim.getName(), dim.getLength());
            g4.dimHash.put(dim, dimid);
        }
        for (Variable v : g4.g.getVariables()) {
            int[] dimids = new int[v.getRank()];
            int count = 0;
            for (Dimension d : v.getDimensions()) {
                int dimid = !d.isShared() ? this.addDimension(grpid, v.getShortName() + "_Dim" + count, d.getLength()) : this.findDimensionId(g4, d).intValue();
                dimids[count++] = dimid;
            }
            IntByReference varidp = new IntByReference();
            int typid = this.convertDataType(v.getDataType());
            int ret = nc4.nc_def_var(grpid, v.getShortName(), typid, dimids.length, dimids, varidp);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            int varid = varidp.getValue();
            v.setSPobject(new Vinfo(grpid, varid, typid));
            for (Attribute att : v.getAttributes()) {
                this.writeAttribute(grpid, varid, att, v);
            }
        }
        for (Group nested : g4.g.getGroups()) {
            IntByReference grpidp = new IntByReference();
            int ret = nc4.nc_def_grp(grpid, nested.getShortName(), grpidp);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            int nestedId = grpidp.getValue();
            this.createGroup(nestedId, new Group4(nested, g4));
        }
    }

    private Integer findDimensionId(Group4 g4, Dimension d) {
        if (g4 == null) {
            return null;
        }
        Integer dimid = g4.dimHash.get(d);
        if (dimid == null) {
            dimid = this.findDimensionId(g4.parent, d);
        }
        return dimid;
    }

    private int addDimension(int grpid, String name, int length) throws IOException {
        IntByReference dimidp = new IntByReference();
        int ret = nc4.nc_def_dim(grpid, name, length, dimidp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        return dimidp.getValue();
    }

    private void writeAttribute(int grpid, int varid, Attribute att, Variable v) throws IOException {
        if (v != null && att.getName().equals("_FillValue")) {
            if (att.getLength() != 1) {
                log.warn("_FillValue length must be one on var = " + v.getFullName());
                return;
            }
            if (att.getDataType() != v.getDataType()) {
                log.warn("_FillValue type must agree with var = " + v.getFullName() + " type " + (Object)((Object)att.getDataType()) + "!=" + (Object)((Object)v.getDataType()));
                return;
            }
        }
        if (att.getName().equals("CLASS")) {
            return;
        }
        if (att.getName().equals("DIMENSION_LIST")) {
            return;
        }
        if (att.getName().equals("DIMENSION_SCALE")) {
            return;
        }
        if (att.getName().equals("DIMENSION_LABELS")) {
            return;
        }
        int ret = 0;
        Array values = att.getValues();
        switch (att.getDataType()) {
            case STRING: {
                if (att.getLength() == 1) {
                    byte[] svalb = att.getStringValue().getBytes(CDM.utf8Charset);
                    ret = nc4.nc_put_att_text(grpid, varid, att.getName(), svalb.length, svalb);
                    break;
                }
                String[] svalues = new String[att.getLength()];
                for (int i = 0; i < att.getLength(); ++i) {
                    svalues[i] = (String)att.getValue(i);
                }
                ret = nc4.nc_put_att_string(grpid, varid, att.getName(), att.getLength(), svalues);
                break;
            }
            case BYTE: {
                ret = nc4.nc_put_att_schar(grpid, varid, att.getName(), 1, att.getLength(), (byte[])values.getStorage());
                break;
            }
            case CHAR: {
                ret = nc4.nc_put_att_text(grpid, varid, att.getName(), att.getLength(), IospHelper.convertCharToByte((char[])values.getStorage()));
                break;
            }
            case DOUBLE: {
                ret = nc4.nc_put_att_double(grpid, varid, att.getName(), 6, att.getLength(), (double[])values.getStorage());
                break;
            }
            case FLOAT: {
                ret = nc4.nc_put_att_float(grpid, varid, att.getName(), 5, att.getLength(), (float[])values.getStorage());
                break;
            }
            case INT: {
                ret = nc4.nc_put_att_int(grpid, varid, att.getName(), 4, att.getLength(), (int[])values.getStorage());
                break;
            }
            case LONG: {
                ret = nc4.nc_put_att_longlong(grpid, varid, att.getName(), 10, att.getLength(), (long[])values.getStorage());
                break;
            }
            case SHORT: {
                ret = nc4.nc_put_att_short(grpid, varid, att.getName(), 3, att.getLength(), (short[])values.getStorage());
            }
        }
        if (ret != 0) {
            throw new IOException(ret + " (" + nc4.nc_strerror(ret) + ") on attribute " + att + " on var " + varid + " in group " + grpid);
        }
    }

    @Override
    public void writeData(Variable v2, Section section, Array values) throws IOException, InvalidRangeException {
        Vinfo vinfo = (Vinfo)v2.getSPobject();
        if (vinfo == null) {
            log.error("HEY vinfo null for " + v2);
        }
        this.writeData(v2, vinfo.grpid, vinfo.varid, vinfo.typeid, section, values.getStorage());
    }

    private void writeData(Variable v, int grpid, int varid, int typeid, Section section, Object data) throws IOException, InvalidRangeException {
        long[] origin = this.convert(section.getOrigin());
        long[] shape = this.convert(section.getShape());
        long[] stride = this.convert(section.getStride());
        boolean isUnsigned = this.isUnsigned(typeid);
        int sectionLen = (int)section.computeSize();
        switch (typeid) {
            case 1: 
            case 7: {
                int ret;
                byte[] valb = (byte[])data;
                assert (valb.length == sectionLen);
                int n = ret = isUnsigned ? nc4.nc_put_vars_uchar(grpid, varid, origin, shape, stride, valb) : nc4.nc_put_vars_schar(grpid, varid, origin, shape, stride, valb);
                if (ret == 0) break;
                throw new IOException(nc4.nc_strerror(ret));
            }
            case 2: {
                char[] valc = (char[])data;
                assert (valc.length == sectionLen);
                byte[] valb = IospHelper.convertCharToByte(valc);
                int ret = nc4.nc_put_vars_text(grpid, varid, origin, shape, stride, valb);
                if (ret == 0) break;
                log.error("%s on var %s%n", (Object)nc4.nc_strerror(ret), (Object)v);
                return;
            }
            case 6: {
                double[] vald = (double[])data;
                assert (vald.length == sectionLen);
                int ret = nc4.nc_put_vars_double(grpid, varid, origin, shape, stride, vald);
                if (ret == 0) break;
                throw new IOException(nc4.nc_strerror(ret));
            }
            case 5: {
                float[] valf = (float[])data;
                assert (valf.length == sectionLen);
                int ret = nc4.nc_put_vars_float(grpid, varid, origin, shape, stride, valf);
                if (ret == 0) break;
                log.error("%s on var %s%n", (Object)nc4.nc_strerror(ret), (Object)v);
                return;
            }
            case 4: {
                int ret;
                int[] vali = (int[])data;
                assert (vali.length == sectionLen);
                int n = ret = isUnsigned ? nc4.nc_put_vars_uint(grpid, varid, origin, shape, stride, vali) : nc4.nc_put_vars_int(grpid, varid, origin, shape, stride, vali);
                if (ret == 0) break;
                log.error("%s on var %s%n", (Object)nc4.nc_strerror(ret), (Object)v);
                return;
            }
            case 10: {
                int ret;
                long[] vall = (long[])data;
                assert (vall.length == sectionLen);
                int n = ret = isUnsigned ? nc4.nc_put_vars_ulonglong(grpid, varid, origin, shape, stride, vall) : nc4.nc_put_vars_longlong(grpid, varid, origin, shape, stride, vall);
                if (ret == 0) break;
                throw new IOException(nc4.nc_strerror(ret));
            }
            case 3: {
                int ret;
                short[] vals = (short[])data;
                assert (vals.length == sectionLen);
                int n = ret = isUnsigned ? nc4.nc_put_vars_ushort(grpid, varid, origin, shape, stride, vals) : nc4.nc_put_vars_short(grpid, varid, origin, shape, stride, vals);
                if (ret == 0) break;
                throw new IOException(nc4.nc_strerror(ret));
            }
            case 12: {
                String[] valss = (String[])data;
                assert (valss.length == sectionLen);
                int ret = nc4.nc_put_vars_string(grpid, varid, origin, shape, stride, valss);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
            }
            default: {
                UserType userType = this.userTypes.get(typeid);
                if (userType == null) {
                    throw new IOException("Unknown userType == " + typeid);
                }
                if (userType.typeClass == 15 || userType.typeClass == 13 || userType.typeClass == 14 || userType.typeClass == 16) {
                    // empty if block
                }
                throw new IOException("Unsupported userType = " + typeid + " userType= " + userType);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        int ret = nc4.nc_sync(this.ncid);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret));
        }
        this.updateDimensions(this.ncfile.getRootGroup());
    }

    @Override
    public void setFill(boolean fill) {
    }

    @Override
    public boolean rewriteHeader(boolean largeFile) throws IOException {
        return false;
    }

    @Override
    public void updateAttribute(Variable v2, Attribute att) throws IOException {
    }

    public NetcdfFile open(String location) throws Exception {
        MyNetcdfFile ncfile = new MyNetcdfFile(this);
        ncfile.setLocation(location);
        try {
            this.open(null, ncfile, null);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        return ncfile;
    }

    public static void main(String[] args) throws Exception {
        Nc4Iosp iosp = new Nc4Iosp(NetcdfFileWriter.Version.netcdf4);
        String loc4 = "Q:/cdmUnitTest/formats/netcdf4/files/xma022032.nc";
        String loc3 = "Q:/cdmUnitTest/formats/netcdf3/example1.nc";
        NetcdfFile ncfile = iosp.open(loc4);
        System.out.println("" + ncfile);
    }

    static {
        libName = "netcdf4";
        warn = true;
    }

    private static class MyNetcdfFile
    extends NetcdfFile {
        MyNetcdfFile(IOServiceProvider spi) {
            this.spi = spi;
        }
    }

    private class ConvertedType {
        DataType dt;
        boolean isVen;

        ConvertedType(DataType dt) {
            this.dt = dt;
        }
    }

    private class Field {
        int grpid;
        int typeid;
        int fldidx;
        String name;
        int offset;
        int fldtypeid;
        int ndims;
        int[] dims;
        ConvertedType ctype;
        Array data;

        Field(int grpid, int typeid, int fldidx, String name, int offset, int fldtypeid, int ndims, int[] dims) {
            this.grpid = grpid;
            this.typeid = typeid;
            this.fldidx = fldidx;
            this.name = name;
            this.offset = offset;
            this.fldtypeid = fldtypeid;
            this.ndims = ndims;
            this.dims = new int[ndims];
            System.arraycopy(dims, 0, this.dims, 0, ndims);
            this.ctype = Nc4Iosp.this.convertDataType(fldtypeid);
            Section s = new Section(dims);
            if (Nc4Iosp.this.isVlen(fldtypeid)) {
                int[] edims = new int[dims.length + 1];
                System.arraycopy(edims, 0, dims, 0, dims.length);
                edims[dims.length] = -1;
                dims = edims;
            }
        }

        public String toString2() {
            return "name='" + this.name + " fldtypeid=" + Nc4Iosp.this.getDataTypeName(this.fldtypeid) + " ndims=" + this.ndims + " offset=" + this.offset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Field");
            sb.append("{grpid=").append(this.grpid);
            sb.append(", typeid=").append(this.typeid);
            sb.append(", fldidx=").append(this.fldidx);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", offset=").append(this.offset);
            sb.append(", fldtypeid=").append(this.fldtypeid);
            sb.append(", ndims=").append(this.ndims);
            sb.append(", dims=").append(this.dims == null ? "null" : "");
            for (int i = 0; this.dims != null && i < this.dims.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.dims[i]);
            }
            sb.append(", dtype=").append((Object)this.ctype.dt);
            if (this.ctype.isVen) {
                sb.append("(vlen)");
            }
            sb.append('}');
            return sb.toString();
        }

        Variable makeMemberVariable(Group g, Structure parent) {
            Variable v = new Variable(Nc4Iosp.this.ncfile, g, parent, this.name);
            v.setDataType(((Nc4Iosp)Nc4Iosp.this).convertDataType((int)this.fldtypeid).dt);
            if (Nc4Iosp.this.isUnsigned(this.fldtypeid)) {
                v.addAttribute(new Attribute("_Unsigned", "true"));
            }
            if (this.ctype.isVen) {
                v.setDimensions("*");
            } else {
                try {
                    v.setDimensionsAnonymous(this.dims);
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
            }
            return v;
        }
    }

    private class UserType {
        int grpid;
        int typeid;
        String name;
        int size;
        int baseTypeid;
        long nfields;
        int typeClass;
        EnumTypedef e;
        List<Field> flds;

        UserType(int grpid, int typeid, String name, long size, int baseTypeid, long nfields, int typeClass) throws IOException {
            this.grpid = grpid;
            this.typeid = typeid;
            this.name = name;
            this.size = (int)size;
            this.baseTypeid = baseTypeid;
            this.nfields = nfields;
            this.typeClass = typeClass;
            if (typeClass == 16) {
                this.readFields();
            }
        }

        void setEnum(EnumTypedef e) {
            this.e = e;
        }

        void addField(Field fld) {
            if (this.flds == null) {
                this.flds = new ArrayList<Field>(10);
            }
            this.flds.add(fld);
        }

        public String toString2() {
            return "name='" + this.name + "' id=" + Nc4Iosp.this.getDataTypeName(this.typeid) + " userType=" + Nc4Iosp.this.getDataTypeName(this.typeClass) + " baseType=" + Nc4Iosp.this.getDataTypeName(this.baseTypeid);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UserType");
            sb.append("{grpid=").append(this.grpid);
            sb.append(", typeid=").append(this.typeid);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", size=").append(this.size);
            sb.append(", baseTypeid=").append(this.baseTypeid);
            sb.append(", nfields=").append(this.nfields);
            sb.append(", typeClass=").append(this.typeClass);
            sb.append(", e=").append(this.e);
            sb.append('}');
            return sb.toString();
        }

        void readFields() throws IOException {
            int fldidx = 0;
            while ((long)fldidx < this.nfields) {
                byte[] fldname = new byte[257];
                IntByReference field_typeidp = new IntByReference();
                IntByReference ndimsp = new IntByReference();
                NativeLongByReference offsetp = new NativeLongByReference();
                int[] dims = new int[1024];
                int ret = nc4.nc_inq_compound_field(this.grpid, this.typeid, fldidx, fldname, offsetp, field_typeidp, ndimsp, dims);
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
                Field fld = new Field(this.grpid, this.typeid, fldidx, Nc4Iosp.this.makeString(fldname), offsetp.getValue().intValue(), field_typeidp.getValue(), ndimsp.getValue(), dims);
                this.addField(fld);
                ++fldidx;
            }
        }
    }

    private class Group4 {
        Group g;
        Group4 parent;
        Map<Dimension, Integer> dimHash;

        Group4(Group g, Group4 parent) {
            this.g = g;
            this.parent = parent;
        }
    }

    private class Vinfo {
        int grpid;
        int varid;
        int typeid;
        UserType utype;

        Vinfo(int grpid, int varid, int typeid) {
            this.grpid = grpid;
            this.varid = varid;
            this.typeid = typeid;
        }
    }
}

