/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class Orthographic
extends ProjectionImpl {
    private final double lat0;
    private final double lon0;
    private final double R;
    private double lon0Degrees;
    private double cosLat0;
    private double sinLat0;

    @Override
    public ProjectionImpl constructCopy() {
        return new Orthographic(this.getOriginLat(), this.getOriginLon(), this.R);
    }

    public Orthographic() {
        this(0.0, 0.0);
    }

    public Orthographic(double lat0, double lon0) {
        this(lat0, lon0, EARTH_RADIUS);
    }

    public Orthographic(double lat0, double lon0, double earthRadius) {
        super("Orthographic", false);
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.R = earthRadius;
        this.precalculate();
        this.addParameter("grid_mapping_name", "orthographic");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("earth_radius", earthRadius * 1000.0);
    }

    private void precalculate() {
        this.sinLat0 = Math.sin(this.lat0);
        this.cosLat0 = Math.cos(this.lat0);
        this.lon0Degrees = Math.toDegrees(this.lon0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Orthographic that = (Orthographic)o;
        if (Double.compare(that.R, this.R) != 0) {
            return false;
        }
        if (Double.compare(that.lat0, this.lat0) != 0) {
            return false;
        }
        return Double.compare(that.lon0, this.lon0) == 0;
    }

    public int hashCode() {
        long temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.R != 0.0 ? Double.doubleToLongBits(this.R) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getOriginLon() {
        return Math.toDegrees(this.lon0);
    }

    public double getOriginLat() {
        return Math.toDegrees(this.lat0);
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Orthographic";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Orthographic{lat0=" + this.lat0 + ", lon0=" + this.lon0 + ", R=" + this.R + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
        double cosc = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
        if (cosc >= 0.0) {
            toX = this.R * Math.cos(fromLat) * Math.sin(lonDiff);
            toY = this.R * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff));
        } else {
            toX = Double.POSITIVE_INFINITY;
            toY = Double.POSITIVE_INFINITY;
        }
        result.setLocation(toX, toY);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double toLat;
        double fromX = world.getX();
        double fromY = world.getY();
        double rho = Math.sqrt(fromX * fromX + fromY * fromY);
        double c = Math.asin(rho / this.R);
        double toLon = this.lon0;
        double temp = 0.0;
        if (Math.abs(rho) > 1.0E-6) {
            toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
            if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
            } else if (this.lat0 == 0.7853981633974483) {
                toLon = this.lon0 + Math.atan(fromX / -fromY);
                temp = -fromY;
            } else {
                toLon = this.lon0 + Math.atan(fromX / fromY);
                temp = fromY;
            }
        } else {
            toLat = this.lat0;
        }
        toLat = Math.toDegrees(toLat);
        toLon = Math.toDegrees(toLon);
        if (temp < 0.0) {
            toLon += 180.0;
        }
        toLon = LatLonPointImpl.lonNormal(toLon);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toY;
            double toX;
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
            double cosc = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
            if (cosc >= 0.0) {
                toX = this.R * Math.cos(fromLat) * Math.sin(lonDiff);
                toY = this.R * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff));
            } else {
                toX = Double.POSITIVE_INFINITY;
                toY = Double.POSITIVE_INFINITY;
            }
            resultXA[i] = (float)toX;
            resultYA[i] = (float)toY;
        }
        return to;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toLat;
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double rho = Math.sqrt(fromX * fromX + fromY * fromY);
            double c = Math.asin(rho / this.R);
            double toLon = this.lon0;
            double temp = 0.0;
            if (Math.abs(rho) > 1.0E-6) {
                toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
                if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                    temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                    toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
                } else if (this.lat0 == 0.7853981633974483) {
                    toLon = this.lon0 + Math.atan(fromX / -fromY);
                    temp = -fromY;
                } else {
                    toLon = this.lon0 + Math.atan(fromX / fromY);
                    temp = fromY;
                }
            } else {
                toLat = this.lat0;
            }
            toLat = Math.toDegrees(toLat);
            toLon = Math.toDegrees(toLon);
            if (temp < 0.0) {
                toLon += 180.0;
            }
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toY;
            double toX;
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
            double cosc = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
            if (cosc >= 0.0) {
                toX = this.R * Math.cos(fromLat) * Math.sin(lonDiff);
                toY = this.R * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff));
            } else {
                toX = Double.POSITIVE_INFINITY;
                toY = Double.POSITIVE_INFINITY;
            }
            resultXA[i] = toX;
            resultYA[i] = toY;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toLat;
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double rho = Math.sqrt(fromX * fromX + fromY * fromY);
            double c = Math.asin(rho / this.R);
            double toLon = this.lon0;
            double temp = 0.0;
            if (Math.abs(rho) > 1.0E-6) {
                toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
                if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                    temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                    toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
                } else if (this.lat0 == 0.7853981633974483) {
                    toLon = this.lon0 + Math.atan(fromX / -fromY);
                    temp = -fromY;
                } else {
                    toLon = this.lon0 + Math.atan(fromX / fromY);
                    temp = fromY;
                }
            } else {
                toLat = this.lat0;
            }
            toLat = Math.toDegrees(toLat);
            toLon = Math.toDegrees(toLon);
            if (temp < 0.0) {
                toLon += 180.0;
            }
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }

    public static void main(String[] args) {
        Orthographic a = new Orthographic(40.0, -100.0);
        ProjectionPointImpl p = a.latLonToProj(30.0, -110.0);
        System.out.println("proj point = " + p);
        LatLonPoint ll = a.projToLatLon(p);
        System.out.println("ll = " + ll);
    }
}

