/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class RafNimbus
extends TableConfigurerImpl {
    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String center = ds.findAttValueIgnoreCase(null, "Convention", null);
        return center != null && center.equals("NCAR-RAF/nimbus");
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        TableConfig topTable = new TableConfig(Table.Type.Top, "singleTrajectory");
        CoordinateAxis coordAxis = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (coordAxis == null) {
            errlog.format("Cant find a time coordinate", new Object[0]);
            return null;
        }
        Dimension innerDim = coordAxis.getDimension(0);
        boolean obsIsStruct = Evaluator.hasRecordStructure(ds) && innerDim.isUnlimited();
        TableConfig obsTable = new TableConfig(Table.Type.Structure, innerDim.getName());
        obsTable.dimName = innerDim.getName();
        obsTable.time = coordAxis.getFullName();
        obsTable.structName = obsIsStruct ? "record" : innerDim.getName();
        obsTable.structureType = obsIsStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
        CoordSysEvaluator.findCoordWithDimension(obsTable, ds, innerDim);
        topTable.addChild(obsTable);
        return topTable;
    }
}

