/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.grib1.Grib1IndexProto;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.grib.grib1.Grib1SectionBitMap;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Index
extends GribIndex {
    private static Logger log = LoggerFactory.getLogger(Grib1Index.class);
    public static final String MAGIC_START = "Grib1Index";
    private static final int version = 5;
    private static final boolean debug = false;
    private List<Grib1SectionGridDefinition> gdsList;
    private List<Grib1Record> records;

    public List<Grib1SectionGridDefinition> getGds() {
        return this.gdsList;
    }

    public List<Grib1Record> getRecords() {
        return this.records;
    }

    @Override
    public int getNRecords() {
        return this.records.size();
    }

    public boolean readIndex(String filename, long gribLastModified) throws IOException {
        return this.readIndex(filename, gribLastModified, CollectionManager.Force.test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readIndex(String filename, long gribLastModified, CollectionManager.Force force) throws IOException {
        boolean bl;
        File idxFile = GribCollection.getIndexFile(filename + ".gbx9");
        if (!idxFile.exists()) {
            return false;
        }
        long idxModified = idxFile.lastModified();
        if (force != CollectionManager.Force.nocheck && idxModified < gribLastModified) {
            return false;
        }
        FileInputStream fin = new FileInputStream(idxFile);
        try {
            if (!NcStream.readAndTest(fin, MAGIC_START.getBytes())) {
                log.info("Bad magic number of grib index, on file" + idxFile);
                boolean bl2 = false;
                return bl2;
            }
            int v = NcStream.readVInt(fin);
            if (v != 5) {
                if (v == 0 || v > 5) {
                    throw new IOException("Grib1Index found version " + v + ", want version " + 5 + " on " + filename);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Grib1Index found version " + v + ", want version " + 5 + " on " + filename);
                }
                boolean bl3 = false;
                return bl3;
            }
            int size = NcStream.readVInt(fin);
            if (size <= 0 || size > 100000000) {
                log.warn("Grib1Index bad size = {} for {} ", size, (Object)filename);
                boolean bl4 = false;
                return bl4;
            }
            byte[] m = new byte[size];
            NcStream.readFully(fin, m);
            Grib1IndexProto.Grib1Index proto = Grib1IndexProto.Grib1Index.parseFrom(m);
            String fname = proto.getFilename();
            this.gdsList = new ArrayList<Grib1SectionGridDefinition>(proto.getGdsListCount());
            for (Grib1IndexProto.Grib1GdsSection pgds : proto.getGdsListList()) {
                Grib1SectionGridDefinition gds = this.readGds(pgds);
                this.gdsList.add(gds);
            }
            this.records = new ArrayList<Grib1Record>(proto.getRecordsCount());
            for (Grib1IndexProto.Grib1Record precord : proto.getRecordsList()) {
                this.records.add(this.readRecord(precord));
            }
        }
        catch (NegativeArraySizeException e) {
            log.error("GribIndex failed on " + filename, e);
            bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error("GribIndex failed on " + filename, e);
            bl = false;
            return bl;
        }
        finally {
            fin.close();
        }
        return true;
    }

    private Grib1Record readRecord(Grib1IndexProto.Grib1Record p) {
        Grib1SectionIndicator is = new Grib1SectionIndicator(p.getGribMessageStart(), p.getGribMessageLength());
        Grib1SectionProductDefinition pds = new Grib1SectionProductDefinition(p.getPds().toByteArray());
        Grib1SectionGridDefinition gds = pds.gdsExists() ? this.gdsList.get(p.getGdsIdx()) : new Grib1SectionGridDefinition(pds);
        Grib1SectionBitMap bms = pds.bmsExists() ? new Grib1SectionBitMap(p.getBmsPos()) : null;
        Grib1SectionBinaryData dataSection = new Grib1SectionBinaryData(p.getDataPos(), p.getDataLen());
        return new Grib1Record(p.getHeader().toByteArray(), is, gds, pds, bms, dataSection);
    }

    private Grib1SectionGridDefinition readGds(Grib1IndexProto.Grib1GdsSection proto) {
        ByteString bytes = proto.getGds();
        return new Grib1SectionGridDefinition(bytes.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean makeIndex(String filename, Formatter f) throws IOException {
        File idxFile = GribCollection.getIndexFile(filename + ".gbx9");
        FileOutputStream fout = new FileOutputStream(idxFile);
        RandomAccessFile raf = null;
        try {
            Grib1Record r;
            fout.write(MAGIC_START.getBytes("UTF-8"));
            NcStream.writeVInt(fout, 5);
            HashMap<Long, Integer> gdsMap = new HashMap<Long, Integer>();
            this.gdsList = new ArrayList<Grib1SectionGridDefinition>();
            this.records = new ArrayList<Grib1Record>(200);
            Grib1IndexProto.Grib1Index.Builder rootBuilder = Grib1IndexProto.Grib1Index.newBuilder();
            rootBuilder.setFilename(filename);
            raf = new RandomAccessFile(filename, "r");
            Grib1RecordScanner scan = new Grib1RecordScanner(raf);
            while (scan.hasNext() && (r = scan.next()) != null) {
                this.records.add(r);
                Grib1SectionGridDefinition gds = r.getGDSsection();
                Integer index = (Integer)gdsMap.get(gds.calcCRC());
                if (gds.getPredefinedGridDefinition() >= 0) {
                    index = 0;
                } else if (index == null) {
                    this.gdsList.add(gds);
                    index = this.gdsList.size() - 1;
                    gdsMap.put(gds.calcCRC(), index);
                    rootBuilder.addGdsList(this.makeGdsProto(gds));
                }
                rootBuilder.addRecords(this.makeRecordProto(r, index));
            }
            Grib1IndexProto.Grib1Index index = rootBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt(fout, b.length);
            fout.write(b);
            f.format("  made gbx9 index for %s size=%d%n", filename, b.length);
            boolean bl = true;
            return bl;
        }
        finally {
            fout.close();
            if (raf != null) {
                raf.close();
            }
        }
    }

    private Grib1IndexProto.Grib1Record makeRecordProto(Grib1Record r, int gdsIndex) throws IOException {
        Grib1IndexProto.Grib1Record.Builder b = Grib1IndexProto.Grib1Record.newBuilder();
        b.setHeader(ByteString.copyFrom(r.getHeader()));
        b.setGribMessageStart(r.getIs().getStartPos());
        b.setGribMessageLength(r.getIs().getMessageLength());
        b.setGdsIdx(gdsIndex);
        Grib1SectionProductDefinition pds = r.getPDSsection();
        b.setPds(ByteString.copyFrom(pds.getRawBytes()));
        if (pds.bmsExists()) {
            Grib1SectionBitMap bms = r.getBitMapSection();
            b.setBmsPos(bms.getStartingPosition());
        }
        Grib1SectionBinaryData ds = r.getDataSection();
        b.setDataPos(ds.getStartingPosition());
        b.setDataLen(ds.getLength());
        return b.build();
    }

    private Grib1IndexProto.Grib1GdsSection makeGdsProto(Grib1SectionGridDefinition gds) throws IOException {
        Grib1IndexProto.Grib1GdsSection.Builder b = Grib1IndexProto.Grib1GdsSection.newBuilder();
        b.setGds(ByteString.copyFrom(gds.getRawBytes()));
        return b.build();
    }

    public static void main(String[] args) throws IOException {
        String filename = "G:/tigge/uv/z_tigge_c_kwbc_20110605120000_glob_prod_cf_HGHT_0000_000_10_uv.grib";
        new Grib1Index().makeIndex(filename, new Formatter(System.out));
    }
}

