/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib2.Grib2Tables;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.grid.GridEnsembleCoord;
import ucar.nc2.iosp.grid.GridRecord;

public class GribEnsembleCoord
extends GridEnsembleCoord {
    private static Logger log = LoggerFactory.getLogger(GribEnsembleCoord.class);

    GribEnsembleCoord(List<GridRecord> records) {
        HashMap<Integer, GridEnsembleCoord.EnsCoord> map = new HashMap<Integer, GridEnsembleCoord.EnsCoord>();
        for (GridRecord record : records) {
            GribGridRecord ggr = (GribGridRecord)record;
            int ensNumber = ggr.getPds().getPerturbationNumber();
            int ensType = ggr.getPds().getPerturbationType();
            int h = 1000 * ensNumber + ensType;
            map.put(h, new GridEnsembleCoord.EnsCoord(ensNumber, ensType));
        }
        this.ensCoords = new ArrayList(map.values());
        Collections.sort(this.ensCoords);
    }

    @Override
    protected void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        Variable v = new Variable(ncfile, g, null, this.getName());
        v.setDimensions(v.getShortName());
        v.setDataType(DataType.STRING);
        v.addAttribute(new Attribute("long_name", "ensemble"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        String[] data = new String[this.getNEnsembles()];
        for (int i = 0; i < this.getNEnsembles(); ++i) {
            GridEnsembleCoord.EnsCoord ec = (GridEnsembleCoord.EnsCoord)this.ensCoords.get(i);
            data[i] = Grib2Tables.codeTable4_6(ec.type) + " " + ec.number;
        }
        Array dataArray = Array.factory(DataType.STRING, new int[]{this.getNEnsembles()}, (Object)data);
        v.setCachedData(dataArray, false);
        ncfile.addVariable(g, v);
    }

    int getIndex(GribGridRecord ggr) {
        int ensNumber = ggr.getPds().getPerturbationNumber();
        int ensType = ggr.getPds().getPerturbationType();
        int count = 0;
        for (GridEnsembleCoord.EnsCoord coord : this.ensCoords) {
            if (coord.number == ensNumber && coord.type == ensType) {
                return count;
            }
            ++count;
        }
        return -1;
    }
}

