/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    private OutputStream myOutput;
    private int myBuffer;
    private int myBitsToGo;
    private static final int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final int BITS_PER_BYTE = 8;

    @Override
    public void write(int b) throws IOException {
        this.myOutput.write(b);
    }

    public BitOutputStream(OutputStream out) {
        this.myOutput = out;
        this.initialize();
    }

    private void initialize() {
        this.myBuffer = 0;
        this.myBitsToGo = 8;
    }

    public BitOutputStream(String filename) {
        try {
            this.myOutput = new BufferedOutputStream(new FileOutputStream(filename));
        }
        catch (FileNotFoundException fnf) {
            System.err.println("could not create " + filename + " " + fnf);
        }
        catch (SecurityException se) {
            System.err.println("security exception on write " + se);
        }
        this.initialize();
    }

    @Override
    public void flush() {
        if (this.myBitsToGo != 8) {
            try {
                this.write(this.myBuffer << this.myBitsToGo);
            }
            catch (IOException ioe) {
                System.err.println("error writing bits on flush " + ioe);
            }
            this.myBuffer = 0;
            this.myBitsToGo = 8;
        }
        try {
            this.myOutput.flush();
        }
        catch (IOException ioe) {
            System.err.println("error on flush " + ioe);
        }
    }

    @Override
    public void close() {
        this.flush();
        try {
            this.myOutput.close();
        }
        catch (IOException ioe) {
            System.err.println("error closing BitOutputStream " + ioe);
        }
    }

    public void write(int howManyBits, int value) throws IOException {
        value &= bmask[howManyBits];
        while (howManyBits >= this.myBitsToGo) {
            this.myBuffer = this.myBuffer << this.myBitsToGo | value >> howManyBits - this.myBitsToGo;
            this.write(this.myBuffer);
            value &= bmask[howManyBits - this.myBitsToGo];
            howManyBits -= this.myBitsToGo;
            this.myBitsToGo = 8;
            this.myBuffer = 0;
        }
        if (howManyBits > 0) {
            this.myBuffer = this.myBuffer << howManyBits | value;
            this.myBitsToGo -= howManyBits;
        }
    }
}

