/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.inventory.CollectionManager;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.GribIosp;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimeCoordUnion;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1TimePartition;
import ucar.nc2.grib.grib1.Grib1TimePartitionBuilder;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.util.CancelTask;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public class Grib1Iosp
extends GribIosp {
    private static final float MISSING_VALUE = Float.NaN;
    private static final Logger logger = LoggerFactory.getLogger(Grib1Iosp.class);
    private static final boolean debugTime = false;
    private static final boolean debugRead = false;
    private Grib1TimePartition timePartition;
    private GribCollection gribCollection;
    private Grib1Customizer cust;
    private GribCollection.GroupHcs gHcs;
    private boolean isTimePartitioned;
    private boolean owned;

    public static String makeVariableLongName(Grib1Customizer cust, GribCollection gribCollection, GribCollection.VariableIndex vindex) {
        return cust.makeVariableLongName(gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter, vindex.levelType, vindex.intvType, vindex.intvName, vindex.isLayer, vindex.probabilityName);
    }

    public static String makeVariableUnits(Grib1Customizer cust, GribCollection gribCollection, GribCollection.VariableIndex vindex) {
        return cust.makeVariableUnits(gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        byte[] b = new byte["Grib1CollectionIndex".length()];
        raf.readFully(b);
        String magic = new String(b);
        if (magic.equals("Grib1CollectionIndex")) {
            return true;
        }
        if (magic.equals("Grib1Partition0Index")) {
            return true;
        }
        return Grib1RecordScanner.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.GRIB1.toString();
    }

    @Override
    public String getFileTypeDescription() {
        return "GRIB1 Collection";
    }

    public Grib1Iosp() {
    }

    public Grib1Iosp(GribCollection.GroupHcs gHcs) {
        this.gHcs = gHcs;
        this.owned = true;
    }

    public Grib1Iosp(GribCollection gc) {
        this.gribCollection = gc;
        this.owned = true;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        boolean isGrib;
        super.open(raf, ncfile, cancelTask);
        Grib1ParamTables tables = this.gribConfig.paramTable != null ? Grib1ParamTables.factory(this.gribConfig.paramTable) : Grib1ParamTables.factory(this.gribConfig.paramTablePath, this.gribConfig.lookupTablePath);
        boolean bl = isGrib = raf != null && Grib1RecordScanner.isValidFile(raf);
        if (isGrib) {
            this.gribCollection = GribIndex.makeGribCollectionFromSingleFile(true, raf, this.gribConfig, CollectionManager.Force.test, new Formatter());
            this.cust = Grib1Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getLocal(), tables);
        }
        if (this.gHcs != null) {
            this.gribCollection = this.gHcs.getGribCollection();
            if (this.gribCollection instanceof Grib1TimePartition) {
                this.isTimePartitioned = true;
                this.timePartition = (Grib1TimePartition)this.gribCollection;
            }
            this.cust = Grib1Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getLocal(), tables);
            this.addGroup(ncfile, this.gHcs, false);
        } else if (this.gribCollection != null) {
            if (this.gribCollection instanceof Grib1TimePartition) {
                this.isTimePartitioned = true;
                this.timePartition = (Grib1TimePartition)this.gribCollection;
            }
            this.cust = Grib1Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getLocal(), tables);
            boolean useGroups = this.gribCollection.getGroups().size() > 1;
            ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(this.gribCollection.getGroups());
            Collections.sort(groups);
            for (GribCollection.GroupHcs g : groups) {
                this.addGroup(ncfile, g, useGroups);
            }
        } else {
            String name;
            raf.seek(0L);
            byte[] b = new byte["Grib1Partition0Index".length()];
            raf.readFully(b);
            String magic = new String(b);
            this.isTimePartitioned = magic.equals("Grib1Partition0Index");
            String location = raf.getLocation();
            File f = new File(location);
            int pos = f.getName().lastIndexOf(".");
            String string = name = pos > 0 ? f.getName().substring(0, pos) : f.getName();
            if (this.isTimePartitioned) {
                this.timePartition = Grib1TimePartitionBuilder.createFromIndex(name, f.getParentFile(), raf);
                this.gribCollection = this.timePartition;
            } else {
                this.gribCollection = Grib1CollectionBuilder.createFromIndex(name, f.getParentFile(), raf, this.gribConfig);
            }
            this.cust = Grib1Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getLocal(), tables);
            ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(this.gribCollection.getGroups());
            Collections.sort(groups);
            boolean useGroups = groups.size() > 1;
            for (GribCollection.GroupHcs g : groups) {
                this.addGroup(ncfile, g, useGroups);
            }
        }
        String val = CommonCodeTable.getCenterName(this.gribCollection.getCenter(), 2);
        ncfile.addAttribute(null, new Attribute("Originating_or_generating_Center", val == null ? Integer.toString(this.gribCollection.getCenter()) : val));
        val = this.cust.getSubCenterName(this.gribCollection.getSubcenter());
        ncfile.addAttribute(null, new Attribute("Originating_or_generating_Subcenter", val == null ? Integer.toString(this.gribCollection.getSubcenter()) : val));
        val = this.cust.getGeneratingProcessName(this.gribCollection.getGenProcessId());
        if (val != null) {
            ncfile.addAttribute(null, new Attribute("Generating_process_or_model", val));
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.6"));
        ncfile.addAttribute(null, new Attribute("history", "Read using CDM IOSP Grib1Collection"));
        ncfile.addAttribute(null, new Attribute("featureType", FeatureType.GRID.name()));
        ncfile.addAttribute(null, new Attribute("file_format", this.getFileTypeId()));
        for (Parameter p : this.gribCollection.getParams()) {
            ncfile.addAttribute(null, new Attribute(p));
        }
    }

    private void addGroup(NetcdfFile ncfile, GribCollection.GroupHcs gHcs, boolean useGroups) {
        String horizDims;
        Group g;
        GdsHorizCoordSys hcs = gHcs.hcs;
        VertCoord.assignVertNames(gHcs.vertCoords, this.cust);
        String grid_mapping = hcs.getName() + "_Projection";
        if (useGroups) {
            g = new Group(ncfile, null, gHcs.getId());
            g.addAttribute(new Attribute("long_name", gHcs.getDescription()));
            try {
                ncfile.addGroup(null, g);
            }
            catch (Exception e) {
                logger.warn("Duplicate Group - skipping");
                return;
            }
        } else {
            g = ncfile.getRootGroup();
        }
        if (hcs == null) {
            logger.error("No GdsHorizCoordSys for gds template {} center {}", gHcs.hcs.template, (Object)this.gribCollection.getCenter());
            throw new IllegalStateException();
        }
        if (hcs.isLatLon()) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
            Variable cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lat", DataType.FLOAT, "lat"));
            cv.addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.gaussLats != null) {
                cv.setCachedData(hcs.gaussLats);
            } else {
                cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
            }
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lon", DataType.FLOAT, "lon"));
            cv.addAttribute(new Attribute("units", "degrees_east"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
        } else {
            Variable hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            ncfile.addDimension(g, new Dimension("x", hcs.nx));
            ncfile.addDimension(g, new Dimension("y", hcs.ny));
            Variable cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "x", DataType.FLOAT, "x"));
            cv.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "y", DataType.FLOAT, "y"));
            cv.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
        }
        for (VertCoord vc : gHcs.vertCoords) {
            this.addVerticalCoordinate(ncfile, g, vc);
        }
        for (TimeCoord tc : gHcs.timeCoords) {
            this.addTimeCoordinate(ncfile, g, tc);
        }
        int ccount = 0;
        for (EnsCoord ec : gHcs.ensCoords) {
            int n = ec.getSize();
            String ecName = "ens" + ccount;
            ncfile.addDimension(g, new Dimension(ecName, n));
            Variable v = new Variable(ncfile, g, null, ecName, DataType.INT, ecName);
            ncfile.addVariable(g, v);
            ++ccount;
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
            int[] data = new int[n];
            int count = 0;
            for (EnsCoord.Coord ecc : ec.getCoords()) {
                data[count++] = ecc.getEnsMember();
            }
            v.setCachedData(Array.factory(DataType.INT, new int[]{n}, (Object)data));
        }
        for (GribCollection.VariableIndex vindex : gHcs.varIndex) {
            GribStatType statType;
            TimeCoord tc = gHcs.timeCoords.get(vindex.timeIdx);
            VertCoord vc = vindex.vertIdx < 0 ? null : gHcs.vertCoords.get(vindex.vertIdx);
            EnsCoord ec = vindex.ensIdx < 0 ? null : gHcs.ensCoords.get(vindex.ensIdx);
            StringBuilder dims = new StringBuilder();
            String tcName = tc.getName();
            dims.append(tcName);
            if (ec != null) {
                dims.append(" ").append("ens").append(vindex.ensIdx);
            }
            if (vc != null) {
                dims.append(" ").append(vc.getName());
            }
            dims.append(" ").append(horizDims);
            String vname = this.cust.makeVariableName(this.gribCollection, vindex);
            Variable v = new Variable(ncfile, g, null, vname, DataType.FLOAT, dims.toString());
            ncfile.addVariable(g, v);
            String desc = Grib1Iosp.makeVariableLongName(this.cust, this.gribCollection, vindex);
            v.addAttribute(new Attribute("long_name", desc));
            v.addAttribute(new Attribute("units", Grib1Iosp.makeVariableUnits(this.cust, this.gribCollection, vindex)));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(Float.NaN)));
            v.addAttribute(new Attribute("grid_mapping", grid_mapping));
            v.addAttribute(new Attribute("Grib_Variable_Id", this.cust.makeVariableNameFromRecord(this.gribCollection, vindex)));
            v.addAttribute(new Attribute("Grib1_Center", this.gribCollection.center));
            v.addAttribute(new Attribute("Grib1_Subcenter", this.gribCollection.subcenter));
            v.addAttribute(new Attribute("Grib1_TableVersion", vindex.tableVersion));
            v.addAttribute(new Attribute("Grib1_Parameter", vindex.parameter));
            Grib1Parameter param = this.cust.getParameter(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter);
            if (param != null && param.getName() != null) {
                v.addAttribute(new Attribute("Grib1_Parameter_Name", param.getName()));
            }
            v.addAttribute(new Attribute("Grib1_Level_Type", vindex.levelType));
            if (vindex.intvName != null && vindex.intvName.length() != 0) {
                v.addAttribute(new Attribute("time_interval", vindex.intvName));
            }
            if (vindex.intvType >= 0 && (statType = this.cust.getStatType(vindex.intvType)) != null) {
                v.addAttribute(new Attribute("Grib1_Statistical_Interval_Type", vindex.intvType));
                v.addAttribute(new Attribute("Grib1_Statistical_Interval_Name", statType.toString()));
                CF.CellMethods cm = GribStatType.getCFCellMethod(statType);
                if (cm != null) {
                    v.addAttribute(new Attribute("cell_methods", tcName + ": " + cm.toString()));
                }
            }
            if (vindex.ensDerivedType >= 0) {
                v.addAttribute(new Attribute("Grib1_Ensemble_Derived_Type", vindex.ensDerivedType));
            } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
                v.addAttribute(new Attribute("Grib1_Probability_Type", vindex.probabilityName));
            }
            v.setSPobject(vindex);
        }
    }

    private void addTimeCoordinate(NetcdfFile ncfile, Group g, TimeCoord tc) {
        int n = tc.getSize();
        String tcName = tc.getName();
        ncfile.addDimension(g, new Dimension(tcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.INT, tcName));
        v.addAttribute(new Attribute("units", tc.getUnits()));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", this.cust.getTimeTypeName(tc.getCode())));
        int[] data = new int[n];
        int count = 0;
        if (tc.isInterval()) {
            for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                data[count++] = tinv.getBounds2();
            }
        } else {
            Iterator<Comparable<TimeCoord.Tinv>> i$ = tc.getCoords().iterator();
            while (i$.hasNext()) {
                int val = (Integer)i$.next();
                data[count++] = val;
            }
        }
        v.setCachedData(Array.factory(DataType.INT, new int[]{n}, (Object)data));
        if (tc.isInterval()) {
            GribStatType statType = this.cust.getStatType(tc.getCode());
            if (statType == null) {
                v.addAttribute(new Attribute("Grib1_statistical_type", tc.getCode()));
            } else {
                v.addAttribute(new Attribute("Grib1_statistical_type", GribStatType.getStatTypeDescription(statType)));
            }
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName + "_bounds", DataType.INT, tcName + " 2"));
            v.addAttribute(new Attribute("bounds", tcName + "_bounds"));
            bounds.addAttribute(new Attribute("units", tc.getUnits()));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            data = new int[2 * n];
            count = 0;
            for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                data[count++] = tinv.getBounds1();
                data[count++] = tinv.getBounds2();
            }
            bounds.setCachedData(Array.factory(DataType.INT, new int[]{n, 2}, (Object)data));
        }
    }

    private void addVerticalCoordinate(NetcdfFile ncfile, Group g, VertCoord vc) {
        int n = vc.getSize();
        String vcName = vc.getName();
        ncfile.addDimension(g, new Dimension(vcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName, DataType.FLOAT, vcName));
        if (vc.getUnits() != null) {
            v.addAttribute(new Attribute("units", vc.getUnits()));
            String desc = this.cust.getLevelDescription(vc.getCode());
            if (desc != null) {
                v.addAttribute(new Attribute("long_name", desc));
            }
            v.addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
        }
        v.addAttribute(new Attribute("Grib1_level_code", vc.getCode()));
        String datum = this.cust.getLevelDatum(vc.getCode());
        if (datum != null) {
            v.addAttribute(new Attribute("datum", datum));
        }
        if (vc.isLayer()) {
            float[] data = new float[n];
            int count = 0;
            for (VertCoord.Level val : vc.getCoords()) {
                data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
            }
            v.setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName + "_bounds", DataType.FLOAT, vcName + " 2"));
            v.addAttribute(new Attribute("bounds", vcName + "_bounds"));
            bounds.addAttribute(new Attribute("units", vc.getUnits()));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + vcName));
            data = new float[2 * n];
            count = 0;
            for (VertCoord.Level level : vc.getCoords()) {
                data[count++] = (float)level.getValue1();
                data[count++] = (float)level.getValue2();
            }
            bounds.setCachedData(Array.factory(DataType.FLOAT, new int[]{n, 2}, (Object)data));
        } else {
            float[] data = new float[n];
            int count = 0;
            for (VertCoord.Level val : vc.getCoords()) {
                data[count++] = (float)val.getValue1();
            }
            v.setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
        }
        if (vc.getCode() == 109) {
            // empty if block
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.owned && this.gribCollection != null) {
            this.gribCollection.close();
        }
        this.gribCollection = null;
        super.close();
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        if (this.gribCollection != null) {
            this.gribCollection.showIndex(f);
        }
        return f.toString();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        Array result = this.isTimePartitioned ? this.readDataFromPartition(v2, section) : this.readDataFromCollection(v2, section);
        long took = System.currentTimeMillis() - start;
        return result;
    }

    private Array readDataFromPartition(Variable v2, Section section) throws IOException, InvalidRangeException {
        TimePartition.VariableIndexPartitioned vindexP = (TimePartition.VariableIndexPartitioned)v2.getSPobject();
        int rangeIdx = 0;
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range ensRange = vindexP.ensIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = vindexP.vertIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        DataReceiver dataReceiver = new DataReceiver(section, yRange, xRange);
        DataReaderPartitioned dataReader = new DataReaderPartitioned();
        TimeCoordUnion timeCoordP = (TimeCoordUnion)vindexP.getTimeCoord();
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            TimeCoordUnion.Val val = timeCoordP.getVal(timeIdx);
            int partno = val.getPartition();
            GribCollection.VariableIndex vindex = vindexP.getVindex(partno);
            for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    int resultIndex = GribCollection.calcIndex(timeRange.index(timeIdx), ensRange.index(ensIdx), levRange.index(levelIdx), ensRange.length(), levRange.length());
                    int recordIndex = -1;
                    int flag = vindexP.flag[partno];
                    recordIndex = flag == 0 ? GribCollection.calcIndex(val.getIndex(), ensIdx, levelIdx, vindex.nens, vindex.nverts) : GribCollection.calcIndex(val.getIndex(), ensIdx, levelIdx, flag, vindex.getEnsCoord(), vindex.getVertCoord(), vindexP.getEnsCoord(), vindexP.getVertCoord());
                    if (recordIndex < 0) continue;
                    GribCollection.Record record = vindex.records[recordIndex];
                    dataReader.addRecord(vindex, partno, record.fileno, record.pos, resultIndex);
                }
            }
        }
        dataReader.read(dataReceiver);
        vindexP.cleanup();
        return dataReceiver.getArray();
    }

    private Array readDataFromCollection(Variable v, Section section) throws IOException, InvalidRangeException {
        GribCollection.VariableIndex vindex = (GribCollection.VariableIndex)v.getSPobject();
        if (vindex.records == null) {
            vindex.readRecords();
        }
        int rangeIdx = 0;
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range ensRange = vindex.ensIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = vindex.vertIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        DataReceiver dataReceiver = new DataReceiver(section, yRange, xRange);
        DataReader dataReader = new DataReader(vindex);
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    int resultIndex = GribCollection.calcIndex(timeRange.index(timeIdx), ensRange.index(ensIdx), levRange.index(levelIdx), ensRange.length(), levRange.length());
                    dataReader.addRecord(ensIdx, timeIdx, levelIdx, resultIndex);
                }
            }
        }
        dataReader.read(dataReceiver);
        return dataReceiver.getArray();
    }

    private void show(Grib1Record gr, long dataPos) {
        if (gr == null) {
            return;
        }
        Formatter f = new Formatter();
        f.format("File=%s%n", this.raf.getLocation());
        Grib1SectionProductDefinition pds = gr.getPDSsection();
        Grib1Parameter param = this.cust.getParameter(pds.getCenter(), pds.getSubCenter(), pds.getTableVersion(), pds.getParameterNumber());
        f.format("  Parameter=%s%n", param);
        f.format("  ReferenceDate=%s%n", gr.getReferenceDate());
        Grib1ParamTime ptime = pds.getParamTime(this.cust);
        f.format("  ForecastTime=%d%n", ptime.getForecastTime());
        if (ptime.isInterval()) {
            int[] tinv = ptime.getInterval();
            f.format("  TimeInterval=(%d,%d)%n", tinv[0], tinv[1]);
        }
        f.format("%n", new Object[0]);
        gr.getPDSsection().showPds(this.cust, f);
        System.out.printf("%nGrib1Record.readData at drsPos %d = %s%n", dataPos, f.toString());
    }

    private class DataReceiver {
        Array dataArray;
        Range yRange;
        Range xRange;
        int horizSize;

        DataReceiver(Section section, Range yRange, Range xRange) {
            this.dataArray = Array.factory(DataType.FLOAT, section.getShape());
            this.yRange = yRange;
            this.xRange = xRange;
            this.horizSize = yRange.length() * xRange.length();
            IndexIterator iter = this.dataArray.getIndexIterator();
            while (iter.hasNext()) {
                iter.setFloatNext(Float.NaN);
            }
        }

        void addData(float[] data, int resultIndex, int nx) throws IOException {
            int start = resultIndex * this.horizSize;
            int count = 0;
            for (int y = this.yRange.first(); y <= this.yRange.last(); y += this.yRange.stride()) {
                for (int x = this.xRange.first(); x <= this.xRange.last(); x += this.xRange.stride()) {
                    int dataIdx = y * nx + x;
                    this.dataArray.setFloat(start + count, data[dataIdx]);
                    ++count;
                }
            }
        }

        Array getArray() {
            return this.dataArray;
        }
    }

    private class DataReader {
        GribCollection.VariableIndex vindex;
        List<DataRecord> records = new ArrayList<DataRecord>();

        private DataReader(GribCollection.VariableIndex vindex) {
            this.vindex = vindex;
        }

        void addRecord(int ensIdx, int timeIdx, int levIdx, int resultIndex) {
            int recordIndex = GribCollection.calcIndex(timeIdx, ensIdx, levIdx, this.vindex.nens, this.vindex.nverts);
            GribCollection.Record record = this.vindex.records[recordIndex];
            this.records.add(new DataRecord(timeIdx, ensIdx, levIdx, resultIndex, record.fileno, record.pos));
        }

        void read(DataReceiver dataReceiver) throws IOException {
            Collections.sort(this.records);
            int currFile = -1;
            RandomAccessFile rafData = null;
            for (DataRecord dr : this.records) {
                if (dr.fileno != currFile) {
                    if (rafData != null) {
                        rafData.close();
                    }
                    rafData = Grib1Iosp.this.gribCollection.getDataRaf(dr.fileno);
                    currFile = dr.fileno;
                }
                if (dr.pos == -1L) continue;
                float[] data = Grib1Record.readData(rafData, dr.pos);
                dataReceiver.addData(data, dr.resultIndex, this.vindex.group.hcs.nx);
            }
            if (rafData != null) {
                rafData.close();
            }
        }

        private class DataRecord
        implements Comparable<DataRecord> {
            int ensIdx;
            int timeIdx;
            int levIdx;
            int resultIndex;
            int fileno;
            long pos;

            DataRecord(int timeIdx, int ensIdx, int levIdx, int resultIndex, int fileno, long pos) {
                this.ensIdx = ensIdx;
                this.timeIdx = timeIdx;
                this.levIdx = levIdx;
                this.resultIndex = resultIndex;
                this.fileno = fileno;
                this.pos = pos;
            }

            @Override
            public int compareTo(DataRecord o) {
                int r = this.fileno - o.fileno;
                return r == 0 ? (int)(this.pos - o.pos) : r;
            }
        }
    }

    private class DataReaderPartitioned {
        List<DataRecord> records = new ArrayList<DataRecord>();

        private DataReaderPartitioned() {
        }

        void addRecord(GribCollection.VariableIndex vindex, int partno, int fileno, long pos, int resultIndex) {
            this.records.add(new DataRecord(partno, vindex, resultIndex, fileno, pos));
        }

        void read(DataReceiver dataReceiver) throws IOException {
            Collections.sort(this.records);
            int currPartno = -1;
            int currFile = -1;
            RandomAccessFile rafData = null;
            for (DataRecord dr : this.records) {
                if (dr.partno != currPartno || dr.fileno != currFile) {
                    if (rafData != null) {
                        rafData.close();
                    }
                    rafData = Grib1Iosp.this.timePartition.getRaf(dr.partno, dr.fileno);
                    currFile = dr.fileno;
                    currPartno = dr.partno;
                }
                if (dr.pos == -1L) continue;
                float[] data = Grib1Record.readData(rafData, dr.pos);
                dataReceiver.addData(data, dr.resultIndex, dr.vindex.group.hcs.nx);
            }
            if (rafData != null) {
                rafData.close();
            }
        }

        private class DataRecord
        implements Comparable<DataRecord> {
            int partno;
            GribCollection.VariableIndex vindex;
            int resultIndex;
            int fileno;
            long pos;

            DataRecord(int partno, GribCollection.VariableIndex vindex, int resultIndex, int fileno, long pos) {
                this.partno = partno;
                this.vindex = vindex;
                this.resultIndex = resultIndex;
                this.fileno = fileno;
                this.pos = pos;
            }

            @Override
            public int compareTo(DataRecord o) {
                int r = this.partno - o.partno;
                if (r != 0) {
                    return r;
                }
                r = this.fileno - o.fileno;
                return r != 0 ? r : (int)(this.pos - o.pos);
            }
        }
    }
}

