/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import thredds.inventory.TimePartitionCollection;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribCollectionProto;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimeCoordUnion;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1TimePartition;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;

public class Grib1TimePartitionBuilder
extends Grib1CollectionBuilder {
    public static final String MAGIC_START = "Grib1Partition0Index";
    private static final Logger logger = LoggerFactory.getLogger(Grib1TimePartitionBuilder.class);
    private static final boolean trace = false;
    private final TimePartitionCollection tpc;
    private final Grib1TimePartition tp;

    public static boolean update(TimePartitionCollection tpc, Formatter f) throws IOException {
        Grib1TimePartitionBuilder builder = new Grib1TimePartitionBuilder(tpc.getCollectionName(), new File(tpc.getRoot()), tpc);
        if (!builder.needsUpdate()) {
            return false;
        }
        builder.readOrCreateIndex(CollectionManager.Force.always, f);
        builder.gc.close();
        return true;
    }

    public static Grib1TimePartition factory(TimePartitionCollection tpc, CollectionManager.Force force, Formatter f) throws IOException {
        Grib1TimePartitionBuilder builder = new Grib1TimePartitionBuilder(tpc.getCollectionName(), new File(tpc.getRoot()), tpc);
        builder.readOrCreateIndex(force, f);
        return builder.tp;
    }

    public static Grib1TimePartition createFromIndex(String name, File directory, RandomAccessFile raf) throws IOException {
        Grib1TimePartitionBuilder builder = new Grib1TimePartitionBuilder(name, directory, null);
        if (builder.readIndex(raf)) {
            return builder.tp;
        }
        throw new IOException("Reading index failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeIndexFile(TimePartitionCollection tpc, CollectionManager.Force force, Formatter f) throws IOException {
        Grib1TimePartitionBuilder builder = null;
        try {
            builder = new Grib1TimePartitionBuilder(tpc.getCollectionName(), new File(tpc.getRoot()), tpc);
            boolean bl = builder.readOrCreateIndex(force, f);
            return bl;
        }
        finally {
            if (builder != null && builder.tp != null) {
                builder.tp.close();
            }
        }
    }

    private Grib1TimePartitionBuilder(String name, File directory, TimePartitionCollection tpc) {
        FeatureCollectionConfig.GribConfig config = tpc == null ? null : (FeatureCollectionConfig.GribConfig)tpc.getAuxInfo("gribConfig");
        this.tp = new Grib1TimePartition(name, directory, config);
        this.gc = this.tp;
        this.tpc = tpc;
    }

    private boolean readOrCreateIndex(CollectionManager.Force ff, Formatter f) throws IOException {
        boolean force;
        File idx = this.gc.getIndexFile();
        boolean bl = force = ff == CollectionManager.Force.always || ff == CollectionManager.Force.test && this.needsUpdate(idx.lastModified(), f);
        if (force || !idx.exists() || !this.readIndex(idx.getPath())) {
            logger.info("TimePartitionBuilder createIndex {}", (Object)idx.getPath());
            this.createPartitionedIndex(f);
            this.readIndex(idx.getPath());
            return true;
        }
        return false;
    }

    private boolean needsUpdate(long collectionLastModified, Formatter f) throws IOException {
        CollectionManager.ChangeChecker cc = Grib1Index.getChangeChecker();
        for (CollectionManager dcm : this.tpc.makePartitions()) {
            File idxFile = GribCollection.getIndexFile(dcm);
            if (!idxFile.exists()) {
                return true;
            }
            if (collectionLastModified < idxFile.lastModified()) {
                return true;
            }
            for (MFile mfile : dcm.getFiles()) {
                if (!cc.hasChangedSince(mfile, idxFile.lastModified())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean createPartitionedIndex(Formatter f) throws IOException {
        long start = System.currentTimeMillis();
        for (CollectionManager dcm : this.tpc.makePartitions()) {
            this.tp.addPartition(dcm);
        }
        ArrayList<TimePartition.Partition> bad = new ArrayList<TimePartition.Partition>();
        for (TimePartition.Partition dc : this.tp.getPartitions()) {
            try {
                dc.makeGribCollection(f);
            }
            catch (Throwable t) {
                logger.error(" Failed to open partition " + dc.getName(), t);
                f.format(" FAIL on partition %s (remove) %n", dc.getDcm().getCollectionName());
                bad.add(dc);
            }
        }
        for (TimePartition.Partition p : bad) {
            this.tp.removePartition(p);
        }
        int n = this.tp.getPartitions().size();
        if (n == 0) {
            logger.error(" Nothing in this partition = " + this.tp.getName());
            f.format(" FAIL Partition empty collection = %s%n", this.tp.getName());
            return false;
        }
        int idx = this.tpc.getProtoIndex(n);
        TimePartition.Partition canon = this.tp.getPartitions().get(idx);
        f.format(" Using canonical partition %s%n", canon.getDcm().getCollectionName());
        if (!this.checkPartitions(canon, f)) {
            logger.error(" Partition check failed, index not written on {} message = {}", (Object)this.tp.getName(), (Object)f.toString());
            f.format(" FAIL Partition check collection = %s%n", this.tp.getName());
            return false;
        }
        this.createPartitionedTimeCoordinates(canon, f);
        this.writeIndex(canon, f);
        this.tp.cleanup();
        long took = System.currentTimeMillis() - start;
        f.format(" CreatePartitionedIndex took %d msecs%n", took);
        return true;
    }

    private boolean checkPartitions(TimePartition.Partition canon, Formatter f) throws IOException {
        List<TimePartition.Partition> partitions = this.tp.getPartitions();
        int npart = partitions.size();
        boolean ok = true;
        GribCollection canonGc = canon.makeGribCollection(f);
        for (GribCollection.GroupHcs firstGroup : canonGc.getGroups()) {
            String gname = firstGroup.getId();
            HashMap<Integer, TimePartition.VariableIndexPartitioned> check = new HashMap<Integer, TimePartition.VariableIndexPartitioned>(firstGroup.varIndex.size());
            ArrayList<GribCollection.VariableIndex> varIndexP = new ArrayList<GribCollection.VariableIndex>(firstGroup.varIndex.size());
            for (GribCollection.VariableIndex vi : firstGroup.varIndex) {
                TimePartition.VariableIndexPartitioned vip = this.tp.makeVariableIndexPartitioned(vi, npart);
                varIndexP.add(vip);
                check.put(vi.cdmHash, vip);
            }
            firstGroup.varIndex = varIndexP;
            for (int partno = 0; partno < npart; ++partno) {
                TimePartition.Partition tpp = partitions.get(partno);
                GribCollection gc = tpp.makeGribCollection(f);
                int groupIdx = gc.findGroupIdxById(firstGroup.getId());
                if (groupIdx < 0) {
                    f.format(" Cant find group %s in partition %s%n", gname, tpp.getName());
                    ok = false;
                    continue;
                }
                GribCollection.GroupHcs group = gc.getGroup(groupIdx);
                for (int varIdx = 0; varIdx < group.varIndex.size(); ++varIdx) {
                    VertCoord vc2;
                    GribCollection.VariableIndex vi2 = group.varIndex.get(varIdx);
                    int flag = 0;
                    GribCollection.VariableIndex vi1 = (GribCollection.VariableIndex)check.get(vi2.cdmHash);
                    if (vi1 == null) {
                        f.format("   WARN Cant find variable %s from %s in proto - ignoring that variable%n", vi2, tpp.getName());
                        continue;
                    }
                    VertCoord vc1 = vi1.getVertCoord();
                    if (vc1 == null != ((vc2 = vi2.getVertCoord()) == null)) {
                        f.format("   ERR Vert coordinates existence on variable %s in %s doesnt match%n", vi2, tpp.getName());
                        ok = false;
                    } else if (vc1 != null && !vc1.equalsData(vc2)) {
                        f.format("   WARN Vert coordinates values on variable %s in %s dont match%n", vi2, tpp.getName());
                        f.format("    canon vc = %s%n", vc1);
                        f.format("    this vc = %s%n", vc2);
                        flag |= 1;
                    }
                    EnsCoord ec1 = vi1.getEnsCoord();
                    EnsCoord ec2 = vi2.getEnsCoord();
                    if (ec1 == null != (ec2 == null)) {
                        f.format("   ERR Ensemble coordinates existence on variable %s in %s doesnt match%n", vi2, tpp.getName());
                        ok = false;
                    } else if (ec1 != null && !ec1.equalsData(ec2)) {
                        f.format("   WARN Ensemble coordinates values on variable %s in %s dont match%n", vi2, tpp.getName());
                        f.format("    canon ec = %s%n", ec1);
                        f.format("    this ec = %s%n", ec2);
                        flag |= 2;
                    }
                    ((TimePartition.VariableIndexPartitioned)vi1).setPartitionIndex(partno, groupIdx, varIdx, flag);
                }
            }
        }
        if (ok) {
            f.format("  Partition check: vert, ens coords OK%n", new Object[0]);
        }
        return ok;
    }

    private boolean createPartitionedTimeCoordinates(TimePartition.Partition canon, Formatter f) throws IOException {
        List<TimePartition.Partition> partitions = this.tp.getPartitions();
        boolean ok = true;
        for (GribCollection.GroupHcs firstGroup : canon.makeGribCollection(f).getGroups()) {
            String gname = firstGroup.getId();
            ArrayList<PartGroup> pgList = new ArrayList<PartGroup>(partitions.size());
            for (TimePartition.Partition dc : partitions) {
                GribCollection.GroupHcs gg = dc.makeGribCollection(f).findGroupById(gname);
                if (gg == null) {
                    logger.error(" Cant find group {} in partition {}", (Object)gname, (Object)dc.getName());
                    continue;
                }
                pgList.add(new PartGroup(gg, dc));
            }
            ArrayList<TimeCoordUnion> unionList = new ArrayList<TimeCoordUnion>();
            for (GribCollection.VariableIndex viCanon : firstGroup.varIndex) {
                TimeCoord tcCanon = viCanon.getTimeCoord();
                ArrayList<TimeCoord> tcPartitions = new ArrayList<TimeCoord>(pgList.size());
                for (PartGroup pg : pgList) {
                    GribCollection.VariableIndex vi2 = pg.group.findVariableByHash(viCanon.cdmHash);
                    if (vi2 == null) {
                        f.format("   WARN Cant find variable %s in partition %s / %s%n", viCanon, pg.tpp.getName(), pg.group.getId());
                        tcPartitions.add(null);
                        continue;
                    }
                    if (vi2.timeIdx < 0 || vi2.timeIdx >= pg.group.timeCoords.size()) {
                        logger.error(" timeIdx out of range var= {} on partition {}", vi2, (Object)pg.tpp.getName());
                        tcPartitions.add(null);
                        continue;
                    }
                    TimeCoord tc2 = vi2.getTimeCoord();
                    if (tc2.isInterval() != tcCanon.isInterval()) {
                        logger.error(" timeIdx wrong interval type var= {} on partition {}", vi2, (Object)pg.tpp.getName());
                        tcPartitions.add(null);
                        continue;
                    }
                    tcPartitions.add(tc2);
                }
                TimeCoordUnion union = new TimeCoordUnion(tcCanon.getCode(), tcPartitions, tcCanon);
                viCanon.partTimeCoordIdx = TimeCoordUnion.findUnique(unionList, union);
            }
            firstGroup.timeCoordPartitions = unionList;
        }
        return ok;
    }

    @Override
    public String getMagicStart() {
        return MAGIC_START;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeIndex(TimePartition.Partition canon, Formatter f) throws IOException {
        File file = this.tp.getIndexFile();
        if (file.exists() && !file.delete()) {
            logger.error("Cant delete " + file.getPath());
        }
        RandomAccessFile raf = new RandomAccessFile(file.getPath(), "rw");
        raf.order(0);
        try {
            raf.write(MAGIC_START.getBytes("UTF-8"));
            raf.writeInt(9);
            raf.writeLong(0L);
            GribCollectionProto.GribCollectionIndex.Builder indexBuilder = GribCollectionProto.GribCollectionIndex.newBuilder();
            indexBuilder.setName(this.tp.getName());
            GribCollection canonGc = canon.makeGribCollection(f);
            for (GribCollection.GroupHcs g : canonGc.getGroups()) {
                indexBuilder.addGroups(this.writeGroupProto(g));
            }
            indexBuilder.setCenter(canonGc.getCenter());
            indexBuilder.setSubcenter(canonGc.getSubcenter());
            indexBuilder.setMaster(canonGc.getMaster());
            indexBuilder.setLocal(canonGc.getLocal());
            for (TimePartition.Partition p : this.tp.getPartitions()) {
                indexBuilder.addPartitions(this.writePartitionProto(p.getName(), p));
            }
            GribCollectionProto.GribCollectionIndex index = indexBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt(raf, b.length);
            raf.write(b);
            f.format("GribCollectionTimePartitionedIndex= %d bytes%n", b.length);
        }
        catch (Throwable throwable) {
            f.format("file size =  %d bytes%n", raf.length());
            raf.close();
            throw throwable;
        }
        f.format("file size =  %d bytes%n", raf.length());
        raf.close();
        return true;
    }

    private GribCollectionProto.Group writeGroupProto(GribCollection.GroupHcs g) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        b.setGds(ByteString.copyFrom(g.rawGds));
        b.setGdsHash(g.gdsHash);
        for (GribCollection.VariableIndex vb : g.varIndex) {
            b.addVariables(this.writeVariableProto((TimePartition.VariableIndexPartitioned)vb));
        }
        for (int i = 0; i < g.timeCoordPartitions.size(); ++i) {
            b.addTimeCoordUnions(this.writeTimeCoordUnionProto(g.timeCoordPartitions.get(i), i));
        }
        List<VertCoord> vertCoords = g.vertCoords;
        for (int i = 0; i < vertCoords.size(); ++i) {
            b.addVertCoords(this.writeCoordProto(vertCoords.get(i), i));
        }
        List<EnsCoord> ensCoords = g.ensCoords;
        for (int i = 0; i < ensCoords.size(); ++i) {
            b.addEnsCoords(this.writeCoordProto(ensCoords.get(i), i));
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(TimePartition.VariableIndexPartitioned v) throws IOException {
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        b.setDiscipline(v.discipline);
        b.setCategory(v.category);
        b.setParameter(v.parameter);
        b.setLevelType(v.levelType);
        b.setIsLayer(v.isLayer);
        b.setIntervalType(v.intvType);
        if (v.intvName != null) {
            b.setIntvName(v.intvName);
        }
        b.setCdmHash(v.cdmHash);
        b.setRecordsPos(0L);
        b.setRecordsLen(0);
        b.setTimeIdx(v.partTimeCoordIdx);
        if (v.vertIdx >= 0) {
            b.setVertIdx(v.vertIdx);
        }
        if (v.ensIdx >= 0) {
            b.setEnsIdx(v.ensIdx);
        }
        if (v.ensDerivedType >= 0) {
            b.setEnsDerivedType(v.ensDerivedType);
        }
        if (v.probabilityName != null) {
            b.setProbabilityName(v.probabilityName);
        }
        if (v.probType >= 0) {
            b.setProbabilityType(v.probType);
        }
        for (int idx : v.groupno) {
            b.addGroupno(idx);
        }
        for (int idx : v.varno) {
            b.addVarno(idx);
        }
        for (int idx : v.flag) {
            b.addFlag(idx);
        }
        return b.build();
    }

    protected GribCollectionProto.TimeCoordUnion writeTimeCoordUnionProto(TimeCoordUnion tcu, int index) throws IOException {
        GribCollectionProto.TimeCoordUnion.Builder b = GribCollectionProto.TimeCoordUnion.newBuilder();
        b.setCode(index);
        b.setUnit(tcu.getUnits());
        if (tcu.isInterval()) {
            for (TimeCoord.Tinv tinv : tcu.getIntervals()) {
                b.addValues(tinv.getBounds1());
                b.addBound(tinv.getBounds2());
            }
        } else {
            Iterator<Comparable<TimeCoord.Tinv>> i$ = tcu.getCoords().iterator();
            while (i$.hasNext()) {
                int value = (Integer)i$.next();
                b.addValues(value);
            }
        }
        for (TimeCoordUnion.Val val : tcu.getValues()) {
            b.addPartition(val.getPartition());
            b.addIndex(val.getIndex());
        }
        return b.build();
    }

    private GribCollectionProto.Partition writePartitionProto(String name, TimePartition.Partition p) throws IOException {
        GribCollectionProto.Partition.Builder b = GribCollectionProto.Partition.newBuilder();
        b.setFilename(p.getIndexFilename());
        b.setName(name);
        return b.build();
    }

    @Override
    protected boolean readPartitions(GribCollectionProto.GribCollectionIndex proto) {
        for (int i = 0; i < proto.getPartitionsCount(); ++i) {
            GribCollectionProto.Partition pp = proto.getPartitions(i);
            this.tp.addPartition(pp.getName(), pp.getFilename());
        }
        return proto.getPartitionsCount() > 0;
    }

    @Override
    protected void readTimePartitions(GribCollection.GroupHcs group, GribCollectionProto.Group proto) {
        ArrayList<TimeCoord> list = new ArrayList<TimeCoord>(proto.getTimeCoordUnionsCount());
        for (int i = 0; i < proto.getTimeCoordUnionsCount(); ++i) {
            GribCollectionProto.TimeCoordUnion tpu = proto.getTimeCoordUnions(i);
            list.add(this.readTimePartition(tpu, i));
        }
        group.timeCoords = list;
    }

    protected TimeCoord readTimePartition(GribCollectionProto.TimeCoordUnion pc, int timeIndex) {
        int[] partition = new int[pc.getPartitionCount()];
        int[] index = new int[pc.getPartitionCount()];
        for (int i = 0; i < pc.getPartitionCount(); ++i) {
            partition[i] = pc.getPartition(i);
            index[i] = pc.getIndex(i);
        }
        if (pc.getBoundCount() > 0) {
            ArrayList<TimeCoord.Tinv> coords = new ArrayList<TimeCoord.Tinv>(pc.getValuesCount());
            for (int i = 0; i < pc.getValuesCount(); ++i) {
                coords.add(new TimeCoord.Tinv((int)pc.getValues(i), (int)pc.getBound(i)));
            }
            TimeCoordUnion tc = new TimeCoordUnion(pc.getCode(), pc.getUnit(), coords, partition, index);
            return tc.setIndex(timeIndex);
        }
        ArrayList<Integer> coords = new ArrayList<Integer>(pc.getValuesCount());
        for (float value : pc.getValuesList()) {
            coords.add((int)value);
        }
        TimeCoordUnion tc = new TimeCoordUnion(pc.getCode(), pc.getUnit(), coords, partition, index);
        return tc.setIndex(timeIndex);
    }

    @Override
    protected GribCollection.VariableIndex readVariable(GribCollectionProto.Variable pv, GribCollection.GroupHcs group) {
        int discipline = pv.getDiscipline();
        int category = pv.getCategory();
        int param = pv.getParameter();
        int levelType = pv.getLevelType();
        int intvType = pv.getIntervalType();
        String intvName = pv.getIntvName();
        boolean isLayer = pv.getIsLayer();
        int ensDerivedType = pv.getEnsDerivedType();
        int probType = pv.getProbabilityType();
        String probabilityName = pv.getProbabilityName();
        int cdmHash = pv.getCdmHash();
        long recordsPos = pv.getRecordsPos();
        int recordsLen = pv.getRecordsLen();
        int timeIdx = pv.getTimeIdx();
        int vertIdx = pv.getVertIdx();
        int ensIdx = pv.getEnsIdx();
        int tableVersion = pv.getTableVersion();
        List<Integer> groupnoList = pv.getGroupnoList();
        List<Integer> varnoList = pv.getVarnoList();
        List<Integer> flagList = pv.getFlagList();
        return this.tp.makeVariableIndex(group, tableVersion, discipline, category, param, levelType, isLayer, intvType, intvName, ensDerivedType, probType, probabilityName, -1, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen, groupnoList, varnoList, flagList);
    }

    public static void main(String[] args) throws IOException {
        Formatter f = new Formatter();
        String indexName = args.length > 0 ? args[0] : "F:/nomads/NOMADS-cfsrr-timeseries.ncx";
        RandomAccessFile raf = new RandomAccessFile(indexName, "r");
        Grib1TimePartition gtc = Grib1TimePartitionBuilder.createFromIndex("test", null, raf);
        gtc.showIndex(f);
        System.out.printf("%s%n", f);
    }

    private class PartGroup {
        GribCollection.GroupHcs group;
        TimePartition.Partition tpp;

        private PartGroup(GribCollection.GroupHcs group, TimePartition.Partition tpp) {
            this.group = group;
            this.tpp = tpp;
        }
    }
}

