/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entities {
    private static final Map<String, Character> full;
    private static final Map<Character, String> xhtmlByVal;
    private static final Map<String, Character> base;
    private static final Map<Character, String> baseByVal;
    private static final Map<Character, String> fullByVal;
    private static final Pattern unescapePattern;
    private static final Pattern strictUnescapePattern;
    private static final Object[][] xhtmlArray;

    private Entities() {
    }

    public static boolean isNamedEntity(String name) {
        return full.containsKey(name);
    }

    public static boolean isBaseNamedEntity(String name) {
        return base.containsKey(name);
    }

    public static Character getCharacterByName(String name) {
        return full.get(name);
    }

    static String escape(String string, Document.OutputSettings out) {
        return Entities.escape(string, out.encoder(), out.escapeMode());
    }

    static String escape(String string, CharsetEncoder encoder, EscapeMode escapeMode) {
        int codePoint;
        StringBuilder accum = new StringBuilder(string.length() * 2);
        Map<Character, String> map = escapeMode.getMap();
        int length = string.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(offset);
            if (codePoint < 65536) {
                char c = (char)codePoint;
                if (map.containsKey(Character.valueOf(c))) {
                    accum.append('&').append(map.get(Character.valueOf(c))).append(';');
                    continue;
                }
                if (encoder.canEncode(c)) {
                    accum.append(c);
                    continue;
                }
                accum.append("&#x").append(Integer.toHexString(codePoint)).append(';');
                continue;
            }
            String c = new String(Character.toChars(codePoint));
            if (encoder.canEncode(c)) {
                accum.append(c);
                continue;
            }
            accum.append("&#x").append(Integer.toHexString(codePoint)).append(';');
        }
        return accum.toString();
    }

    static String unescape(String string) {
        return Entities.unescape(string, false);
    }

    static String unescape(String string, boolean strict) {
        return Parser.unescapeEntities(string, strict);
    }

    private static Map<String, Character> loadEntities(String filename) {
        Properties properties = new Properties();
        HashMap<String, Character> entities = new HashMap<String, Character>();
        try {
            InputStream in = Entities.class.getResourceAsStream(filename);
            properties.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new MissingResourceException("Error loading entities resource: " + e.getMessage(), "Entities", filename);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Character val = Character.valueOf((char)Integer.parseInt((String)entry.getValue(), 16));
            String name = (String)entry.getKey();
            entities.put(name, val);
        }
        return entities;
    }

    private static Map<Character, String> toCharacterKey(Map<String, Character> inMap) {
        HashMap<Character, String> outMap = new HashMap<Character, String>();
        for (Map.Entry<String, Character> entry : inMap.entrySet()) {
            Character character = entry.getValue();
            String name = entry.getKey();
            if (outMap.containsKey(character)) {
                if (!name.toLowerCase().equals(name)) continue;
                outMap.put(character, name);
                continue;
            }
            outMap.put(character, name);
        }
        return outMap;
    }

    static /* synthetic */ Map access$000() {
        return xhtmlByVal;
    }

    static /* synthetic */ Map access$100() {
        return baseByVal;
    }

    static /* synthetic */ Map access$200() {
        return fullByVal;
    }

    static {
        unescapePattern = Pattern.compile("&(#(x|X)?([0-9a-fA-F]+)|[a-zA-Z]+\\d*);?");
        strictUnescapePattern = Pattern.compile("&(#(x|X)?([0-9a-fA-F]+)|[a-zA-Z]+\\d*);");
        xhtmlArray = new Object[][]{{"quot", 34}, {"amp", 38}, {"apos", 39}, {"lt", 60}, {"gt", 62}};
        xhtmlByVal = new HashMap<Character, String>();
        base = Entities.loadEntities("entities-base.properties");
        baseByVal = Entities.toCharacterKey(base);
        full = Entities.loadEntities("entities-full.properties");
        fullByVal = Entities.toCharacterKey(full);
        for (Object[] entity : xhtmlArray) {
            Character c = Character.valueOf((char)((Integer)entity[1]).intValue());
            xhtmlByVal.put(c, (String)entity[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscapeMode {
        xhtml(Entities.access$000()),
        base(Entities.access$100()),
        extended(Entities.access$200());

        private Map<Character, String> map;

        private EscapeMode(Map<Character, String> map) {
            this.map = map;
        }

        public Map<Character, String> getMap() {
            return this.map;
        }
    }
}

