/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribResourceReader;
import ucar.nc2.grib.GribLevelType;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;

public class FnmocTables
extends Grib1Customizer {
    private static final Logger logger = LoggerFactory.getLogger(FnmocTables.class);
    private static HashMap<Integer, GribLevelType> levelTypesMap;
    private static HashMap<Integer, String> genProcessMap;

    FnmocTables(Grib1ParamTables tables) {
        super(58, tables);
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        if (genProcessMap == null) {
            this.readGenProcess("resources/grib1/fnmoc/US058MMTA-ALPdoc.pntabs-prodname-masterModelTableOrdered.GRIB1.TblA.xml");
        }
        if (genProcessMap == null) {
            return null;
        }
        return genProcessMap.get(genProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGenProcess(String path) {
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(path);
            if (is == null) {
                logger.error("Cant find FNMOC gen process table = " + path);
                return;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, String> result = new HashMap<Integer, String>(200);
            Element fnmocTable = root.getChild("fnmocTable");
            List<Element> params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getChildText("grib1Id"));
                String desc = elem1.getChildText("fullName");
                result.put(code, desc);
            }
            genProcessMap = result;
        }
        catch (IOException ioe) {
            logger.error("Cant read FNMOC Table 1 = " + path, ioe);
            return;
        }
        catch (JDOMException e) {
            logger.error("Cant parse FNMOC Table 1 = " + path, e);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return;
    }

    @Override
    protected VertCoord.VertUnit makeVertUnit(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt != null ? lt : super.makeVertUnit(code);
    }

    @Override
    public String getLevelNameShort(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.getLevelNameShort(code) : lt.getAbbrev();
    }

    @Override
    public String getLevelDescription(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.getLevelDescription(code) : lt.getDatum();
    }

    @Override
    public String getLevelUnits(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.getLevelUnits(code) : lt.getUnits();
    }

    @Override
    public boolean isLayer(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.isLayer(code) : lt.isLayer();
    }

    @Override
    public boolean isPositiveUp(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.isPositiveUp(code) : lt.isPositiveUp();
    }

    @Override
    public String getLevelDatum(int code) {
        GribLevelType lt = this.getLevelType(code);
        return lt == null ? super.getLevelDatum(code) : lt.getDatum();
    }

    private GribLevelType getLevelType(int code) {
        if (code < 199) {
            return null;
        }
        if (levelTypesMap == null) {
            levelTypesMap = this.readFnmocTable3("resources/grib1/fnmoc/US058MMTA-ALPdoc.pntabs-prodname-masterLevelTypeTableOrdered.GRIB1.Tbl3.xml");
        }
        if (levelTypesMap == null) {
            return null;
        }
        return levelTypesMap.get(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<Integer, GribLevelType> readFnmocTable3(String path) {
        HashMap<Integer, GribLevelType> hashMap;
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(path);
            if (is == null) {
                logger.error("Cant find FnmocTable3 = " + path);
                HashMap<Integer, GribLevelType> hashMap2 = null;
                return hashMap2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, GribLevelType> result = new HashMap<Integer, GribLevelType>(200);
            Element fnmocTable = root.getChild("fnmocTable");
            List<Element> params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getChildText("grib1Id"));
                if (code < 129) continue;
                String desc = elem1.getChildText("description");
                String abbrev = elem1.getChildText("name");
                String units = elem1.getChildText("units");
                String datum = elem1.getChildText("datum");
                boolean isLayer = elem1.getChild("isLayer") != null;
                boolean isPositiveUp = elem1.getChild("isPositiveUp") != null;
                GribLevelType lt = new GribLevelType(code, desc, abbrev, units, datum, isPositiveUp, isLayer);
                result.put(code, lt);
            }
            hashMap = result;
        }
        catch (IOException ioe) {
            logger.error("Cant read FnmocTable3 = " + path, ioe);
            HashMap<Integer, GribLevelType> hashMap3 = null;
            return hashMap3;
        }
        catch (JDOMException e) {
            logger.error("Cant parse FnmocTable3 = " + path, e);
            HashMap<Integer, GribLevelType> hashMap4 = null;
            return hashMap4;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return hashMap;
    }
}

