/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import ucar.grib.GribNumbers;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GDSVariables;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.Grib2Tables;
import ucar.grib.grib2.ParameterTable;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2Dump {
    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans metadata");
        System.out.println("<output file> file to store results");
        System.out.println("<true or false> whether to read/display data too");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <output file> <true or false>");
        System.exit(0);
    }

    public void gribDump(String[] args) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        boolean displayData = false;
        TimeZone tz = TimeZone.getTimeZone("127");
        TimeZone.setDefault(tz);
        try {
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            if (args.length == 3) {
                raf = new RandomAccessFile(args[0], "r");
                ps = new PrintStream(new FilterOutputStream(new FileOutputStream(args[1], false)));
                displayData = args[2].equalsIgnoreCase("true");
            } else if (args.length == 2) {
                raf = new RandomAccessFile(args[0], "r");
                if (args[1].equalsIgnoreCase("true") || args[1].equalsIgnoreCase("false")) {
                    displayData = args[1].equalsIgnoreCase("true");
                } else {
                    ps = new PrintStream(new FilterOutputStream(new FileOutputStream(args[1], false)));
                }
            } else if (args.length == 1) {
                raf = new RandomAccessFile(args[0], "r");
            } else {
                System.exit(0);
            }
            raf.order(0);
            Grib2Input g2i = new Grib2Input(raf);
            g2i.scan(false, false);
            List<Grib2Record> records = g2i.getRecords();
            for (int i = 0; i < records.size(); ++i) {
                Grib2Record record = records.get(i);
                Grib2IndicatorSection is = record.getIs();
                Grib2IdentificationSection id = record.getId();
                Grib2GridDefinitionSection gds = record.getGDS();
                Grib2ProductDefinitionSection pds = record.getPDS();
                ps.println("--------------------------------------------------------------------");
                ps.println("                        Header : " + record.getHeader());
                this.printIS(is, ps);
                this.printID(id, dateFormat, ps);
                this.printGDS(gds, ps);
                this.printPDS(is, pds, ps);
                if (!displayData) continue;
                float[] data = null;
                ps.println("--------------------------------------------------------------------");
                Grib2Data gd = new Grib2Data(raf);
                data = gd.getData(record.getGdsOffset(), record.getPdsOffset(), id.getRefTime());
                if (data == null) break;
                for (int j = 0; j < data.length; ++j) {
                    ps.println("data[ " + j + " ]=" + data[j]);
                }
                break;
            }
            raf.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
    }

    private void printIS(Grib2IndicatorSection is, PrintStream ps) {
        ps.println("                    Discipline : " + is.getDiscipline() + " " + is.getDisciplineName());
        ps.println("                  GRIB Edition : " + is.getGribEdition());
        ps.println("                   GRIB length : " + is.getGribLength());
    }

    private void printID(Grib2IdentificationSection id, SimpleDateFormat dateFormat, PrintStream ps) {
        ps.println("            Originating Center : " + id.getCenter_id() + " " + Grib1Tables.getCenter_idName(id.getCenter_id()));
        ps.println("        Originating Sub-Center : " + id.getSubcenter_id());
        ps.println("Significance of Reference Time : " + id.getSignificanceOfRT() + " " + id.getSignificanceOfRTName());
        ps.println("                Reference Time : " + dateFormat.format(id.getBaseTime()));
        ps.println("                Product Status : " + id.getProductStatus() + " " + id.getProductStatusName());
        ps.println("                  Product Type : " + id.getProductType() + " " + id.getProductTypeName());
    }

    private void printGDS(Grib2GridDefinitionSection gds, PrintStream ps) {
        Grib2GDSVariables gdsv = gds.getGdsVars();
        ps.println("         Number of data points : " + gdsv.getNumberPoints());
        ps.println("                     Grid Name : " + gdsv.getGdtn() + " " + Grib2Tables.codeTable3_1(gdsv.getGdtn()));
        String winds = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? "Relative" : "True";
        switch (gdsv.getGdtn()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib2Tables.codeTable3_2(gdsv.getShape()));
                if (gdsv.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gdsv.getNx());
                ps.println("Number of points along meridian: " + gdsv.getNy());
                ps.println("                   Basic angle : " + gdsv.getBasicAngle());
                ps.println("    Subdivisions of basic angle: " + gdsv.getSubDivisions());
                ps.println("  Latitude of first grid point : " + gdsv.getLa1());
                ps.println(" Longitude of first grid point : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("   Latitude of last grid point : " + gdsv.getLa2());
                ps.println("  Longitude of last grid point : " + gdsv.getLo2());
                ps.println("         i direction increment : " + gdsv.getDx());
                ps.println("         j direction increment : " + gdsv.getDy());
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                if (gdsv.getGdtn() == 1) {
                    ps.println("     Latitude of southern pole : " + gdsv.getSpLat());
                    ps.println("    Longitude of southern pole : " + gdsv.getSpLon());
                    ps.println("                Rotation angle : " + gdsv.getRotationAngle());
                    break;
                }
                if (gdsv.getGdtn() == 2) {
                    ps.println("              Latitude of pole : " + gdsv.getPoleLat());
                    ps.println("             Longitude of pole : " + gdsv.getPoleLon());
                    ps.println("             Stretching factor : " + gdsv.getStretchingFactor());
                    break;
                }
                if (gdsv.getGdtn() != 3) break;
                ps.println("     Latitude of southern pole : " + gdsv.getSpLat());
                ps.println("    Longitude of southern pole : " + gdsv.getSpLon());
                ps.println("                Rotation angle : " + gdsv.getRotationAngle());
                ps.println("              Latitude of pole : " + gdsv.getPoleLat());
                ps.println("             Longitude of pole : " + gdsv.getPoleLon());
                ps.println("             Stretching factor : " + gdsv.getStretchingFactor());
                break;
            }
            case 10: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib2Tables.codeTable3_2(gdsv.getShape()));
                if (gdsv.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gdsv.getNx());
                ps.println("Number of points along meridian: " + gdsv.getNy());
                ps.println("  Latitude of first grid point : " + gdsv.getLa1());
                ps.println(" Longitude of first grid point : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("   Latitude of last grid point : " + gdsv.getLa2());
                ps.println("  Longitude of last grid point : " + gdsv.getLo2());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                ps.println("                   Basic angle : " + gdsv.getAngle());
                ps.println("         i direction increment : " + gdsv.getDx());
                ps.println("         j direction increment : " + gdsv.getDy());
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                break;
            }
            case 20: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib2Tables.codeTable3_2(gdsv.getShape()));
                if (gdsv.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gdsv.getNx());
                ps.println("Number of points along meridian: " + gdsv.getNy());
                ps.println("  Latitude of first grid point : " + gdsv.getLa1());
                ps.println(" Longitude of first grid point : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                break;
            }
            case 30: {
                ps.println("                    Grid Shape : " + gdsv.getShape() + " " + Grib2Tables.codeTable3_2(gdsv.getShape()));
                if (gdsv.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("                            Nx : " + gdsv.getNx());
                ps.println("                            Ny : " + gdsv.getNy());
                ps.println("                           La1 : " + gdsv.getLa1());
                ps.println("                           Lo1 : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           LaD : " + gdsv.getLaD());
                ps.println("                           LoV : " + gdsv.getLoV());
                ps.println("                            Dx : " + gdsv.getDx());
                ps.println("                            Dy : " + gdsv.getDy());
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("             Projection center : " + gdsv.getProjectionFlag());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                ps.println("                        Latin1 : " + gdsv.getLatin1());
                ps.println("                        Latin2 : " + gdsv.getLatin2());
                ps.println("                         SpLat : " + gdsv.getSpLat());
                ps.println("                         SpLon : " + gdsv.getSpLon());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib2Tables.codeTable3_2(gdsv.getShape()));
                if (gdsv.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 3) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gdsv.getNx());
                ps.println("Number of points along meridian: " + gdsv.getNy());
                ps.println("                   Basic angle : " + gdsv.getAngle());
                ps.println("    Subdivisions of basic angle: " + gdsv.getSubDivisions());
                ps.println("  Latitude of first grid point : " + gdsv.getLa1());
                ps.println(" Longitude of first grid point : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("   Latitude of last grid point : " + gdsv.getLa2());
                ps.println("  Longitude of last grid point : " + gdsv.getLo2());
                ps.println("         i direction increment : " + gdsv.getDx());
                ps.println("             Stretching factor : " + gdsv.getStretchingFactor());
                ps.println("           Number of parallels : " + gdsv.getNp());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                if (gdsv.getGdtn() == 41) {
                    ps.println("     Latitude of southern pole : " + gdsv.getSpLat());
                    ps.println("    Longitude of southern pole : " + gdsv.getSpLon());
                    ps.println("                Rotation angle : " + gdsv.getRotationAngle());
                    break;
                }
                if (gdsv.getGdtn() == 42) {
                    ps.println("              Latitude of pole : " + gdsv.getPoleLat());
                    ps.println("             Longitude of pole : " + gdsv.getPoleLon());
                    ps.println("             Stretching factor : " + gdsv.getStretchingFactor());
                    break;
                }
                if (gdsv.getGdtn() != 43) break;
                ps.println("     Latitude of southern pole : " + gdsv.getSpLat());
                ps.println("    Longitude of southern pole : " + gdsv.getSpLon());
                ps.println("                Rotation angle : " + gdsv.getRotationAngle());
                ps.println("              Latitude of pole : " + gdsv.getPoleLat());
                ps.println("             Longitude of pole : " + gdsv.getPoleLon());
                ps.println("             Stretching factor : " + gdsv.getStretchingFactor());
                break;
            }
            case 90: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib2Tables.codeTable3_2(gdsv.getShape()));
                if (gdsv.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 3) {
                    ps.println("        Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("        Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gdsv.getNx());
                ps.println("Number of points along meridian: " + gdsv.getNy());
                ps.println("Latitude of sub-satellite point: " + gdsv.getLap());
                ps.println("  Longitude of sub-satellite pt: " + gdsv.getLop());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("      Dx i direction increment : " + gdsv.getDx());
                ps.println("      Dy j direction increment : " + gdsv.getDy());
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("Xp-coordinate of sub-satellite : " + gdsv.getXp());
                ps.println("Yp-coordinate of sub-satellite : " + gdsv.getYp());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                ps.println("                   Basic angle : " + gdsv.getAngle());
                ps.println("     Nr Altitude of the camera : " + gdsv.getNr());
                ps.println("       Xo-coordinate of origin : " + gdsv.getXo());
                ps.println("       Yo-coordinate of origin : " + gdsv.getYo());
                break;
            }
            case 204: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib2Tables.codeTable3_2(gdsv.getShape()));
                if (gdsv.getShape() == 1) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 3) {
                    ps.println("        Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("        Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gdsv.getNx());
                ps.println("Number of points along meridian: " + gdsv.getNy());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                break;
            }
            default: {
                ps.println("Unknown Grid Type" + gdsv.getGdtn());
            }
        }
    }

    private void printPDS(Grib2IndicatorSection is, Grib2ProductDefinitionSection pds, PrintStream ps) {
        Grib2Pds pdsv = pds.getPdsVars();
        int productDefinition = pdsv.getProductDefinitionTemplate();
        ps.println("            Product Definition : " + productDefinition + " " + Grib2Tables.codeTable4_0(productDefinition));
        ps.println("            Parameter Category : " + pdsv.getParameterCategory() + " " + ParameterTable.getCategoryName(is.getDiscipline(), pdsv.getParameterCategory()));
        ps.println("                Parameter Name : " + pdsv.getParameterNumber() + " " + ParameterTable.getParameterName(is.getDiscipline(), pdsv.getParameterCategory(), pdsv.getParameterNumber()));
        ps.println("               Parameter Units : " + ParameterTable.getParameterUnit(is.getDiscipline(), pdsv.getParameterCategory(), pdsv.getParameterNumber()));
        int tgp = pdsv.getGenProcessType();
        ps.println("       Generating Process Type : " + tgp + " " + Grib2Tables.codeTable4_3(tgp));
        ps.println("                  ForecastTime : " + pdsv.getForecastTime());
        ps.println("            First Surface Type : " + pdsv.getLevelType1() + " " + Grib2Tables.codeTable4_5(pdsv.getLevelType1()));
        ps.println("           First Surface value : " + pdsv.getLevelValue1());
        ps.println("           Second Surface Type : " + pdsv.getLevelType2() + " " + Grib2Tables.codeTable4_5(pdsv.getLevelType2()));
        ps.println("          Second Surface value : " + pdsv.getLevelValue2());
    }

    public static void main(String[] args) {
        Grib2Dump g2d = new Grib2Dump();
        if (args.length < 1) {
            Class<?> cl = g2d.getClass();
            Grib2Dump.usage(cl.getName());
            return;
        }
        g2d.gribDump(args);
    }
}

