/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.DbFileSummaryMap;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseLocalUtilizationTracker
extends BaseUtilizationTracker {
    private Map<Object, DbFileSummaryMap> dbMap;

    BaseLocalUtilizationTracker(EnvironmentImpl env, Map<Object, DbFileSummaryMap> dbMap) {
        super(env, env.getCleaner());
        this.dbMap = dbMap;
    }

    Map<Object, DbFileSummaryMap> getDatabaseMap() {
        return this.dbMap;
    }

    public void transferToUtilizationTracker(UtilizationTracker tracker) throws DatabaseException {
        for (TrackedFileSummary localSummary : this.getTrackedFiles()) {
            TrackedFileSummary fileSummary = tracker.getFileSummary(localSummary.getFileNumber());
            fileSummary.addTrackedSummary(localSummary);
        }
        for (Object key : this.dbMap.keySet()) {
            DatabaseImpl db = this.databaseKeyToDatabaseImpl(key);
            DbFileSummaryMap fileMap = this.dbMap.get(key);
            if (db != null) {
                for (Map.Entry<Long, DbFileSummary> fileEntry : fileMap.entrySet()) {
                    Long fileNum = fileEntry.getKey();
                    DbFileSummary dbFileSummary = db.getDbFileSummary(fileNum, true);
                    if (dbFileSummary == null) continue;
                    DbFileSummary localSummary = fileEntry.getValue();
                    dbFileSummary.add(localSummary);
                }
            }
            this.releaseDatabaseImpl(db);
            fileMap.subtractFromMemoryBudget();
        }
    }

    abstract DatabaseImpl databaseKeyToDatabaseImpl(Object var1) throws DatabaseException;

    abstract void releaseDatabaseImpl(DatabaseImpl var1);

    @Override
    DbFileSummary getDbFileSummary(Object databaseKey, long fileNum) {
        if (databaseKey != null) {
            DbFileSummaryMap fileMap = this.dbMap.get(databaseKey);
            if (fileMap == null) {
                fileMap = new DbFileSummaryMap(true);
                fileMap.init(this.env);
                this.dbMap.put(databaseKey, fileMap);
            }
            return fileMap.get(fileNum, true, false, this.env.getFileManager());
        }
        return null;
    }

    void removeDbFileSummaries(Object databaseKey) {
        DbFileSummaryMap fileMap = this.dbMap.remove(databaseKey);
        if (fileMap != null) {
            fileMap.subtractFromMemoryBudget();
        }
    }
}

