/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.grib.GribEnsembleCoord;
import ucar.nc2.iosp.grib.GribHorizCoordSys;
import ucar.nc2.iosp.grib.GribTimeCoord;
import ucar.nc2.iosp.grib.GribVariable;
import ucar.nc2.iosp.grib.GribVertCoord;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridEnsembleCoord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.unidata.io.RandomAccessFile;

public class GribIndexToNC
extends GridIndexToNC {
    private static Logger logger = LoggerFactory.getLogger(GribIndexToNC.class);

    public GribIndexToNC(String filename) {
        super(filename);
    }

    public GribIndexToNC(RandomAccessFile raf) {
        super(raf);
    }

    @Override
    protected void addExtraAttributes(GridRecord firstRecord, GridTableLookup lookup, NetcdfFile ncfile) {
        String center = null;
        String subcenter = null;
        if (lookup instanceof Grib2GridTableLookup) {
            String model;
            Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)lookup;
            GribGridRecord ggr = (GribGridRecord)firstRecord;
            center = g2lookup.getFirstCenterName();
            ncfile.addAttribute(null, new Attribute("Originating_center", center));
            subcenter = g2lookup.getFirstSubcenterName();
            if (subcenter != null) {
                ncfile.addAttribute(null, new Attribute("Originating_subcenter", subcenter));
            }
            if ((model = g2lookup.getModel()) != null) {
                ncfile.addAttribute(null, new Attribute("Generating_Model", model));
            }
            if (null != g2lookup.getFirstProductStatusName()) {
                ncfile.addAttribute(null, new Attribute("Product_Status", g2lookup.getFirstProductStatusName()));
            }
            ncfile.addAttribute(null, new Attribute("Product_Type", g2lookup.getFirstProductTypeName()));
        } else if (lookup instanceof Grib1GridTableLookup) {
            String model;
            Grib1GridTableLookup g1lookup = (Grib1GridTableLookup)lookup;
            ncfile.addAttribute(null, new Attribute("Originating_center_id", ((Grib1GridTableLookup)lookup).getFirstCenterId()));
            ncfile.addAttribute(null, new Attribute("Originating_subcenter_id", ((Grib1GridTableLookup)lookup).getFirstSubcenterId()));
            ncfile.addAttribute(null, new Attribute("Table_version", ((Grib1GridTableLookup)lookup).getFirstTableVersion()));
            center = g1lookup.getFirstCenterName();
            subcenter = g1lookup.getFirstSubcenterName();
            ncfile.addAttribute(null, new Attribute("Originating_center", center));
            if (subcenter != null) {
                ncfile.addAttribute(null, new Attribute("Originating_subcenter", subcenter));
            }
            if ((model = g1lookup.getModel()) != null) {
                ncfile.addAttribute(null, new Attribute("Generating_Model", model));
            }
            if (null != g1lookup.getFirstProductStatusName()) {
                ncfile.addAttribute(null, new Attribute("Product_Status", g1lookup.getFirstProductStatusName()));
            }
            ncfile.addAttribute(null, new Attribute("Product_Type", g1lookup.getFirstProductTypeName()));
        }
    }

    @Override
    protected GridEnsembleCoord addEnsembles(List<GridEnsembleCoord> ensembleCoords, List<GridRecord> recordList) {
        GridEnsembleCoord useEnsembleCoord = null;
        GribEnsembleCoord ensembleCoord = new GribEnsembleCoord(recordList);
        for (GridEnsembleCoord gec : ensembleCoords) {
            if (!ensembleCoord.equals(gec)) continue;
            useEnsembleCoord = gec;
            break;
        }
        if (useEnsembleCoord == null) {
            useEnsembleCoord = ensembleCoord;
            ensembleCoords.add(ensembleCoord);
        }
        return useEnsembleCoord;
    }

    @Override
    protected GridHorizCoordSys makeGridHorizCoordSys(GridDefRecord gds, GridTableLookup lookup, Group g) {
        return new GribHorizCoordSys(gds, lookup, g);
    }

    @Override
    protected GridVariable makeGridVariable(String indexFilename, String name, GridHorizCoordSys hcs, GridTableLookup lookup) {
        return new GribVariable(indexFilename, name, hcs, lookup);
    }

    @Override
    protected GridTimeCoord makeGridTimeCoord(List<GridRecord> recordList, String location) {
        return new GribTimeCoord(recordList, location);
    }

    @Override
    protected GridVertCoord makeGridVertCoord(List<GridRecord> recordList, String vname, GridTableLookup lookup, GridHorizCoordSys hcs) {
        return new GribVertCoord(recordList, vname, lookup, hcs);
    }
}

