/*
 * Decompiled with CFR 0.152.
 */
package visad.data.units;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.OffsetUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.data.units.UnitsDB;

public class UnitTable
implements UnitsDB,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Hashtable nameMap;
    private final Hashtable symbolMap;
    private final SortedSet unitSet;

    public UnitTable(int numNames) throws IllegalArgumentException {
        this(numNames, 0);
    }

    public UnitTable(int numNames, int numSymbols) throws IllegalArgumentException {
        if (numNames < 0 || numSymbols < 0) {
            throw new IllegalArgumentException("Negative hashtable size");
        }
        this.nameMap = new Hashtable(numNames);
        this.symbolMap = new Hashtable(numSymbols);
        this.unitSet = Collections.synchronizedSortedSet(new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Unit)o1).toString().compareToIgnoreCase(((Unit)o2).toString());
            }
        }));
    }

    public Unit get(String name) {
        Unit unit = null;
        if (name.length() == 0) {
            unit = new DerivedUnit();
        } else {
            unit = this.getBySymbol(name);
            if (unit == null) {
                unit = this.getByName(name);
            }
        }
        return unit;
    }

    protected Unit getByName(String name) {
        return (Unit)this.nameMap.get(name.toLowerCase());
    }

    protected Unit getBySymbol(String symbol) {
        return (Unit)this.symbolMap.get(symbol);
    }

    public void put(BaseUnit unit) throws IllegalArgumentException {
        String name = unit.unitName();
        this.putName(name, unit);
        this.putName(this.makePlural(name), unit);
        this.putSymbol(unit.unitSymbol(), unit);
    }

    protected String makePlural(String name) {
        char penultimateChar;
        int length = name.length();
        char lastChar = name.charAt(length - 1);
        String plural = lastChar != 'y' ? name + (lastChar == 's' || lastChar == 'x' || lastChar == 'z' || name.endsWith("ch") ? "es" : "s") : (length == 1 ? name + "s" : ((penultimateChar = name.charAt(length - 2)) == 'a' || penultimateChar == 'e' || penultimateChar == 'i' || penultimateChar == 'o' || penultimateChar == 'u' ? name + "s" : name.substring(0, length - 1) + "ies"));
        return plural;
    }

    public void putName(String name, Unit unit) {
        String[] stringArray;
        if (name == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".putName(String,Unit): <null> unit name");
        }
        if (unit == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".putName(String,Unit): <null> unit");
        }
        if ((name = name.toLowerCase()).indexOf(32) == -1 && name.indexOf(95) == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = name.replace('_', ' ');
            stringArray = stringArray3;
            stringArray3[1] = name.replace(' ', '_');
        }
        String[] names = stringArray;
        for (int i = 0; i < names.length; ++i) {
            Unit prevUnit = (Unit)this.nameMap.get(names[i]);
            if (prevUnit != null && !prevUnit.equals(unit)) {
                throw new IllegalArgumentException("Attempt to replace unit \"" + prevUnit + " with unit \"" + unit + '\"');
            }
            this.nameMap.put(names[i], unit);
        }
        this.unitSet.add(unit);
    }

    public void putSymbol(String symbol, Unit unit) {
        if (symbol == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".putName(String,Unit): <null> unit symbol");
        }
        if (unit == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".putName(String,Unit): <null> unit");
        }
        Unit prevUnit = (Unit)this.symbolMap.get(symbol);
        if (prevUnit != null && !prevUnit.equals(unit)) {
            throw new IllegalArgumentException("Attempt to replace unit \"" + prevUnit + " with unit \"" + unit + '\"');
        }
        this.symbolMap.put(symbol, unit);
        this.unitSet.add(unit);
    }

    public Enumeration getNameEnumeration() {
        return this.nameMap.keys();
    }

    public Enumeration getSymbolEnumeration() {
        return this.symbolMap.keys();
    }

    public Enumeration getUnitEnumeration() {
        return new Enumeration(){
            private final Iterator iter;
            {
                this.iter = UnitTable.this.unitSet.iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public String toString() {
        return this.nameMap.toString() + this.symbolMap.toString();
    }

    public static void main(String[] args) throws Exception {
        UnitTable db = new UnitTable(13);
        db.put(SI.ampere);
        db.put(SI.candela);
        db.put(SI.kelvin);
        db.put(SI.kilogram);
        db.put(SI.meter);
        db.put(SI.mole);
        db.put(SI.second);
        db.put(SI.radian);
        db.putName("amp", SI.ampere);
        db.putName("celsius", new OffsetUnit(273.15, SI.kelvin));
        db.putName("newton", SI.kilogram.multiply(SI.meter).divide(SI.second.pow(2)));
        db.putName("rankine", new ScaledUnit(0.5555555555555556, SI.kelvin));
        db.putName("fahrenheit", new OffsetUnit(459.67, (ScaledUnit)db.get("rankine")));
        System.out.println("db:");
        System.out.println(db.toString());
    }

    public void list() {
        Enumeration en = this.getUnitEnumeration();
        while (en.hasMoreElements()) {
            Unit unit = (Unit)en.nextElement();
            System.out.println(unit.getIdentifier() + " = " + unit.getDefinition());
        }
    }
}

