/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.util.Formatter;
import ucar.nc2.iosp.bufr.DataDescriptor;

public class BitCounterCompressed {
    private final DataDescriptor dkey;
    private final int nrows;
    private final int bitOffset;
    private int dataWidth;
    private BitCounterCompressed[][] nested;

    public BitCounterCompressed(DataDescriptor dkey, int n, int bitOffset) {
        this.dkey = dkey;
        this.nrows = n;
        this.bitOffset = bitOffset;
    }

    void setDataWidth(int dataWidth) {
        this.dataWidth = dataWidth;
    }

    public int getStartingBitPos() {
        return this.bitOffset;
    }

    public int getBitPos(int msgOffset) {
        return this.bitOffset + this.dkey.bitWidth + 6 + this.dataWidth * msgOffset;
    }

    public int getTotalBits() {
        if (this.nested == null) {
            return this.dkey.bitWidth + 6 + this.dataWidth * this.nrows;
        }
        int totalBits = 0;
        for (BitCounterCompressed[] counters : this.nested) {
            if (counters == null) continue;
            for (BitCounterCompressed counter : counters) {
                if (counter == null) continue;
                totalBits += counter.getTotalBits();
            }
        }
        if (this.dkey.replicationCountSize > 0) {
            totalBits += this.dkey.replicationCountSize + 6;
        }
        return totalBits;
    }

    public BitCounterCompressed[] getNestedCounters(int innerIndex) {
        return this.nested[innerIndex];
    }

    public void addNestedCounters(int innerDimensionSize) {
        this.nested = new BitCounterCompressed[innerDimensionSize][this.dkey.getSubKeys().size()];
    }

    public int ncounters() {
        if (this.nested == null) {
            return 1;
        }
        int ncounters = 0;
        for (BitCounterCompressed[] counters : this.nested) {
            if (counters == null) continue;
            for (BitCounterCompressed counter : counters) {
                if (counter == null) continue;
                ncounters += counter.ncounters();
            }
        }
        return ncounters;
    }

    public void show(Formatter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.format(" ", new Object[0]);
        }
        out.format("%8d %8d %4d %s %n", this.getTotalBits(), this.bitOffset, this.dataWidth, this.dkey.name);
        if (this.nested != null) {
            for (BitCounterCompressed[] counters : this.nested) {
                if (counters == null) continue;
                for (BitCounterCompressed counter : counters) {
                    if (counter == null) continue;
                    counter.show(out, indent + 2);
                }
            }
        }
    }
}

