/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermVector;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;

class TermVectorsReader {
    private FieldInfos fieldInfos;
    private InputStream tvx;
    private InputStream tvd;
    private InputStream tvf;
    private int size;

    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos) throws IOException {
        if (d.fileExists(segment + ".tvx")) {
            this.tvx = d.openFile(segment + ".tvx");
            this.checkValidFormat(this.tvx);
            this.tvd = d.openFile(segment + ".tvd");
            this.checkValidFormat(this.tvd);
            this.tvf = d.openFile(segment + ".tvf");
            this.checkValidFormat(this.tvf);
            this.size = (int)this.tvx.length() / 8;
        }
        this.fieldInfos = fieldInfos;
    }

    private void checkValidFormat(InputStream in) throws IOException {
        int format = in.readInt();
        if (format > 1) {
            throw new IOException("Incompatible format version: " + format + " expected " + 1 + " or less");
        }
    }

    synchronized void close() throws IOException {
        if (this.tvx != null) {
            this.tvx.close();
        }
        if (this.tvd != null) {
            this.tvd.close();
        }
        if (this.tvf != null) {
            this.tvf.close();
        }
    }

    int size() {
        return this.size;
    }

    synchronized TermFreqVector get(int docNum, String field) {
        int fieldNumber = this.fieldInfos.fieldNumber(field);
        SegmentTermVector result = null;
        if (this.tvx != null) {
            try {
                int i;
                this.tvx.seek((long)docNum * 8L + 4L);
                long position = this.tvx.readLong();
                this.tvd.seek(position);
                int fieldCount = this.tvd.readVInt();
                int number = 0;
                int found = -1;
                for (i = 0; i < fieldCount; ++i) {
                    if ((number += this.tvd.readVInt()) != fieldNumber) continue;
                    found = i;
                }
                if (found != -1) {
                    position = 0L;
                    for (i = 0; i <= found; ++i) {
                        position += this.tvd.readVLong();
                    }
                    result = this.readTermVector(field, position);
                }
            }
            catch (Exception e) {}
        } else {
            System.out.println("No tvx file");
        }
        return result;
    }

    synchronized TermFreqVector[] get(int docNum) {
        SegmentTermVector[] result = null;
        if (this.tvx != null) {
            try {
                this.tvx.seek((long)docNum * 8L + 4L);
                long position = this.tvx.readLong();
                this.tvd.seek(position);
                int fieldCount = this.tvd.readVInt();
                if (fieldCount != 0) {
                    int number = 0;
                    String[] fields = new String[fieldCount];
                    for (int i = 0; i < fieldCount; ++i) {
                        fields[i] = this.fieldInfos.fieldName(number += this.tvd.readVInt());
                    }
                    position = 0L;
                    long[] tvfPointers = new long[fieldCount];
                    for (int i = 0; i < fieldCount; ++i) {
                        tvfPointers[i] = position += this.tvd.readVLong();
                    }
                    result = this.readTermVectors(fields, tvfPointers);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No tvx file");
        }
        return result;
    }

    private SegmentTermVector[] readTermVectors(String[] fields, long[] tvfPointers) throws IOException {
        SegmentTermVector[] res = new SegmentTermVector[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            res[i] = this.readTermVector(fields[i], tvfPointers[i]);
        }
        return res;
    }

    private SegmentTermVector readTermVector(String field, long tvfPointer) throws IOException {
        this.tvf.seek(tvfPointer);
        int numTerms = this.tvf.readVInt();
        if (numTerms == 0) {
            return new SegmentTermVector(field, null, null);
        }
        int length = numTerms + this.tvf.readVInt();
        String[] terms = new String[numTerms];
        int[] termFreqs = new int[numTerms];
        int start = 0;
        int deltaLength = 0;
        int totalLength = 0;
        char[] buffer = new char[]{};
        String previousString = "";
        for (int i = 0; i < numTerms; ++i) {
            start = this.tvf.readVInt();
            totalLength = start + (deltaLength = this.tvf.readVInt());
            if (buffer.length < totalLength) {
                buffer = new char[totalLength];
                for (int j = 0; j < previousString.length(); ++j) {
                    buffer[j] = previousString.charAt(j);
                }
            }
            this.tvf.readChars(buffer, start, deltaLength);
            terms[i] = new String(buffer, 0, totalLength);
            previousString = terms[i];
            termFreqs[i] = this.tvf.readVInt();
        }
        SegmentTermVector tv = new SegmentTermVector(field, terms, termFreqs);
        return tv;
    }
}

