/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.MetadataBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.xml.names.MetadataElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.ThreddsXmlParserIssue;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserHelper;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.parser.stax.ThreddsMetadataElementParser;

class MetadataElementParser
extends AbstractElementParser {
    private final DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper;
    private final DatasetNodeBuilder parentDatasetNodeBuilder;
    private final MetadataBuilder selfBuilder;
    private boolean isInheritedByDescendants = false;
    private boolean containsThreddsMetadata = false;
    private String title;
    private URI externalRefUri;
    private boolean isContainedContent = false;
    private StringBuilder content;
    private ThreddsMetadataElementParser.Factory threddsMetadataElementParserFactory;
    private ThreddsMetadataElementParser threddsMetadataElementParser;

    private MetadataElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
        super(elementName, reader, builderFactory);
        this.parentDatasetNodeBuilder = parentDatasetNodeBuilder;
        this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
        this.threddsMetadataElementParserFactory = new ThreddsMetadataElementParser.Factory();
        this.selfBuilder = builderFactory.newMetadataBuilder();
    }

    @Override
    MetadataBuilder getSelfBuilder() {
        if (this.containsThreddsMetadata) {
            return null;
        }
        return this.selfBuilder;
    }

    boolean doesMetadataElementGetInherited() {
        return this.isInheritedByDescendants;
    }

    boolean isContainsThreddsMetadata() {
        return this.containsThreddsMetadata;
    }

    ThreddsMetadataBuilder getThreddsMetadataBuilder() {
        if (!this.containsThreddsMetadata) {
            return this.builderFactory.newThreddsMetadataBuilder();
        }
        return this.threddsMetadataElementParser.getSelfBuilder();
    }

    boolean addThreddsMetadataBuilderToList(List<ThreddsMetadataBuilder> tmBuilders) {
        if (this.getSelfBuilder() != null) {
            return tmBuilders.add(this.threddsMetadataElementParser.getSelfBuilder());
        }
        return false;
    }

    @Override
    void parseStartElement() throws ThreddsXmlParserException {
        StartElement nextElement;
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute inheritedAtt = startElement.getAttributeByName(MetadataElementNames.MetadataElement_Inherited);
        if (inheritedAtt != null && inheritedAtt.getValue().equalsIgnoreCase("true")) {
            this.isInheritedByDescendants = true;
        }
        if (this.threddsMetadataElementParserFactory.isEventMyStartElement(nextElement = this.peekAtNextEventIfStartElement())) {
            this.containsThreddsMetadata = true;
            return;
        }
        Attribute titleAtt = startElement.getAttributeByName(MetadataElementNames.MetadataElement_XlinkTitle);
        Attribute externalRefAtt = startElement.getAttributeByName(MetadataElementNames.MetadataElement_XlinkHref);
        if (titleAtt == null && externalRefAtt == null) {
            this.selfBuilder.setContainedContent(true);
            return;
        }
        if (titleAtt == null || externalRefAtt == null) {
            String msg = "External reference metadata element has null title or URI.";
            ThreddsXmlParserIssue issue = StaxThreddsXmlParserUtils.createIssueForUnexpectedElement(msg, this.reader);
            this.log.warn("parseStartElement(): " + issue.getMessage());
            throw new ThreddsXmlParserException(issue);
        }
        this.selfBuilder.setTitle(titleAtt.getValue());
        String uriString = externalRefAtt.getValue();
        try {
            this.selfBuilder.setExternalReference(new URI(uriString));
        }
        catch (URISyntaxException e) {
            String msg = "External reference metadata element with bad URI syntax [" + uriString + "].";
            ThreddsXmlParserIssue issue = StaxThreddsXmlParserUtils.createIssueForException(msg, this.reader, e);
            this.log.warn("parseStartElement(): " + issue.getMessage(), e);
            throw new ThreddsXmlParserException(issue);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void handleChildStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (this.containsThreddsMetadata) {
            if (!this.threddsMetadataElementParserFactory.isEventMyStartElement(startElement)) {
                String msg = "Expecting THREDDS Metadata, got non-THREDDS Metadata";
                ThreddsXmlParserIssue issue = StaxThreddsXmlParserUtils.createIssueForUnexpectedElement(msg, this.reader);
                throw new ThreddsXmlParserException(issue);
            }
            if (this.threddsMetadataElementParser == null) {
                this.threddsMetadataElementParser = this.threddsMetadataElementParserFactory.getNewParser(this.reader, this.builderFactory, this.parentDatasetNodeBuilder, this.parentDatasetNodeElementParserHelper, this.isInheritedByDescendants);
            }
            this.threddsMetadataElementParser.parse();
            return;
        }
        if (this.threddsMetadataElementParserFactory.isEventMyStartElement(startElement)) {
            String msg = "Unexpected THREDDS Metadata";
            ThreddsXmlParserIssue issue = StaxThreddsXmlParserUtils.createIssueForUnexpectedElement(msg, this.reader);
            throw new ThreddsXmlParserException(issue);
        }
        if (!this.isContainedContent) {
            String msg = "Unexpected content";
            ThreddsXmlParserIssue issue = StaxThreddsXmlParserUtils.createIssueForUnexpectedElement(msg, this.reader);
            throw new ThreddsXmlParserException(issue);
        }
        if (this.content == null) {
            this.content = new StringBuilder();
        }
        this.content.append(StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader));
    }

    @Override
    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        if (!this.containsThreddsMetadata && this.content != null) {
            this.selfBuilder.setContent(this.content.toString());
        }
    }

    static class Factory {
        private QName elementName = MetadataElementNames.MetadataElement;

        Factory() {
        }

        boolean isEventMyStartElement(XMLEvent event) {
            return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
        }

        MetadataElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
            return new MetadataElementParser(this.elementName, reader, builderFactory, parentDatasetNodeBuilder, parentDatasetNodeElementParserHelper);
        }
    }
}

