/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import net.jcip.annotations.ThreadSafe;
import thredds.inventory.MFile;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class MFileOS
implements MFile {
    private final File file;
    private final long lastModified;
    private Object auxInfo;

    public MFileOS(File file) {
        this.file = file;
        this.lastModified = file.lastModified();
    }

    public MFileOS(String filename) {
        this.file = new File(filename);
        this.lastModified = this.file.lastModified();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public String getPath() {
        return StringUtil2.replace(this.file.getPath(), '\\', "/");
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public int compareTo(MFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    @Override
    public Object getAuxInfo() {
        return this.auxInfo;
    }

    @Override
    public void setAuxInfo(Object auxInfo) {
        this.auxInfo = auxInfo;
    }
}

