/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.grib2.Grib2IndexProto;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Index
extends GribIndex {
    private static Logger log = LoggerFactory.getLogger(Grib2Index.class);
    private static final String MAGIC_START = "Grib2Index";
    private static final int version = 5;
    private static final boolean debug = false;
    private List<Grib2SectionGridDefinition> gdsList;
    private List<Grib2Record> records;

    public List<Grib2SectionGridDefinition> getGds() {
        return this.gdsList;
    }

    public List<Grib2Record> getRecords() {
        return this.records;
    }

    @Override
    public int getNRecords() {
        return this.records.size();
    }

    public boolean readIndex(String filename, long gribLastModified) throws IOException {
        return this.readIndex(filename, gribLastModified, CollectionManager.Force.test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readIndex(String filename, long gribLastModified, CollectionManager.Force force) throws IOException {
        File idxFile = Grib2Index.getIndexFile(filename);
        if (!idxFile.exists()) {
            return false;
        }
        long idxModified = idxFile.lastModified();
        if (force != CollectionManager.Force.nocheck && idxModified < gribLastModified) {
            return false;
        }
        FileInputStream fin = new FileInputStream(idxFile);
        try {
            if (!NcStream.readAndTest(fin, MAGIC_START.getBytes())) {
                log.debug("Bad magic number of grib index, should be= {}Grib2Index");
                boolean bl = false;
                return bl;
            }
            int v = NcStream.readVInt(fin);
            if (v != 5) {
                if (v == 0 || v > 5) {
                    throw new IOException("GribIndex found version " + v + ", want version " + 5 + " on " + filename);
                }
                log.debug("GribIndex found version " + v + ", want version " + 5 + " on " + filename);
                boolean bl = false;
                return bl;
            }
            int size = NcStream.readVInt(fin);
            if (size <= 0 || size > 100000000) {
                log.warn("Grib2Index bad size = {} for {} ", size, (Object)filename);
                boolean bl = false;
                return bl;
            }
            byte[] m = new byte[size];
            NcStream.readFully(fin, m);
            Grib2IndexProto.Grib2Index proto = Grib2IndexProto.Grib2Index.parseFrom(m);
            String fname = proto.getFilename();
            this.gdsList = new ArrayList<Grib2SectionGridDefinition>(proto.getGdsListCount());
            for (Grib2IndexProto.GribGdsSection pgds : proto.getGdsListList()) {
                Grib2SectionGridDefinition gds = this.readGds(pgds);
                this.gdsList.add(gds);
            }
            this.records = new ArrayList<Grib2Record>(proto.getRecordsCount());
            for (Grib2IndexProto.Grib2Record precord : proto.getRecordsList()) {
                this.records.add(this.readRecord(precord));
            }
        }
        catch (NegativeArraySizeException e) {
            log.error("GribIndex failed on " + filename, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return true;
    }

    private Grib2Record readRecord(Grib2IndexProto.Grib2Record p) {
        Grib2SectionIndicator is = new Grib2SectionIndicator(p.getGribMessageStart(), p.getGribMessageLength(), p.getDiscipline());
        Grib2SectionIdentification ids = this.readIdMessage(p.getIds());
        Grib2SectionLocalUse lus = null;
        if (p.hasLus()) {
            lus = new Grib2SectionLocalUse(p.getLus().toByteArray());
        }
        int gdsIndex = p.getGdsIdx();
        Grib2SectionGridDefinition gds = this.gdsList.get(gdsIndex);
        Grib2SectionProductDefinition pds = new Grib2SectionProductDefinition(p.getPds().toByteArray());
        Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(p.getDrsPos(), p.getDrsNpoints(), p.getDrsTemplate());
        Grib2SectionBitMap bms = new Grib2SectionBitMap(p.getBmsPos(), p.getBmsIndicator());
        Grib2SectionData data = new Grib2SectionData(p.getDataPos(), p.getDataLen());
        return new Grib2Record(p.getHeader().toByteArray(), is, ids, lus, gds, pds, drs, bms, data);
    }

    private Grib2SectionIdentification readIdMessage(Grib2IndexProto.GribIdSection p) {
        return new Grib2SectionIdentification(p.getCenterId(), p.getSubcenterId(), p.getMasterTableVersion(), p.getLocalTableVersion(), p.getSignificanceOfRT(), p.getRefDate(0), p.getRefDate(1), p.getRefDate(2), p.getRefDate(3), p.getRefDate(4), p.getRefDate(5), p.getProductionStatus(), p.getProcessedDataType());
    }

    private Grib2SectionGridDefinition readGds(Grib2IndexProto.GribGdsSection proto) {
        ByteString bytes = proto.getGds();
        return new Grib2SectionGridDefinition(bytes.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean makeIndex(String filename, Formatter f) throws IOException {
        File idxFile = Grib2Index.getIndexFile(filename);
        FileOutputStream fout = new FileOutputStream(idxFile);
        RandomAccessFile raf = null;
        try {
            Grib2Record r;
            fout.write(MAGIC_START.getBytes("UTF-8"));
            NcStream.writeVInt(fout, 5);
            HashMap<Long, Integer> gdsMap = new HashMap<Long, Integer>();
            this.gdsList = new ArrayList<Grib2SectionGridDefinition>();
            this.records = new ArrayList<Grib2Record>(200);
            Grib2IndexProto.Grib2Index.Builder rootBuilder = Grib2IndexProto.Grib2Index.newBuilder();
            rootBuilder.setFilename(filename);
            raf = new RandomAccessFile(filename, "r");
            Grib2RecordScanner scan = new Grib2RecordScanner(raf);
            while (scan.hasNext() && (r = scan.next()) != null) {
                this.records.add(r);
                Grib2SectionGridDefinition gds = r.getGDSsection();
                Integer index = (Integer)gdsMap.get(gds.calcCRC());
                if (index == null) {
                    this.gdsList.add(gds);
                    index = this.gdsList.size() - 1;
                    gdsMap.put(gds.calcCRC(), index);
                    rootBuilder.addGdsList(this.makeGdsProto(gds));
                }
                rootBuilder.addRecords(this.makeRecordProto(r, index));
            }
            Grib2IndexProto.Grib2Index index = rootBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt(fout, b.length);
            fout.write(b);
            f.format("  made gbx9 index for %s size=%d%n", filename, b.length);
            boolean bl = true;
            return bl;
        }
        finally {
            fout.close();
            if (raf != null) {
                raf.close();
            }
        }
    }

    private Grib2IndexProto.Grib2Record makeRecordProto(Grib2Record r, int gdsIndex) throws IOException {
        Grib2IndexProto.Grib2Record.Builder b = Grib2IndexProto.Grib2Record.newBuilder();
        b.setHeader(ByteString.copyFrom(r.getHeader()));
        b.setGribMessageStart(r.getIs().getStartPos());
        b.setGribMessageLength(r.getIs().getMessageLength());
        b.setDiscipline(r.getDiscipline());
        b.setIds(this.makeIdProto(r.getId()));
        byte[] lus = r.getLocalUseSection().getRawBytes();
        if (lus != null && lus.length > 0) {
            b.setLus(ByteString.copyFrom(lus));
        }
        b.setGdsIdx(gdsIndex);
        b.setPds(ByteString.copyFrom(r.getPDSsection().getRawBytes()));
        Grib2SectionDataRepresentation drs = r.getDataRepresentationSection();
        b.setDrsPos(drs.getStartingPosition());
        b.setDrsNpoints(drs.getDataPoints());
        b.setDrsTemplate(drs.getDataTemplate());
        Grib2SectionBitMap bms = r.getBitmapSection();
        b.setBmsPos(bms.getStartingPosition());
        b.setBmsIndicator(bms.getBitMapIndicator());
        Grib2SectionData ds = r.getDataSection();
        b.setDataPos(ds.getStartingPosition());
        b.setDataLen(ds.getMsgLength());
        return b.build();
    }

    private Grib2IndexProto.GribGdsSection makeGdsProto(Grib2SectionGridDefinition gds) throws IOException {
        Grib2IndexProto.GribGdsSection.Builder b = Grib2IndexProto.GribGdsSection.newBuilder();
        b.setGds(ByteString.copyFrom(gds.getRawBytes()));
        return b.build();
    }

    private Grib2IndexProto.GribIdSection makeIdProto(Grib2SectionIdentification id) throws IOException {
        Grib2IndexProto.GribIdSection.Builder b = Grib2IndexProto.GribIdSection.newBuilder();
        b.setCenterId(id.getCenter_id());
        b.setSubcenterId(id.getSubcenter_id());
        b.setMasterTableVersion(id.getMaster_table_version());
        b.setLocalTableVersion(id.getLocal_table_version());
        b.setSignificanceOfRT(id.getSignificanceOfRT());
        b.addRefDate(id.getYear());
        b.addRefDate(id.getMonth());
        b.addRefDate(id.getDay());
        b.addRefDate(id.getHour());
        b.addRefDate(id.getMinute());
        b.addRefDate(id.getSecond());
        b.setProductionStatus(id.getProductionStatus());
        b.setProcessedDataType(id.getTypeOfProcessedData());
        return b.build();
    }

    public static void main(String[] args) throws IOException {
        String filename = "G:/tigge/uv/z_tigge_c_kwbc_20110605120000_glob_prod_cf_HGHT_0000_000_10_uv.grib";
        new Grib2Index().makeIndex(filename, new Formatter(System.out));
    }
}

