/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.JulianChronology;
import uk.ac.rdg.resc.edal.time.AllLeapChronology;
import uk.ac.rdg.resc.edal.time.NoLeapChronology;
import uk.ac.rdg.resc.edal.time.ThreeSixtyDayChronology;

public enum Calendar {
    gregorian,
    proleptic_gregorian,
    noleap,
    all_leap,
    uniform30day,
    julian,
    none;

    private static final Map<Calendar, Chronology> CHRONOLOGIES;

    public static Calendar get(String s) {
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("gregorian") || s.equalsIgnoreCase("standard")) {
            return gregorian;
        }
        if (s.equalsIgnoreCase("proleptic_gregorian") || s.equalsIgnoreCase("ISO8601")) {
            return proleptic_gregorian;
        }
        if (s.equalsIgnoreCase("noleap") || s.equalsIgnoreCase("365_day")) {
            return noleap;
        }
        if (s.equalsIgnoreCase("all_leap") || s.equalsIgnoreCase("366_day")) {
            return all_leap;
        }
        if (s.equalsIgnoreCase("uniform30day") || s.equalsIgnoreCase("360_day")) {
            return uniform30day;
        }
        if (s.equalsIgnoreCase("julian")) {
            return julian;
        }
        if (s.equalsIgnoreCase("none")) {
            return none;
        }
        return null;
    }

    public static Calendar getDefault() {
        return proleptic_gregorian;
    }

    static Chronology getChronology(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return CHRONOLOGIES.get((Object)cal);
    }

    static Chronology getChronology(String cal) {
        if (cal == null) {
            return null;
        }
        return CHRONOLOGIES.get((Object)Calendar.get(cal));
    }

    static {
        CHRONOLOGIES = new HashMap<Calendar, Chronology>();
        CHRONOLOGIES.put(gregorian, GJChronology.getInstanceUTC());
        CHRONOLOGIES.put(proleptic_gregorian, ISOChronology.getInstanceUTC());
        CHRONOLOGIES.put(none, ISOChronology.getInstanceUTC());
        CHRONOLOGIES.put(julian, JulianChronology.getInstanceUTC());
        CHRONOLOGIES.put(all_leap, AllLeapChronology.getInstanceUTC());
        CHRONOLOGIES.put(noleap, NoLeapChronology.getInstanceUTC());
        CHRONOLOGIES.put(uniform30day, ThreeSixtyDayChronology.getInstanceUTC());
    }
}

