/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.IO;

public class LogLocalManager {
    static File topDir;
    private static final String specialLog = "threddsServlet.log";
    private String server;
    private boolean isAccess;
    private String where;
    private List<FileDateRange> localFiles;
    private SimpleDateFormat localFormat;
    private int filenameDatePos;
    private DateFormatter df = new DateFormatter();

    static File getDirectory(String server, String where) {
        String cleanServer = null;
        try {
            cleanServer = URLEncoder.encode(server, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new File(topDir, cleanServer + "/" + where);
    }

    LogLocalManager(String server, boolean isAccess) {
        this.server = server;
        this.isAccess = isAccess;
        this.where = isAccess ? "access" : "thredds";
        this.filenameDatePos = isAccess ? "access.".length() : "threddsServlet.log.".length();
        String format = isAccess ? "yyyy-MM-dd" : "yyyy-MM-dd-HH";
        this.localFormat = new SimpleDateFormat(format, Locale.US);
    }

    public String getRoots() {
        File localDir = LogLocalManager.getDirectory(this.server, "");
        File file = new File(localDir, "roots.txt");
        if (!file.exists()) {
            return null;
        }
        try {
            return IO.readFile(file.getPath());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public List<FileDateRange> getLocalFiles(Date start, Date end) {
        File localDir = LogLocalManager.getDirectory(this.server, this.where);
        if (!localDir.exists() && !localDir.mkdirs()) {
            System.out.printf("cant create %s%n", localDir);
            return new ArrayList<FileDateRange>(0);
        }
        ArrayList<FileDateRange> list = new ArrayList<FileDateRange>();
        for (File f : localDir.listFiles()) {
            if (f.isDirectory() || f.getName().endsWith(".zip")) continue;
            list.add(new FileDateRange(f));
        }
        Collections.sort(list, new ServletFileCompare());
        FileDateRange prev = null;
        for (FileDateRange fdr : list) {
            if (prev != null) {
                prev.end = new Date(fdr.start.getTime() - 1L);
            }
            prev = fdr;
        }
        if (list.size() > 1) {
            FileDateRange first = (FileDateRange)list.get(0);
            long interval = first.end.getTime() - first.start.getTime();
            if (this.isAccess) {
                FileDateRange last = (FileDateRange)list.get(list.size() - 1);
                last.end = new Date(last.start.getTime() + interval);
            } else {
                FileDateRange nextLast = (FileDateRange)list.get(list.size() - 2);
                nextLast.end = new Date(nextLast.start.getTime() + interval);
                FileDateRange last = (FileDateRange)list.get(list.size() - 1);
                last.start = nextLast.end;
                last.end = new Date(last.start.getTime() + interval);
            }
        } else if (prev != null) {
            prev.end = this.isAccess ? new Date(prev.start.getTime() + 86400000L) : new Date(prev.start.getTime() + 3600000L);
        }
        this.localFiles = new ArrayList<FileDateRange>();
        for (FileDateRange have : list) {
            if (start != null && start.after(have.end) || end != null && have.start.after(end)) continue;
            this.localFiles.add(have);
        }
        return this.localFiles;
    }

    Date getStartDate() {
        if (this.localFiles == null) {
            return null;
        }
        if (this.localFiles.size() == 0) {
            return null;
        }
        FileDateRange f = this.localFiles.get(0);
        return f.start;
    }

    Date getEndDate() {
        if (this.localFiles == null) {
            return null;
        }
        if (this.localFiles.size() == 0) {
            return null;
        }
        FileDateRange f = this.localFiles.get(this.localFiles.size() - 1);
        return f.end;
    }

    public String getServer() {
        return this.server;
    }

    static {
        String dataDir = System.getProperty("tdsMonitor.dataDir");
        if (dataDir != null) {
            topDir = new File(dataDir);
        } else {
            String homeDir = System.getProperty("user.home");
            topDir = new File(homeDir, "tdsMonitor");
        }
        System.out.printf("logs stored at= %s%n", topDir);
    }

    public class FileDateRange {
        File f;
        Date start;
        Date end;

        FileDateRange(File f) {
            this.f = f;
            this.start = this.extractStartDate(f.getName());
            System.out.printf(" %s == %s%n", f.getName(), LogLocalManager.this.df.toDateTimeStringISO(this.start));
        }

        Date extractStartDate(String name) {
            if (!LogLocalManager.this.isAccess && name.equals(LogLocalManager.specialLog)) {
                Calendar cal = Calendar.getInstance();
                cal.add(11, -1);
                return cal.getTime();
            }
            try {
                String filenameDate = name.substring(LogLocalManager.this.filenameDatePos);
                return LogLocalManager.this.localFormat.parse(filenameDate);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class ServletFileCompare
    implements Comparator<FileDateRange> {
        private ServletFileCompare() {
        }

        @Override
        public int compare(FileDateRange o1, FileDateRange o2) {
            if (o1.f.getName().equals(LogLocalManager.specialLog)) {
                return 1;
            }
            if (o2.f.getName().equals(LogLocalManager.specialLog)) {
                return -1;
            }
            return o1.f.getName().compareTo(o2.f.getName());
        }
    }
}

