/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.constants;

public enum FeatureType {
    ANY,
    GRID,
    RADIAL,
    SWATH,
    IMAGE,
    ANY_POINT,
    POINT,
    PROFILE,
    SECTION,
    STATION,
    STATION_PROFILE,
    TRAJECTORY,
    STATION_RADIAL,
    FMRC,
    GRIB,
    UGRID,
    NONE;


    public static FeatureType getType(String name) {
        if (name == null) {
            return null;
        }
        try {
            return FeatureType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isPointFeatureType() {
        return this == POINT || this == STATION || this == TRAJECTORY || this == PROFILE || this == STATION_PROFILE || this == SECTION;
    }

    public boolean isGridFeatureType() {
        return this == GRID || this == FMRC;
    }

    public boolean isUnstructuredGridFeatureType() {
        return this == UGRID;
    }
}

