/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.noaa;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.noaa.GhcnmProto;
import ucar.nc2.iosp.noaa.StructureDataRegexp;
import ucar.nc2.ncml.NcmlConstructor;
import ucar.nc2.stream.NcStream;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Ghcnm2
extends AbstractIOServiceProvider {
    private static final String dataPatternRegexp = "(\\d{11})(\\d{4})TAVG([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)?(.)?(.)?.*";
    private static final String stnPatternRegexp = "(\\d{11}) ([ \\.\\-\\d]{8}) ([ \\.\\-\\d]{9}) ([ \\.\\-\\d]{6}) (.{30}) ([ \\-\\d]{4})(.)([ \\-\\d]{5})(..)(..)(..)([ \\-\\d]{2})(.)(..)(.{16})(.).*";
    private static final Pattern dataPattern = Pattern.compile("(\\d{11})(\\d{4})TAVG([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)(.)(.)([ \\-\\d]{5})(.)?(.)?(.)?.*");
    private static final Pattern stnPattern = Pattern.compile("(\\d{11}) ([ \\.\\-\\d]{8}) ([ \\.\\-\\d]{9}) ([ \\.\\-\\d]{6}) (.{30}) ([ \\-\\d]{4})(.)([ \\-\\d]{5})(..)(..)(..)([ \\-\\d]{2})(.)(..)(.{16})(.).*");
    private static final String STNID = "stnid";
    private static final String STN_EXT = ".inv";
    private static final String DAT_EXT = ".dat";
    private static final String IDX_EXT = ".ncx";
    private static final String MAGIC_START_IDX = "GhncmIndex";
    private static final int version = 1;
    private RandomAccessFile stnRaf;
    private RandomAccessFile dataRaf;
    private HashMap<Long, StationIndex> map = new HashMap(10000);
    private int stn_fldno;
    private StructureDataRegexp.Vinfo dataVinfo;
    private StructureDataRegexp.Vinfo stnVinfo;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        String dataFile = raf.getLocation();
        int pos = dataFile.lastIndexOf(".");
        if (pos <= 0) {
            return false;
        }
        String base = dataFile.substring(0, pos);
        String ext = dataFile.substring(pos);
        if (!(ext.equals(DAT_EXT) || ext.equals(STN_EXT) || ext.equals(IDX_EXT))) {
            return false;
        }
        if (ext.equals(IDX_EXT)) {
            File datFile = new File(base + DAT_EXT);
            if (!datFile.exists()) {
                return false;
            }
            File stnFile = new File(base + STN_EXT);
            if (!stnFile.exists()) {
                return false;
            }
            raf.seek(0L);
            byte[] b = new byte[MAGIC_START_IDX.length()];
            raf.read(b);
            String test = new String(b, "UTF-8");
            return test.equals(MAGIC_START_IDX);
        }
        if (ext.equals(DAT_EXT)) {
            File stnFile = new File(base + STN_EXT);
            return stnFile.exists() && this.isValidFile(raf, dataPattern);
        }
        File stnFile = new File(base + DAT_EXT);
        return stnFile.exists() && this.isValidFile(raf, stnPattern);
    }

    private boolean isValidFile(RandomAccessFile raf, Pattern p) throws IOException {
        String line;
        raf.seek(0L);
        while ((line = raf.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            Matcher matcher = p.matcher(line);
            return matcher.matches();
        }
        return false;
    }

    @Override
    public String getFileTypeId() {
        return "GHCNM";
    }

    @Override
    public String getFileTypeDescription() {
        return "GLOBAL HISTORICAL CLIMATOLOGY NETWORK MONTHLY";
    }

    @Override
    public String getFileTypeVersion() {
        return Integer.toString(1);
    }

    @Override
    public void open(RandomAccessFile raff, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        String dataFile = raff.getLocation();
        int pos = dataFile.lastIndexOf(".");
        String base = dataFile.substring(0, pos);
        String ext = dataFile.substring(pos);
        if (ext.equals(IDX_EXT)) {
            this.dataRaf = new RandomAccessFile(base + DAT_EXT, "r");
            this.stnRaf = new RandomAccessFile(base + STN_EXT, "r");
        } else if (ext.equals(DAT_EXT)) {
            this.dataRaf = raff;
            this.stnRaf = new RandomAccessFile(base + STN_EXT, "r");
        } else {
            this.stnRaf = raff;
            this.dataRaf = new RandomAccessFile(base + DAT_EXT, "r");
        }
        NcmlConstructor ncmlc = new NcmlConstructor();
        if (!ncmlc.populateFromResource("resources/nj22/iosp/ghcnm.ncml", ncfile)) {
            throw new IllegalStateException(ncmlc.getErrlog().toString());
        }
        ncfile.finish();
        this.dataVinfo = this.setVinfo(this.dataRaf, ncfile, dataPattern, "all_data");
        this.stnVinfo = this.setVinfo(this.stnRaf, ncfile, stnPattern, "station");
        StructureMembers.Member m = this.stnVinfo.sm.findMember(STNID);
        StructureDataRegexp.VinfoField f = (StructureDataRegexp.VinfoField)m.getDataObject();
        this.stn_fldno = f.fldno;
        File idxFile = new File(base + IDX_EXT);
        if (!idxFile.exists()) {
            this.makeIndex(this.stnVinfo, this.dataVinfo, idxFile);
        } else {
            this.readIndex(idxFile.getPath());
        }
    }

    private StructureDataRegexp.Vinfo setVinfo(RandomAccessFile raff, NetcdfFile ncfile, Pattern p, String seqName) {
        Sequence seq = (Sequence)ncfile.findVariable(seqName);
        StructureMembers sm = seq.makeStructureMembers();
        StructureDataRegexp.Vinfo result = new StructureDataRegexp.Vinfo(raff, sm, p);
        seq.setSPobject(result);
        int fldno = 1;
        for (StructureMembers.Member m : sm.getMembers()) {
            StructureDataRegexp.VinfoField vf = new StructureDataRegexp.VinfoField(fldno++);
            Variable v = seq.findVariable(m.getName());
            Attribute att = v.findAttribute("iosp_scale");
            if (att != null) {
                vf.hasScale = true;
                vf.scale = att.getNumericValue().floatValue();
                v.remove(att);
            }
            m.setDataObject(vf);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.stnRaf.close();
        this.dataRaf.close();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        StructureDataRegexp.Vinfo vinfo = (StructureDataRegexp.Vinfo)v2.getSPobject();
        return new ArraySequence(vinfo.sm, new SeqIter(vinfo), vinfo.nelems);
    }

    @Override
    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        StructureDataRegexp.Vinfo vinfo = (StructureDataRegexp.Vinfo)s.getSPobject();
        return new SeqIter(vinfo);
    }

    private void readIndex(String indexFilename) throws IOException {
        FileInputStream fin = new FileInputStream(indexFilename);
        if (!NcStream.readAndTest(fin, MAGIC_START_IDX.getBytes("UTF-8"))) {
            throw new IllegalStateException("bad index file");
        }
        int version = fin.read();
        if (version != 1) {
            throw new IllegalStateException("Bad version = " + version);
        }
        int count = NcStream.readVInt(fin);
        for (int i = 0; i < count; ++i) {
            int size = NcStream.readVInt(fin);
            byte[] pb = new byte[size];
            NcStream.readFully(fin, pb);
            StationIndex si = this.decodeStationIndex(pb);
            this.map.put(si.stnId, si);
        }
        fin.close();
        System.out.println(" read index map size=" + this.map.values().size());
    }

    private void makeIndex(StructureDataRegexp.Vinfo stnInfo, StructureDataRegexp.Vinfo dataInfo, File indexFile) throws IOException {
        StructureMembers.Member m = stnInfo.sm.findMember(STNID);
        StructureDataRegexp.VinfoField f = (StructureDataRegexp.VinfoField)m.getDataObject();
        int stnCount = 0;
        stnInfo.rafile.seek(0L);
        while (true) {
            long stnPos = stnInfo.rafile.getFilePointer();
            String line = stnInfo.rafile.readLine();
            if (line == null) break;
            Matcher matcher = stnInfo.p.matcher(line);
            if (!matcher.matches()) {
                System.out.printf("FAIL %s%n", line);
                continue;
            }
            String svalue = matcher.group(f.fldno);
            Long id = Long.parseLong(svalue.trim());
            StationIndex s = new StationIndex();
            s.stnId = id;
            s.stnPos = stnPos;
            this.map.put(id, s);
            ++stnCount;
        }
        m = dataInfo.sm.findMember(STNID);
        f = (StructureDataRegexp.VinfoField)m.getDataObject();
        StationIndex currStn = null;
        int totalCount = 0;
        dataInfo.rafile.seek(0L);
        while (true) {
            long dataPos = dataInfo.rafile.getFilePointer();
            String line = dataInfo.rafile.readLine();
            if (line == null) break;
            Matcher matcher = dataInfo.p.matcher(line);
            if (!matcher.matches()) {
                System.out.printf("FAIL %s%n", line);
                continue;
            }
            String svalue = matcher.group(f.fldno).trim();
            Long id = Long.parseLong(svalue);
            if (currStn == null || currStn.stnId != id) {
                StationIndex s = this.map.get(id);
                if (s == null) {
                    System.out.printf("Cant find %d%n", id);
                } else if (s.dataCount != 0) {
                    System.out.printf("Not in order %d at pos %d %n", id, dataPos);
                } else {
                    s.dataPos = dataPos;
                    ++totalCount;
                }
                currStn = s;
            }
            ++currStn.dataCount;
        }
        FileOutputStream fout = new FileOutputStream(indexFile);
        long size = 0L;
        fout.write(MAGIC_START_IDX.getBytes("UTF-8"));
        fout.write(1);
        size += (long)NcStream.writeVInt(fout, stnCount);
        for (StationIndex s : this.map.values()) {
            byte[] pb = s.encodeStationProto();
            size += (long)NcStream.writeVInt(fout, pb.length);
            size += (long)pb.length;
            fout.write(pb);
        }
        fout.close();
    }

    private StationIndex decodeStationIndex(byte[] data) throws InvalidProtocolBufferException {
        GhcnmProto.StationIndex proto = GhcnmProto.StationIndex.parseFrom(data);
        return new StationIndex(proto);
    }

    private class StationIndex {
        long stnId;
        long stnPos;
        long dataPos;
        int dataCount;

        StationIndex() {
        }

        StationIndex(GhcnmProto.StationIndex proto) {
            this.stnId = proto.getStnid();
            this.stnPos = proto.getStnPos();
            this.dataPos = proto.getDataPos();
            this.dataCount = proto.getDataCount();
        }

        private byte[] encodeStationProto() {
            GhcnmProto.StationIndex.Builder builder = GhcnmProto.StationIndex.newBuilder();
            builder.setStnid(this.stnId);
            builder.setStnPos(this.stnPos);
            builder.setDataPos(this.dataPos);
            builder.setDataCount(this.dataCount);
            GhcnmProto.StationIndex proto = builder.build();
            return proto.toByteArray();
        }
    }

    private class StnDataIter
    implements StructureDataIterator {
        private StructureMembers sm;
        private int countRead;
        private StationIndex stationIndex;

        StnDataIter(StructureMembers sm, StationIndex stationIndex) {
            this.sm = sm;
            this.stationIndex = stationIndex;
            this.reset();
        }

        @Override
        public StructureDataIterator reset() {
            this.countRead = 0;
            try {
                Ghcnm2.this.dataRaf.seek(this.stationIndex.dataPos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.countRead < this.stationIndex.dataCount;
        }

        @Override
        public StructureData next() throws IOException {
            Matcher matcher;
            String line;
            do {
                if ((line = Ghcnm2.this.dataRaf.readLine()) != null) continue;
                return null;
            } while (line.startsWith("#") || line.trim().length() == 0 || !(matcher = dataPattern.matcher(line)).matches());
            ++this.countRead;
            return new StructureDataRegexp(this.sm, matcher);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public int getCurrentRecno() {
            return this.countRead - 1;
        }

        @Override
        public void finish() {
        }
    }

    private class StructureDataRegexpGhcnm
    extends StructureDataRegexp {
        StructureMembers members;
        Matcher matcher;

        StructureDataRegexpGhcnm(StructureMembers members, Matcher matcher) {
            super(members, matcher);
            this.members = members;
            this.matcher = matcher;
        }

        @Override
        public ArraySequence getArraySequence(StructureMembers.Member m) {
            String svalue = this.matcher.group(Ghcnm2.this.stn_fldno).trim();
            Long stnId = Long.parseLong(svalue);
            StationIndex si = (StationIndex)Ghcnm2.this.map.get(stnId);
            return new ArraySequence(((Ghcnm2)Ghcnm2.this).dataVinfo.sm, new StnDataIter(((Ghcnm2)Ghcnm2.this).dataVinfo.sm, si), -1);
        }
    }

    private class SeqIter
    implements StructureDataIterator {
        private StructureDataRegexp.Vinfo vinfo;
        private long bytesRead;
        private long totalBytes;
        private int recno;
        private StructureData curr;

        SeqIter(StructureDataRegexp.Vinfo vinfo) throws IOException {
            this.vinfo = vinfo;
            this.totalBytes = (int)vinfo.rafile.length();
            vinfo.rafile.seek(0L);
        }

        @Override
        public StructureDataIterator reset() {
            this.bytesRead = 0L;
            this.recno = 0;
            try {
                this.vinfo.rafile.seek(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            boolean more;
            boolean bl = more = this.bytesRead < this.totalBytes;
            if (!more) {
                this.vinfo.nelems = this.recno;
                return false;
            }
            this.curr = this.reallyNext();
            boolean bl2 = more = this.curr != null;
            if (!more) {
                this.vinfo.nelems = this.recno;
                return false;
            }
            return more;
        }

        @Override
        public StructureData next() throws IOException {
            return this.curr;
        }

        private StructureData reallyNext() throws IOException {
            Matcher matcher;
            while (true) {
                String line;
                if ((line = this.vinfo.rafile.readLine()) == null) {
                    return null;
                }
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                matcher = this.vinfo.p.matcher(line);
                if (matcher.matches()) break;
                System.out.printf("FAIL %s%n", line);
            }
            this.bytesRead = this.vinfo.rafile.getFilePointer();
            ++this.recno;
            return new StructureDataRegexpGhcnm(this.vinfo.sm, matcher);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public int getCurrentRecno() {
            return this.recno - 1;
        }

        @Override
        public void finish() {
        }
    }
}

